/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.mapping.Layer;
import com.supermap.ui.HitTestInfo;
import com.supermap.ui.LayersTree;
import com.supermap.ui.LayersTreeCellRenderer;
import com.supermap.ui.NodeDataType;
import com.supermap.ui.TreeNodeData;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

class LayersTreeCellEditor
implements TreeCellEditor,
KeyListener,
ActionListener,
TreeSelectionListener {
    private LayersTree _$7 = null;
    private LayersTreeCellRenderer _$6 = null;
    private JTextField _$5 = null;
    private Layer _$4 = null;
    private Timer _$3;
    private TreePath _$2;
    private TreeNodeData _$1;

    public LayersTreeCellEditor(LayersTree layersTree, LayersTreeCellRenderer layersTreeCellRenderer) {
        this._$6 = layersTreeCellRenderer;
        this._$7 = layersTree;
        this._$7.addTreeSelectionListener(this);
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        int n2;
        Component component;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        TreeNodeData treeNodeData = (TreeNodeData)defaultMutableTreeNode.getUserObject();
        JPanel jPanel = this._$6.getPanel(treeNodeData);
        NodeDataType nodeDataType = treeNodeData.getType();
        if (nodeDataType.equals((Object)NodeDataType.LAYER)) {
            this._$1 = treeNodeData;
            Object object2 = treeNodeData.getData();
            if (object2 instanceof Layer) {
                component = (Layer)object2;
                this._$4 = component;
                this._$5 = new JTextField(component.getCaption());
                this._$5.setFont(jTree.getFont());
                this._$5.addKeyListener(this);
            }
        }
        if ((component = jPanel.getComponent((n2 = jPanel.getComponentCount()) - 1)) instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            jLabel.setText("");
        }
        jPanel.add(this._$5);
        return jPanel;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
    }

    public void cancelCellEditing() {
    }

    public Object getCellEditorValue() {
        return this._$5.getText();
    }

    public boolean isCellEditable(EventObject eventObject) {
        boolean bl = false;
        if (eventObject instanceof MouseEvent) {
            TreePath treePath = this._$7.getPathForLocation(((MouseEvent)eventObject).getX(), ((MouseEvent)eventObject).getY());
            boolean bl2 = bl = this._$2 != null && treePath != null && this._$2.equals(treePath);
        }
        if (bl && this.shouldStartEditingTimer(eventObject)) {
            this.startEditingTimer();
        } else if (this._$3 != null && this._$3.isRunning()) {
            this._$3.stop();
        }
        return eventObject == null;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return false;
    }

    public boolean stopCellEditing() {
        this.validateLayerCaption((String)this.getCellEditorValue());
        return true;
    }

    private void _$2() {
        this.stopCellEditing();
    }

    private void _$1(EventObject eventObject) {
        this.isCellEditable(eventObject);
    }

    private void _$1() {
        this._$7.updateUI();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void validateLayerCaption(String string) {
        this._$4.setCaption(string);
        this._$1();
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\n') {
            this._$2();
            this._$1(keyEvent);
            this._$1();
        }
    }

    protected void startEditingTimer() {
        if (this._$3 == null) {
            this._$3 = new Timer(1200, this);
            this._$3.setRepeats(false);
        }
        this._$3.start();
    }

    protected boolean shouldStartEditingTimer(EventObject eventObject) {
        MouseEvent mouseEvent;
        HitTestInfo hitTestInfo;
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject) && (hitTestInfo = this._$7.hitTest((mouseEvent = (MouseEvent)eventObject).getX(), mouseEvent.getY())) != null) {
            return mouseEvent.getClickCount() == 1 && hitTestInfo.getIndex() == hitTestInfo.getIndexCount() - 1;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._$7 != null && this._$2 != null) {
            this._$7.startEditingAtPath(this._$2);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this._$7 != null) {
            this._$2 = this._$7.getSelectionCount() == 1 ? this._$7.getSelectionPath() : null;
        }
        if (this._$3 != null) {
            this._$3.stop();
        }
    }
}

