/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.mapping.InternalDatasetVector;
import com.supermap.mapping.InternalDatasets;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.Map;
import com.supermap.mapping.MapNative;
import com.supermap.mapping.MapToolkitNative;

public class MapToolkit {
    protected MapToolkit() {
    }

    static DatasetVector mapLabelToDataset(Map map, Datasource datasource, String string, ConvertOption convertOption) {
        if (map == null) {
            String string2 = InternalResource.loadString("map", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)map);
        if (l == 0L) {
            String string3 = InternalResource.loadString("map", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null) {
            String string4 = InternalResource.loadString("datasource", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l2 == 0L) {
            String string5 = InternalResource.loadString("datasource", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("datasetName", "MapToolkit_DatasetNameIsIllegal", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if (convertOption == null) {
            String string7 = InternalResource.loadString("convertOption", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        int n = convertOption.value();
        DatasetVector datasetVector = null;
        long l3 = MapToolkitNative.jni_MapLabelToDataset(l, l2, string, n);
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstanc(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
        return datasetVector;
    }

    public static Map mapLabelPreprocess(Map map, Datasource datasource, double[] dArray, String string) {
        int n;
        if (map == null) {
            String string2 = InternalResource.loadString("map", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)map);
        if (l == 0L) {
            String string3 = InternalResource.loadString("map", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null) {
            String string4 = InternalResource.loadString("datasource", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (dArray.length == 0) {
            String string5 = InternalResource.loadString("datasource", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = dArray.length;
        if (n2 == 0) {
            return null;
        }
        if (string == null || string.trim().length() == 0) {
            String string6 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        long l3 = MapToolkitNative.jni_CloneMap(l);
        long[] lArray = MapToolkitNative.jni_GetLabelLayers(l3, ConvertOption.ALL.value());
        long[] lArray2 = MapToolkitNative.jni_GetPointLayers(l3);
        if (lArray.length == 0) {
            MapNative.jni_Delete(l3);
            return null;
        }
        double d = MapNative.jni_GetScale(l3);
        String string7 = MapNative.jni_GetName(l3);
        for (n = 0; n < dArray.length; ++n) {
            double d2 = dArray[n];
            int n3 = 1;
            if (d2 < 0.0 || d2 <= 1.0E-20) continue;
            n3 = d2 > 1.0 ? (int)d2 : (int)(1.0 / d2);
            DatasetVector datasetVector = null;
            String string8 = "Label" + n3 + "ALL";
            MapNative.jni_SetScale(l3, dArray[n]);
            long l4 = MapToolkitNative.jni_LabelLayersToOne(l3, lArray, l2, string8);
            if (l4 == 0L) continue;
            datasetVector = InternalDatasetVector.createInstanc(l4, datasource);
            datasetVector.setDescription(string7);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        MapNative.jni_SetScale(l3, d);
        for (n = 0; n < lArray.length; ++n) {
            LayerNative.jni_SetIsVisible(lArray[n], false);
        }
        for (n = 0; n < lArray2.length; ++n) {
            LayerNative.jni_SetIsVisible(lArray2[n], false);
        }
        MapNative.jni_SetName(l3, string);
        Map map2 = Map.createInstance(l3);
        map2.setWorkspace(map.getWorkspace());
        InternalHandleDisposable.setIsDisposable(map2, true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map2));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
        return map2;
    }

    public static String checkMapIsAvailableForTile(Map map) {
        if (map == null) {
            String string = InternalResource.loadString("map", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)map);
        if (l == 0L) {
            String string = InternalResource.loadString("map", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return MapToolkitNative.jni_CheckMapIsAvailableForTile(l, "");
    }

    public static String checkMapIsAvailableForTile(String string) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("mapXML", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        return MapToolkitNative.jni_CheckMapIsAvailableForTile(0L, string);
    }

    static class ConvertOption
    extends Enum {
        public static final ConvertOption THEMELABELONLY = new ConvertOption(0, 0);
        public static final ConvertOption TEXTLAYERONLY = new ConvertOption(1, 1);
        public static final ConvertOption ALL = new ConvertOption(2, 2);

        private ConvertOption(int n, int n2) {
            super(n, n2);
        }
    }
}

