/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.impl;

import com.googlecode.ehcache.annotations.AdviceType;
import com.googlecode.ehcache.annotations.CacheAttributeSource;
import com.googlecode.ehcache.annotations.Cacheable;
import com.googlecode.ehcache.annotations.CacheableAttribute;
import com.googlecode.ehcache.annotations.CacheableInterceptor;
import com.googlecode.ehcache.annotations.DecoratedCacheType;
import com.googlecode.ehcache.annotations.DefaultCacheableInterceptor;
import com.googlecode.ehcache.annotations.DefaultTriggersRemoveInterceptor;
import com.googlecode.ehcache.annotations.KeyGenerator;
import com.googlecode.ehcache.annotations.MethodAttribute;
import com.googlecode.ehcache.annotations.ParameterMask;
import com.googlecode.ehcache.annotations.PartialCacheKey;
import com.googlecode.ehcache.annotations.Property;
import com.googlecode.ehcache.annotations.ResolverFactory;
import com.googlecode.ehcache.annotations.SelfPopulatingCacheScope;
import com.googlecode.ehcache.annotations.TriggersRemove;
import com.googlecode.ehcache.annotations.TriggersRemoveAttribute;
import com.googlecode.ehcache.annotations.TriggersRemoveInterceptor;
import com.googlecode.ehcache.annotations.When;
import com.googlecode.ehcache.annotations.impl.CacheableAttributeImpl;
import com.googlecode.ehcache.annotations.impl.MultiKeyConcurrentMap;
import com.googlecode.ehcache.annotations.impl.PropertyComparator;
import com.googlecode.ehcache.annotations.impl.TriggersRemoveAttributeImpl;
import com.googlecode.ehcache.annotations.key.CacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.ReflectionHelper;
import com.googlecode.ehcache.annotations.key.ReflectionHelperAware;
import com.googlecode.ehcache.annotations.resolver.CacheResolverFactory;
import com.googlecode.ehcache.annotations.resolver.CacheableCacheResolver;
import com.googlecode.ehcache.annotations.resolver.DefaultCacheResolverFactory;
import com.googlecode.ehcache.annotations.resolver.TriggersRemoveCacheResolver;
import com.googlecode.ehcache.annotations.support.TaskSchedulerAdapter;
import com.googlecode.ehcache.annotations.support.TaskSchedulerAdapterFactory;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import net.sf.ehcache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheAttributeSourceImpl
implements CacheAttributeSource,
BeanFactoryAware,
InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MultiKeyConcurrentMap<Class<?>, Method, Boolean> ingoredMethods = new MultiKeyConcurrentMap();
    private final MultiKeyConcurrentMap<Class<?>, Method, MethodAttribute> attributesCache = new MultiKeyConcurrentMap();
    private DefaultListableBeanFactory childBeanFactory;
    private CacheManager cacheManager;
    private BeanFactory beanFactory;
    private SelfPopulatingCacheScope selfPopulatingCacheScope;
    private Boolean createCaches;
    private CacheKeyGenerator<? extends Serializable> defaultCacheKeyGenerator;
    private CacheableInterceptor defaultCacheableInterceptor = DefaultCacheableInterceptor.INSTANCE;
    private TriggersRemoveInterceptor defaultTriggersRemoveInterceptor = DefaultTriggersRemoveInterceptor.INSTANCE;
    private ReflectionHelper reflectionHelper;
    private CacheResolverFactory cacheResolverFactory;
    private TaskSchedulerAdapter scheduler;
    private SchedulingTaskExecutor executor;

    public void setScheduler(Object scheduler) {
        this.scheduler = TaskSchedulerAdapterFactory.createTaskSchedulerAdapter(scheduler);
    }

    public void setExecutor(SchedulingTaskExecutor executor) {
        this.executor = executor;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.childBeanFactory = new DefaultListableBeanFactory(this.beanFactory);
    }

    public void setCreateCaches(boolean createCaches) {
        this.createCaches = createCaches;
    }

    public void setDefaultCacheKeyGenerator(CacheKeyGenerator<? extends Serializable> defaultCacheKeyGenerator) {
        this.defaultCacheKeyGenerator = defaultCacheKeyGenerator;
    }

    public void setDefaultCacheableInterceptor(CacheableInterceptor defaultCacheableInterceptor) {
        this.defaultCacheableInterceptor = defaultCacheableInterceptor;
    }

    public void setDefaultTriggersRemoveInterceptor(TriggersRemoveInterceptor defaultTriggersRemoveInterceptor) {
        this.defaultTriggersRemoveInterceptor = defaultTriggersRemoveInterceptor;
    }

    public void setSelfPopulatingCacheScope(SelfPopulatingCacheScope selfPopulatingCacheScope) {
        this.selfPopulatingCacheScope = selfPopulatingCacheScope;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setReflectionHelper(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }

    public void setCacheResolverFactory(CacheResolverFactory cacheResolverFactory) {
        this.cacheResolverFactory = cacheResolverFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.cacheResolverFactory == null) {
            DefaultCacheResolverFactory defaultCacheResolverFactory = new DefaultCacheResolverFactory(this.getCacheManager());
            if (this.createCaches != null) {
                defaultCacheResolverFactory.setCreateCaches(this.createCaches);
            }
            if (this.selfPopulatingCacheScope != null) {
                defaultCacheResolverFactory.setSelfPopulatingCacheScope(this.selfPopulatingCacheScope);
            }
            defaultCacheResolverFactory.setExecutor(this.executor);
            defaultCacheResolverFactory.setScheduler(this.scheduler);
            this.cacheResolverFactory = defaultCacheResolverFactory;
        } else {
            if (this.createCaches != null) {
                this.logger.warn("createCaches was specified but a custom CacheResolverFactory was also configured. The createCaches value will be ignored.");
            }
            if (this.selfPopulatingCacheScope != null) {
                this.logger.warn("selfPopulatingCacheScope was specified but a custom CacheResolverFactory was also configured. The selfPopulatingCacheScope value will be ignored.");
            }
            if (this.executor != null) {
                this.logger.warn("executor was specified but a custom CacheResolverFactory was also configured. The executor value will be ignored.");
            }
            if (this.scheduler != null) {
                this.logger.warn("scheduler was specified but a custom CacheResolverFactory was also configured. The scheduler value will be ignored.");
            }
        }
    }

    @Override
    public AdviceType getAdviceType(Method method, Class<?> targetClass) {
        MethodAttribute methodAttribute = this.getMethodAttribute(method, targetClass);
        if (methodAttribute != null) {
            return methodAttribute.getAdviceType();
        }
        return AdviceType.NONE;
    }

    @Override
    public CacheableAttribute getCacheableAttribute(Method method, Class<?> targetClass) {
        MethodAttribute methodAttribute = this.getMethodAttribute(method, targetClass);
        if (methodAttribute != null && AdviceType.CACHE == methodAttribute.getAdviceType()) {
            return (CacheableAttribute)methodAttribute;
        }
        return null;
    }

    @Override
    public TriggersRemoveAttribute getTriggersRemoveAttribute(Method method, Class<?> targetClass) {
        MethodAttribute methodAttribute = this.getMethodAttribute(method, targetClass);
        if (methodAttribute != null && AdviceType.REMOVE == methodAttribute.getAdviceType()) {
            return (TriggersRemoveAttribute)methodAttribute;
        }
        return null;
    }

    private MethodAttribute getMethodAttribute(Method method, Class<?> targetClass) {
        if (this.ingoredMethods.containsKey(targetClass, method)) {
            return null;
        }
        MethodAttribute attributes = this.attributesCache.get(targetClass, method);
        if (attributes != null) {
            return attributes;
        }
        MethodAttribute att = this.computeMethodAttribute(method, targetClass);
        if (att == null) {
            this.ingoredMethods.put(targetClass, method, Boolean.TRUE);
        } else {
            this.logger.debug("Adding {} advised method '{}' with attribute: {}", new Object[]{att.getAdviceType(), method.getName(), att});
            MethodAttribute existing = this.attributesCache.putIfAbsent(targetClass, method, att);
            if (existing != null) {
                return existing;
            }
        }
        return att;
    }

    protected boolean allowPublicMethodsOnly() {
        return false;
    }

    protected CacheManager getCacheManager() {
        return this.cacheManager;
    }

    private MethodAttribute computeMethodAttribute(Method method, Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        MethodAttribute att = this.findMethodAttribute(specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod));
        if (att != null) {
            return att;
        }
        if (specificMethod != method && (att = this.findMethodAttribute(method)) != null) {
            return att;
        }
        return null;
    }

    private MethodAttribute findMethodAttribute(Method method) {
        Cacheable cacheableAnnotation = method.getAnnotation(Cacheable.class);
        if (cacheableAnnotation != null) {
            ParameterMask parameterMask = this.parsePartialCacheKeyAnnotations(method);
            return this.parseCacheableAnnotation(cacheableAnnotation, method, parameterMask);
        }
        TriggersRemove triggersRemove = method.getAnnotation(TriggersRemove.class);
        if (triggersRemove != null) {
            ParameterMask parameterMask = this.parsePartialCacheKeyAnnotations(method);
            return this.parseTriggersRemoveAnnotation(triggersRemove, method, parameterMask);
        }
        for (Annotation metaAnn : method.getAnnotations()) {
            Class<? extends Annotation> annotationType = metaAnn.annotationType();
            cacheableAnnotation = annotationType.getAnnotation(Cacheable.class);
            if (cacheableAnnotation != null) {
                ParameterMask parameterMask = this.parsePartialCacheKeyAnnotations(method);
                return this.parseCacheableAnnotation(cacheableAnnotation, method, parameterMask);
            }
            triggersRemove = annotationType.getAnnotation(TriggersRemove.class);
            if (triggersRemove == null) continue;
            ParameterMask parameterMask = this.parsePartialCacheKeyAnnotations(method);
            return this.parseTriggersRemoveAnnotation(triggersRemove, method, parameterMask);
        }
        return null;
    }

    protected ParameterMask parsePartialCacheKeyAnnotations(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        boolean[] mask = new boolean[parameterAnnotations.length];
        block0: for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = parameterAnnotations[i]) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!PartialCacheKey.class.equals(annotationType)) continue;
                mask[i] = true;
                continue block0;
            }
        }
        return ParameterMask.create(mask);
    }

    protected CacheableAttribute parseCacheableAnnotation(Cacheable ann, Method method, ParameterMask parameterMask) {
        String resolverFactoryName = ann.resolverFactoryName();
        ResolverFactory resolverFactory = ann.resolverFactory();
        CacheResolverFactory cacheResolverFactory = this.getCacheResolverFactory(resolverFactoryName, resolverFactory);
        CacheableCacheResolver cacheResolver = cacheResolverFactory.getCacheResolver(ann, method);
        String keyGeneratorName = ann.keyGeneratorName();
        KeyGenerator keyGenerator = ann.keyGenerator();
        CacheKeyGenerator<? extends Serializable> cacheKeyGenerator = this.getCacheKeyGenerator(keyGeneratorName, keyGenerator);
        String cacheableInteceptorName = ann.cacheableInteceptorName();
        CacheableInterceptor cacheInterceptor = this.getCacheInterceptor(cacheableInteceptorName);
        boolean cacheNull = ann.cacheNull();
        DecoratedCacheType decoratedCacheType = DecoratedCacheType.getDecoratedCacheType(ann, method);
        if (!(cacheNull || decoratedCacheType != DecoratedCacheType.REFRESHING_SELF_POPULATING_CACHE && decoratedCacheType != DecoratedCacheType.SELF_POPULATING_CACHE)) {
            this.logger.warn("cacheNull is set to false and decoratedCacheType is " + (Object)((Object)decoratedCacheType) + ", cacheNull will be ignored on: " + method);
        }
        return new CacheableAttributeImpl(cacheResolver, cacheKeyGenerator, parameterMask, cacheNull, cacheInterceptor);
    }

    protected TriggersRemoveAttribute parseTriggersRemoveAnnotation(TriggersRemove ann, Method method, ParameterMask parameterMask) {
        String resolverFactoryName = ann.resolverFactoryName();
        ResolverFactory resolverFactory = ann.resolverFactory();
        CacheResolverFactory cacheResolverFactory = this.getCacheResolverFactory(resolverFactoryName, resolverFactory);
        TriggersRemoveCacheResolver cacheResolver = cacheResolverFactory.getCacheResolver(ann, method);
        String keyGeneratorName = ann.keyGeneratorName();
        KeyGenerator keyGenerator = ann.keyGenerator();
        CacheKeyGenerator<? extends Serializable> cacheKeyGenerator = this.getCacheKeyGenerator(keyGeneratorName, keyGenerator);
        String triggersRemoveInteceptorName = ann.triggersRemoveInteceptorName();
        TriggersRemoveInterceptor triggersRemoveInterceptor = this.getTriggersRemoveInterceptor(triggersRemoveInteceptorName);
        boolean removeAll = ann.removeAll();
        When when = ann.when();
        return new TriggersRemoveAttributeImpl(cacheResolver, cacheKeyGenerator, parameterMask, triggersRemoveInterceptor, removeAll, when);
    }

    protected final CacheableInterceptor getCacheInterceptor(String cacheableInteceptorName) {
        if (StringUtils.hasLength((String)cacheableInteceptorName)) {
            return (CacheableInterceptor)this.beanFactory.getBean(cacheableInteceptorName, CacheableInterceptor.class);
        }
        return this.defaultCacheableInterceptor;
    }

    protected final TriggersRemoveInterceptor getTriggersRemoveInterceptor(String triggersRemoveInterceptorName) {
        if (StringUtils.hasLength((String)triggersRemoveInterceptorName)) {
            return (TriggersRemoveInterceptor)this.beanFactory.getBean(triggersRemoveInterceptorName, TriggersRemoveInterceptor.class);
        }
        return this.defaultTriggersRemoveInterceptor;
    }

    protected final CacheResolverFactory getCacheResolverFactory(String resolverFactoryName, ResolverFactory resolverFactory) {
        String cacheResolverClassName = resolverFactory.name();
        if (cacheResolverClassName.length() > 0) {
            return this.getOrCreateCacheResolverFactory(resolverFactory);
        }
        if (StringUtils.hasLength((String)resolverFactoryName)) {
            return (CacheResolverFactory)this.beanFactory.getBean(resolverFactoryName, CacheResolverFactory.class);
        }
        return this.cacheResolverFactory;
    }

    protected final CacheKeyGenerator<? extends Serializable> getCacheKeyGenerator(String keyGeneratorName, KeyGenerator keyGenerator) {
        String keyGeneratorClassName = keyGenerator.name();
        if (keyGeneratorClassName.length() > 0) {
            return this.getOrCreateCacheKeyGenerator(keyGenerator);
        }
        CacheKeyGenerator cacheKeyGenerator = StringUtils.hasLength((String)keyGeneratorName) ? (CacheKeyGenerator)this.beanFactory.getBean(keyGeneratorName, CacheKeyGenerator.class) : this.defaultCacheKeyGenerator;
        return cacheKeyGenerator;
    }

    protected final CacheKeyGenerator<? extends Serializable> getOrCreateCacheKeyGenerator(KeyGenerator keyGenerator) {
        String keyGeneratorClassName = keyGenerator.name();
        if (!keyGeneratorClassName.contains(".")) {
            keyGeneratorClassName = "com.googlecode.ehcache.annotations.key." + keyGeneratorClassName;
        }
        return this.getOrCreateChildBean(CacheKeyGenerator.class, keyGeneratorClassName, keyGenerator.properties());
    }

    protected final CacheResolverFactory getOrCreateCacheResolverFactory(ResolverFactory resolverFactory) {
        String resolverFactoryClassName = resolverFactory.name();
        if (!resolverFactoryClassName.contains(".")) {
            resolverFactoryClassName = "com.googlecode.ehcache.annotations.resolver." + resolverFactoryClassName;
        }
        return this.getOrCreateChildBean(CacheResolverFactory.class, resolverFactoryClassName, resolverFactory.properties());
    }

    protected final <T> T getOrCreateChildBean(Class<T> beanType, String beanClass, Property[] properties) {
        AbstractBeanDefinition beanDefinition;
        StringBuilder beanNameBuilder = new StringBuilder();
        beanNameBuilder.append(beanClass);
        MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
        Arrays.sort(properties, PropertyComparator.INSTANCE);
        for (Property property : properties) {
            String name = property.name();
            String value = property.value();
            String ref = property.ref();
            beanNameBuilder.append("[").append(name).append(",").append(value).append(",").append(ref).append("]");
            if (value.length() > 0) {
                if (ref.length() > 0) {
                    throw new IllegalArgumentException("Only one of value or ref must be specified no both on Property with name: " + name);
                }
                mutablePropertyValues.addPropertyValue(name, (Object)value);
                continue;
            }
            if (ref.length() > 0) {
                mutablePropertyValues.addPropertyValue(name, (Object)new RuntimeBeanReference(ref));
                continue;
            }
            throw new IllegalArgumentException("Either value or ref must be specified on Property with name: " + name);
        }
        String beanName = beanNameBuilder.toString();
        if (this.childBeanFactory.containsBean(beanName)) {
            return (T)this.childBeanFactory.getBean(beanName, beanType);
        }
        try {
            beanDefinition = BeanDefinitionReaderUtils.createBeanDefinition(null, (String)beanClass, (ClassLoader)ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreationException("Could not find class '" + beanClass + "' to create " + beanType + " from", (Throwable)e);
        }
        if (ReflectionHelperAware.class.isAssignableFrom(beanDefinition.getBeanClass())) {
            mutablePropertyValues.addPropertyValue("reflectionHelper", (Object)this.reflectionHelper);
        }
        beanDefinition.setPropertyValues(mutablePropertyValues);
        this.childBeanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return (T)this.childBeanFactory.getBean(beanName, beanType);
    }
}

