/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.mustache;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.sampullara.mustache.Code;
import com.sampullara.mustache.FunctionIterator;
import com.sampullara.mustache.MustacheException;
import com.sampullara.mustache.MustacheJava;
import com.sampullara.mustache.MustacheTrace;
import com.sampullara.mustache.Scope;
import com.sampullara.util.FutureWriter;
import com.sampullara.util.TemplateFunction;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jackson.JsonNode;

public class Mustache {
    protected static Logger logger = Logger.getLogger(Mustache.class.getName());
    protected static final boolean debug = Boolean.getBoolean("mustache.debug");
    public static final boolean trace = Boolean.getBoolean("mustache.trace");
    public static final boolean profile = Boolean.getBoolean("mustache.profile");
    private static final String IMPLICIT_CURRENT_ELEMENT_TOKEN = ".";
    protected static final ThreadLocal<Integer> line = new ThreadLocal();
    private String name;
    private Code[] compiled;
    protected MustacheJava mj;
    protected ThreadLocal<Stack<FutureWriter>> capturedWriter = new ThreadLocal<Stack<FutureWriter>>(){

        @Override
        protected Stack<FutureWriter> initialValue() {
            return new Stack<FutureWriter>();
        }
    };
    protected ThreadLocal<Stack<FutureWriter>> actual = new ThreadLocal<Stack<FutureWriter>>(){

        @Override
        protected Stack<FutureWriter> initialValue() {
            return new Stack<FutureWriter>();
        }
    };
    private static Map<String, Mustache> templateFunctionCache = new ConcurrentHashMap<String, Mustache>();
    private Map<String, Mustache> partialCache = new ConcurrentHashMap<String, Mustache>();
    private static Map<String, Boolean> missing = new ConcurrentHashMap<String, Boolean>();
    private static Pattern findToEncode = Pattern.compile("&(?!\\w+;)|[\"<>\\\\\n]");

    public Scope unexecute(String text) throws MustacheException {
        AtomicInteger position = new AtomicInteger(0);
        Scope unexecuted = this.unexecute(text, position);
        if (unexecuted == null) {
            int min = Math.min(position.get() + 50, position.get() + Math.max(0, text.length() - position.get()));
            throw new MustacheException("Failed to match template at " + this.name + ":" + line.get() + " with text " + text.substring(position.get(), min));
        }
        return unexecuted;
    }

    protected Scope unexecute(String text, AtomicInteger position) throws MustacheException {
        Scope current = new Scope();
        for (int i = 0; i < this.compiled.length && current != null; ++i) {
            if (debug) {
                line.set(this.compiled[i].getLine());
            }
            Code[] truncate = Mustache.truncate(this.compiled, i + 1, new Code[0]);
            current = this.compiled[i].unexecute(current, text, position, truncate);
        }
        return current;
    }

    public static Code[] truncate(Code[] codes, int start, Code[] next) {
        if (codes.length <= 1) {
            return next;
        }
        Code[] truncate = new Code[codes.length - start];
        System.arraycopy(codes, start, truncate, 0, truncate.length);
        return truncate;
    }

    public final void execute(Writer writer, Map map) throws MustacheException, IOException {
        FutureWriter fw = new FutureWriter(writer);
        this.execute(fw, new Scope((Object)map));
        fw.flush();
    }

    public final void execute(Writer writer, JsonNode jsonNode) throws MustacheException, IOException {
        FutureWriter fw = new FutureWriter(writer);
        this.execute(fw, new Scope(jsonNode));
        fw.flush();
    }

    public final void execute(Writer writer, Scope ctx) throws MustacheException, IOException {
        FutureWriter fw = new FutureWriter(writer);
        this.execute(fw, ctx);
        fw.flush();
    }

    public final void execute(FutureWriter writer, Map map) throws MustacheException {
        this.execute(writer, new Scope((Object)map));
    }

    public final void execute(FutureWriter writer, JsonNode jsonNode) throws MustacheException {
        this.execute(writer, new Scope(jsonNode));
    }

    public void execute(FutureWriter writer, Scope ctx) throws MustacheException {
        for (Code code : this.compiled) {
            if (debug) {
                line.set(code.getLine());
            }
            code.execute(writer, ctx);
        }
    }

    public void identity(FutureWriter writer) throws MustacheException {
        for (Code code : this.compiled) {
            if (debug) {
                line.set(code.getLine());
            }
            code.identity(writer);
        }
    }

    protected void enqueue(FutureWriter writer, final Mustache m, final Scope s) throws IOException {
        writer = this.pushWriter(writer);
        writer.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                FutureWriter fw = new FutureWriter();
                m.execute(fw, s);
                return fw;
            }
        });
    }

    protected FutureWriter pushWriter(FutureWriter writer) {
        Stack<FutureWriter> capturedStack = this.capturedWriter.get();
        if (capturedStack.size() > 0) {
            Stack<FutureWriter> actualStack = this.actual.get();
            actualStack.push(writer);
            writer = capturedStack.peek();
        }
        return writer;
    }

    protected void write(Writer writer, Scope s, String name, boolean encode) throws MustacheException {
        MustacheTrace.Event event = null;
        if (trace) {
            Object parent = s.getParent();
            String traceName = parent == null ? s.getClass().getName() : parent.getClass().getName();
            event = MustacheTrace.addEvent("get: " + name, traceName);
        }
        Object value = this.getValue(s, name);
        if (trace) {
            event.end();
        }
        if (value != null) {
            FutureWriter fw;
            if (value instanceof Future) {
                try {
                    if (writer instanceof FutureWriter) {
                        fw = (FutureWriter)writer;
                        fw.enqueue((Future)value);
                        return;
                    }
                    value = ((Future)value).get();
                }
                catch (Exception e) {
                    throw new MustacheException("Failed to evaluate future value: " + name, e);
                }
            }
            if (value instanceof FutureWriter) {
                if (writer instanceof FutureWriter) {
                    fw = (FutureWriter)writer;
                    final Object finalValue = value;
                    try {
                        fw.enqueue(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                return finalValue;
                            }
                        });
                    }
                    catch (IOException e) {
                        throw new MustacheException("Failed to enqueue future writer", e);
                    }
                }
            } else {
                String string = String.valueOf(value);
                if (encode) {
                    string = this.encode(string);
                }
                try {
                    writer.write(string);
                }
                catch (IOException e) {
                    throw new MustacheException("Failed to write: " + e);
                }
            }
        }
    }

    public void setCompiled(List<Code> compiled) {
        this.compiled = new ArrayList<Code>(compiled).toArray(new Code[compiled.size()]);
    }

    public Code[] getCompiled() {
        return this.compiled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String filename) {
        this.name = filename;
    }

    protected Iterable<Scope> ifiterable(Scope s, final String name) {
        return Iterables.limit((Iterable)Iterables.transform(this.iterable(s, name), (Function)new Function<Scope, Scope>(){

            public Scope apply(Scope scope) {
                scope.remove(name);
                return scope;
            }
        }), (int)1);
    }

    protected Iterable<Scope> iterable(final Scope s, final String name) {
        Object value;
        MustacheTrace.Event event = null;
        if (trace) {
            Object parent = s.getParent();
            String traceName = parent == null ? s.getClass().getName() : parent.getClass().getName();
            event = MustacheTrace.addEvent("iterable: " + name, traceName);
        }
        if ((value = this.getValue(s, name)) instanceof Function) {
            if (trace) {
                event.end();
            }
            return this.function(s, (Function)value);
        }
        if (trace) {
            event.end();
        }
        if (value == null || value instanceof Boolean && !((Boolean)value).booleanValue()) {
            return Scope.EMPTY;
        }
        return new Iterable<Scope>(){

            @Override
            public Iterator<Scope> iterator() {
                return new Iterator<Scope>(){
                    Iterator i;
                    Object iterable;
                    {
                        this.iterable = value;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.i == null) {
                            if (this.iterable instanceof Future) {
                                try {
                                    this.iterable = ((Future)this.iterable).get();
                                    if (this.iterable == null || this.iterable instanceof Boolean && !((Boolean)this.iterable).booleanValue()) {
                                        return false;
                                    }
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            this.i = this.iterable instanceof Iterable && (!(this.iterable instanceof JsonNode) || ((JsonNode)this.iterable).isArray()) ? ((Iterable)this.iterable).iterator() : new SingleValueIterator(this.iterable);
                        }
                        return this.i.hasNext();
                    }

                    @Override
                    public Scope next() {
                        MustacheTrace.Event event = null;
                        if (trace) {
                            Object parent = s.getParent();
                            String traceName = parent == null ? s.getClass().getName() : parent.getClass().getName();
                            event = MustacheTrace.addEvent("iterable next: " + name, traceName);
                        }
                        Object value = this.i.next();
                        if (trace) {
                            event.end();
                        }
                        Scope scope = !(value instanceof Boolean) ? new Scope(value, s) : new Scope(s);
                        scope.put(name, value);
                        return scope;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public FunctionIterator function(final Scope scope, final Function f) {
        final boolean templateFunction = f instanceof TemplateFunction;
        return new FunctionIterator(f){

            @Override
            public Iterator<Scope> iterator() {
                return new Iterator<Scope>(){
                    boolean first = true;
                    StringWriter writer = new StringWriter();

                    @Override
                    public synchronized boolean hasNext() {
                        if (this.first) {
                            Mustache.this.capturedWriter.get().push(new FutureWriter(this.writer));
                        } else {
                            try {
                                String applyString;
                                Mustache.this.capturedWriter.get().pop().flush();
                                Object apply = f.apply((Object)this.writer.toString());
                                String string = applyString = apply == null ? null : String.valueOf(apply);
                                if (templateFunction) {
                                    if (applyString != null) {
                                        Mustache mustache = (Mustache)templateFunctionCache.get(applyString);
                                        if (mustache == null) {
                                            mustache = Mustache.this.mj.parse(applyString, Mustache.this.name);
                                            templateFunctionCache.put(applyString, mustache);
                                        }
                                        mustache.execute(Mustache.this.actual.get().pop(), scope);
                                    }
                                } else {
                                    Mustache.this.actual.get().pop().write(applyString);
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return this.first;
                    }

                    @Override
                    public synchronized Scope next() {
                        if (this.first) {
                            this.first = false;
                            return scope;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public void setMustacheJava(MustacheJava mj) {
        this.mj = mj;
    }

    protected Mustache partial(String name) throws MustacheException {
        return this.compilePartial(name);
    }

    protected Mustache compilePartial(String name) throws MustacheException {
        MustacheTrace.Event event = null;
        if (trace) {
            event = MustacheTrace.addEvent("compile partial: " + name, "");
        }
        Mustache mustache = this.mj.parseFile(name + IMPLICIT_CURRENT_ELEMENT_TOKEN + this.getPartialExtension());
        mustache.setMustacheJava(this.mj);
        if (trace) {
            event.end();
        }
        return mustache;
    }

    protected String getPartialExtension() {
        int index = this.name.lastIndexOf(IMPLICIT_CURRENT_ELEMENT_TOKEN);
        return this.name.substring(index + 1);
    }

    protected void partial(FutureWriter writer, Scope s, String name, Mustache partial) throws MustacheException {
        if (name != null) {
            Object parent;
            MustacheTrace.Event event = null;
            if (trace) {
                parent = s.getParent();
                String traceName = parent == null ? s.getClass().getName() : parent.getClass().getName();
                event = MustacheTrace.addEvent("partial: " + name, traceName);
            }
            Scope scope = (parent = s.get(name)) == null ? s : new Scope(parent, s);
            partial.execute(writer, scope);
            if (trace) {
                event.end();
            }
        }
    }

    protected Iterable<Scope> inverted(Scope s, String name) {
        boolean isntEmpty;
        MustacheTrace.Event event = null;
        if (trace) {
            Object parent = s.getParent();
            String traceName = parent == null ? s.getClass().getName() : parent.getClass().getName();
            event = MustacheTrace.addEvent("inverted: " + name, traceName);
        }
        Object possibleFuture = this.getValue(s, name);
        while (possibleFuture instanceof Future) {
            try {
                possibleFuture = ((Future)possibleFuture).get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Object value = possibleFuture;
        if (trace) {
            event.end();
        }
        boolean bl = isntEmpty = value instanceof Iterable && ((Iterable)value).iterator().hasNext();
        if (isntEmpty || value instanceof Boolean && ((Boolean)value).booleanValue() || value != null && !(value instanceof Iterable) && !(value instanceof Boolean)) {
            return Scope.EMPTY;
        }
        final Scope scope = new Scope(s);
        scope.put(name, true);
        return new Iterable<Scope>(){

            @Override
            public Iterator<Scope> iterator() {
                return new Iterator<Scope>(){
                    Scope value;
                    {
                        this.value = scope;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.value != null;
                    }

                    @Override
                    public Scope next() {
                        Scope tmp = this.value;
                        this.value = null;
                        return tmp;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    protected Object getValue(Scope s, String name) {
        try {
            Object o = IMPLICIT_CURRENT_ELEMENT_TOKEN.equals(name) ? s.values().iterator().next() : s.get(name);
            if (o == null && debug) {
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                    String className = ste.getClassName();
                    if (!className.startsWith("com.sampullara.mustaches.Mustache")) continue;
                    sb.append(this.name).append(":").append(ste.getLineNumber());
                    break;
                }
                if (sb.length() == 0) {
                    sb.append(this.name).append(":").append(line.get());
                }
                String location = name + " @ " + sb;
                if (!name.startsWith("_") && missing.put(location, true) == null) {
                    logger.warning("No field, method or key found for: " + location + " " + s);
                }
            }
            if (o == Scope.NULL) {
                return null;
            }
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String encode(String value) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = findToEncode.matcher(value);
        while (matcher.find()) {
            char c = matcher.group().charAt(0);
            switch (c) {
                case '&': {
                    matcher.appendReplacement(sb, "&amp;");
                    break;
                }
                case '\\': {
                    matcher.appendReplacement(sb, "\\\\");
                    break;
                }
                case '\"': {
                    matcher.appendReplacement(sb, "&quot;");
                    break;
                }
                case '<': {
                    matcher.appendReplacement(sb, "&lt;");
                    break;
                }
                case '>': {
                    matcher.appendReplacement(sb, "&gt;");
                    break;
                }
                case '\n': {
                    matcher.appendReplacement(sb, "&#10;");
                }
            }
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String decode(String value) {
        return value.replaceAll("&quot;", "\"").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&#10;", "\n").replaceAll("\\\\", "\\").replaceAll("&amp;", "&");
    }

    private class SingleValueIterator
    implements Iterator {
        private boolean done;
        private Object value;

        SingleValueIterator(Object value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        public Object next() {
            if (!this.done) {
                this.done = true;
                return this.value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.done = true;
        }
    }
}

