/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorGradientType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.GeoStyle;
import com.supermap.data.JoinItems;
import com.supermap.data.Size2D;
import com.supermap.data.TextStyle;
import com.supermap.data.Toolkit;
import com.supermap.mapping.AlongLineCulture;
import com.supermap.mapping.AlongLineDirection;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalTextStyle;
import com.supermap.mapping.LabelBackShape;
import com.supermap.mapping.LabelMatrix;
import com.supermap.mapping.LabelType;
import com.supermap.mapping.MixedTextStyle;
import com.supermap.mapping.OverLengthLabelMode;
import com.supermap.mapping.RangeMode;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeLabelItem;
import com.supermap.mapping.ThemeLabelNative;
import java.util.ArrayList;

public class ThemeLabel
extends Theme {
    private ArrayList _$9 = null;
    private GeoStyle _$8 = null;
    private GeoStyle _$7 = null;
    private TextStyle _$6 = null;
    private MixedTextStyle _$5 = null;
    private LabelMatrix _$4 = null;
    private ThemeLabel _$3 = null;
    private Size2D _$2;
    private RangeMode _$1;

    public ThemeLabel() {
        long l = ThemeLabelNative.jni_New();
        this.setHandle(l, true);
        this._$1();
        this._$9 = new ArrayList();
        this._$1 = RangeMode.NONE;
    }

    public ThemeLabel(ThemeLabel themeLabel) {
        if (themeLabel == null) {
            String string = InternalResource.loadString("themeLabel", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeLabel.getHandle() == 0L) {
            String string = InternalResource.loadString("themeLabel", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeLabelNative.jni_Clone(themeLabel.getHandle());
        this.setHandle(l, true);
        this._$9 = new ArrayList();
        int n = themeLabel.getLabelItemsList().size();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeLabel));
        for (int i = 0; i < n; ++i) {
            ThemeLabelItem themeLabelItem = new ThemeLabelItem(this);
            this._$9.add(themeLabelItem);
        }
        this._$1 = RangeMode.NONE;
    }

    ThemeLabel(long l, boolean bl) {
        this.setHandle(l, bl);
        int n = ThemeLabelNative.jni_GetValueCount(this.getHandle());
        this._$9 = new ArrayList();
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            ThemeLabelItem themeLabelItem = new ThemeLabelItem(this);
            this._$9.add(themeLabelItem);
        }
        this._$1 = RangeMode.NONE;
    }

    public ThemeLabelItem getItem(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return (ThemeLabelItem)this._$9.get(n);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetValueCount(this.getHandle());
        int n2 = 0;
        n2 = n == 0 || n == 1 ? 0 : n - 1;
        return n2;
    }

    public GeoStyle getBackStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBackStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 == null && (l = ThemeLabelNative.jni_GetBackStyle(this.getHandle())) != 0L) {
            this._$8 = InternalGeoStyle.createInstance(l);
        }
        return this._$8;
    }

    public void setBackStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBackStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle2 = geoStyle.clone();
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle2);
        ThemeLabelNative.jni_SetBackStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle2);
    }

    public LabelBackShape getBackShape() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBackShape()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetBackShape(this.getHandle());
        return (LabelBackShape)InternalEnum.parseUGCValue(LabelBackShape.class, n);
    }

    public void setBackShape(LabelBackShape labelBackShape) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBackShape(LabelBackShape value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (labelBackShape == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(labelBackShape);
        ThemeLabelNative.jni_SetBackShape(this.getHandle(), n);
    }

    public int getMaxLabelLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxLabelLength()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetMaxLabelLength(this.getHandle());
    }

    public void setMaxLabelLength(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxLabelLength(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "ThemeLabel_TheArgumentOfMaxLabelLengthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeLabelNative.jni_SetMaxLabelLength(this.getHandle(), n);
    }

    public OverLengthLabelMode getOverLengthMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOverLengthMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetOverLengthMode(this.getHandle());
        return (OverLengthLabelMode)InternalEnum.parseUGCValue(OverLengthLabelMode.class, n);
    }

    public void setOverLengthMode(OverLengthLabelMode overLengthLabelMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverLenghMode(OverLengthLabelMode value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (overLengthLabelMode == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(overLengthLabelMode);
        ThemeLabelNative.jni_SetOverLengthMode(this.getHandle(), n);
    }

    public boolean isFlowEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsFlowEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsFlowEnabled(this.getHandle());
    }

    public void setFlowEnabled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsFlowEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetIsFlowEnabled(this.getHandle(), bl);
    }

    public boolean isSmallGeometryLabeled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSmallGeometryLabeled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsSmallGeometryLabeled(this.getHandle());
    }

    public void setSmallGeometryLabeled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSmallGeometryLabeled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetSmallGeometryLabeled(this.getHandle(), bl);
    }

    public AlongLineDirection getAlongLineDirection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAlongLineDirection()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetAlongLineDirection(this.getHandle());
        return (AlongLineDirection)InternalEnum.parseUGCValue(AlongLineDirection.class, n);
    }

    public void setAlongLineDirection(AlongLineDirection alongLineDirection) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAlongLineDirection(AlongLineDirection value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (alongLineDirection == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(alongLineDirection);
        ThemeLabelNative.jni_SetAlongLineDirection(this.getHandle(), n);
    }

    public AlongLineCulture getAlongLineCulture() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAlongLineCulture()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetAlongLineCulture(this.getHandle());
        return (AlongLineCulture)InternalEnum.parseUGCValue(AlongLineCulture.class, n);
    }

    public void setAlongLineCulture(AlongLineCulture alongLineCulture) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAlongLineCulture(AlongLineCulture value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (alongLineCulture == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(alongLineCulture);
        ThemeLabelNative.jni_SetAlongLineCulture(this.getHandle(), n);
    }

    public boolean isAlongLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAlongLine()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsAlongLine(this.getHandle());
    }

    public void setAlongLine(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsAlongLine(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetIsAlongLine(this.getHandle(), bl);
    }

    public boolean isAngleFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsAngleFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsAngleFixed(this.getHandle());
    }

    public void setAngleFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsAngleFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetIsAngleFixed(this.getHandle(), bl);
    }

    public boolean isOverlapAvoided() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsOverlapAvoided()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsOverlapAvoid(this.getHandle());
    }

    public void setOverlapAvoided(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsOverlapAvoided(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetIsOverlapAvoid(this.getHandle(), bl);
    }

    public boolean isRepeatIntervalFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRepeatIntervalFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetRepeatIntervalFixed(this.getHandle());
    }

    public void setRepeatIntervalFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRepeatIntervalFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetRepeatIntervalFixed(this.getHandle(), bl);
    }

    public double getLabelRepeatInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabelRepeatInterval()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetLabelRepeatInterval(this.getHandle());
    }

    public void setLabelRepeatInterval(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLabelRepeatInterval(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetLabelRepeatInterval(this.getHandle(), d);
    }

    public String getOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetX()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetOffsetX(this.getHandle());
    }

    public void setOffsetX(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOffsetX(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        ThemeLabelNative.jni_SetOffsetX(this.getHandle(), string);
    }

    public String getOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetY()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetOffsetY(this.getHandle());
    }

    public void setOffsetY(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOffsetY(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        ThemeLabelNative.jni_SetOffsetY(this.getHandle(), string);
    }

    public GeoStyle getLeaderLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLeaderLineStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$7 == null && (l = ThemeLabelNative.jni_GetLeaderLineStyle(this.getHandle())) != 0L) {
            this._$7 = InternalGeoStyle.createInstance(l);
        }
        return this._$7;
    }

    public void setLeaderLineStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLeaderLineStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle2 = geoStyle.clone();
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle2);
        ThemeLabelNative.jni_SetLeaderLineStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle2);
    }

    public boolean isLeaderLineDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsLeaderLineDisplayed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsLeaderLineDisplayed(this.getHandle());
    }

    public void setLeaderLineDisplayed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsLeaderLineDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetIsLeaderLineDisplayed(this.getHandle(), bl);
    }

    public String getRangeExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetRangeExpression(this.getHandle());
    }

    public void setRangeExpression(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setRangeExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        ThemeLabelNative.jni_SetRangeExpression(this.getHandle(), string);
    }

    public String getLabelExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabelExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetLabelExpression(this.getHandle());
    }

    public void setLabelExpression(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setLabelExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetLabelExpression(this.getHandle(), string);
        this.m_lock.unlock();
    }

    public TextStyle getUniformStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUniformStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$6 == null && (l = ThemeLabelNative.jni_GetUniformStyle(this.getHandle())) != 0L) {
            this._$6 = InternalTextStyle.createInstance(l);
        }
        return this._$6;
    }

    public void setUniformStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUniformStyle(TextStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle2 = textStyle.clone();
        this.m_lock.lock();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle2);
        ThemeLabelNative.jni_SetUniformStyle(this.getHandle(), l2);
        this.m_lock.unlock();
        InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle2);
    }

    public boolean addToHead(ThemeLabelItem themeLabelItem) {
        return this.addToHead(themeLabelItem, false);
    }

    public boolean addToTail(ThemeLabelItem themeLabelItem) {
        return this.addToTail(themeLabelItem, false);
    }

    public boolean addToHead(ThemeLabelItem themeLabelItem, boolean bl) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToHead(ThemeLabelItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeLabelItem.getStart() >= themeLabelItem.getEnd()) {
            if (bl) {
                if (Toolkit.isZero((double)(themeLabelItem.getStart() - themeLabelItem.getEnd()))) {
                    return false;
                }
                Double d = themeLabelItem.getStart();
                themeLabelItem.setStart(themeLabelItem.getEnd());
                themeLabelItem.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeLabel_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeLabelNative.jni_GetValueAt(this.getHandle(), 0);
            double d3 = themeLabelItem.getEnd();
            double d4 = d3 - d2;
            boolean bl2 = Toolkit.isZero((double)d4);
            if (!bl2) {
                if (bl) {
                    themeLabelItem.setEnd(d2);
                } else {
                    String string = InternalResource.loadString("item.getEnd()", "ThemeLabel_InvalidEndOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl2 = Toolkit.isZero((double)(d4 = (d = themeLabelItem.getStart()) - d2))) || d > d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeLabelItem themeLabelItem2 = new ThemeLabelItem(themeLabelItem);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabelItem2.getStyle());
        boolean bl3 = ThemeLabelNative.jni_AddToHead(this.getHandle(), themeLabelItem2.getCaption(), themeLabelItem2.isVisible(), l, themeLabelItem2.getStart(), themeLabelItem2.getEnd());
        if (bl3) {
            ThemeLabelItem themeLabelItem3 = new ThemeLabelItem(this);
            this._$9.add(0, themeLabelItem3);
            this._$2();
        }
        this.m_lock.unlock();
        return bl3;
    }

    public boolean addToTail(ThemeLabelItem themeLabelItem, boolean bl) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToTail(ThemeLabelItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeLabelItem.getStart() >= themeLabelItem.getEnd()) {
            if (bl) {
                if (Toolkit.isZero((double)(themeLabelItem.getStart() - themeLabelItem.getEnd()))) {
                    return false;
                }
                Double d = themeLabelItem.getStart();
                themeLabelItem.setStart(themeLabelItem.getEnd());
                themeLabelItem.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeLabel_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeLabelNative.jni_GetValueAt(this.getHandle(), n);
            double d3 = themeLabelItem.getStart();
            double d4 = d3 - d2;
            boolean bl2 = Toolkit.isZero((double)d4);
            if (!bl2) {
                if (bl) {
                    themeLabelItem.setStart(d2);
                } else {
                    String string = InternalResource.loadString("item.getStart()", "ThemeLabel_InavlidStartOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl2 = Toolkit.isZero((double)(d4 = d2 - (d = themeLabelItem.getEnd())))) || d < d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeLabelItem themeLabelItem2 = new ThemeLabelItem(themeLabelItem);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeLabelItem2.getStyle());
        boolean bl3 = ThemeLabelNative.jni_AddToTail(this.getHandle(), themeLabelItem2.getCaption(), themeLabelItem2.isVisible(), l, themeLabelItem2.getStart(), themeLabelItem2.getEnd());
        if (bl3) {
            ThemeLabelItem themeLabelItem3 = new ThemeLabelItem(this);
            this._$9.add(themeLabelItem3);
            this._$2();
        }
        this.m_lock.unlock();
        return bl3;
    }

    public boolean split(int n, double d, TextStyle textStyle, String string, TextStyle textStyle2, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("split(int index, double splitValue, TextStyle style1, String caption1, TextStyle style2, String caption2)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string4 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string4);
        }
        if (textStyle == null) {
            String string5 = InternalResource.loadString("style1", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        if (l == 0L) {
            String string6 = InternalResource.loadString("style1", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if (textStyle2 == null) {
            String string7 = InternalResource.loadString("style2", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle2);
        if (l2 == 0L) {
            String string8 = InternalResource.loadString("style2", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string8);
        }
        double d2 = ThemeLabelNative.jni_GetValueAt(this.getHandle(), n);
        double d3 = ThemeLabelNative.jni_GetValueAt(this.getHandle(), n + 1);
        if (d <= d2 || d >= d3) {
            String string9 = InternalResource.loadString("splitValue", "ThemeLabel_InvalidSplitValue", "mapping_resources");
            throw new IllegalArgumentException(string9);
        }
        TextStyle textStyle3 = textStyle.clone();
        TextStyle textStyle4 = textStyle2.clone();
        long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle3);
        long l4 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle4);
        if (string == null || string.trim().length() == 0) {
            String string10 = InternalResource.loadString("caption1", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string10);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string11 = InternalResource.loadString("caption2", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string11);
        }
        this.m_lock.lock();
        boolean bl = ThemeLabelNative.jni_Split(this.getHandle(), n, d, l3, string, l4, string2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle4);
        if (bl) {
            ThemeLabelItem themeLabelItem = new ThemeLabelItem(this);
            this._$9.add(n + 1, themeLabelItem);
            this._$2();
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean merge(int n, int n2, TextStyle textStyle, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("merge(int index, int count, TextStyle style, String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n3 = this.getCount();
        if (n < 0 || n >= n3) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string3);
        }
        if (n + n2 < n || n + n2 > n3) {
            String string4 = InternalResource.loadString("count", "ThemeLabel_TheCountIsInvalid", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (textStyle == null) {
            String string6 = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        if (l == 0L) {
            String string7 = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        if (n2 == 0) {
            return true;
        }
        this.m_lock.unlock();
        TextStyle textStyle2 = textStyle.clone();
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle2);
        boolean bl = ThemeLabelNative.jni_Merge(this.getHandle(), n, n2, l2, string);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle2);
        if (bl) {
            ThemeLabelItem themeLabelItem = (ThemeLabelItem)this._$9.get(n);
            double d = ThemeLabelNative.jni_GetValueAt(this.getHandle(), n + 1);
            themeLabelItem.setEnd(d);
            themeLabelItem.setCaption(string);
            themeLabelItem.setStyle(textStyle.clone());
            for (int i = 0; i < n2 - 1; ++i) {
                ThemeLabelItem themeLabelItem2 = (ThemeLabelItem)this._$9.get(n + 1);
                themeLabelItem2.clearHandle();
                this._$9.remove(n + 1);
            }
            this._$2();
        }
        this.m_lock.unlock();
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_Clear(this.getHandle());
        if (this._$9 != null) {
            this._$4();
        }
        this.m_lock.unlock();
    }

    public static ThemeLabel makeDefault(DatasetVector datasetVector, String string, RangeMode rangeMode, double d) {
        return ThemeLabel.makeDefault(datasetVector, string, rangeMode, d, null, null);
    }

    public static ThemeLabel makeDefault(DatasetVector datasetVector, String string, RangeMode rangeMode, double d, ColorGradientType colorGradientType) {
        return ThemeLabel.makeDefault(datasetVector, string, rangeMode, d, colorGradientType, null);
    }

    public static ThemeLabel makeDefault(DatasetVector datasetVector, String string, RangeMode rangeMode, double d, ColorGradientType colorGradientType, JoinItems joinItems) {
        int n;
        int n2;
        long l;
        long l2;
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l3 == 0L) {
            String string2 = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("rangeExpression", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)joinItems)) == 0L) {
            String string4 = InternalResource.loadString("joinItems", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (rangeMode == null) {
            String string5 = InternalResource.loadString("rangeMode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if ((rangeMode.equals((Object)RangeMode.EQUALINTERVAL) || rangeMode.equals((Object)RangeMode.SQUAREROOT) || rangeMode.equals((Object)RangeMode.LOGARITHM) || rangeMode.equals((Object)RangeMode.QUANTILE)) && d < 1.0) {
            String string6 = InternalResource.loadString("rangeParameter", "ThemeLabel_TheArgumentOfRangeParameterShouldNotBeLessThanOneRange", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if (rangeMode.equals((Object)RangeMode.CUSTOMINTERVAL) && d < 0.0) {
            String string7 = InternalResource.loadString("rangeParameter", "ThemeLabel_TheArgumentOfRangeParameterShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        if ((l = ThemeLabelNative.jni_MakeDefault(l3, string, l2, n2 = InternalEnum.getUGCValue(rangeMode), d, n = InternalEnum.getUGCValue((Enum)colorGradientType))) == 0L) {
            return null;
        }
        ThemeLabel themeLabel = new ThemeLabel(l, true);
        themeLabel._$1(rangeMode);
        return themeLabel;
    }

    public int indexOf(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetValueCount(this.getHandle());
        int[] nArray = new int[n];
        ThemeLabelNative.jni_GetValues(this.getHandle(), nArray);
        for (int i = 0; i < n - 1; ++i) {
            if (!((double)nArray[i] <= d) || !(d < (double)nArray[i + 1])) continue;
            return i;
        }
        return -1;
    }

    public void reverseStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_ReverseStyle(this.getHandle());
        this.m_lock.unlock();
    }

    @Deprecated
    public MixedTextStyle getUniformMixedSytle() {
        return this.getUniformMixedStyle();
    }

    public MixedTextStyle getUniformMixedStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUniformMixedSytle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null && ThemeLabelNative.jni_GetUniformMixedSytle(this.getHandle())) {
            this._$5 = new MixedTextStyle(this);
        }
        return this._$5;
    }

    @Deprecated
    public void setUniformMixedSytle(MixedTextStyle mixedTextStyle) {
        this.setUniformMixedStyle(mixedTextStyle);
    }

    public void setUniformMixedStyle(MixedTextStyle mixedTextStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUniformMixedSytle(MixedTextStyle value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (mixedTextStyle == null) {
            if (this._$5 != null) {
                this._$5.clearHandle();
                this._$5 = null;
            }
            ThemeLabelNative.jni_SetUniformMixedSytle(this.getHandle(), false);
            return;
        }
        ThemeLabelNative.jni_SetUniformMixedSytle(this.getHandle(), true);
        if (this._$5 == null) {
            this._$5 = new MixedTextStyle(this);
        }
        this._$5.setDefaultStyle(mixedTextStyle.getDefaultStyle());
        if (mixedTextStyle.getSeparator() != null) {
            this._$5.setSeparator(mixedTextStyle.getSeparator());
        }
        this._$5.setSeparatorEnabled(mixedTextStyle.isSeparatorEnabled());
        this._$5.setSplitIndexes(mixedTextStyle.getSplitIndexes());
        this._$5.setStyles(mixedTextStyle.getStyles());
    }

    public LabelMatrix getLabels() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLabels()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null && (l = ThemeLabelNative.jni_GetThemeLabelLabelMatrix(this.getHandle())) != 0L) {
            this._$4 = new LabelMatrix(l, this);
            int n = InternalEnum.getUGCValue(LabelType.TABLE);
            ThemeLabelNative.jni_SetThemeLabelType(this.getHandle(), n);
        }
        return this._$4;
    }

    public void setLabels(LabelMatrix labelMatrix) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLabels()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(LabelType.TEXT);
        if (labelMatrix == null) {
            if (this._$4 != null) {
                this._$4.clearHandle();
            }
            this._$4 = null;
            ThemeLabelNative.jni_SetThemeLabelType(this.getHandle(), n);
            ThemeLabelNative.jni_SetThemeLabelLabelMatrix(this.getHandle(), 0L);
            return;
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)labelMatrix) == 0L) {
            String string = InternalResource.loadString("setLabels()", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        n = InternalEnum.getUGCValue(LabelType.TABLE);
        ThemeLabelNative.jni_SetThemeLabelType(this.getHandle(), n);
        long l = ThemeLabelNative.jni_SetThemeLabelLabelMatrix(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)labelMatrix));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)labelMatrix));
        if (this._$4 == null) {
            this._$4 = new LabelMatrix(l, this);
        } else {
            this._$4.clearHandle();
            this._$4.refreshPartsList(l, this);
        }
        this.m_lock.unlock();
    }

    public ThemeLabel getParent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$3;
    }

    public int getNumericPrecision() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNumericPrecision()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = ThemeLabelNative.jni_GetNumericPrecision(this.getHandle());
        if (string.equals("")) {
            return -1;
        }
        if (string.indexOf(".") == -1 || string.indexOf("f") == -1) {
            return -1;
        }
        int n = string.indexOf(".") + 1;
        string = string.substring(n, string.indexOf("f"));
        return Integer.parseInt(string);
    }

    public void setNumericPrecision(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNumericPrecision(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (n >= 0) {
            string = "1." + n + "f";
        }
        ThemeLabelNative.jni_SetNumericPrecision(this.getHandle(), string);
    }

    public int getMaxTextHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxTextHeight()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetMaxTextHeight(this.getHandle());
    }

    public void setMaxTextHeight(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxTextHeight(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetMaxTextHeight(this.getHandle(), n);
        this.m_lock.unlock();
    }

    public int getMinTextHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinTextHeight()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetMinTextHeight(this.getHandle());
    }

    public void setMinTextHeight(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinTextHeight(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetMinTextHeight(this.getHandle(), n);
        this.m_lock.unlock();
    }

    public int getMaxTextWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxTextHeight()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetMaxTextWidth(this.getHandle());
    }

    public void setMaxTextWidth(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxTextWidth(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetMaxTextWidth(this.getHandle(), n);
        this.m_lock.unlock();
    }

    public int getMinTextWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinTextWidth()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetMinTextWidth(this.getHandle());
    }

    public void setMinTextWidth(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinTextWidth(int result)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeLabelNative.jni_SetMinTextWidth(this.getHandle(), n);
        this.m_lock.unlock();
    }

    public Size2D getTextExtentInflation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextExtentInflation()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        ThemeLabelNative.jni_GetTextExtentInflation(this.getHandle(), dArray);
        if (this._$2 == null) {
            this._$2 = new Size2D(dArray[0], dArray[1]);
        } else {
            this._$2.setWidth(dArray[0]);
            this._$2.setHeight(dArray[1]);
        }
        return this._$2;
    }

    public void setTextExtentInflation(Size2D size2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextExtentInflation(Size2D value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (size2D.getHeight() < 0.0 || size2D.getWidth() < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeLabelNative.jni_SetTextExtentInflation(this.getHandle(), size2D.getWidth(), size2D.getHeight());
    }

    public boolean isRepeatedLabelAvoided() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRepeatedLableAvoided()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_IsRepeatedLableAvoided(this.getHandle());
    }

    public void setRepeatedLabelAvoided(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRepeatedLableAvoided(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetRepeatedLableAvoided(this.getHandle(), bl);
    }

    public boolean isOffsetFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsOffsetFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_isOffsetFixed(this.getHandle());
    }

    public void setOffsetFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetOffsetFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_setOffsetFixed(this.getHandle(), bl);
    }

    public boolean isAutoAdjustRegionLabel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAutoAdjustRegionLabel()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_IsAutoAdjustRegionLabel(this.getHandle());
    }

    public void setAutoAdjustRegionLabel(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAutoAdjustRegionLabel(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetAutoAdjustRegionLabel(this.getHandle(), bl);
    }

    public boolean isVertical() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVertical()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_IsVertical(this.getHandle());
    }

    public void setVertical(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVertical(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetVertical(this.getHandle(), bl);
    }

    @Deprecated
    public double getTextSpaceing() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextSpaceing()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetTextSpaceing(this.getHandle());
    }

    public double getTextSpacing() {
        return this.getTextSpaceing();
    }

    @Deprecated
    public void setTextSpaceing(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextSpaceing(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetTextSpaceing(this.getHandle(), d);
    }

    public void setTextSpacing(double d) {
        this.setTextSpaceing(d);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeLabelNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{AlongLineDirection =");
        stringBuffer.append(this.getAlongLineDirection().name());
        stringBuffer.append(",IsSmallGeometryLabeled = ");
        stringBuffer.append(this.isSmallGeometryLabeled());
        stringBuffer.append("BackShape = ");
        stringBuffer.append(this.getBackShape().name());
        stringBuffer.append(",BackStyle = ");
        stringBuffer.append(this.getBackStyle());
        stringBuffer.append(",Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append(",IsAlongLine = ");
        stringBuffer.append(this.isAlongLine());
        stringBuffer.append(",IsAngleFixed = ");
        stringBuffer.append(this.isAngleFixed());
        stringBuffer.append(",IsFlowEnabled = ");
        stringBuffer.append(this.isFlowEnabled());
        stringBuffer.append(",IsRepeatIntervalFixed = ");
        stringBuffer.append(this.isRepeatIntervalFixed());
        stringBuffer.append(",IsLeaderLineDisplayed = ");
        stringBuffer.append(this.isLeaderLineDisplayed());
        stringBuffer.append(",isOverlapAvoided = ");
        stringBuffer.append(this.isOverlapAvoided());
        stringBuffer.append(",LabelExpression = ");
        stringBuffer.append(this.getLabelExpression());
        stringBuffer.append(",LabelRepeatInterval = ");
        stringBuffer.append(this.getLabelRepeatInterval());
        stringBuffer.append(",LeaderLineStyle = ");
        stringBuffer.append(this.getLeaderLineStyle());
        stringBuffer.append(",MaxLabelLength = ");
        stringBuffer.append(this.getMaxLabelLength());
        stringBuffer.append(",OffsetX = ");
        stringBuffer.append(this.getOffsetX());
        stringBuffer.append(",OffsetY = ");
        stringBuffer.append(this.getOffsetY());
        stringBuffer.append(",OverLengthMode = ");
        stringBuffer.append(this.getOverLengthMode().name());
        stringBuffer.append(",RangeExpression = ");
        stringBuffer.append(this.getRangeExpression());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    @Deprecated
    public boolean isAllDirectionsOverlapedAvoided() {
        return this.isAllDirectionsOverlappedAvoided();
    }

    public boolean isAllDirectionsOverlappedAvoided() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_IsAllDirectionOverlap(this.getHandle());
    }

    @Deprecated
    public void setAllDirectionsOverlapedAvoided(boolean bl) {
        this.setAllDirectionsOverlappedAvoided(bl);
    }

    public void setAllDirectionsOverlappedAvoided(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetAllDirectionOverlaped(this.getHandle(), bl);
    }

    public double getAlongLineSpaceRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAlongLineSpaceRatio()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetAlongLineSpaceRatio(this.getHandle());
    }

    public void setAlongLineSpaceRatio(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAlongLineSpaceRatio()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetAlongLineSpaceRatio(this.getHandle(), d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromXML(String string) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(string);
            if (bl) {
                if (this._$8 != null) {
                    InternalGeoStyle.clearHandle(this._$8);
                    this._$8 = null;
                }
                if (this._$7 != null) {
                    InternalGeoStyle.clearHandle(this._$7);
                    this._$7 = null;
                }
                this._$3();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public RangeMode getRangeMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeLabelNative.jni_GetRangeMode(this.getHandle());
        return (RangeMode)InternalEnum.parseUGCValue(RangeMode.class, n);
    }

    public double getCustomInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCustomInterval()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetCustomInterval(this.getHandle());
    }

    protected void clearHandle() {
        if (this._$9 != null) {
            this._$4();
            this._$9 = null;
        }
        if (this._$8 != null) {
            InternalGeoStyle.clearHandle(this._$8);
            this._$8 = null;
        }
        if (this._$7 != null) {
            InternalGeoStyle.clearHandle(this._$7);
            this._$7 = null;
        }
        if (this._$5 != null) {
            this._$5.clearHandle();
            this._$5 = null;
        }
        if (this._$4 != null) {
            this._$4.clearHandle();
            this._$4 = null;
        }
        if (this._$6 != null) {
            InternalTextStyle.clearHandle(this._$6);
            this._$6 = null;
        }
        this._$2 = null;
        this.setHandle(0L);
    }

    ArrayList getLabelItemsList() {
        return this._$9;
    }

    void setParent(ThemeLabel themeLabel) {
        this._$3 = themeLabel;
    }

    private void _$4() {
        int n = this._$9.size();
        for (int i = 0; i < n; ++i) {
            ThemeLabelItem themeLabelItem = (ThemeLabelItem)this._$9.get(i);
            themeLabelItem.clearHandle();
        }
        this._$9.clear();
    }

    private void _$3() {
        if (this._$9 != null) {
            this._$4();
        }
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeLabelItem themeLabelItem = new ThemeLabelItem(this);
            this._$9.add(themeLabelItem);
        }
    }

    private void _$2() {
        int n = this.getCount();
        long[] lArray = new long[n];
        ThemeLabelNative.jni_GetStylesHandle(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            ThemeLabelItem themeLabelItem = this.getItem(i);
            themeLabelItem.refreshStyle(lArray[i]);
        }
    }

    private void _$1() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reset()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_Reset(this.getHandle());
    }

    private void _$1(RangeMode rangeMode) {
        this._$1 = rangeMode;
    }

    public boolean isTextExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTextExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeLabelNative.jni_GetIsTextExpression(this.getHandle());
    }

    public void setTextExpression(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setisTextExpression(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeLabelNative.jni_SetIsTextExpression(this.getHandle(), bl);
    }
}

