/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.DatasetImage;
import com.supermap.mapping.ImageStretchType;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.Layers;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageStretchOption {
    private Layer _$3 = null;
    private Layers _$2 = null;
    private boolean _$1 = false;
    ImageStretchType m_imageStretchType;
    double m_standardDeviationStretchFactor;
    double m_gaussianStretchRatioFactor;
    boolean m_gaussianStretchIsMidFactor;
    ArrayList<ArrayList<Integer>> m_arrHistogramStandard;

    public ImageStretchOption() {
        this._$1 = false;
        this.m_imageStretchType = ImageStretchType.MINIMUMMAXIMUM;
        this.m_standardDeviationStretchFactor = 2.0;
        this.m_gaussianStretchRatioFactor = 2.0;
        this.m_gaussianStretchIsMidFactor = true;
        this.m_arrHistogramStandard = new ArrayList();
    }

    ImageStretchOption(Layer layer, Layers layers) {
        this._$3 = layer;
        this._$2 = layers;
        this._$1 = true;
        this.m_imageStretchType = ImageStretchType.NONE;
        this.m_standardDeviationStretchFactor = 2.0;
        this.m_gaussianStretchRatioFactor = 2.0;
        this.m_gaussianStretchIsMidFactor = true;
        this.m_arrHistogramStandard = new ArrayList();
    }

    public ImageStretchOption(ImageStretchOption imageStretchOption) {
        if (imageStretchOption == null) {
            String string = InternalResource.loadString("imageStretchOption", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this._$3 = imageStretchOption._$3;
        this._$2 = imageStretchOption._$2;
        this._$1 = false;
    }

    public ImageStretchType getStretchType() {
        if (this._$1) {
            long l = InternalHandle.getHandle(this._$3);
            if (l == 0L) {
                String string = InternalResource.loadString("getStretchType()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ImageStretchType imageStretchType = ImageStretchType.NONE;
            int n = LayerNative.jni_GetImageStretchType(l);
            switch (n) {
                case 0: {
                    imageStretchType = ImageStretchType.NONE;
                    break;
                }
                case 1: {
                    imageStretchType = ImageStretchType.STANDARDDEVIATION;
                    break;
                }
                case 2: {
                    imageStretchType = ImageStretchType.MINIMUMMAXIMUM;
                    break;
                }
                case 3: {
                    imageStretchType = ImageStretchType.HISTOGRAMEQUALIZATION;
                    break;
                }
                case 4: {
                    imageStretchType = ImageStretchType.HISTOGRAMSPECIFICATION;
                    break;
                }
                case 5: {
                    imageStretchType = ImageStretchType.GAUSSIAN;
                    break;
                }
                default: {
                    String string = InternalResource.loadString("getStretchType()", "GlobalArgument_OutOfBounds", "mapping_resources");
                    throw new IllegalStateException(string);
                }
            }
            return imageStretchType;
        }
        return this.m_imageStretchType;
    }

    public void setStretchType(ImageStretchType imageStretchType) {
        if (this._$1) {
            long l = InternalHandle.getHandle(this._$3);
            if (l == 0L) {
                String string = InternalResource.loadString("setStretchType(ImageStretchType stretchType)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (!(this._$3.getDataset() instanceof DatasetImage)) {
                String string = InternalResource.loadString("setStretchType(ImageStretchType stretchType)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = 0;
            if (imageStretchType == ImageStretchType.NONE) {
                n = 0;
            } else if (imageStretchType == ImageStretchType.STANDARDDEVIATION) {
                n = 1;
            } else if (imageStretchType == ImageStretchType.MINIMUMMAXIMUM) {
                n = 2;
            } else if (imageStretchType == ImageStretchType.HISTOGRAMEQUALIZATION) {
                n = 3;
            } else if (imageStretchType == ImageStretchType.HISTOGRAMSPECIFICATION) {
                n = 4;
            } else if (imageStretchType == ImageStretchType.GAUSSIAN) {
                n = 5;
            }
            LayerNative.jni_SetImageStretchType(l, n);
        }
        this.m_imageStretchType = imageStretchType;
    }

    public double getStandardDeviationStretchFactor() {
        if (this._$1) {
            long l = InternalHandle.getHandle(this._$3);
            if (l == 0L) {
                String string = InternalResource.loadString("getStandardDeviationStretchFactor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetStandardDeviationStretchFactor(l);
        }
        return this.m_standardDeviationStretchFactor;
    }

    public void setStandardDeviationStretchFactor(double d) {
        if (d < 0.0) {
            String string = InternalResource.loadString("setStandardDeviationStretchFactor(double value)", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1) {
            long l = InternalHandle.getHandle(this._$3);
            if (l == 0L) {
                String string = InternalResource.loadString("setStandardDeviationStretchFactor(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetStandardDeviationStretchFactor(l, d);
        }
        this.m_standardDeviationStretchFactor = d;
    }

    public void setGaussianStretchRatioFactor(double d) {
        if (d < 0.0) {
            String string = InternalResource.loadString("setGaussianStretchRatioFactor(double value)", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1) {
            long l = InternalHandle.getHandle(this._$3);
            if (l == 0L) {
                String string = InternalResource.loadString("setGaussianStretchRatioFactor(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetGaussianStretchRatioFactor(l, d);
        }
        this.m_gaussianStretchRatioFactor = d;
    }

    public void setGaussianStretchMiddleFactor(boolean bl) {
        if (this._$1) {
            long l = InternalHandle.getHandle(this._$3);
            if (l == 0L) {
                String string = InternalResource.loadString("setGaussianStretchIsMidFactor(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetGaussianStretchIsMidFactor(l, bl);
        }
        this.m_gaussianStretchIsMidFactor = bl;
    }

    public double getGaussianStretchRatioFactor() {
        if (this._$1) {
            long l = InternalHandle.getHandle(this._$3);
            if (l == 0L) {
                String string = InternalResource.loadString("getGaussianStretchRatioFactor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetGaussianStretchRatioFactor(l);
        }
        return this.m_gaussianStretchRatioFactor;
    }

    public boolean isGaussianStretchMiddleFactor() {
        if (this._$1) {
            long l = InternalHandle.getHandle(this._$3);
            if (l == 0L) {
                String string = InternalResource.loadString("getGaussianStretchIsMidFactor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            return LayerNative.jni_GetGaussianStretchIsMidFactor(l);
        }
        return this.m_gaussianStretchIsMidFactor;
    }

    public ArrayList<ArrayList<Integer>> getStandardHistograms() {
        if (this._$1) {
            long l = InternalHandle.getHandle(this._$3);
            if (l == 0L) {
                String string = InternalResource.loadString("getArrStandardHistogram()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_arrHistogramStandard.clear();
            int n = LayerNative.jni_GetStandardHistSize(l);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < n; ++i) {
                int[] nArray = LayerNative.jni_GetStandardHistCount(l, i);
                int n2 = nArray.length;
                for (int j = 0; j < n2; ++j) {
                    arrayList.add(nArray[j]);
                }
                this.m_arrHistogramStandard.add(arrayList);
            }
            return this.m_arrHistogramStandard;
        }
        return this.m_arrHistogramStandard;
    }

    public void setStandardHistograms(ArrayList<ArrayList<Integer>> arrayList) {
        if (arrayList == null) {
            String string = InternalResource.loadString("setStandardHistograms(ArrayList<ArrayList<Integer>> value)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = arrayList.size();
        if (this._$1) {
            long l = InternalHandle.getHandle(this._$3);
            if (l == 0L) {
                String string = InternalResource.loadString("setStandardHistograms(ArrayList<ArrayList<Integer>> value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            LayerNative.jni_SetStandardHistSize(l, n);
            ArrayList<Object> arrayList2 = new ArrayList();
            for (int i = 0; i < n; ++i) {
                arrayList2 = arrayList.get(i);
                int n2 = arrayList2.size();
                int[] nArray = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    nArray[j] = (Integer)arrayList2.get(j);
                }
                LayerNative.jni_SetStandardHistCount(l, i, nArray);
            }
        }
        this.m_arrHistogramStandard = arrayList;
    }
}

