/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.lucene;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.wltea.analyzer.IKSegmentation;
import org.wltea.analyzer.Lexeme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IKQueryParser {
    private static ThreadLocal<Map<String, TokenBranch>> keywordCacheThreadLocal = new ThreadLocal();
    private static boolean isMaxWordLength = false;

    public static void setMaxWordLength(boolean isMaxWordLength) {
        IKQueryParser.isMaxWordLength = isMaxWordLength;
    }

    private static Query optimizeQueries(List<Query> queries) {
        if (queries.size() == 0) {
            return null;
        }
        if (queries.size() == 1) {
            return queries.get(0);
        }
        BooleanQuery mustQueries = new BooleanQuery();
        for (Query q : queries) {
            mustQueries.add(q, BooleanClause.Occur.MUST);
        }
        return mustQueries;
    }

    private static Map<String, TokenBranch> getTheadLocalCache() {
        Map<String, TokenBranch> keywordCache = keywordCacheThreadLocal.get();
        if (keywordCache == null) {
            keywordCache = new HashMap<String, TokenBranch>(4);
            keywordCacheThreadLocal.set(keywordCache);
        }
        return keywordCache;
    }

    private static TokenBranch getCachedTokenBranch(String query) {
        Map<String, TokenBranch> keywordCache = IKQueryParser.getTheadLocalCache();
        return keywordCache.get(query);
    }

    private static void cachedTokenBranch(String query, TokenBranch tb) {
        Map<String, TokenBranch> keywordCache = IKQueryParser.getTheadLocalCache();
        keywordCache.put(query, tb);
    }

    private static Query _parse(String field, String query) throws IOException {
        if (field == null) {
            throw new IllegalArgumentException("parameter \"field\" is null");
        }
        if (query == null || "".equals(query.trim())) {
            return new TermQuery(new Term(field));
        }
        TokenBranch root = IKQueryParser.getCachedTokenBranch(query);
        if (root != null) {
            return IKQueryParser.optimizeQueries(root.toQueries(field));
        }
        root = new TokenBranch(null);
        StringReader input = new StringReader(query.trim());
        IKSegmentation ikSeg = new IKSegmentation(input, isMaxWordLength);
        Lexeme lexeme = ikSeg.next();
        while (lexeme != null) {
            root.accept(lexeme);
            lexeme = ikSeg.next();
        }
        IKQueryParser.cachedTokenBranch(query, root);
        return IKQueryParser.optimizeQueries(root.toQueries(field));
    }

    public static Query parse(String ikQueryExp) {
        ExpressionParser ikExpParser = new ExpressionParser();
        return ikExpParser.parserExp(ikQueryExp);
    }

    public static Query parse(String field, String query) throws IOException {
        if (field == null) {
            throw new IllegalArgumentException("parameter \"field\" is null");
        }
        String[] qParts = query.split("\\s");
        if (qParts.length > 1) {
            BooleanQuery resultQuery = new BooleanQuery();
            String[] stringArray = qParts;
            int n = qParts.length;
            int n2 = 0;
            while (n2 < n) {
                Query partQuery;
                String q = stringArray[n2];
                if (!("".equals(q) || (partQuery = IKQueryParser._parse(field, q)) == null || partQuery instanceof BooleanQuery && ((BooleanQuery)partQuery).getClauses().length <= 0)) {
                    resultQuery.add(partQuery, BooleanClause.Occur.SHOULD);
                }
                ++n2;
            }
            return resultQuery;
        }
        return IKQueryParser._parse(field, query);
    }

    public static Query parseMultiField(String[] fields, String query) throws IOException {
        if (fields == null) {
            throw new IllegalArgumentException("parameter \"fields\" is null");
        }
        BooleanQuery resultQuery = new BooleanQuery();
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Query partQuery;
            String field = stringArray[n2];
            if (!(field == null || (partQuery = IKQueryParser.parse(field, query)) == null || partQuery instanceof BooleanQuery && ((BooleanQuery)partQuery).getClauses().length <= 0)) {
                resultQuery.add(partQuery, BooleanClause.Occur.SHOULD);
            }
            ++n2;
        }
        return resultQuery;
    }

    public static Query parseMultiField(String[] fields, String query, BooleanClause.Occur[] flags) throws IOException {
        if (fields == null) {
            throw new IllegalArgumentException("parameter \"fields\" is null");
        }
        if (flags == null) {
            throw new IllegalArgumentException("parameter \"flags\" is null");
        }
        if (flags.length != fields.length) {
            throw new IllegalArgumentException("flags.length != fields.length");
        }
        BooleanQuery resultQuery = new BooleanQuery();
        int i = 0;
        while (i < fields.length) {
            Query partQuery;
            if (!(fields[i] == null || (partQuery = IKQueryParser.parse(fields[i], query)) == null || partQuery instanceof BooleanQuery && ((BooleanQuery)partQuery).getClauses().length <= 0)) {
                resultQuery.add(partQuery, flags[i]);
            }
            ++i;
        }
        return resultQuery;
    }

    public static Query parseMultiField(String[] fields, String[] queries) throws IOException {
        if (fields == null) {
            throw new IllegalArgumentException("parameter \"fields\" is null");
        }
        if (queries == null) {
            throw new IllegalArgumentException("parameter \"queries\" is null");
        }
        if (queries.length != fields.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery resultQuery = new BooleanQuery();
        int i = 0;
        while (i < fields.length) {
            Query partQuery;
            if (!(fields[i] == null || (partQuery = IKQueryParser.parse(fields[i], queries[i])) == null || partQuery instanceof BooleanQuery && ((BooleanQuery)partQuery).getClauses().length <= 0)) {
                resultQuery.add(partQuery, BooleanClause.Occur.SHOULD);
            }
            ++i;
        }
        return resultQuery;
    }

    public static Query parseMultiField(String[] fields, String[] queries, BooleanClause.Occur[] flags) throws IOException {
        if (fields == null) {
            throw new IllegalArgumentException("parameter \"fields\" is null");
        }
        if (queries == null) {
            throw new IllegalArgumentException("parameter \"queries\" is null");
        }
        if (flags == null) {
            throw new IllegalArgumentException("parameter \"flags\" is null");
        }
        if (queries.length != fields.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery resultQuery = new BooleanQuery();
        int i = 0;
        while (i < fields.length) {
            Query partQuery;
            if (!(fields[i] == null || (partQuery = IKQueryParser.parse(fields[i], queries[i])) == null || partQuery instanceof BooleanQuery && ((BooleanQuery)partQuery).getClauses().length <= 0)) {
                resultQuery.add(partQuery, flags[i]);
            }
            ++i;
        }
        return resultQuery;
    }

    public static void main(String[] args) {
        String ikQueryExp = "(id='1231231' && title:'MYNAMEmonkey') || (content:'\u4f60\u597d\u5417'  || ulr='www.ik.com') - name:'\u6797\u826f\u76ca'";
        Query result = IKQueryParser.parse(ikQueryExp);
        System.out.println(result);
    }

    static class ExpressionParser {
        private List<Element> elements = new ArrayList<Element>();
        private Stack<Query> querys = new Stack();
        private Stack<Element> operates = new Stack();

        public Query parserExp(String expression) {
            Query lucenceQuery;
            block4: {
                lucenceQuery = null;
                try {
                    this.splitElements(expression);
                    this.parseSyntax();
                    if (this.querys.size() == 1) {
                        lucenceQuery = this.querys.pop();
                        break block4;
                    }
                    throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff1a \u7f3a\u5c11\u903b\u8f91\u64cd\u4f5c\u7b26");
                }
                finally {
                    this.elements.clear();
                    this.querys.clear();
                    this.operates.clear();
                }
            }
            return lucenceQuery;
        }

        private void splitElements(String expression) {
            if (expression == null) {
                return;
            }
            Element curretElement = null;
            char[] expChars = expression.toCharArray();
            int i = 0;
            while (i < expChars.length) {
                switch (expChars[i]) {
                    case '&': {
                        if (curretElement == null) {
                            curretElement = new Element();
                            curretElement.type = (char)38;
                            curretElement.append(expChars[i]);
                            break;
                        }
                        if (curretElement.type == '&') {
                            curretElement.append(expChars[i]);
                            this.elements.add(curretElement);
                            curretElement = null;
                            break;
                        }
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            break;
                        }
                        this.elements.add(curretElement);
                        curretElement = new Element();
                        curretElement.type = (char)38;
                        curretElement.append(expChars[i]);
                        break;
                    }
                    case '|': {
                        if (curretElement == null) {
                            curretElement = new Element();
                            curretElement.type = (char)124;
                            curretElement.append(expChars[i]);
                            break;
                        }
                        if (curretElement.type == '|') {
                            curretElement.append(expChars[i]);
                            this.elements.add(curretElement);
                            curretElement = null;
                            break;
                        }
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            break;
                        }
                        this.elements.add(curretElement);
                        curretElement = new Element();
                        curretElement.type = (char)124;
                        curretElement.append(expChars[i]);
                        break;
                    }
                    case '-': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                break;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)45;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        break;
                    }
                    case '(': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                break;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)40;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        break;
                    }
                    case ')': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                break;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)41;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        break;
                    }
                    case ':': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                break;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)58;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        break;
                    }
                    case '=': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                break;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)61;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        break;
                    }
                    case ' ': {
                        if (curretElement == null) break;
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            break;
                        }
                        this.elements.add(curretElement);
                        curretElement = null;
                        break;
                    }
                    case '\'': {
                        if (curretElement == null) {
                            curretElement = new Element();
                            curretElement.type = (char)39;
                            break;
                        }
                        if (curretElement.type == '\'') {
                            this.elements.add(curretElement);
                            curretElement = null;
                            break;
                        }
                        this.elements.add(curretElement);
                        curretElement = new Element();
                        curretElement.type = (char)39;
                        break;
                    }
                    default: {
                        if (curretElement == null) {
                            curretElement = new Element();
                            curretElement.type = (char)70;
                            curretElement.append(expChars[i]);
                            break;
                        }
                        if (curretElement.type == 'F') {
                            curretElement.append(expChars[i]);
                            break;
                        }
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            break;
                        }
                        this.elements.add(curretElement);
                        curretElement = new Element();
                        curretElement.type = (char)70;
                        curretElement.append(expChars[i]);
                    }
                }
                ++i;
            }
            if (curretElement != null) {
                this.elements.add(curretElement);
                curretElement = null;
            }
        }

        private void parseSyntax() {
            int i = 0;
            while (i < this.elements.size()) {
                Query q;
                Element e = this.elements.get(i);
                if ('F' == e.type) {
                    TermQuery tQuery;
                    Element e2 = this.elements.get(i + 1);
                    if ('=' != e2.type && ':' != e2.type) {
                        throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff1a = \u6216 \uff1a \u53f7\u4e22\u5931");
                    }
                    Element e3 = this.elements.get(i + 2);
                    if ('\'' != e3.type) {
                        throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff1a\u5339\u914d\u503c\u4e22\u5931");
                    }
                    i += 2;
                    if ('=' == e2.type) {
                        tQuery = new TermQuery(new Term(e.toString(), e3.toString()));
                        this.querys.push((Query)tQuery);
                    } else if (':' == e2.type) {
                        try {
                            tQuery = IKQueryParser.parse(e.toString(), e3.toString());
                            this.querys.push((Query)tQuery);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else if ('(' == e.type) {
                    this.operates.push(e);
                } else if (')' == e.type) {
                    boolean doPop = true;
                    while (doPop && !this.operates.empty()) {
                        Element op = this.operates.pop();
                        if ('(' == op.type) {
                            doPop = false;
                            continue;
                        }
                        q = this.toQuery(op);
                        this.querys.push(q);
                    }
                } else if (this.operates.isEmpty()) {
                    this.operates.push(e);
                } else {
                    boolean doPeek = true;
                    while (doPeek && !this.operates.isEmpty()) {
                        Element eleOnTop = this.operates.peek();
                        if ('(' == eleOnTop.type) {
                            doPeek = false;
                            this.operates.push(e);
                            continue;
                        }
                        if (this.compare(e, eleOnTop) == 1) {
                            this.operates.push(e);
                            doPeek = false;
                            continue;
                        }
                        if (this.compare(e, eleOnTop) == 0) {
                            q = this.toQuery(eleOnTop);
                            this.operates.pop();
                            this.querys.push(q);
                            continue;
                        }
                        q = this.toQuery(eleOnTop);
                        this.operates.pop();
                        this.querys.push(q);
                    }
                    if (doPeek && this.operates.empty()) {
                        this.operates.push(e);
                    }
                }
                ++i;
            }
            while (!this.operates.isEmpty()) {
                Element eleOnTop = this.operates.pop();
                Query q = this.toQuery(eleOnTop);
                this.querys.push(q);
            }
        }

        private Query toQuery(Element op) {
            BooleanQuery resultQuery = new BooleanQuery();
            if (this.querys.size() < 2) {
                throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff1aSubQuery \u4e2a\u6570\u4e0d\u5339\u914d");
            }
            Query q2 = this.querys.pop();
            Query q1 = this.querys.pop();
            if ('&' == op.type) {
                BooleanClause c;
                int n;
                int n2;
                BooleanClause[] booleanClauseArray;
                BooleanClause[] clauses;
                if (q1 instanceof TermQuery) {
                    resultQuery.add(q1, BooleanClause.Occur.MUST);
                } else {
                    clauses = ((BooleanQuery)q1).getClauses();
                    if (clauses[0].getOccur() == BooleanClause.Occur.MUST) {
                        booleanClauseArray = clauses;
                        n2 = clauses.length;
                        n = 0;
                        while (n < n2) {
                            c = booleanClauseArray[n];
                            resultQuery.add(c);
                            ++n;
                        }
                    } else {
                        resultQuery.add(q1, BooleanClause.Occur.MUST);
                    }
                }
                if (q2 instanceof TermQuery) {
                    resultQuery.add(q2, BooleanClause.Occur.MUST);
                } else {
                    clauses = ((BooleanQuery)q2).getClauses();
                    if (clauses[0].getOccur() == BooleanClause.Occur.MUST) {
                        booleanClauseArray = clauses;
                        n2 = clauses.length;
                        n = 0;
                        while (n < n2) {
                            c = booleanClauseArray[n];
                            resultQuery.add(c);
                            ++n;
                        }
                    } else {
                        resultQuery.add(q2, BooleanClause.Occur.MUST);
                    }
                }
            } else if ('|' == op.type) {
                BooleanClause c;
                int n;
                int n3;
                BooleanClause[] booleanClauseArray;
                BooleanClause[] clauses;
                if (q1 instanceof TermQuery) {
                    resultQuery.add(q1, BooleanClause.Occur.SHOULD);
                } else {
                    clauses = ((BooleanQuery)q1).getClauses();
                    if (clauses[0].getOccur() == BooleanClause.Occur.SHOULD) {
                        booleanClauseArray = clauses;
                        n3 = clauses.length;
                        n = 0;
                        while (n < n3) {
                            c = booleanClauseArray[n];
                            resultQuery.add(c);
                            ++n;
                        }
                    } else {
                        resultQuery.add(q1, BooleanClause.Occur.SHOULD);
                    }
                }
                if (q2 instanceof TermQuery) {
                    resultQuery.add(q2, BooleanClause.Occur.SHOULD);
                } else {
                    clauses = ((BooleanQuery)q2).getClauses();
                    if (clauses[0].getOccur() == BooleanClause.Occur.SHOULD) {
                        booleanClauseArray = clauses;
                        n3 = clauses.length;
                        n = 0;
                        while (n < n3) {
                            c = booleanClauseArray[n];
                            resultQuery.add(c);
                            ++n;
                        }
                    } else {
                        resultQuery.add(q2, BooleanClause.Occur.SHOULD);
                    }
                }
            } else if ('-' == op.type) {
                if (q1 instanceof TermQuery) {
                    resultQuery.add(q1, BooleanClause.Occur.MUST);
                } else {
                    BooleanClause[] clauses;
                    BooleanClause[] booleanClauseArray = clauses = ((BooleanQuery)q1).getClauses();
                    int n = clauses.length;
                    int n4 = 0;
                    while (n4 < n) {
                        BooleanClause c = booleanClauseArray[n4];
                        resultQuery.add(c);
                        ++n4;
                    }
                }
                resultQuery.add(q2, BooleanClause.Occur.MUST_NOT);
            }
            return resultQuery;
        }

        private int compare(Element e1, Element e2) {
            if ('&' == e1.type) {
                if ('&' == e2.type) {
                    return 0;
                }
                return 1;
            }
            if ('|' == e1.type) {
                if ('&' == e2.type) {
                    return -1;
                }
                if ('|' == e2.type) {
                    return 0;
                }
                return 1;
            }
            if ('-' == e2.type) {
                return 0;
            }
            return -1;
        }

        private class Element {
            char type = '\u0000';
            StringBuffer eleTextBuff = new StringBuffer();

            public void append(char c) {
                this.eleTextBuff.append(c);
            }

            public String toString() {
                return this.eleTextBuff.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TokenBranch {
        private static final int REFUSED = -1;
        private static final int ACCEPTED = 0;
        private static final int TONEXT = 1;
        private int leftBorder;
        private int rightBorder;
        private Lexeme lexeme;
        private List<TokenBranch> acceptedBranchs;
        private TokenBranch nextBranch;

        TokenBranch(Lexeme lexeme) {
            if (lexeme != null) {
                this.lexeme = lexeme;
                this.leftBorder = lexeme.getBeginPosition();
                this.rightBorder = lexeme.getEndPosition();
            }
        }

        public int getLeftBorder() {
            return this.leftBorder;
        }

        public int getRightBorder() {
            return this.rightBorder;
        }

        public Lexeme getLexeme() {
            return this.lexeme;
        }

        public List<TokenBranch> getAcceptedBranchs() {
            return this.acceptedBranchs;
        }

        public TokenBranch getNextBranch() {
            return this.nextBranch;
        }

        public int hashCode() {
            if (this.lexeme == null) {
                return 0;
            }
            return this.lexeme.hashCode() * 37;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (o instanceof TokenBranch) {
                TokenBranch other = (TokenBranch)o;
                if (this.lexeme == null || other.getLexeme() == null) {
                    return false;
                }
                return this.lexeme.equals(other.getLexeme());
            }
            return false;
        }

        boolean accept(Lexeme _lexeme) {
            int acceptType = this.checkAccept(_lexeme);
            switch (acceptType) {
                case -1: {
                    return false;
                }
                case 0: {
                    if (this.acceptedBranchs == null) {
                        this.acceptedBranchs = new ArrayList<TokenBranch>(2);
                        this.acceptedBranchs.add(new TokenBranch(_lexeme));
                    } else {
                        boolean acceptedByChild = false;
                        for (TokenBranch childBranch : this.acceptedBranchs) {
                            boolean bl = acceptedByChild = childBranch.accept(_lexeme) || acceptedByChild;
                        }
                        if (!acceptedByChild) {
                            this.acceptedBranchs.add(new TokenBranch(_lexeme));
                        }
                    }
                    if (_lexeme.getEndPosition() <= this.rightBorder) break;
                    this.rightBorder = _lexeme.getEndPosition();
                    break;
                }
                case 1: {
                    if (this.nextBranch == null) {
                        this.nextBranch = new TokenBranch(null);
                    }
                    this.nextBranch.accept(_lexeme);
                }
            }
            return true;
        }

        List<Query> toQueries(String fieldName) {
            ArrayList<Query> queries = new ArrayList<Query>(1);
            if (this.lexeme != null) {
                queries.add((Query)new TermQuery(new Term(fieldName, this.lexeme.getLexemeText())));
            }
            if (this.acceptedBranchs != null && this.acceptedBranchs.size() > 0) {
                if (this.acceptedBranchs.size() == 1) {
                    Query onlyOneQuery = IKQueryParser.optimizeQueries(this.acceptedBranchs.get(0).toQueries(fieldName));
                    if (onlyOneQuery != null) {
                        queries.add(onlyOneQuery);
                    }
                } else {
                    BooleanQuery orQuery = new BooleanQuery();
                    for (TokenBranch childBranch : this.acceptedBranchs) {
                        Query childQuery = IKQueryParser.optimizeQueries(childBranch.toQueries(fieldName));
                        if (childQuery == null) continue;
                        orQuery.add(childQuery, BooleanClause.Occur.SHOULD);
                    }
                    if (orQuery.getClauses().length > 0) {
                        queries.add((Query)orQuery);
                    }
                }
            }
            if (this.nextBranch != null) {
                queries.addAll(this.nextBranch.toQueries(fieldName));
            }
            return queries;
        }

        private int checkAccept(Lexeme _lexeme) {
            int acceptType = 0;
            if (_lexeme == null) {
                throw new IllegalArgumentException("parameter:lexeme is null");
            }
            acceptType = this.lexeme == null ? (this.rightBorder > 0 && _lexeme.getBeginPosition() >= this.rightBorder ? 1 : 0) : (_lexeme.getBeginPosition() < this.lexeme.getBeginPosition() ? -1 : (_lexeme.getBeginPosition() >= this.lexeme.getBeginPosition() && _lexeme.getBeginPosition() < this.lexeme.getEndPosition() ? -1 : (_lexeme.getBeginPosition() >= this.lexeme.getEndPosition() && _lexeme.getBeginPosition() < this.rightBorder ? 0 : 1)));
            return acceptType;
        }
    }
}

