/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class BaseIndex
extends SchemaObjectBase
implements Index {
    protected IndexColumn[] indexColumns;
    protected Column[] columns;
    protected int[] columnIds;
    protected Table table;
    protected IndexType indexType;
    protected boolean isMultiVersion;

    protected void initBaseIndex(Table table, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initSchemaObjectBase(table.getSchema(), n, string, "index");
        this.indexType = indexType;
        this.table = table;
        if (indexColumnArray != null) {
            this.indexColumns = indexColumnArray;
            this.columns = new Column[indexColumnArray.length];
            int n2 = this.columns.length;
            this.columnIds = new int[n2];
            for (int i = 0; i < n2; ++i) {
                Column column;
                this.columns[i] = column = indexColumnArray[i].column;
                this.columnIds[i] = column.getColumnId();
            }
        }
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    DbException getDuplicateKeyException() {
        String string = this.getName() + " ON " + this.table.getSQL() + "(" + this.getColumnListSQL() + ")";
        DbException dbException = DbException.get(23505, string);
        dbException.setSource(this);
        return dbException;
    }

    @Override
    public String getPlanSQL() {
        return this.getSQL();
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeIndex(this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public Cursor find(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(tableFilter.getSession(), searchRow, searchRow2);
    }

    @Override
    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        throw DbException.throwInternalError();
    }

    protected long getCostRangeIndex(int[] nArray, long l) {
        long l2 = l += 1000L;
        long l3 = l;
        int n = 0;
        if (nArray == null) {
            return l2;
        }
        int n2 = this.columns.length;
        for (int i = 0; i < n2; ++i) {
            long l4;
            Column column = this.columns[i];
            int n3 = column.getColumnId();
            int n4 = nArray[n3];
            if ((n4 & 1) == 1) {
                if (i == this.columns.length - 1 && this.getIndexType().isUnique()) {
                    l2 = 3L;
                    break;
                }
                l4 = l * (long)(n = 100 - (100 - n) * (100 - column.getSelectivity()) / 100) / 100L;
                if (l4 <= 0L) {
                    l4 = 1L;
                }
            } else {
                if ((n4 & 6) == 6) {
                    l2 = 2L + l3 / 4L;
                    break;
                }
                if ((n4 & 2) == 2) {
                    l2 = 2L + l3 / 3L;
                    break;
                }
                if ((n4 & 4) != 4) break;
                l2 = l3 / 3L;
                break;
            }
            l3 = Math.max(l / l4, 1L);
            l2 = 2L + l3;
        }
        return l2;
    }

    @Override
    public int compareRows(SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == searchRow2) {
            return 0;
        }
        int n = this.indexColumns.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.columnIds[i];
            Value value = searchRow2.getValue(n2);
            if (value == null) {
                return 0;
            }
            int n3 = this.compareValues(searchRow.getValue(n2), value, this.indexColumns[i].sortType);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    boolean containsNullAndAllowMultipleNull(SearchRow searchRow) {
        Mode mode = this.database.getMode();
        if (mode.uniqueIndexSingleNull) {
            return false;
        }
        if (mode.uniqueIndexSingleNullExceptAllColumnsAreNull) {
            for (int n : this.columnIds) {
                Value value = searchRow.getValue(n);
                if (value == ValueNull.INSTANCE) continue;
                return false;
            }
            return true;
        }
        for (int n : this.columnIds) {
            Value value = searchRow.getValue(n);
            if (value != ValueNull.INSTANCE) continue;
            return true;
        }
        return false;
    }

    int compareKeys(SearchRow searchRow, SearchRow searchRow2) {
        long l;
        long l2 = searchRow.getKey();
        if (l2 == (l = searchRow2.getKey())) {
            if (this.isMultiVersion) {
                int n = searchRow.getVersion();
                int n2 = searchRow2.getVersion();
                return MathUtils.compareInt(n2, n);
            }
            return 0;
        }
        return l2 > l ? 1 : -1;
    }

    private int compareValues(Value value, Value value2, int n) {
        boolean bl;
        if (value == value2) {
            return 0;
        }
        boolean bl2 = value == null;
        boolean bl3 = bl = value2 == null;
        if (bl2 || bl) {
            return SortOrder.compareNull(bl2, n);
        }
        int n2 = this.table.compareTypeSave(value, value2);
        if ((n & 1) != 0) {
            n2 = -n2;
        }
        return n2;
    }

    @Override
    public int getColumnIndex(Column column) {
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            if (!this.columns[i].equals(column)) continue;
            return i;
        }
        return -1;
    }

    private String getColumnListSQL() {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (IndexColumn indexColumn : this.indexColumns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        return statementBuilder.toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        StringBuilder stringBuilder = new StringBuilder("CREATE ");
        stringBuilder.append(this.indexType.getSQL());
        stringBuilder.append(' ');
        if (this.table.isHidden()) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(string);
        stringBuilder.append(" ON ").append(table.getSQL());
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuilder.append('(').append(this.getColumnListSQL()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    @Override
    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void commit(int n, Row row) {
    }

    void setMultiVersion(boolean bl) {
        this.isMultiVersion = bl;
    }

    @Override
    public Row getRow(Session session, long l) {
        throw DbException.getUnsupportedException(this.toString());
    }

    @Override
    public boolean isHidden() {
        return this.table.isHidden();
    }

    @Override
    public boolean isRowIdIndex() {
        return false;
    }

    @Override
    public boolean canScan() {
        return true;
    }

    @Override
    public void setSortedInsertMode(boolean bl) {
    }
}

