/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.Prepared;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.table.RegularTable;
import org.h2.table.Table;
import org.h2.util.StatementBuilder;

public class Analyze
extends DefineCommand {
    private int sampleRows;

    public Analyze(Session session) {
        super(session);
        this.sampleRows = session.getDatabase().getSettings().analyzeSample;
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        for (Table table : database.getAllTablesAndViews(false)) {
            Analyze.analyzeTable(this.session, table, this.sampleRows, true);
        }
        return 0;
    }

    public static void analyzeTable(Session session, Table table, int n, boolean bl) {
        int n2;
        Column[] columnArray;
        if (!(table instanceof RegularTable) || table.isHidden() || session == null) {
            return;
        }
        if (!bl) {
            if (session.getDatabase().isSysTableLocked()) {
                return;
            }
            if (table.hasSelectTrigger()) {
                return;
            }
        }
        if (table.isTemporary() && !table.isGlobalTemporary() && session.findLocalTempTable(table.getName()) == null) {
            return;
        }
        if (table.isLockedExclusively() && !table.isLockedExclusivelyBy(session)) {
            return;
        }
        if (!session.getUser().hasRight(table, 1)) {
            return;
        }
        if (session.getCancel() != 0L) {
            return;
        }
        Database database = session.getDatabase();
        StatementBuilder statementBuilder = new StatementBuilder("SELECT ");
        for (Column i : columnArray = table.getColumns()) {
            statementBuilder.appendExceptFirst(", ");
            n2 = i.getType();
            if (n2 == 15 || n2 == 16) {
                statementBuilder.append("100");
                continue;
            }
            statementBuilder.append("SELECTIVITY(").append(i.getSQL()).append(')');
        }
        statementBuilder.append(" FROM ").append(table.getSQL());
        if (n > 0) {
            statementBuilder.append(" LIMIT 1 SAMPLE_SIZE ").append(n);
        }
        String string = statementBuilder.toString();
        Prepared prepared = session.prepare(string);
        ResultInterface resultInterface = prepared.query(0);
        resultInterface.next();
        for (int session2 = 0; session2 < columnArray.length; ++session2) {
            n2 = resultInterface.currentRow()[session2].getInt();
            columnArray[session2].setSelectivity(n2);
        }
        if (bl) {
            database.update(session, table);
        } else {
            Session session2 = database.getSystemSession();
            if (session2 != session) {
                database.update(session2, table);
                session2.commit(true);
            }
        }
    }

    public void setTop(int n) {
        this.sampleRows = n;
    }

    @Override
    public int getType() {
        return 21;
    }
}

