/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.core.validator;

import javax.xml.namespace.QName;
import org.opensaml.saml1.core.StatusCode;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCodeSchemaValidator
implements Validator<StatusCode> {
    public void validate(StatusCode statusCode) throws ValidationException {
        this.validateValue(statusCode);
        this.validateValueContent(statusCode);
    }

    protected void validateValue(StatusCode statusCode) throws ValidationException {
        QName value = statusCode.getValue();
        if (value == null) {
            throw new ValidationException("No Value attribute present");
        }
    }

    protected void validateValueContent(StatusCode statusCode) throws ValidationException {
        QName statusValue = statusCode.getValue();
        if ("urn:oasis:names:tc:SAML:1.0:protocol".equals(statusValue.getNamespaceURI())) {
            if (!(statusValue.equals(StatusCode.SUCCESS) || statusValue.equals(StatusCode.VERSION_MISMATCH) || statusValue.equals(StatusCode.REQUESTER) || statusValue.equals(StatusCode.RESPONDER) || statusValue.equals(StatusCode.REQUEST_VERSION_TOO_HIGH) || statusValue.equals(StatusCode.REQUEST_VERSION_TOO_LOW) || statusValue.equals(StatusCode.REQUEST_VERSION_DEPRICATED) || statusValue.equals(StatusCode.TOO_MANY_RESPONSES) || statusValue.equals(StatusCode.REQUEST_DENIED) || statusValue.equals(StatusCode.RESOURCE_NOT_RECOGNIZED))) {
                throw new ValidationException("Status code value was in the SAML 1 protocol namespace but was not of an allowed value: " + statusValue);
            }
        } else if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(statusValue.getNamespaceURI())) {
            throw new ValidationException("Status code value was in the SAML 1 assertion namespace, no values are allowed in that namespace");
        }
    }
}

