/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.geoprocessor.common;

import com.supermap.geoprocessor.common.LogProvider;
import com.supermap.geoprocessor.common.Utility;
import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;

public class Context {
    private static String contextProperties = "context.properties";
    private static String defineDriver = null;
    private static String defineUrl = null;
    private static String defineUser = null;
    private static String definePassword = null;
    private static String defineModelFolder = null;
    private static Context instance = null;
    private static String logPath = "";
    private static Log log;
    private static String usrDir;
    private static Map<String, String> environment;

    public static synchronized Context initialize() {
        LogProvider.setLogPath(logPath);
        log = LogProvider.getLog(Context.class);
        if (instance == null) {
            log.debug((Object)"Initialized context.");
            instance = new Context();
        }
        return instance;
    }

    public static String[] getClasses() {
        String string = null;
        if (environment.get("importClass") != null && environment.get("importClass").length() >= 0) {
            string = environment.get("importClass");
        }
        if (string != null && string.length() >= 0) {
            return string.split(",");
        }
        return null;
    }

    public static String[] getDlls() {
        String string = null;
        if (environment.get("dynamicLibrary") != null && environment.get("dynamicLibrary").length() >= 0) {
            string = environment.get("dynamicLibrary");
        }
        if (string != null && string.length() >= 0) {
            return string.split(",");
        }
        return null;
    }

    public static String getSavePath() {
        if (environment.get("savePath") != null && environment.get("savePath").length() >= 0) {
            return environment.get("savePath");
        }
        return null;
    }

    public static String getSourcePath() {
        String string = null;
        string = System.getProperty("user.dir") + File.separator + "src" + File.separator + Context.getSavePath().replace(".", File.separator);
        return string;
    }

    public static String getBuildPath() {
        String string = null;
        string = System.getProperty("user.dir") + File.separator + "build" + File.separator + "classes";
        return string;
    }

    public static String getUrl() {
        if (defineUrl != null) {
            return defineUrl;
        }
        if (environment.get("url") != null && environment.get("url").length() >= 0) {
            return environment.get("url");
        }
        return null;
    }

    public static String getDriver() {
        if (defineDriver != null) {
            return defineDriver;
        }
        if (environment.get("driver") != null && environment.get("driver").length() >= 0) {
            return environment.get("driver");
        }
        return null;
    }

    public static void setDriver(String string) {
        defineDriver = string;
    }

    public static void setUrl(String string) {
        defineUrl = string;
    }

    public static void setPassword(String string) {
        definePassword = string;
    }

    public static void setUser(String string) {
        defineUser = string;
    }

    public static String getUser() {
        if (defineUser != null) {
            return defineUser;
        }
        if (environment.get("user") != null && environment.get("user").length() >= 0) {
            return environment.get("user");
        }
        return null;
    }

    public static String getPassword() {
        if (definePassword != null) {
            return definePassword;
        }
        if (environment.get("password") != null && environment.get("password").length() >= 0) {
            return environment.get("password");
        }
        return null;
    }

    public static String getModelFolder() {
        if (environment.get("model.dir") != null && environment.get("model.dir").length() >= 0) {
            return environment.get("model.dir");
        }
        return null;
    }

    public static void setModelFolder(String string) {
        defineModelFolder = string;
    }

    public static void setLog4jPath(String string) {
        logPath = string;
    }

    public static String getLog4jPath() {
        return logPath;
    }

    public static String getProperty(String string) {
        if (environment.get(string) != null && environment.get(string).length() >= 0) {
            return environment.get(string);
        }
        return null;
    }

    private Context() {
        environment = Utility.readProperties(contextProperties);
    }

    static {
        usrDir = "";
        environment = null;
    }
}

