/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalProcessingEnum;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.Tile;
import com.supermap.data.processing.Tiles;
import com.supermap.data.processing.VectorCacheFileNative;

public class VectorCacheFile
extends InternalHandleDisposable {
    public VectorCacheFile() {
        long l = VectorCacheFileNative.jni_New();
        this.setHandle(l, true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            VectorCacheFileNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public boolean open(String string, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("open()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.length() == 0) {
            String string4 = InternalResource.loadString("open()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string4);
        }
        boolean bl = VectorCacheFileNative.jni_Open(this.getHandle(), string, string2);
        return bl;
    }

    public boolean open(String string) {
        return this.open(string, "");
    }

    public String getTileFullName(double d, int n, int n2, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getTileFullName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("open()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string3);
        }
        return VectorCacheFileNative.jni_GetTileFullName(this.getHandle(), d, n, n2, string);
    }

    public String extractCacheFile(double d, int n, int n2, String string, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("getTileFullName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        if (string2 == null) {
            String string4 = InternalResource.loadString("open()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string4);
        }
        return VectorCacheFileNative.jni_ExtractCacheFile(this.getHandle(), d, n, n2, string, string2);
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = VectorCacheFileNative.jni_GetStorageType(this.getHandle());
        return (StorageType)InternalProcessingEnum.parseUGCValue(StorageType.class, n);
    }

    public Tile[] computeTiles(double d, Point2D[] point2DArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = point2DArray.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2DArray[i].getX();
            dArray2[i] = point2DArray[i].getY();
        }
        long l = VectorCacheFileNative.jni_ComputeTiles(this.getHandle(), d, dArray, dArray2);
        Tiles tiles = new Tiles(l);
        if (tiles.getCount() == 0) {
            return null;
        }
        Tile[] tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    public boolean deleteGeometryTiles(Tile[] tileArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteGeomertyTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = tileArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = com.supermap.data.processing.InternalHandle.getHandle((InternalHandle)tileArray[i]);
        }
        return VectorCacheFileNative.jni_DeleteGeometryTiles(this.getHandle(), lArray);
    }

    public boolean deleteAttributeTiles(Tile[] tileArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteGeomertyTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = tileArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = com.supermap.data.processing.InternalHandle.getHandle((InternalHandle)tileArray[i]);
        }
        return VectorCacheFileNative.jni_DeleteAttributeTiles(this.getHandle(), lArray);
    }

    public Rectangle2D getTileBounds(double d, int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        VectorCacheFileNative.jni_GetTileBounds(this.getHandle(), d, n, n2, dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public long getRevisionNumber() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRevisionNumber", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorCacheFileNative.jni_GetRevisionNumber(this.getHandle());
    }

    public boolean updateRevisionNumber(long l) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRevisionNumber(int)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorCacheFileNative.jni_UpdateRevisionNumber(this.getHandle(), l);
    }

    public double[] getScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = VectorCacheFileNative.jni_GetScales(this.getHandle());
        return dArray;
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        VectorCacheFileNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }
}

