/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Unit;
import com.supermap.data.processing.CacheTileParameter;
import com.supermap.data.processing.CacheWriterListener;
import com.supermap.data.processing.CompactTileParameter;
import com.supermap.data.processing.MapTilingMode;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.TileFormat;
import com.supermap.data.processing.TileSize;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheWriter {
    private String _$22 = "Cache";
    private TileFormat _$21 = TileFormat.JPG;
    private TileSize _$20 = TileSize.SIZE256;
    private String _$19 = "";
    private HashMap<Double, String> _$18 = new HashMap();
    private Double _$17 = 5.1;
    private String _$16 = "";
    private PrjCoordSys _$15 = null;
    private Color _$14 = Color.white;
    private Boolean _$13 = false;
    private int _$12 = 100;
    private Boolean _$11 = true;
    private StorageType _$10 = StorageType.Original;
    private MapTilingMode _$9 = MapTilingMode.LOCAL;
    private Boolean _$8 = false;
    private Double _$7 = 96.0;
    private Rectangle2D _$6 = new Rectangle2D();
    private Rectangle2D _$5 = new Rectangle2D();
    private Rectangle2D _$4 = new Rectangle2D();
    private GeoRegion _$3 = new GeoRegion();
    private String _$2;
    private ArrayList<CacheWriterListener> _$1 = new ArrayList();

    public String getCacheName() {
        return this._$22;
    }

    public void setCacheName(String string) {
        this._$22 = string;
    }

    public TileFormat getTileFormat() {
        return this._$21;
    }

    public void setTileFormat(TileFormat tileFormat) {
        this._$21 = tileFormat;
    }

    public TileSize getTileSize() {
        return this._$20;
    }

    public void setTileSize(TileSize tileSize) {
        this._$20 = tileSize;
    }

    public String getHashCode() {
        return this._$19;
    }

    public void setHashCode(String string) {
        this._$19 = string;
    }

    public HashMap<Double, String> getCacheScaleCaptions() {
        return this._$18;
    }

    public void setCacheScaleCaptions(Double[] doubleArray) {
        this._$18.clear();
        for (Double d : doubleArray) {
            if (this._$18.containsKey(d)) continue;
            this._$18.put(d, String.valueOf(Math.round(1.0 / d)));
        }
    }

    public PrjCoordSys getPrjCoordSys() {
        return this._$15;
    }

    public void setPrjCoordSys(PrjCoordSys prjCoordSys) {
        this._$15 = prjCoordSys;
    }

    public double getDPI() {
        return this._$7;
    }

    public void setDPI(double d) {
        this._$7 = d;
    }

    public StorageType getStorageType() {
        return this._$10;
    }

    public void setStorageType(StorageType storageType) {
        this._$10 = storageType;
    }

    public Rectangle2D getCacheBounds() {
        return this._$6;
    }

    public void setCacheBounds(Rectangle2D rectangle2D) {
        this._$6 = rectangle2D;
    }

    public Rectangle2D getIndexBounds() {
        return this._$5;
    }

    public void setIndexBounds(Rectangle2D rectangle2D) {
        this._$5 = rectangle2D;
    }

    public String getOutputFolder() {
        return this._$2;
    }

    public void setOutputFolder(String string) {
        this._$2 = string;
    }

    public Boolean getTransparent() {
        return this._$13;
    }

    public void setTransparent(Boolean bl) {
        this._$13 = bl;
    }

    public String getProvider() {
        return this._$16;
    }

    public void setProvider(String string) {
        this._$16 = string;
    }

    public void addCacheWriterListener(CacheWriterListener cacheWriterListener) {
        if (!this._$1.contains(cacheWriterListener)) {
            this._$1.add(cacheWriterListener);
        }
    }

    public void removeCacheWriterListener(CacheWriterListener cacheWriterListener) {
        this._$1.remove(cacheWriterListener);
    }

    void fireCacheWriterListener(CacheTileParameter cacheTileParameter, CompactTileParameter compactTileParameter) {
        for (CacheWriterListener cacheWriterListener : this._$1) {
            cacheWriterListener.writTile(cacheTileParameter, compactTileParameter);
        }
    }

    public void writeTile(CacheTileParameter cacheTileParameter, CompactTileParameter compactTileParameter) {
        this.fireCacheWriterListener(cacheTileParameter, compactTileParameter);
    }

    public Boolean Build() throws Exception {
        Boolean bl;
        File file = new File(this._$2);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (this._$2.isEmpty()) {
            return false;
        }
        file = new File(this._$2 + "/" + this._$22 + "/" + this._$2(this._$21) + "_" + this._$20.value() + "_" + this._$19);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(bl = Boolean.valueOf((bl = this.ToConfigFile(this._$2 + "/" + this._$22 + "/" + this._$22 + ".sci")) != false && this.ToConfigFile(file.getPath() + "/" + this._$22 + ".inf") != false)).booleanValue()) {
            return false;
        }
        double d = this._$1();
        for (double d2 : this._$18.keySet()) {
            double d3 = 1.0 / (d2 * this._$7 / 254.0);
            double d4 = (d3 /= d) * (double)this._$20.value();
            int n = (int)Math.floor((this._$6.getLeft() - this._$5.getLeft()) / d4);
            int n2 = (int)Math.floor(-((this._$6.getTop() - this._$5.getTop()) / d4));
            int n3 = (int)Math.floor((this._$6.getRight() - this._$5.getLeft()) / d4);
            int n4 = (int)Math.floor(-((this._$6.getBottom() - this._$5.getTop()) / d4));
            for (int i = n2; i <= n4; ++i) {
                for (int j = n; j <= n3; ++j) {
                    Rectangle2D rectangle2D = new Rectangle2D(this._$5.getLeft() + (double)j * d4, this._$5.getTop() - (double)(i + 1) * d4, this._$5.getLeft() + (double)(j + 1) * d4, this._$5.getTop() - (double)i * d4);
                    String string = this.getTilePath(d2, i, j);
                    CacheTileParameter cacheTileParameter = new CacheTileParameter(d2, i, j, rectangle2D, string);
                    CompactTileParameter compactTileParameter = null;
                    if (this._$10 == StorageType.Compact) {
                        compactTileParameter = new CompactTileParameter(i % 128, j % 128);
                    }
                    this.writeTile(cacheTileParameter, compactTileParameter);
                }
            }
        }
        return true;
    }

    private double _$1() {
        double d = 0.0;
        d = this._$15.getCoordUnit().equals((Object)Unit.DEGREE) ? this._$15.getGeoCoordSys().getGeoDatum().getGeoSpheroid().getAxis() * (double)(this._$15.getCoordUnit().value() - 1000000000) * 10000.0 * Math.PI / 3.1415922E8 : (double)this._$15.getCoordUnit().value();
        return d;
    }

    public String getTilePath(Double d, int n, int n2) {
        if (d <= 0.0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._$2);
        if (!this._$2.endsWith("/") && !this._$2.endsWith("\\")) {
            stringBuilder.append("/");
        }
        stringBuilder.append(this._$22);
        stringBuilder.append("/");
        stringBuilder.append(this._$2(this._$21));
        stringBuilder.append("_");
        stringBuilder.append(this._$20.value());
        stringBuilder.append("_");
        stringBuilder.append(this._$19);
        stringBuilder.append("/");
        if (this._$18.containsKey(d)) {
            stringBuilder.append(this._$18.get(d));
        } else {
            stringBuilder.append(Math.round(1.0 / d));
        }
        stringBuilder.append("/");
        int n3 = n < 0 ? n / 128 - 1 : n / 128;
        stringBuilder.append(n3);
        stringBuilder.append("/");
        n3 = n2 < 0 ? n2 / 128 - 1 : n2 / 128;
        stringBuilder.append(n3);
        if (this._$10 == StorageType.Original) {
            stringBuilder.append("/");
            stringBuilder.append(n);
            stringBuilder.append("x");
            stringBuilder.append(n2);
            stringBuilder.append(this._$1(this._$21));
        } else {
            stringBuilder.append(".cf");
        }
        return stringBuilder.toString();
    }

    public Boolean ToConfigFile(String string) throws Exception {
        this._$4 = this._$6;
        if (this._$5.isEmpty()) {
            this._$5 = this._$6;
        }
        return !this._$22.isEmpty() && this._$15 != null && this._$7 > 0.0 && !this._$6.isEmpty() && this._$1(string) != false;
    }

    private Boolean _$1(String string) {
        try {
            String string2 = System.getProperty("line.separator");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            stringBuilder.append(string2);
            stringBuilder.append("<SuperMapCache>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Version>");
            stringBuilder.append(String.format("%d.0", (int)(this._$17 * 10.0) / 10));
            stringBuilder.append("</sml:Version>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:MinorVersion>");
            stringBuilder.append(String.valueOf((int)(this._$17 * 10.0) % 10));
            stringBuilder.append("</sml:MinorVersion>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:VersionRequired>");
            stringBuilder.append(String.format("%d.0", (int)(this._$17 * 10.0) / 10));
            stringBuilder.append("</sml:VersionRequired>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:CacheName>");
            stringBuilder.append(this._$22);
            stringBuilder.append("</sml:CacheName>");
            stringBuilder.append(string2);
            if (this._$16.isEmpty()) {
                stringBuilder.append("<sml:Provider/>");
            } else {
                stringBuilder.append("<sml:Provider>");
                stringBuilder.append(this._$16);
                stringBuilder.append("</sml:Provider>");
            }
            stringBuilder.append(string2);
            stringBuilder.append("<sml:MapName>");
            stringBuilder.append(this._$22);
            stringBuilder.append("</sml:MapName>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:HashCode>");
            stringBuilder.append(this._$19);
            stringBuilder.append("</sml:HashCode>");
            stringBuilder.append(string2);
            stringBuilder.append(this._$15.toXML(20031211));
            stringBuilder.append("<sml:ImageType>");
            stringBuilder.append((Object)this._$21);
            stringBuilder.append("</sml:ImageType>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:DefaultColor>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Red>");
            stringBuilder.append(String.format("0x%X", this._$14.getRed()));
            stringBuilder.append("</sml:Red>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Green>");
            stringBuilder.append(String.format("0x%X", this._$14.getGreen()));
            stringBuilder.append("</sml:Green>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Blue>");
            stringBuilder.append(String.format("0x%X", this._$14.getBlue()));
            stringBuilder.append("</sml:Blue>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Alpha>");
            stringBuilder.append(String.format("0x%X", this._$14.getAlpha()));
            stringBuilder.append("</sml:Alpha>");
            stringBuilder.append(string2);
            stringBuilder.append("</sml:DefaultColor>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Transparent>");
            stringBuilder.append(this._$13.toString().toUpperCase());
            stringBuilder.append("</sml:Transparent>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:ImageCompress>");
            stringBuilder.append(this._$12);
            stringBuilder.append("</sml:ImageCompress>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:FillMargin>");
            stringBuilder.append(this._$11.toString().toUpperCase());
            stringBuilder.append("</sml:FillMargin>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:StorageType>");
            stringBuilder.append((Object)this._$10);
            stringBuilder.append("</sml:StorageType>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:TileType>");
            stringBuilder.append((Object)this._$9);
            stringBuilder.append("</sml:TileType>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:HashCodeEnabled>");
            stringBuilder.append(this._$8.toString().toUpperCase());
            stringBuilder.append("</sml:HashCodeEnabled>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:ImageSize>");
            stringBuilder.append(this._$20.value());
            stringBuilder.append("</sml:ImageSize>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Bounds>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Left>");
            stringBuilder.append(this._$6.getLeft());
            stringBuilder.append("</sml:Left>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Top>");
            stringBuilder.append(this._$6.getTop());
            stringBuilder.append("</sml:Top>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Right>");
            stringBuilder.append(this._$6.getRight());
            stringBuilder.append("</sml:Right>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Bottom>");
            stringBuilder.append(this._$6.getBottom());
            stringBuilder.append("</sml:Bottom>");
            stringBuilder.append(string2);
            stringBuilder.append("</sml:Bounds>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:CoordRatio>");
            stringBuilder.append(String.valueOf(this._$7 / 25.4));
            stringBuilder.append("</sml:CoordRatio>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:IndexBounds>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Left>");
            stringBuilder.append(this._$5.getLeft());
            stringBuilder.append("</sml:Left>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Top>");
            stringBuilder.append(this._$5.getTop());
            stringBuilder.append("</sml:Top>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Right>");
            stringBuilder.append(this._$5.getRight());
            stringBuilder.append("</sml:Right>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Bottom>");
            stringBuilder.append(this._$5.getBottom());
            stringBuilder.append("</sml:Bottom>");
            stringBuilder.append(string2);
            stringBuilder.append("</sml:IndexBounds>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:MapBounds>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Left>");
            stringBuilder.append(this._$4.getLeft());
            stringBuilder.append("</sml:Left>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Top>");
            stringBuilder.append(this._$4.getTop());
            stringBuilder.append("</sml:Top>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Right>");
            stringBuilder.append(this._$4.getRight());
            stringBuilder.append("</sml:Right>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Bottom>");
            stringBuilder.append(this._$4.getBottom());
            stringBuilder.append("</sml:Bottom>");
            stringBuilder.append(string2);
            stringBuilder.append("</sml:MapBounds>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:Scales>");
            stringBuilder.append(string2);
            for (Double object2 : this._$18.keySet()) {
                stringBuilder.append("<sml:Scale>");
                stringBuilder.append(string2);
                stringBuilder.append("<sml:Value>");
                stringBuilder.append(object2);
                stringBuilder.append("</sml:Value>");
                stringBuilder.append(string2);
                stringBuilder.append("<sml:Caption>");
                stringBuilder.append(this._$18.get(object2));
                stringBuilder.append("</sml:Caption>");
                stringBuilder.append(string2);
                stringBuilder.append("</sml:Scale>");
                stringBuilder.append(string2);
            }
            stringBuilder.append("</sml:Scales>");
            stringBuilder.append(string2);
            stringBuilder.append("<sml:ClipRegion/>");
            stringBuilder.append(string2);
            stringBuilder.append("</SuperMapCache>");
            File file = new File(string);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(stringBuilder.toString().getBytes("UTF-8"));
            fileOutputStream.flush();
            fileOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public Boolean FromConfigFile(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                return false;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            String string2 = new String(byArray, "UTF-8");
            if (!string2.contains("<SuperMapCache>")) {
                return false;
            }
            String string3 = this._$1(string2, "sml:Version", true);
            if (Double.valueOf(string3) != 5.0) {
                return false;
            }
            this._$17 = 5.1;
            this._$22 = string3 = this._$1(string2, "sml:CacheName", true);
            string3 = this._$1(string2, "sml:Provider", true);
            if (!string3.isEmpty()) {
                this._$16 = string3;
            }
            this._$19 = string3 = this._$1(string2, "sml:HashCode", true);
            string3 = this._$1(string2, "sml:CoordinateReferenceSystem", false);
            if (this._$15 == null) {
                this._$15 = new PrjCoordSys();
            }
            if (!this._$15.fromXML(string3, 20031211)) {
                return false;
            }
            string3 = this._$1(string2, "sml:ImageType", true);
            this._$21 = (TileFormat)Enum.parse(((Object)((Object)this._$21)).getClass(), (String)string3);
            string3 = this._$1(string2, "sml:DefaultColor", true);
            String string4 = this._$1(string3, "sml:Red", true);
            int n = Integer.valueOf(string4.replaceAll("0x", ""), 16);
            string4 = this._$1(string3, "sml:Green", true);
            int n2 = Integer.valueOf(string4.replaceAll("0x", ""), 16);
            string4 = this._$1(string3, "sml:Blue", true);
            int n3 = Integer.valueOf(string4.replaceAll("0x", ""), 16);
            string4 = this._$1(string3, "sml:Alpha", true);
            int n4 = Integer.valueOf(string4.replaceAll("0x", ""), 16);
            this._$14 = new Color(n, n2, n3, n4);
            string3 = this._$1(string2, "sml:Transparent", true);
            this._$13 = Boolean.valueOf(string3);
            string3 = this._$1(string2, "sml:ImageCompress", true);
            this._$12 = Integer.valueOf(string3);
            string3 = this._$1(string2, "sml:FillMargin", true);
            this._$11 = Boolean.valueOf(string3);
            string3 = this._$1(string2, "sml:StorageType", true);
            this._$10 = (StorageType)Enum.parse(((Object)((Object)this._$10)).getClass(), (String)string3);
            string3 = this._$1(string2, "sml:TileType", true);
            this._$9 = (MapTilingMode)Enum.parse(((Object)((Object)this._$9)).getClass(), (String)string3);
            string3 = this._$1(string2, "sml:HashCodeEnabled", true);
            this._$8 = Boolean.valueOf(string3);
            string3 = this._$1(string2, "sml:ImageSize", true);
            this._$20 = (TileSize)Enum.parse(((Object)((Object)this._$20)).getClass(), (int)Integer.valueOf(string3));
            string3 = this._$1(string2, "sml:Bounds", true);
            string4 = this._$1(string3, "sml:Left", true);
            Double d = Double.valueOf(string4);
            string4 = this._$1(string3, "sml:Top", true);
            Double d2 = Double.valueOf(string4);
            string4 = this._$1(string3, "sml:Right", true);
            Double d3 = Double.valueOf(string4);
            string4 = this._$1(string3, "sml:Bottom", true);
            Double d4 = Double.valueOf(string4);
            this._$6 = new Rectangle2D(d.doubleValue(), d4.doubleValue(), d3.doubleValue(), d2.doubleValue());
            string3 = this._$1(string2, "sml:CoordRatio", true);
            this._$7 = Double.valueOf(string3) * 25.4;
            string3 = this._$1(string2, "sml:IndexBounds", true);
            string4 = this._$1(string3, "sml:Left", true);
            d = Double.valueOf(string4);
            string4 = this._$1(string3, "sml:Top", true);
            d2 = Double.valueOf(string4);
            string4 = this._$1(string3, "sml:Right", true);
            d3 = Double.valueOf(string4);
            string4 = this._$1(string3, "sml:Bottom", true);
            d4 = Double.valueOf(string4);
            this._$5 = new Rectangle2D(d.doubleValue(), d4.doubleValue(), d3.doubleValue(), d2.doubleValue());
            string3 = this._$1(string2, "sml:MapBounds", true);
            string4 = this._$1(string3, "sml:Left", true);
            d = Double.valueOf(string4);
            string4 = this._$1(string3, "sml:Top", true);
            d2 = Double.valueOf(string4);
            string4 = this._$1(string3, "sml:Right", true);
            d3 = Double.valueOf(string4);
            string4 = this._$1(string3, "sml:Bottom", true);
            d4 = Double.valueOf(string4);
            this._$4 = new Rectangle2D(d.doubleValue(), d4.doubleValue(), d3.doubleValue(), d2.doubleValue());
            string3 = this._$1(string2, "sml:Scales", true);
            this._$18.clear();
            while (string3.contains("sml:Scale")) {
                string4 = this._$1(string3, "sml:Scale", false);
                String string5 = this._$1(string4, "sml:Value", true);
                Double d5 = Double.valueOf(string5);
                String string6 = this._$1(string4, "sml:Caption", true);
                if (!this._$18.containsKey(d5)) {
                    this._$18.put(d5, string6);
                }
                string3 = string3.replaceAll(string4, "");
            }
            string3 = this._$1(string2, "sml:ClipRegion", true);
            if (!string3.isEmpty()) {
                this._$3 = new GeoRegion();
                this._$3.fromXML(string3);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private String _$1(String string, String string2, Boolean bl) {
        if (string.isEmpty() || string2.isEmpty()) {
            return "";
        }
        String string3 = "<" + string2 + ">";
        String string4 = "</" + string2 + ">";
        int n = string.indexOf(string3);
        if (n < 0) {
            return "";
        }
        int n2 = string.indexOf(string4, n);
        if (n2 < 0 || n2 <= n) {
            return "";
        }
        if (bl.booleanValue()) {
            return string.substring(n + string3.length(), n2);
        }
        return string.substring(n, n2 + string4.length());
    }

    private String _$2(TileFormat tileFormat) {
        String string = "";
        switch (tileFormat.value()) {
            case 122: {
                string = "J";
                break;
            }
            case 123: {
                string = "P";
                break;
            }
            case 124: {
                string = "G";
                break;
            }
            case 147: {
                string = "JP";
                break;
            }
            case 8888: {
                string = "P8";
                break;
            }
        }
        return string;
    }

    private String _$1(TileFormat tileFormat) {
        String string = "";
        switch (tileFormat.value()) {
            case 122: 
            case 147: {
                string = ".jpg";
                break;
            }
            case 123: 
            case 8888: {
                string = ".png";
                break;
            }
            case 124: {
                string = ".gif";
                break;
            }
        }
        return string;
    }
}

