/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalMaterial;
import com.supermap.data.InternalResource;
import com.supermap.data.Material;
import com.supermap.data.StrokeType;
import com.supermap.data.SymbolMarkerStrokeNative;

public class SymbolMarkerStroke
extends InternalHandleDisposable {
    public SymbolMarkerStroke(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("data", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("data", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = SymbolMarkerStrokeNative.jni_New();
        this.setHandle(l2, true);
        geometry.makeSureNativeObjectLive();
    }

    SymbolMarkerStroke(long l) {
        this.setHandle(l, false);
    }

    public StrokeType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = SymbolMarkerStrokeNative.jni_GetType(this.getHandle());
        return (StrokeType)Enum.parseUGCValue(StrokeType.class, n);
    }

    public Material getMaterial() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetMaterial()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = SymbolMarkerStrokeNative.jni_GetMaterial(this.getHandle());
        if (l == 0L) {
            return null;
        }
        Material material = InternalMaterial.createInstance(l);
        return material;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolMarkerStrokeNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

