/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Material;
import com.supermap.data.MeshNative;
import java.awt.Color;

public class Mesh
extends InternalHandleDisposable {
    private Material _$3 = null;

    private int _$5() {
        return MeshNative.jni_GetColorsCount(this.getHandle());
    }

    private int _$4() {
        return MeshNative.jni_GetIndexesCount(this.getHandle());
    }

    private int _$3() {
        return MeshNative.jni_GetNormalsCount(this.getHandle());
    }

    private int _$2() {
        return MeshNative.jni_GetTextureCoordsCount(this.getHandle());
    }

    private int _$1() {
        return MeshNative.jni_GetVerticesCount(this.getHandle());
    }

    public Mesh() {
        long l = MeshNative.jni_New();
        this.setHandle(l, true);
    }

    public Mesh(Mesh mesh) {
        this(mesh, true);
    }

    protected Mesh(Mesh mesh, boolean bl) {
        if (mesh == null) {
            String string = InternalResource.loadString("Mesh", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (mesh.getHandle() == 0L) {
            String string = InternalResource.loadString("Mesh", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = MeshNative.jni_Clone(mesh.getHandle());
        this.setHandle(l, bl);
        InternalHandleDisposable.makeSureNativeObjectLive(mesh);
    }

    protected Mesh(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("Mesh", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, false);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MeshNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public Color[] getColors() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColors", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this._$5();
        Color[] colorArray = new Color[n];
        if (n > 0) {
            int[] nArray = new int[n];
            MeshNative.jni_GetColors(this.getHandle(), nArray);
            for (int i = 0; i < n; ++i) {
                colorArray[i] = new Color(nArray[i], true);
            }
        }
        return colorArray;
    }

    public void setColors(Color[] colorArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColors", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (colorArray == null) {
            colorArray = new Color[]{};
        }
        int n = colorArray.length;
        int[] nArray = new int[n];
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = colorArray[i].getRGB();
            }
        }
        MeshNative.jni_SetColors(this.getHandle(), nArray);
    }

    public int[] getIndexes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIndexes", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this._$4();
        int[] nArray = new int[n];
        if (n > 0) {
            MeshNative.jni_GetIndexes(this.getHandle(), nArray);
        }
        return nArray;
    }

    public void setIndexes(int[] nArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIndexes", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            nArray = new int[]{};
        }
        MeshNative.jni_SetIndexes(this.getHandle(), nArray);
    }

    public Material getMaterial() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaterial", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$3;
    }

    public void setMaterial(Material material) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaterial", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this._$3 = material;
    }

    public double[] getNormals() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNormals", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this._$3();
        double[] dArray = new double[n * 3];
        if (n > 0) {
            MeshNative.jni_GetNormals(this.getHandle(), dArray);
        }
        return dArray;
    }

    public void setNormals(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNormals", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (dArray == null) {
            dArray = new double[]{};
        }
        MeshNative.jni_SetNormals(this.getHandle(), dArray);
    }

    public double[] getTextureCoords() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextureCoords", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this._$2();
        double[] dArray = new double[n * 2];
        if (n > 0) {
            MeshNative.jni_GetTextureCoords(this.getHandle(), dArray);
        }
        return dArray;
    }

    public void setTextureCoords(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextureCoords", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (dArray == null) {
            dArray = new double[]{};
        }
        MeshNative.jni_SetTextureCoords(this.getHandle(), dArray);
    }

    public double[] getVertices() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVertices", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this._$1();
        double[] dArray = new double[n * 3];
        if (n > 0) {
            MeshNative.jni_GetVertices(this.getHandle(), dArray);
        }
        return dArray;
    }

    public void setVertices(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVertices", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (dArray == null) {
            dArray = new double[]{};
        }
        MeshNative.jni_SetVertices(this.getHandle(), dArray);
    }
}

