/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.LayoutAddedEvent;
import com.supermap.data.LayoutAddedListener;
import com.supermap.data.LayoutClearedEvent;
import com.supermap.data.LayoutClearedListener;
import com.supermap.data.LayoutClearingEvent;
import com.supermap.data.LayoutClearingListener;
import com.supermap.data.LayoutRemovedEvent;
import com.supermap.data.LayoutRemovedListener;
import com.supermap.data.LayoutRemovingEvent;
import com.supermap.data.LayoutRemovingListener;
import com.supermap.data.LayoutRenamedEvent;
import com.supermap.data.LayoutRenamedListener;
import com.supermap.data.LayoutRenamingEvent;
import com.supermap.data.LayoutRenamingListener;
import com.supermap.data.LayoutsNative;
import com.supermap.data.Workspace;
import java.util.concurrent.CopyOnWriteArrayList;

public class Layouts {
    private Workspace _$1;
    transient CopyOnWriteArrayList<LayoutRenamingListener> m_layoutRenamingListeners;
    transient CopyOnWriteArrayList<LayoutRenamedListener> m_layoutRenamedListeners;
    transient CopyOnWriteArrayList<LayoutRemovingListener> m_layoutRemovingListeners;
    transient CopyOnWriteArrayList<LayoutRemovedListener> m_layoutRemovedListeners;
    transient CopyOnWriteArrayList<LayoutAddedListener> m_layoutAddedListeners;
    transient CopyOnWriteArrayList<LayoutClearingListener> m_layoutClearingListeners;
    transient CopyOnWriteArrayList<LayoutClearedListener> m_layoutClearedListeners;

    Layouts(Workspace workspace) {
        this._$1 = workspace;
    }

    public int getCount() {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return LayoutsNative.jni_GetCount(this._$1.getHandle());
    }

    public String get(int n) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return LayoutsNative.jni_GetItem(this._$1.getHandle(), n);
    }

    public int add(String string, String string2) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.indexOf(string) >= 0) {
            String string5 = InternalResource.loadString("name", "Layouts_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        int n = -1;
        n = LayoutsNative.jni_Add(this._$1.getHandle(), string, string2);
        if (n > -1) {
            LayoutAddedEvent layoutAddedEvent = new LayoutAddedEvent(this, string);
            this.fireAdded(layoutAddedEvent);
        }
        return n;
    }

    public boolean insert(int n, String string, String string2) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (n < 0 || n > this.getCount()) {
            String string4 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.indexOf(string) >= 0) {
            String string6 = InternalResource.loadString("name", "Layouts_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        return LayoutsNative.jni_Insert(this._$1.getHandle(), n, string, string2);
    }

    public boolean setLayoutXML(int n, String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (n < 0 || n >= this.getCount()) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string3);
        }
        if (string == null) {
            string = "";
        }
        return LayoutsNative.jni_SetLayoutXML(this._$1.getHandle(), n, string);
    }

    public boolean setLayoutXML(String string, String string2) {
        int n;
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((n = this.indexOf(string)) == -1) {
            String string5 = InternalResource.loadString("name", "Layouts_NameIsNotInLayouts", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        return this.setLayoutXML(n, string2);
    }

    public String getLayoutXML(int n) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return LayoutsNative.jni_GetLayoutXML(this._$1.getHandle(), n);
    }

    public String getLayoutXML(String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        int n = this.indexOf(string);
        if (n == -1) {
            String string4 = InternalResource.loadString("name", "Layouts_NameIsNotInLayouts", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        return LayoutsNative.jni_GetLayoutXML(this._$1.getHandle(), n);
    }

    public boolean remove(int n) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = this.get(n);
        LayoutRemovingEvent layoutRemovingEvent = new LayoutRemovingEvent(this, string);
        this.fireRemoving(layoutRemovingEvent);
        if (layoutRemovingEvent.isCancel()) {
            return false;
        }
        boolean bl = false;
        bl = LayoutsNative.jni_Remove(this._$1.getHandle(), n);
        if (bl) {
            LayoutRemovedEvent layoutRemovedEvent = new LayoutRemovedEvent(this, string);
            this.fireRemoved(layoutRemovedEvent);
        }
        return bl;
    }

    public boolean remove(String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        int n = this.indexOf(string);
        if (n != -1) {
            bl = this.remove(n);
        }
        return bl;
    }

    public void clear() {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        LayoutClearingEvent layoutClearingEvent = new LayoutClearingEvent(this);
        this.fireClearing(layoutClearingEvent);
        if (layoutClearingEvent.isCancel()) {
            return;
        }
        int n = this.getCount();
        LayoutsNative.jni_Clear(this._$1.getHandle());
        LayoutClearedEvent layoutClearedEvent = new LayoutClearedEvent(this, n);
        this.fireCleared(layoutClearedEvent);
    }

    public int indexOf(String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            n = LayoutsNative.jni_IndexOf(this._$1.getHandle(), string);
        }
        return n;
    }

    public String getAvailableLayoutName(String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        return LayoutsNative.jni_GetUnoccupiedLayoutName(this._$1.getHandle(), string);
    }

    public boolean rename(String string, String string2) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("oldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string5 = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this.indexOf(string) == -1) {
            String string6 = InternalResource.loadString("oldName", "Layouts_NameIsNotInLayouts", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (string2.equalsIgnoreCase(string)) {
            return false;
        }
        if (this.indexOf(string2) >= 0) {
            String string7 = InternalResource.loadString("newName", "Layouts_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        LayoutRenamingEvent layoutRenamingEvent = new LayoutRenamingEvent(this, string, string2);
        this.fireRenaming(layoutRenamingEvent);
        if (layoutRenamingEvent.isCancel()) {
            return false;
        }
        boolean bl = false;
        bl = LayoutsNative.jni_Rename(this._$1.getHandle(), string, string2);
        if (bl) {
            LayoutRenamedEvent layoutRenamedEvent = new LayoutRenamedEvent(this, string, string2);
            this.fireRenamed(layoutRenamedEvent);
        }
        return bl;
    }

    protected void clearHandle() {
        this._$1 = null;
    }

    public synchronized void addRenamingListener(LayoutRenamingListener layoutRenamingListener) {
        if (this.m_layoutRenamingListeners == null) {
            this.m_layoutRenamingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutRenamingListeners.contains(layoutRenamingListener)) {
            this.m_layoutRenamingListeners.add(layoutRenamingListener);
        }
    }

    public void removeRenamingListener(LayoutRenamingListener layoutRenamingListener) {
        if (this.m_layoutRenamingListeners != null && this.m_layoutRenamingListeners.contains(layoutRenamingListener)) {
            this.m_layoutRenamingListeners.remove(layoutRenamingListener);
        }
    }

    protected void fireRenaming(LayoutRenamingEvent layoutRenamingEvent) {
        if (this.m_layoutRenamingListeners != null) {
            CopyOnWriteArrayList<LayoutRenamingListener> copyOnWriteArrayList = this.m_layoutRenamingListeners;
            for (LayoutRenamingListener layoutRenamingListener : copyOnWriteArrayList) {
                layoutRenamingListener.layoutRenaming(layoutRenamingEvent);
            }
        }
    }

    public synchronized void addRenamedListener(LayoutRenamedListener layoutRenamedListener) {
        if (this.m_layoutRenamedListeners == null) {
            this.m_layoutRenamedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutRenamedListeners.contains(layoutRenamedListener)) {
            this.m_layoutRenamedListeners.add(layoutRenamedListener);
        }
    }

    public void removeRenamedListener(LayoutRenamedListener layoutRenamedListener) {
        if (this.m_layoutRenamedListeners != null && this.m_layoutRenamedListeners.contains(layoutRenamedListener)) {
            this.m_layoutRenamedListeners.remove(layoutRenamedListener);
        }
    }

    protected void fireRenamed(LayoutRenamedEvent layoutRenamedEvent) {
        if (this.m_layoutRenamedListeners != null) {
            CopyOnWriteArrayList<LayoutRenamedListener> copyOnWriteArrayList = this.m_layoutRenamedListeners;
            for (LayoutRenamedListener layoutRenamedListener : copyOnWriteArrayList) {
                layoutRenamedListener.layoutRenamed(layoutRenamedEvent);
            }
        }
    }

    public synchronized void addRemovingListener(LayoutRemovingListener layoutRemovingListener) {
        if (this.m_layoutRemovingListeners == null) {
            this.m_layoutRemovingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutRemovingListeners.contains(layoutRemovingListener)) {
            this.m_layoutRemovingListeners.add(layoutRemovingListener);
        }
    }

    public void removeRemovingListener(LayoutRemovingListener layoutRemovingListener) {
        if (this.m_layoutRemovingListeners != null && this.m_layoutRemovingListeners.contains(layoutRemovingListener)) {
            this.m_layoutRemovingListeners.remove(layoutRemovingListener);
        }
    }

    protected void fireRemoving(LayoutRemovingEvent layoutRemovingEvent) {
        if (this.m_layoutRemovingListeners != null) {
            CopyOnWriteArrayList<LayoutRemovingListener> copyOnWriteArrayList = this.m_layoutRemovingListeners;
            for (LayoutRemovingListener layoutRemovingListener : copyOnWriteArrayList) {
                layoutRemovingListener.layoutRemoving(layoutRemovingEvent);
            }
        }
    }

    public synchronized void addRemovedListener(LayoutRemovedListener layoutRemovedListener) {
        if (this.m_layoutRemovedListeners == null) {
            this.m_layoutRemovedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutRemovedListeners.contains(layoutRemovedListener)) {
            this.m_layoutRemovedListeners.add(layoutRemovedListener);
        }
    }

    public void removeRemovedListener(LayoutRemovedListener layoutRemovedListener) {
        if (this.m_layoutRemovedListeners != null && this.m_layoutRemovedListeners.contains(layoutRemovedListener)) {
            this.m_layoutRemovedListeners.remove(layoutRemovedListener);
        }
    }

    protected void fireRemoved(LayoutRemovedEvent layoutRemovedEvent) {
        if (this.m_layoutRemovedListeners != null) {
            CopyOnWriteArrayList<LayoutRemovedListener> copyOnWriteArrayList = this.m_layoutRemovedListeners;
            for (LayoutRemovedListener layoutRemovedListener : copyOnWriteArrayList) {
                layoutRemovedListener.layoutRemoved(layoutRemovedEvent);
            }
        }
    }

    public synchronized void addAddedListener(LayoutAddedListener layoutAddedListener) {
        if (this.m_layoutAddedListeners == null) {
            this.m_layoutAddedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutAddedListeners.contains(layoutAddedListener)) {
            this.m_layoutAddedListeners.add(layoutAddedListener);
        }
    }

    public void removeAddedListener(LayoutAddedListener layoutAddedListener) {
        if (this.m_layoutAddedListeners != null && this.m_layoutAddedListeners.contains(layoutAddedListener)) {
            this.m_layoutAddedListeners.remove(layoutAddedListener);
        }
    }

    protected void fireAdded(LayoutAddedEvent layoutAddedEvent) {
        if (this.m_layoutAddedListeners != null) {
            CopyOnWriteArrayList<LayoutAddedListener> copyOnWriteArrayList = this.m_layoutAddedListeners;
            for (LayoutAddedListener layoutAddedListener : copyOnWriteArrayList) {
                layoutAddedListener.layoutAdded(layoutAddedEvent);
            }
        }
    }

    public synchronized void addClearingListener(LayoutClearingListener layoutClearingListener) {
        if (this.m_layoutClearingListeners == null) {
            this.m_layoutClearingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutClearingListeners.contains(layoutClearingListener)) {
            this.m_layoutClearingListeners.add(layoutClearingListener);
        }
    }

    public void removeClearingListener(LayoutClearingListener layoutClearingListener) {
        if (this.m_layoutClearingListeners != null && this.m_layoutClearingListeners.contains(layoutClearingListener)) {
            this.m_layoutClearingListeners.remove(layoutClearingListener);
        }
    }

    protected void fireClearing(LayoutClearingEvent layoutClearingEvent) {
        if (this.m_layoutClearingListeners != null) {
            CopyOnWriteArrayList<LayoutClearingListener> copyOnWriteArrayList = this.m_layoutClearingListeners;
            for (LayoutClearingListener layoutClearingListener : copyOnWriteArrayList) {
                layoutClearingListener.layoutClearing(layoutClearingEvent);
            }
        }
    }

    public synchronized void addClearedListener(LayoutClearedListener layoutClearedListener) {
        if (this.m_layoutClearedListeners == null) {
            this.m_layoutClearedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutClearedListeners.contains(layoutClearedListener)) {
            this.m_layoutClearedListeners.add(layoutClearedListener);
        }
    }

    public void removeClearedListener(LayoutClearedListener layoutClearedListener) {
        if (this.m_layoutClearedListeners != null && this.m_layoutClearedListeners.contains(layoutClearedListener)) {
            this.m_layoutClearedListeners.remove(layoutClearedListener);
        }
    }

    protected void fireCleared(LayoutClearedEvent layoutClearedEvent) {
        if (this.m_layoutClearedListeners != null) {
            CopyOnWriteArrayList<LayoutClearedListener> copyOnWriteArrayList = this.m_layoutClearedListeners;
            for (LayoutClearedListener layoutClearedListener : copyOnWriteArrayList) {
                layoutClearedListener.layoutCleared(layoutClearedEvent);
            }
        }
    }
}

