/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Animation;
import com.supermap.data.BoundingBox;
import com.supermap.data.GeoModelNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Meshes;
import com.supermap.data.Point3D;
import java.io.File;

public class GeoModel
extends Geometry3D {
    protected Meshes m_meshes;
    private Animation _$8;

    public GeoModel() {
        this.setHandle(GeoModelNative.jni_New(), true);
    }

    public GeoModel(GeoModel geoModel) {
        if (geoModel == null) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoModel);
        if (l == 0L) {
            String string = InternalResource.loadString("geoModel", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoModelNative.jni_Clone(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoModel);
    }

    GeoModel(long l) {
        this.setHandle(l, false);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoModelNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setName(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("name", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        GeoModelNative.jni_SetName(this.getHandle(), string);
    }

    public Meshes getMeshes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMeshes()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_meshes == null) {
            this.m_meshes = new Meshes(this.getHandle());
        }
        return this.m_meshes;
    }

    public Animation getAnimation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMeshes()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoModelNative.jni_GetAnimation(this.getHandle());
        if (this._$8 == null) {
            this._$8 = new Animation(l);
        }
        return this._$8;
    }

    public boolean fromFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromFile(String file)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("file", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string4 = InternalResource.loadString("file", "GeoModel_TheFileIsNotExist", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        return GeoModelNative.jni_FromFile(this.getHandle(), string);
    }

    public boolean toStreamFile(String string) {
        return GeoModelNative.jni_ToStreamFile(this.getHandle(), string);
    }

    public boolean fromFile(String string, Point3D point3D) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromFile(String file, Point3D position)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("file", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = this.fromFile(string);
        if (bl) {
            this.setPosition(point3D);
        }
        return bl;
    }

    public boolean toSGM(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("toSGM(String fileSGM)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("fileSGM", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        return GeoModelNative.jni_ToSGM(this.getHandle(), string);
    }

    public boolean toSGZ(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("toSGZ(String fileSGZ)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("fileSGM", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        return GeoModelNative.jni_ToSGZ(this.getHandle(), string);
    }

    public GeoModel clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoModel(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoModelNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected static GeoModel creatInstance(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoModel(l);
    }

    public void computeBoundingBox() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeBoundingBox()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoModelNative.jni_ComputeBoundingBox(this.getHandle());
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBoundingBox(BoundingBox boundingBox)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = boundingBox.getHandle();
        GeoModelNative.jni_SetBoundingBox(this.getHandle(), l);
    }

    protected void clearHandle() {
        if (this._$8 != null) {
            this._$8.clearHandle();
            this._$8 = null;
        }
        this.setHandle(0L);
    }

    protected static void clearMeshes(GeoModel geoModel) {
        geoModel.m_meshes = null;
    }
}

