/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLineNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import java.util.ArrayList;

public class GeoLine
extends Geometry {
    private ArrayList _$5;

    public GeoLine() {
        long l = GeoLineNative.jni_New();
        this.setHandle(l, true);
        this._$5 = new ArrayList();
    }

    public GeoLine(GeoLine geoLine) {
        if (geoLine == null) {
            String string = InternalResource.loadString("geoLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLine.getHandle() == 0L) {
            String string = InternalResource.loadString("geoLine", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoLineNative.jni_Clone(geoLine.getHandle());
        this.setHandle(l, true);
        this._$5 = new ArrayList();
        for (int i = 0; i < geoLine.getPartsList().size(); ++i) {
            Point2Ds point2Ds = (Point2Ds)geoLine.getPartsList().get(i);
            this._$5.add(point2Ds.clone());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLine);
    }

    public GeoLine(Point2Ds point2Ds) {
        this();
        this.addPart(point2Ds);
    }

    GeoLine(long l) {
        this.setHandle(l, false);
        this._$5 = new ArrayList();
        this.refrashPartsList();
    }

    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    public GeoLine clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoLine(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoLineNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineNative.jni_GetLength(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineNative.jni_GetPartCount(this.getHandle());
    }

    public int addPart(Point2Ds point2Ds) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("points", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
        }
        n = GeoLineNative.jni_AddPart(this.getHandle(), dArray, dArray2);
        Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
        this._$5.add(point2Ds2);
        return n;
    }

    public boolean removePart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoLineNative.jni_RemovePart(this.getHandle(), n);
        if (bl) {
            this._$5.remove(n);
        }
        return bl;
    }

    public GeoRegion convertToRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToRegion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoLineNative.jni_ConvertToRegion(this.getHandle());
        GeoRegion geoRegion = new GeoRegion(l);
        geoRegion.setIsDisposable(true);
        if (this.getPartCount() != geoRegion.getPartCount()) {
            String string = InternalResource.loadString("convertToRegion", "GeoLine_UnsupportOperation", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return geoRegion;
    }

    public Point2D findPointOnLineByDistance(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPointOnLineByDistance(double distance)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("distance", "GeoLine_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2D point2D = new Point2D();
        if (this.getPartCount() > 0) {
            double[] dArray = new double[2];
            GeoLineNative.jni_FindPointOnLineByDistance(this.getHandle(), d, dArray);
            point2D.setX(dArray[0]);
            point2D.setY(dArray[1]);
        }
        return point2D;
    }

    public Point2Ds getPart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (Point2Ds)this._$5.get(n);
    }

    public boolean insertPart(int n, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("Point2Ds", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int n3 = this.getPartCount();
        if (n3 == n) {
            int n4 = this.addPart(point2Ds);
            boolean bl2 = bl = n4 == n;
            if (bl) {
                Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
                this._$5.add(n, point2Ds2);
            }
            return bl;
        }
        if (n < 0 || n > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        bl = GeoLineNative.jni_InsertPart(this.getHandle(), n, dArray, dArray2);
        if (bl) {
            Point2Ds point2Ds3 = new Point2Ds(point2Ds, this);
            this._$5.add(n, point2Ds3);
        }
        return bl;
    }

    public boolean reverse() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverse()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = GeoLineNative.jni_Reverse(this.getHandle());
        this._$1();
        return bl;
    }

    public boolean setPart(int n, Point2Ds point2Ds) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = point2Ds.getCount();
        if (n3 < 2) {
            String string = InternalResource.loadString("Point2Ds", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = point2Ds.getItem(n2).getX();
            dArray2[n2] = point2Ds.getItem(n2).getY();
        }
        n2 = GeoLineNative.jni_SetPart(this.getHandle(), n, dArray, dArray2) ? 1 : 0;
        if (n2 == 1) {
            Point2Ds point2Ds2 = (Point2Ds)this._$5.get(n);
            Point2Ds point2Ds3 = new Point2Ds(point2Ds, this);
            this._$5.set(n, point2Ds3);
            point2Ds2.setUserType(Point2Ds.UserType.NONE);
        }
        return n2 != 0;
    }

    boolean setPartJustToUGC(int n, Point2Ds point2Ds) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPartJustToUGC(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = point2Ds.getCount();
        if (n3 < 2) {
            String string = InternalResource.loadString("Point2Ds", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = point2Ds.getItem(n2).getX();
            dArray2[n2] = point2Ds.getItem(n2).getY();
        }
        n2 = GeoLineNative.jni_SetPart(this.getHandle(), n, dArray, dArray2) ? 1 : 0;
        return n2 != 0;
    }

    public int indexOf(Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(Point2Ds part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$5.indexOf(point2Ds);
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = super.fromXML(string);
        if (bl) {
            this.refrashPartsList();
        }
        return bl;
    }

    public Geometry mirror(Point2D point2D, Point2D point2D2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mirror(Point2D startPoint, Point2D endPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLine geoLine = (GeoLine)super.mirror(point2D, point2D2);
        int n = geoLine.getPartCount();
        geoLine._$5 = new ArrayList();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = new Point2Ds(geoLine._$1(i));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, geoLine);
            geoLine._$5.add(point2Ds2);
        }
        return geoLine;
    }

    public void offset(double d, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.offset(d, d2);
        this._$1();
    }

    public void resize(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("resize(Rectangle2D bounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.resize(rectangle2D);
        this._$1();
    }

    public void rotate(Point2D point2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.rotate(point2D, d);
        this._$1();
    }

    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineNative.jni_Clear(this.getHandle());
        this._$5.clear();
    }

    protected void clearHandle() {
        super.clearHandle();
        if (this._$5 != null) {
            this._$5.clear();
            this._$5 = null;
        }
    }

    ArrayList getPartsList() {
        return this._$5;
    }

    private Point2D[] _$1(int n) {
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = GeoLineNative.jni_GetPartPointCount(this.getHandle(), n);
        if (n2 > 1) {
            Point2D[] point2DArray = new Point2D[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            GeoLineNative.jni_GetPart(this.getHandle(), n, dArray, dArray2);
            for (int i = 0; i < n2; ++i) {
                point2DArray[i] = new Point2D(dArray[i], dArray2[i]);
            }
            return point2DArray;
        }
        return null;
    }

    private void _$1() {
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = (Point2Ds)this._$5.get(i);
            point2Ds.setUserType(Point2Ds.UserType.NONE);
            point2Ds.clear();
            point2Ds.addRange(this._$1(i));
            point2Ds.setUserType(Point2Ds.UserType.GEOLINE);
        }
    }

    void refrashPartsList() {
        int n = this.getPartCount();
        this._$5.clear();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = new Point2Ds(this._$1(i));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
            this._$5.add(point2Ds2);
        }
    }
}

