/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoBoxNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Size2D;

public class GeoBox
extends Geometry3D {
    public GeoBox() {
        long l = GeoBoxNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoBox(GeoBox geoBox) {
        if (geoBox == null) {
            String string = InternalResource.loadString("geoBox", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoBox);
        if (l == 0L) {
            String string = InternalResource.loadString("geoBox", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoBoxNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoBox);
    }

    public GeoBox(Point3D point3D, Size2D size2D, double d) {
        if (size2D.getWidth() <= 0.0) {
            String string = InternalResource.loadString("length", "GeoBox_LengthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (size2D.getHeight() <= 0.0) {
            String string = InternalResource.loadString("width", "GeoBox_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("height", "GeoBox_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoBoxNative.jni_New1(point3D.getX(), point3D.getY(), point3D.getZ(), size2D.getWidth(), size2D.getHeight(), d);
        this.setHandle(l, true);
    }

    GeoBox(long l) {
        this.setHandle(l, false);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        GeoBoxNative.jni_GetCenter(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoBoxNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoBox_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoBoxNative.jni_SetHeight(this.getHandle(), d);
    }

    public Size2D getBottomSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBottomSize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoBoxNative.jni_getBottomSize(this.getHandle());
        return new Size2D(dArray[0], dArray[1]);
    }

    public void setBottomSize(Size2D size2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetLength(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (size2D.getWidth() <= 0.0) {
            String string = InternalResource.loadString("value", "GeoBox_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (size2D.getHeight() <= 0.0) {
            String string = InternalResource.loadString("value", "GeoBox_LengthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoBoxNative.jni_setBottomSize(this.getHandle(), size2D.getWidth(), size2D.getHeight());
    }

    public GeoBox clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoBox(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoBoxNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

