/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CodeDomain;
import com.supermap.data.DomainNative;
import com.supermap.data.DomainType;
import com.supermap.data.Enum;
import com.supermap.data.FieldType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalResource;
import com.supermap.data.RangeDomain;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Pattern;

public abstract class Domain
extends InternalHandle {
    protected Domain() {
    }

    public int getID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DomainNative.jni_GetID(this.getHandle());
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DomainNative.jni_GetName(this.getHandle());
    }

    public DomainType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DomainNative.jni_GetType(this.getHandle());
        return (DomainType)Enum.parseUGCValue(DomainType.class, n);
    }

    public FieldType getValueType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DomainNative.jni_GetValueType(this.getHandle());
        return (FieldType)Enum.parseUGCValue(FieldType.class, n);
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DomainNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        DomainNative.jni_SetDecription(this.getHandle(), string);
    }

    public boolean check(Object object) {
        FieldType fieldType = this.getValueType();
        boolean bl = false;
        if (object != null) {
            String string = object.toString();
            if (fieldType.equals(FieldType.INT16)) {
                bl = DomainNative.jni_CheckInt16Value(this.getHandle(), Short.valueOf(string));
            } else if (fieldType.equals(FieldType.INT32)) {
                bl = DomainNative.jni_CheckInt32Value(this.getHandle(), Integer.valueOf(string));
            } else if (fieldType.equals(FieldType.INT64)) {
                bl = DomainNative.jni_CheckInt64Value(this.getHandle(), Long.valueOf(string));
            } else if (fieldType.equals(FieldType.SINGLE)) {
                bl = DomainNative.jni_CheckFloatValue(this.getHandle(), Float.valueOf(string).floatValue());
            } else if (fieldType.equals(FieldType.DOUBLE)) {
                bl = DomainNative.jni_CheckDoubleValue(this.getHandle(), Double.valueOf(string));
            } else if (fieldType.equals(FieldType.TEXT)) {
                bl = DomainNative.jni_CheckTextValue(this.getHandle(), string);
            } else if (fieldType.equals(FieldType.DATETIME)) {
                Serializable serializable;
                Date date = null;
                if (object instanceof String) {
                    String string2;
                    serializable = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
                    if (((Pattern)serializable).matcher(string2 = (String)object).matches()) {
                        String string3 = System.getProperty("os.name").toLowerCase();
                        if (string3.equals("aix")) {
                            try {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                date = simpleDateFormat.parse(string2);
                            }
                            catch (ParseException parseException) {
                                try {
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                    date = simpleDateFormat.parse(string2);
                                }
                                catch (ParseException parseException2) {}
                            }
                        } else {
                            try {
                                date = DateFormat.getDateInstance().parse(string2);
                            }
                            catch (ParseException parseException) {}
                        }
                    }
                } else {
                    date = (Date)object;
                }
                serializable = new GregorianCalendar(Locale.getDefault());
                ((Calendar)serializable).setTime(date);
                int n = ((Calendar)serializable).get(1);
                int n2 = ((Calendar)serializable).get(2) + 1;
                int n3 = ((Calendar)serializable).get(5);
                int n4 = ((Calendar)serializable).get(11);
                int n5 = ((Calendar)serializable).get(12);
                int n6 = ((Calendar)serializable).get(13);
                bl = DomainNative.jni_CheckDateTimeValue(this.getHandle(), n, n2, n3, n4, n5, n6);
            }
        }
        return bl;
    }

    public boolean checkInt(int n) {
        boolean bl = false;
        bl = DomainNative.jni_CheckInt32Value(this.getHandle(), n);
        return bl;
    }

    public boolean checkDouble(double d) {
        boolean bl = false;
        bl = DomainNative.jni_CheckDoubleValue(this.getHandle(), d);
        return bl;
    }

    public boolean checkString(String string) {
        boolean bl = false;
        bl = DomainNative.jni_CheckTextValue(this.getHandle(), string);
        return bl;
    }

    protected static Domain CreateInstance(long l, DomainType domainType) {
        if (l == 0L) {
            String string = InternalResource.loadString("", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Domain domain = null;
        if (domainType.equals(DomainType.RANGE) || domainType.equals(DomainType.RANGE_NOT)) {
            domain = new RangeDomain(l);
        } else if (domainType.equals(DomainType.CODE) || domainType.equals(DomainType.CODE_NOT)) {
            domain = new CodeDomain(l);
        }
        return domain;
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }
}

