/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetCreatedEvent;
import com.supermap.data.DatasetCreatedListener;
import com.supermap.data.DatasetDeletedAllEvent;
import com.supermap.data.DatasetDeletedAllListener;
import com.supermap.data.DatasetDeletedEvent;
import com.supermap.data.DatasetDeletedListener;
import com.supermap.data.DatasetDeletingAllEvent;
import com.supermap.data.DatasetDeletingAllListener;
import com.supermap.data.DatasetDeletingEvent;
import com.supermap.data.DatasetDeletingListener;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridCollection;
import com.supermap.data.DatasetGridCollectionInfo;
import com.supermap.data.DatasetGridInfo;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetImageCollection;
import com.supermap.data.DatasetImageCollectionInfo;
import com.supermap.data.DatasetImageInfo;
import com.supermap.data.DatasetRenamedEvent;
import com.supermap.data.DatasetRenamedListener;
import com.supermap.data.DatasetRenamingEvent;
import com.supermap.data.DatasetRenamingListener;
import com.supermap.data.DatasetTopology;
import com.supermap.data.DatasetTopologyInfo;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.DatasetsNative;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceNative;
import com.supermap.data.EncodeType;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

public class Datasets {
    private ArrayList<Dataset> _$3 = null;
    private Datasource _$2 = null;
    transient CopyOnWriteArrayList<DatasetRenamingListener> m_datasetRenamingListeners;
    transient CopyOnWriteArrayList<DatasetRenamedListener> m_datasetRenamedListeners;
    transient CopyOnWriteArrayList<DatasetDeletingListener> m_datasetDeletingListeners;
    transient CopyOnWriteArrayList<DatasetDeletedListener> m_datasetDeletedListeners;
    transient CopyOnWriteArrayList<DatasetDeletingAllListener> m_datasetDeletingAllListeners;
    transient CopyOnWriteArrayList<DatasetDeletedAllListener> m_datasetDeletedAllListeners;
    transient CopyOnWriteArrayList<DatasetCreatedListener> m_datasetCreatedListeners;
    private static Integer _$1 = new Integer(0);

    protected Datasets() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datasets(Datasource datasource) {
        Integer n = _$1;
        synchronized (n) {
            this.clearHandle();
            this._$3 = new ArrayList();
            this._$2 = datasource;
            this.reset();
        }
    }

    public int getCount() {
        if (!this._$1()) {
            String string = InternalResource.loadString("getCount()", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$3.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset get(String string) {
        if (!this._$1()) {
            String string2 = InternalResource.loadString("get(String name)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        Dataset dataset = null;
        Integer n = _$1;
        synchronized (n) {
            int n2 = this.indexOf(string);
            if (n2 != -1) {
                dataset = this.get(n2);
            }
        }
        return dataset;
    }

    public Dataset get(int n) {
        if (!this._$1()) {
            String string = InternalResource.loadString("get(int index)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this._$3.get(n);
    }

    public Datasource getDatasource() {
        if (!this._$1()) {
            String string = InternalResource.loadString("getDatasource()", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$2;
    }

    public DatasetVector create(DatasetVectorInfo datasetVectorInfo) {
        Object object;
        String string;
        if (!this._$1()) {
            String string2 = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$2.isReadOnly()) {
            String string3 = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        if (datasetVectorInfo == null) {
            String string4 = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string4);
        }
        if (datasetVectorInfo.getHandle() == 0L) {
            String string5 = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!Datasets.isCreatableEnCodeType(datasetVectorInfo.getType(), datasetVectorInfo.getEncodeType())) {
            String string6 = InternalResource.loadString("value", "DatasetVectorInfo_IllegalEncodeType", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (datasetVectorInfo.getType().equals(DatasetType.NETWORK) && !this.isAvailableDatasetName(string = (String)(object = datasetVectorInfo.getName()) + "_node")) {
            String string7 = InternalResource.loadString("networkDatasetName", "Datasets_CreateDatasetNameLengthMoreThanThirty", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (!Datasets.isCreatableVectorType(datasetVectorInfo.getType())) {
            object = InternalResource.loadString("type", "Datasets_FailToCreateBecauseOfType", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        if (!Datasets.isCreatableEnCodeType(datasetVectorInfo.getType(), datasetVectorInfo.getEncodeType())) {
            object = InternalResource.loadString("encodeType", "Datasets_FailToCreateBecauseOfEncodeType", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = null;
        if (datasetVectorInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetVectorInfo.getName())) {
            string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if ((datasetVectorInfo.getType() == DatasetType.PARAMETRICLINE || datasetVectorInfo.getType() == DatasetType.PARAMETRICREGION) && this._$2.getEngineType() != EngineType.SQLPLUS && this._$2.getEngineType() != EngineType.ORACLEPLUS && this._$2.getEngineType() != EngineType.UDB) {
            string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_FailToCreateBecauseOfType", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        long l = DatasetsNative.jni_CreateDatasetVector(this._$2.getHandle(), datasetVectorInfo.getHandle());
        if (l != 0L) {
            object = new DatasetVector(l, this._$2);
            this.add((Dataset)object);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(datasetVectorInfo);
        return object;
    }

    public DatasetGrid create(DatasetGridInfo datasetGridInfo) {
        if (!this._$1()) {
            String string = InternalResource.loadString("create(DatasetGridInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (datasetGridInfo == null) {
            String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetGridInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetGridInfo.getWidth() <= 0) {
            String string = InternalResource.loadString("datasetInfo", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this._$2.isReadOnly()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetGridInfo.getHeight() <= 0) {
            String string = InternalResource.loadString("datasetInfo", "DatasetGrid_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Datasets.isCreatableEnCodeType(DatasetType.GRID, datasetGridInfo.getEncodeType())) {
            String string = InternalResource.loadString("encodeType", "Datasets_FailToCreateBecauseOfEncodeType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGrid datasetGrid = null;
        if (datasetGridInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetGridInfo.getName())) {
            String string = InternalResource.loadString("datasetInfo.name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetsNative.jni_CreateDatasetRaster(this._$2.getHandle(), datasetGridInfo.getHandle(), false);
        if (l != 0L) {
            datasetGrid = new DatasetGrid(l, this._$2);
            this.add(datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(datasetGridInfo);
        return datasetGrid;
    }

    public DatasetImage create(DatasetImageInfo datasetImageInfo) {
        if (!this._$1()) {
            String string = InternalResource.loadString("create(DatasetImageInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2.isReadOnly()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetImageInfo == null) {
            String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetImageInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetImageInfo.getWidth() <= 0) {
            String string = InternalResource.loadString("datasetInfo", "DatasetImage_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetImageInfo.getHeight() <= 0) {
            String string = InternalResource.loadString("datasetInfo", "DatasetImage_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetImage datasetImage = null;
        if (datasetImageInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetImageInfo.getName())) {
            String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetsNative.jni_CreateDatasetRaster(this._$2.getHandle(), datasetImageInfo.getHandle(), true);
        if (l != 0L) {
            datasetImage = new DatasetImage(l, this._$2);
            this.add(datasetImage);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(datasetImageInfo);
        return datasetImage;
    }

    public DatasetTopology create(DatasetTopologyInfo datasetTopologyInfo) {
        if (!this._$1()) {
            String string = InternalResource.loadString("create(DatasetTopologyInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2.isReadOnly()) {
            String string = InternalResource.loadString("create(DatasetTopologyInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetTopologyInfo == null) {
            String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetTopology datasetTopology = null;
        if (!this.isAvailableDatasetName(datasetTopologyInfo.getName())) {
            String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetsNative.jni_CreateDatasetTopology(this._$2.getHandle(), datasetTopologyInfo.getName());
        if (l != 0L) {
            datasetTopology = new DatasetTopology(l, this._$2);
            this.add(datasetTopology);
        }
        return datasetTopology;
    }

    public DatasetGridCollection createGridCollection(String string, PixelFormat pixelFormat) {
        if (!this._$1()) {
            String string2 = InternalResource.loadString("createGridCollection(String name,PixelFormat pixFormat)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$2.isReadOnly()) {
            String string3 = InternalResource.loadString("createGridCollection(String name,PixelFormat pixFormat)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        DatasetGridCollection datasetGridCollection = null;
        if (string.equals("") || !this.isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        DatasetGridCollectionInfo datasetGridCollectionInfo = new DatasetGridCollectionInfo();
        datasetGridCollectionInfo.setName(string);
        datasetGridCollectionInfo.setPixelFormat(pixelFormat);
        long l = DatasetsNative.jni_CreateCollection(this._$2.getHandle(), datasetGridCollectionInfo.getHandle());
        if (l != 0L) {
            datasetGridCollection = new DatasetGridCollection(l, this._$2);
            this.add(datasetGridCollection);
        }
        datasetGridCollectionInfo.dispose();
        return datasetGridCollection;
    }

    public DatasetGridCollection createGridCollection(DatasetGridCollectionInfo datasetGridCollectionInfo) {
        if (!this._$1()) {
            String string = InternalResource.loadString("createGridCollection(String name,PixelFormat pixFormat)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2.isReadOnly()) {
            String string = InternalResource.loadString("createGridCollection(String name,PixelFormat pixFormat)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasetGridCollection datasetGridCollection = null;
        long l = DatasetsNative.jni_CreateCollection(this._$2.getHandle(), datasetGridCollectionInfo.getHandle());
        if (l != 0L) {
            datasetGridCollection = new DatasetGridCollection(l, this._$2);
            this.add(datasetGridCollection);
        }
        return datasetGridCollection;
    }

    public DatasetImageCollection createImageCollection(String string) {
        if (!this._$1()) {
            String string2 = InternalResource.loadString("createImageCollection(String name,PixelFormat pixFormat)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$2.isReadOnly()) {
            String string3 = InternalResource.loadString("createImageCollection(String name,PixelFormat pixFormat)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        DatasetImageCollection datasetImageCollection = null;
        if (string.equals("") || !this.isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        DatasetImageCollectionInfo datasetImageCollectionInfo = new DatasetImageCollectionInfo();
        datasetImageCollectionInfo.setName(string);
        long l = DatasetsNative.jni_CreateCollection(this._$2.getHandle(), datasetImageCollectionInfo.getHandle());
        if (l != 0L) {
            datasetImageCollection = new DatasetImageCollection(l, this._$2);
            this.add(datasetImageCollection);
        }
        datasetImageCollectionInfo.dispose();
        return datasetImageCollection;
    }

    public DatasetImageCollection createImageCollection(DatasetImageCollectionInfo datasetImageCollectionInfo) {
        if (!this._$1()) {
            String string = InternalResource.loadString("createImageCollection(String name,PixelFormat pixFormat)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2.isReadOnly()) {
            String string = InternalResource.loadString("createImageCollection(String name,PixelFormat pixFormat)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasetImageCollection datasetImageCollection = null;
        long l = DatasetsNative.jni_CreateCollection(this._$2.getHandle(), datasetImageCollectionInfo.getHandle());
        if (l != 0L) {
            datasetImageCollection = new DatasetImageCollection(l, this._$2);
            this.add(datasetImageCollection);
        }
        return datasetImageCollection;
    }

    public Dataset createFromTemplate(String string, Dataset dataset) {
        if (!this._$1()) {
            String string2 = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$2.isReadOnly()) {
            String string3 = InternalResource.loadString("createFromTemplate(String name, Dataset templateDataset)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!this.isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (dataset.getHandle() == 0L) {
            String string6 = InternalResource.loadString("templateDataset", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string6);
        }
        Dataset dataset2 = null;
        long l = DatasetsNative.jni_CreateDatasetFromTemplate(this._$2.getHandle(), string, dataset.getHandle());
        if (l != 0L) {
            dataset2 = Dataset.createInstance(l, dataset.getType(), this._$2);
            this.add(dataset2);
        }
        return dataset2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String string) {
        if (!this._$1()) {
            String string2 = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$2.isReadOnly()) {
            String string3 = InternalResource.loadString("delete(String name)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        Integer n = _$1;
        synchronized (n) {
            int n2 = this.indexOf(string);
            if (-1 == n2) {
                return true;
            }
            Dataset dataset = this.get(n2);
            DatasetDeletingEvent datasetDeletingEvent = new DatasetDeletingEvent(this, string);
            this.fireDeleting(datasetDeletingEvent);
            if (datasetDeletingEvent.getCancel()) {
                return false;
            }
            boolean bl = false;
            bl = DatasetsNative.jni_DeleteDataset2(this._$2.getHandle(), string);
            if (bl) {
                dataset.clearHandle();
                this._$3.remove(n2);
                DatasetDeletedEvent datasetDeletedEvent = new DatasetDeletedEvent(this, string);
                this.fireDeleted(datasetDeletedEvent);
            }
            return bl;
        }
    }

    public boolean delete(int n) {
        if (!this._$1()) {
            String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2.isReadOnly()) {
            String string = InternalResource.loadString("delete(int index)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Dataset dataset = this.get(n);
        String string = dataset.getName();
        DatasetDeletingEvent datasetDeletingEvent = new DatasetDeletingEvent(this, string);
        this.fireDeleting(datasetDeletingEvent);
        if (datasetDeletingEvent.getCancel()) {
            return false;
        }
        boolean bl = DatasetsNative.jni_DeleteDataset(this._$2.getHandle(), n);
        if (bl) {
            dataset.clearHandle();
            this._$3.remove(n);
            DatasetDeletedEvent datasetDeletedEvent = new DatasetDeletedEvent(this, string);
            this.fireDeleted(datasetDeletedEvent);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        if (!this._$1()) {
            String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2.isReadOnly()) {
            String string = InternalResource.loadString("deleteAll()", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        Integer n = _$1;
        synchronized (n) {
            DatasetDeletingAllEvent datasetDeletingAllEvent = new DatasetDeletingAllEvent(this);
            this.fireDeletingAll(datasetDeletingAllEvent);
            if (datasetDeletingAllEvent.getCancel()) {
                return;
            }
            DatasetsNative.jni_DeleteAll(this._$2.getHandle());
            int n2 = this.getCount();
            Dataset dataset = null;
            for (int i = 0; i < n2; ++i) {
                dataset = this.get(i);
                dataset.clearHandle();
            }
            this._$3.clear();
            DatasetDeletedAllEvent datasetDeletedAllEvent = new DatasetDeletedAllEvent(this, n2);
            this.fireDeletedAll(datasetDeletedAllEvent);
        }
    }

    public boolean isAvailableDatasetName(String string) {
        if (!this._$1()) {
            String string2 = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = DatasetsNative.jni_IsAvailableDatasetName(this._$2.getHandle(), string);
        }
        return bl;
    }

    public String getAvailableDatasetName(String string) {
        if (!this._$1()) {
            String string2 = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        return DatasetsNative.jni_GetUnoccupiedDatasetName(this._$2.getHandle(), string);
    }

    public boolean rename(String string, String string2) {
        if (!this._$1()) {
            String string3 = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this._$2.isReadOnly()) {
            String string4 = InternalResource.loadString("rename(String oldName, String newName)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("oldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string6 = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (string.equalsIgnoreCase(string2)) {
            return false;
        }
        Dataset dataset = this.get(string);
        if (dataset == null) {
            String string7 = InternalResource.loadString("oldName", "Global_SpecifiedNameNotExist", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (this.indexOf(string2) != -1) {
            String string8 = InternalResource.loadString("newName", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        DatasetRenamingEvent datasetRenamingEvent = new DatasetRenamingEvent(this, string, string2);
        this.fireRenaming(datasetRenamingEvent);
        boolean bl = false;
        if (datasetRenamingEvent.getCancel()) {
            return false;
        }
        bl = dataset.rename(string2);
        if (bl) {
            DatasetRenamedEvent datasetRenamedEvent = new DatasetRenamedEvent(this, string, string2);
            this.fireRenamed(datasetRenamedEvent);
        }
        return bl;
    }

    public boolean contains(String string) {
        if (!this._$1()) {
            String string2 = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (this.indexOf(string) != -1) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(String string) {
        int n = -1;
        Integer n2 = _$1;
        synchronized (n2) {
            if (string != null && string.trim().length() != 0) {
                int n3 = this.getCount();
                for (int i = 0; i < n3; ++i) {
                    if (!string.equalsIgnoreCase(this.get(i).getName())) continue;
                    return i;
                }
            }
            return n;
        }
    }

    static boolean isCreatableVectorType(DatasetType datasetType) {
        boolean bl = true;
        if (datasetType.equals(DatasetType.LINKTABLE) || datasetType.equals(DatasetType.NETWORK) || datasetType.equals(DatasetType.GRID) || datasetType.equals(DatasetType.IMAGE) || datasetType.equals(DatasetType.WCS) || datasetType.equals(DatasetType.WMS) || datasetType.equals(DatasetType.TOPOLOGY)) {
            bl = false;
        }
        return bl;
    }

    static boolean isCreatableEnCodeType(DatasetType datasetType, EncodeType encodeType) {
        boolean bl = true;
        if (datasetType.equals(DatasetType.TABULAR) || datasetType.equals(DatasetType.POINT) || datasetType.equals(DatasetType.PARAMETRICLINE) || datasetType.equals(DatasetType.PARAMETRICREGION)) {
            bl = bl && encodeType.equals(EncodeType.NONE);
        } else if (Datasets.isCreatableVectorType(datasetType)) {
            bl = bl && !encodeType.equals(EncodeType.DCT);
            bl = bl && !encodeType.equals(EncodeType.SGL);
            bl = bl && !encodeType.equals(EncodeType.LZW);
        } else if (datasetType.equals(DatasetType.GRID) || datasetType.equals(DatasetType.WCS) || datasetType.equals(DatasetType.WMS)) {
            bl = encodeType.equals(EncodeType.NONE) || encodeType.equals(EncodeType.DCT) || encodeType.equals(EncodeType.SGL) || encodeType.equals(EncodeType.LZW);
        } else if (datasetType.equals(DatasetType.IMAGE)) {
            bl = encodeType.equals(EncodeType.NONE) || encodeType.equals(EncodeType.DCT) || encodeType.equals(EncodeType.SGL) || encodeType.equals(EncodeType.LZW) || encodeType.equals(EncodeType.COMPOUND);
        }
        return bl;
    }

    void clearHandle() {
        if (this._$3 != null) {
            int n = this._$3.size();
            for (int i = 0; i < n; ++i) {
                if (this._$3.get(i) == null) continue;
                this._$3.get(i).clearHandle();
            }
            this._$3.clear();
            this._$3 = null;
        }
        this._$2 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Dataset dataset) {
        Integer n = _$1;
        synchronized (n) {
            String string = dataset.getName();
            if (this.contains(string)) {
                String string2 = InternalResource.loadString("dataset", "Datasets_DatasetIsAlreadyExist", "data_resources");
                throw new IllegalArgumentException(string2);
            }
            this._$3.add(dataset);
            DatasetCreatedEvent datasetCreatedEvent = new DatasetCreatedEvent(this, dataset.getName());
            this.fireCreated(datasetCreatedEvent);
        }
    }

    protected static void add(Datasets datasets, Dataset dataset) {
        if (datasets != null) {
            datasets.add(dataset);
        }
    }

    void reset() {
        this._$3.clear();
        int n = DatasourceNative.jni_GetDatasetsCount(this._$2.getHandle());
        long[] lArray = new long[n];
        int[] nArray = new int[n];
        DatasourceNative.jni_GetDatasets(this._$2.getHandle(), lArray, nArray);
        for (int i = 0; i < n; ++i) {
            DatasetType datasetType;
            try {
                datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[i]);
            }
            catch (RuntimeException runtimeException) {
                if (nArray[i] == 88) {
                    datasetType = DatasetType.IMAGE;
                }
                if (nArray[i] == 89) {
                    datasetType = DatasetType.GRID;
                }
                if (nArray[i] == 90) {
                    datasetType = DatasetType.DEM;
                }
                if (nArray[i] != DatasetType.DEM.getUGCValue()) continue;
                datasetType = DatasetType.DEM;
            }
            try {
                Dataset dataset = Dataset.createInstance(lArray[i], datasetType, this._$2);
                if (dataset == null) continue;
                this._$3.add(dataset);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private boolean _$2(String string) {
        String string2 = "sm_seq_" + string + "_node";
        return string2.length() > 30;
    }

    private String _$1(String string) {
        if (string.trim().length() == 0) {
            return string;
        }
        String string2 = string.charAt(0) >= '0' && string.charAt(0) <= '9' || string.startsWith("_") ? "Dataset_" + string : string;
        return string2;
    }

    private boolean _$1() {
        boolean bl = true;
        if (this._$2 == null || this._$2.getHandle() == 0L) {
            bl = false;
        }
        return bl;
    }

    void refresh() {
        int n = this._$3.size();
        int n2 = DatasourceNative.jni_GetDatasetsCount(this._$2.getHandle());
        long[] lArray = new long[n2];
        int[] nArray = new int[n2];
        DatasourceNative.jni_GetDatasets(this._$2.getHandle(), lArray, nArray);
        for (int i = 0; i < n2; ++i) {
            DatasetType datasetType;
            if (this._$3.size() > i) {
                if (this._$3.get(i).getHandle() == lArray[i]) continue;
                this._$3.get(i).clearHandle();
                this._$3.remove(i);
            }
            try {
                datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[i]);
            }
            catch (RuntimeException runtimeException) {
                if (nArray[i] == 88) {
                    datasetType = DatasetType.IMAGE;
                }
                if (nArray[i] == 89) {
                    datasetType = DatasetType.GRID;
                }
                if (nArray[i] == 90) {
                    datasetType = DatasetType.DEM;
                }
                if (nArray[i] != DatasetType.DEM.getUGCValue()) continue;
                datasetType = DatasetType.DEM;
            }
            try {
                Dataset dataset = Dataset.createInstance(lArray[i], datasetType, this._$2);
                if (dataset == null) continue;
                this._$3.add(dataset);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    ArrayList getList() {
        return this._$3;
    }

    public synchronized void addRenamingListener(DatasetRenamingListener datasetRenamingListener) {
        if (this.m_datasetRenamingListeners == null) {
            this.m_datasetRenamingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_datasetRenamingListeners.contains(datasetRenamingListener)) {
            this.m_datasetRenamingListeners.add(datasetRenamingListener);
        }
    }

    public void removeRenamingListener(DatasetRenamingListener datasetRenamingListener) {
        if (this.m_datasetRenamingListeners != null && this.m_datasetRenamingListeners.contains(datasetRenamingListener)) {
            this.m_datasetRenamingListeners.remove(datasetRenamingListener);
        }
    }

    protected void fireRenaming(DatasetRenamingEvent datasetRenamingEvent) {
        if (this.m_datasetRenamingListeners != null) {
            CopyOnWriteArrayList<DatasetRenamingListener> copyOnWriteArrayList = this.m_datasetRenamingListeners;
            int n = copyOnWriteArrayList.size();
            for (int i = 0; i < n; ++i) {
                copyOnWriteArrayList.get(i).datasetRenaming(datasetRenamingEvent);
            }
        }
    }

    public synchronized void addRenamedListener(DatasetRenamedListener datasetRenamedListener) {
        if (this.m_datasetRenamedListeners == null) {
            this.m_datasetRenamedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_datasetRenamedListeners.contains(datasetRenamedListener)) {
            this.m_datasetRenamedListeners.add(datasetRenamedListener);
        }
    }

    public void removeRenamedListener(DatasetRenamedListener datasetRenamedListener) {
        if (this.m_datasetRenamedListeners != null && this.m_datasetRenamedListeners.contains(datasetRenamedListener)) {
            this.m_datasetRenamedListeners.remove(datasetRenamedListener);
        }
    }

    protected void fireRenamed(DatasetRenamedEvent datasetRenamedEvent) {
        if (this.m_datasetRenamedListeners != null) {
            CopyOnWriteArrayList<DatasetRenamedListener> copyOnWriteArrayList = this.m_datasetRenamedListeners;
            for (DatasetRenamedListener datasetRenamedListener : copyOnWriteArrayList) {
                datasetRenamedListener.datasetRenamed(datasetRenamedEvent);
            }
        }
    }

    public synchronized void addDeletingListener(DatasetDeletingListener datasetDeletingListener) {
        if (this.m_datasetDeletingListeners == null) {
            this.m_datasetDeletingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_datasetDeletingListeners.contains(datasetDeletingListener)) {
            this.m_datasetDeletingListeners.add(datasetDeletingListener);
        }
    }

    public void removeDeletingListener(DatasetDeletingListener datasetDeletingListener) {
        if (this.m_datasetDeletingListeners != null && this.m_datasetDeletingListeners.contains(datasetDeletingListener)) {
            this.m_datasetDeletingListeners.remove(datasetDeletingListener);
        }
    }

    protected void fireDeleting(DatasetDeletingEvent datasetDeletingEvent) {
        if (this.m_datasetDeletingListeners != null) {
            CopyOnWriteArrayList<DatasetDeletingListener> copyOnWriteArrayList = this.m_datasetDeletingListeners;
            for (DatasetDeletingListener datasetDeletingListener : copyOnWriteArrayList) {
                datasetDeletingListener.datasetDeleting(datasetDeletingEvent);
            }
        }
    }

    public synchronized void addDeletedListener(DatasetDeletedListener datasetDeletedListener) {
        if (this.m_datasetDeletedListeners == null) {
            this.m_datasetDeletedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_datasetDeletedListeners.contains(datasetDeletedListener)) {
            this.m_datasetDeletedListeners.add(datasetDeletedListener);
        }
    }

    public void removeDeletedListener(DatasetDeletedListener datasetDeletedListener) {
        if (this.m_datasetDeletedListeners != null && this.m_datasetDeletedListeners.contains(datasetDeletedListener)) {
            this.m_datasetDeletedListeners.remove(datasetDeletedListener);
        }
    }

    protected void fireDeleted(DatasetDeletedEvent datasetDeletedEvent) {
        if (this.m_datasetDeletedListeners != null) {
            CopyOnWriteArrayList<DatasetDeletedListener> copyOnWriteArrayList = this.m_datasetDeletedListeners;
            for (DatasetDeletedListener datasetDeletedListener : copyOnWriteArrayList) {
                datasetDeletedListener.DatasetDeleted(datasetDeletedEvent);
            }
        }
    }

    public synchronized void addDeletingAllListener(DatasetDeletingAllListener datasetDeletingAllListener) {
        if (this.m_datasetDeletingAllListeners == null) {
            this.m_datasetDeletingAllListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_datasetDeletingAllListeners.contains(datasetDeletingAllListener)) {
            this.m_datasetDeletingAllListeners.add(datasetDeletingAllListener);
        }
    }

    public void removeDeletingAllListener(DatasetDeletingAllListener datasetDeletingAllListener) {
        if (this.m_datasetDeletingAllListeners != null && this.m_datasetDeletingAllListeners.contains(datasetDeletingAllListener)) {
            this.m_datasetDeletingAllListeners.remove(datasetDeletingAllListener);
        }
    }

    protected void fireDeletingAll(DatasetDeletingAllEvent datasetDeletingAllEvent) {
        if (this.m_datasetDeletingAllListeners != null) {
            CopyOnWriteArrayList<DatasetDeletingAllListener> copyOnWriteArrayList = this.m_datasetDeletingAllListeners;
            for (DatasetDeletingAllListener datasetDeletingAllListener : copyOnWriteArrayList) {
                datasetDeletingAllListener.datasetDeletingAll(datasetDeletingAllEvent);
            }
        }
    }

    public synchronized void addDeletedAllListener(DatasetDeletedAllListener datasetDeletedAllListener) {
        if (this.m_datasetDeletedAllListeners == null) {
            this.m_datasetDeletedAllListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_datasetDeletedAllListeners.contains(datasetDeletedAllListener)) {
            this.m_datasetDeletedAllListeners.add(datasetDeletedAllListener);
        }
    }

    public void removeDeletedAllListener(DatasetDeletedAllListener datasetDeletedAllListener) {
        if (this.m_datasetDeletedAllListeners != null && this.m_datasetDeletedAllListeners.contains(datasetDeletedAllListener)) {
            this.m_datasetDeletedAllListeners.remove(datasetDeletedAllListener);
        }
    }

    protected void fireDeletedAll(DatasetDeletedAllEvent datasetDeletedAllEvent) {
        if (this.m_datasetDeletedAllListeners != null) {
            CopyOnWriteArrayList<DatasetDeletedAllListener> copyOnWriteArrayList = this.m_datasetDeletedAllListeners;
            for (DatasetDeletedAllListener datasetDeletedAllListener : copyOnWriteArrayList) {
                datasetDeletedAllListener.datasetDeletedAll(datasetDeletedAllEvent);
            }
        }
    }

    public synchronized void addCreatedListener(DatasetCreatedListener datasetCreatedListener) {
        if (this.m_datasetCreatedListeners == null) {
            this.m_datasetCreatedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_datasetCreatedListeners.contains(datasetCreatedListener)) {
            this.m_datasetCreatedListeners.add(datasetCreatedListener);
        }
    }

    public void removeCreatedListener(DatasetCreatedListener datasetCreatedListener) {
        if (this.m_datasetCreatedListeners != null && this.m_datasetCreatedListeners.contains(datasetCreatedListener)) {
            this.m_datasetCreatedListeners.remove(datasetCreatedListener);
        }
    }

    protected void fireCreated(DatasetCreatedEvent datasetCreatedEvent) {
        if (this.m_datasetCreatedListeners != null) {
            CopyOnWriteArrayList<DatasetCreatedListener> copyOnWriteArrayList = this.m_datasetCreatedListeners;
            for (DatasetCreatedListener datasetCreatedListener : copyOnWriteArrayList) {
                datasetCreatedListener.datasetCreated(datasetCreatedEvent);
            }
        }
    }

    void addRange(String[] stringArray) {
        long[] lArray = new long[stringArray.length];
        int[] nArray = new int[stringArray.length];
        DatasourceNative.jni_GetAddDatasets(this._$2.getHandle(), lArray, nArray, stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            DatasetType datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, nArray[i]);
            try {
                Dataset dataset = Dataset.createInstance(lArray[i], datasetType, this._$2);
                if (dataset == null) continue;
                this._$3.add(dataset);
                DatasetCreatedEvent datasetCreatedEvent = new DatasetCreatedEvent(this, stringArray[i]);
                this.fireCreated(datasetCreatedEvent);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    Dataset getDatasetByTableName(String string) {
        Dataset dataset = null;
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            if (!this._$3.get(i).getTableName().equals(string)) continue;
            dataset = this._$3.get(i);
            break;
        }
        return dataset;
    }
}

