/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfoNative;
import com.supermap.data.Datasets;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;

public class DatasetVectorInfo
extends InternalHandleDisposable {
    public DatasetVectorInfo() {
        this.setHandle(DatasetVectorInfoNative.jni_New(), true);
        this.reset();
    }

    public DatasetVectorInfo(String string, DatasetType datasetType) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        InternalInvalidState internalInvalidState = Dataset.isValidDatasetName(string);
        if (internalInvalidState != null) {
            String string3 = "";
            if (internalInvalidState.equals(InternalInvalidState.ISEMPTY)) {
                string3 = "Dataset_NameIsEmpty";
            } else if (internalInvalidState.equals(InternalInvalidState.AGAINSYSTEMNAME)) {
                string3 = "Dataset_NameAgainstSys";
            } else if (internalInvalidState.equals(InternalInvalidState.BEYONDLIMIT)) {
                string3 = "Dataset_NameBeyondLimit";
            } else if (internalInvalidState.equals(InternalInvalidState.INVALIDCHAR)) {
                string3 = "Dataset_NameIncludeInvalidChar";
            } else if (internalInvalidState.equals(InternalInvalidState.PREFIXERROR)) {
                string3 = "Dataset_NameErrorPrefix";
            }
            String string4 = InternalResource.loadString("value", string3, "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (datasetType == null) {
            String string5 = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string5);
        }
        this.setHandle(DatasetVectorInfoNative.jni_New(), true);
        this.reset();
        this.setName(string);
        this.setType(datasetType);
    }

    public DatasetVectorInfo(DatasetVectorInfo datasetVectorInfo) {
        if (datasetVectorInfo == null) {
            String string = InternalResource.loadString("datasetVectorInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetVectorInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetVectorInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetVectorInfoNative.jni_Clone(datasetVectorInfo.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(datasetVectorInfo);
    }

    public DatasetVectorInfo(String string, DatasetVector datasetVector) {
        if (datasetVector == null) {
            String string2 = InternalResource.loadString("templateDataset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string2);
        }
        long l = datasetVector.getHandle();
        if (l == 0L) {
            String string3 = InternalResource.loadString("templateDataset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        long l2 = DatasetVectorInfoNative.jni_New2(l);
        this.setHandle(l2, true);
        this.setName(string);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorInfoNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        InternalInvalidState internalInvalidState = Dataset.isValidDatasetName(string);
        if (internalInvalidState != null) {
            String string4 = "";
            if (internalInvalidState.equals(InternalInvalidState.ISEMPTY)) {
                string4 = "Dataset_NameIsEmpty";
            } else if (internalInvalidState.equals(InternalInvalidState.AGAINSYSTEMNAME)) {
                string4 = "Dataset_NameAgainstSys";
            } else if (internalInvalidState.equals(InternalInvalidState.BEYONDLIMIT)) {
                string4 = "Dataset_NameBeyondLimit";
            } else if (internalInvalidState.equals(InternalInvalidState.INVALIDCHAR)) {
                string4 = "Dataset_NameIncludeInvalidChar";
            } else if (internalInvalidState.equals(InternalInvalidState.PREFIXERROR)) {
                string4 = "Dataset_NameErrorPrefix";
            }
            String string5 = InternalResource.loadString("value", string4, "data_resources");
            throw new IllegalArgumentException(string5);
        }
        DatasetVectorInfoNative.jni_SetName(this.getHandle(), string);
    }

    public DatasetType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVectorInfoNative.jni_GetType(this.getHandle());
        return (DatasetType)Enum.parseUGCValue(DatasetType.class, n);
    }

    public void setType(DatasetType datasetType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (datasetType == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!Datasets.isCreatableVectorType(datasetType)) {
            String string = InternalResource.loadString("value", "DatasetVectorInfo_IllegalDatasetType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVectorInfoNative.jni_SetType(this.getHandle(), datasetType.getUGCValue());
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVectorInfoNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n);
    }

    public void setEncodeType(EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (encodeType == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetVectorInfoNative.jni_SetEncodeType(this.getHandle(), encodeType.getUGCValue());
    }

    public boolean isFileCache() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorInfoNative.jni_GetIsFileCache(this.getHandle());
    }

    public void setFileCache(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetVectorInfoNative.jni_SetIsFileCache(this.getHandle(), bl);
    }

    public void setBlobTablespaceName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        DatasetVectorInfoNative.jni_SetBlobTablespaceName(this.getHandle(), string);
    }

    public String getBlobTablespaceName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorInfoNative.jni_GetBlobTablespaceName(this.getHandle());
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "{Name=\"" + this.getName() + "\",Type=" + this.getType().name() + ",EncodeType=" + this.getEncodeType().name() + ",IsFileCache=" + this.isFileCache() + "}";
        return string;
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            DatasetVectorInfoNative.jni_Delete(super.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    void reset() {
        if (this.getHandle() != 0L) {
            DatasetVectorInfoNative.jni_Reset(this.getHandle());
        }
    }
}

