/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.RasterJoinPixelFormat;
import com.supermap.analyst.spatialanalyst.RasterJoinType;
import com.supermap.analyst.spatialanalyst.RasterMosaicNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.License;
import com.supermap.data.ProductType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class RasterMosaic {
    private static License _$2;
    private static transient Vector _$1;

    private RasterMosaic() {
    }

    public static Dataset mosaic(Dataset[] datasetArray, double d, double d2, RasterJoinType rasterJoinType, RasterJoinPixelFormat rasterJoinPixelFormat, double d3, EncodeType encodeType, Rectangle2D rectangle2D, Datasource datasource, String string) {
        int n;
        RasterMosaic._$1();
        long[] lArray = new long[datasetArray.length];
        for (n = 0; n < datasetArray.length; ++n) {
            if (datasetArray[n] == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetArray[n]) == 0L) {
                String string2 = InternalResource.loadString("sourceDatasets", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetArray[n]);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        n = InternalEnum.getUGCValue(rasterJoinType);
        int n2 = InternalEnum.getUGCValue(rasterJoinPixelFormat);
        int n3 = InternalEnum.getUGCValue((Enum)encodeType);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getRight(), rectangle2D.getTop(), rectangle2D.getBottom()};
        long l2 = RasterMosaicNative.jni_Mosaic(lArray, d, d2, n, n2, d3, n3, dArray, l, string);
        if (l2 != 0L) {
            if (datasetArray[0].getType() == DatasetType.IMAGE) {
                DatasetImage datasetImage = InternalDatasetImage.createInstance(l2, datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage);
                return datasetImage;
            }
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l2, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            return datasetGrid;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$2;
        synchronized (object) {
            n = _$2.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$1 == null) {
            _$1 = new Vector();
        }
        if (!_$1.contains(steppedListener)) {
            _$1.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$1 != null && _$1.contains(steppedListener)) {
            _$1.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$1 != null) {
            Vector vector = _$1;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "RasterMosaic";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        RasterMosaic.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$2 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

