/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.InternalHandle;
import com.supermap.data.License;
import com.supermap.data.Workspace;
import com.supermap.realspace.InternalDataset;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalToolkitSpace;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DAddedEvent;
import com.supermap.realspace.Layer3DAddedListener;
import com.supermap.realspace.Layer3DAlwaysRenderChangedEvent;
import com.supermap.realspace.Layer3DAlwaysRenderChangedListener;
import com.supermap.realspace.Layer3DCaptionChangedEvent;
import com.supermap.realspace.Layer3DCaptionChangedListener;
import com.supermap.realspace.Layer3DDataset;
import com.supermap.realspace.Layer3DEditableChangedEvent;
import com.supermap.realspace.Layer3DEditableChangedListener;
import com.supermap.realspace.Layer3DMap;
import com.supermap.realspace.Layer3DNative;
import com.supermap.realspace.Layer3DRemovedEvent;
import com.supermap.realspace.Layer3DRemovedListener;
import com.supermap.realspace.Layer3DSelectableChangedEvent;
import com.supermap.realspace.Layer3DSelectableChangedListener;
import com.supermap.realspace.Layer3DSetting;
import com.supermap.realspace.Layer3DSettingType;
import com.supermap.realspace.Layer3DType;
import com.supermap.realspace.Layer3DVisibleChangedEvent;
import com.supermap.realspace.Layer3DVisibleChangedListener;
import com.supermap.realspace.Layer3DsNative;
import com.supermap.realspace.Scene;
import com.supermap.realspace.Theme3D;
import com.supermap.realspace.Theme3DGraph;
import com.supermap.realspace.Theme3DType;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class Layer3Ds
extends InternalHandle {
    private Scene _$2;
    private ArrayList<Layer3D> _$1;
    transient Vector m_layerAddedListeners;
    transient Vector m_layerRemovedListeners;
    transient Vector<Layer3DCaptionChangedListener> m_layer3DCaptionChangedListeners;
    transient Vector<Layer3DSelectableChangedListener> m_layer3DSelectableChangedListeners;
    transient Vector<Layer3DEditableChangedListener> m_layer3DEditableChangedListeners;
    transient Vector<Layer3DVisibleChangedListener> m_layer3DVisibleChangedListeners;
    transient Vector<Layer3DAlwaysRenderChangedListener> m_layer3DAlwaysRenderChangedListeners;

    Layer3Ds(long l, Scene scene) {
        this.setHandle(l);
        this._$1 = new ArrayList();
        this._$2 = scene;
        Workspace workspace = this._$2.getWorkspace();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            String string;
            long l2 = Layer3DsNative.jni_GetItemByIndex(this.getHandle(), i);
            if (l2 == 0L) continue;
            Layer3D layer3D = null;
            int n2 = Layer3DNative.jni_GetType(l2);
            Layer3DType layer3DType = (Layer3DType)InternalEnum.parse(Layer3DType.class, (int)n2);
            if (layer3DType.equals((Object)Layer3DType.DATASET) || layer3DType.equals((Object)Layer3DType.DATASETIMAGE) || layer3DType.equals((Object)Layer3DType.DATASETVECTOR)) {
                string = Layer3DNative.jni_GetDatasourceAlias(l2);
                long l3 = Layer3DNative.jni_GetDataset(l2);
                Dataset dataset = InternalToolkitSpace.toMangedDataset(workspace, l3);
                layer3D = new Layer3DDataset(l2, dataset, this);
            } else if (layer3DType.equals((Object)Layer3DType.MAP)) {
                string = Layer3DNative.jni_GetName(l2);
                layer3D = new Layer3DMap(l2, this);
            } else {
                layer3D = Layer3D.createInstance(l2, this, layer3DType);
            }
            this._$1.add(layer3D);
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DsNative.jni_GetCount(this.getHandle());
    }

    public Layer3D get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this._$1.get(n);
    }

    public Layer3D get(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("get(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        Layer3D layer3D = null;
        for (int i = 0; i < this._$1.size() && !(layer3D = this._$1.get(i)).getName().equals(string); ++i) {
        }
        return layer3D;
    }

    public Layer3DDataset add(Dataset dataset, Layer3DSetting layer3DSetting, boolean bl) {
        long l;
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Dataset  dataset, Layer3DSetting layer3DSetting,boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)dataset);
        if (l2 == 0L) {
            String string = InternalResource.loadString("dataset", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (layer3DSetting != null && (InternalDataset.getIsVector(dataset) && !layer3DSetting.getType().equals((Object)Layer3DSettingType.VECTOR) || dataset.getType().equals((Object)DatasetType.IMAGE) && !layer3DSetting.getType().equals((Object)Layer3DSettingType.IMAGE) || dataset.getType().equals((Object)DatasetType.GRID) && !layer3DSetting.getType().equals((Object)Layer3DSettingType.GRID))) {
            String string = InternalResource.loadString("dataset", "Layer3Ds_AddDatasetTypeAndLayer3DTypeIsNotMatching", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Workspace workspace = dataset.getDatasource().getWorkspace();
        Workspace workspace2 = this._$2.getWorkspace();
        long l3 = InternalHandle.getHandle((InternalHandle)workspace);
        if (l3 != (l = InternalHandle.getHandle((InternalHandle)workspace2))) {
            String string = InternalResource.loadString("dataset", "Layer3Ds_TheWorkspaceOfDatasetShouldBeTheSameAsScene", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Layer3DsNative.jni_SetDatasource(this.getHandle(), InternalHandle.getHandle((InternalHandle)workspace));
        String string = "";
        string = dataset.getName() + "@" + dataset.getDatasource().getAlias();
        Layer3DDataset layer3DDataset = null;
        long l4 = 0L;
        boolean bl2 = false;
        if (InternalDataset.getIsVector(dataset) && ((DatasetVector)dataset).getRecordCount() <= 3000) {
            bl2 = true;
        }
        if ((l4 = Layer3DsNative.jni_Add(this.getHandle(), Layer3DType.DATASET.value(), string, bl, bl2, 0L)) != 0L) {
            layer3DDataset = new Layer3DDataset(l4, dataset, this);
            if (bl) {
                this._$1.add(0, layer3DDataset);
            } else {
                this._$1.add(layer3DDataset);
            }
            if (layer3DSetting != null) {
                layer3DDataset.setAdditionalSetting(layer3DSetting);
            }
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3DDataset);
            this.fireLayer3DAdded(layer3DAddedEvent);
        }
        return layer3DDataset;
    }

    public Layer3D add(String string, Layer3DType layer3DType, boolean bl) {
        long l;
        Object object;
        this._$1();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("add(String file,boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if ((layer3DType.equals((Object)Layer3DType.KML) || layer3DType.equals((Object)Layer3DType.IMAGEFILE) || layer3DType.equals((Object)Layer3DType.MODEL)) && !((File)(object = new File(string))).exists()) {
            String string3 = InternalResource.loadString("", "Global_PathIsNotValid", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this.checkDataNameAndType(string, layer3DType, "")) {
            object = InternalResource.loadString("layerType", "Layer3Ds_AddDataNameAndLayer3DTypeIsNotMatching", "realspace_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = string;
        Workspace workspace = this._$2.getWorkspace();
        long l2 = 0L;
        if (workspace != null) {
            l2 = InternalHandle.getHandle((InternalHandle)workspace);
        }
        if ((l = Layer3DsNative.jni_Add(this.getHandle(), layer3DType.value(), (String)object, bl, false, l2)) != 0L) {
            Layer3D layer3D = Layer3D.createInstance(l, this, layer3DType);
            if (bl) {
                this._$1.add(0, layer3D);
            } else {
                this._$1.add(layer3D);
            }
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded(layer3DAddedEvent);
            return layer3D;
        }
        return null;
    }

    public Layer3DDataset add(Dataset dataset, Theme3D theme3D, boolean bl) {
        Object object;
        long l;
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Dataset dataset, Theme3D theme3D, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)dataset);
        if (l2 == 0L) {
            String string = InternalResource.loadString("dataset", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (theme3D != null && InternalHandle.getHandle((InternalHandle)theme3D) == 0L) {
            String string = InternalResource.loadString("theme3D", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Workspace workspace = dataset.getDatasource().getWorkspace();
        Workspace workspace2 = this._$2.getWorkspace();
        long l3 = InternalHandle.getHandle((InternalHandle)workspace);
        if (l3 != (l = InternalHandle.getHandle((InternalHandle)workspace2))) {
            String string = InternalResource.loadString("dataset", "Layer3Ds_TheWorkspaceOfDatasetShouldBeTheSameAsScene", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Layer3DsNative.jni_SetDatasource(this.getHandle(), InternalHandle.getHandle((InternalHandle)workspace));
        String string = "";
        string = dataset.getName() + "@" + dataset.getDatasource().getAlias();
        Layer3DDataset layer3DDataset = null;
        long l4 = 0L;
        boolean bl2 = false;
        if (InternalDataset.getIsVector(dataset) && ((DatasetVector)dataset).getRecordCount() <= 3000) {
            bl2 = true;
        }
        if (theme3D != null) {
            if (theme3D.getType() == Theme3DType.GRAPH3D) {
                object = (Theme3DGraph)theme3D;
                Theme3DGraph theme3DGraph = new Theme3DGraph((Theme3DGraph)((Object)object));
                theme3DGraph.calculateExtremum(dataset);
                object.setBarWidth(theme3DGraph.getBarWidth());
                object.setMaxGraphSize(theme3DGraph.getMaxGraphSize());
                object.setMinGraphSize(theme3DGraph.getMinGraphSize());
                l4 = Layer3DsNative.jni_AddTheme(this.getHandle(), string, InternalHandle.getHandle((InternalHandle)theme3DGraph), bl, bl2);
            } else {
                l4 = Layer3DsNative.jni_AddTheme(this.getHandle(), string, InternalHandle.getHandle((InternalHandle)theme3D), bl, bl2);
            }
        } else {
            l4 = Layer3DsNative.jni_Add(this.getHandle(), Layer3DType.DATASET.value(), string, bl, bl2, 0L);
        }
        if (l4 != 0L) {
            layer3DDataset = new Layer3DDataset(l4, dataset, this);
            theme3D.setLayer(layer3DDataset);
            if (bl) {
                this._$1.add(0, layer3DDataset);
            } else {
                this._$1.add(layer3DDataset);
            }
            object = new Layer3DAddedEvent((Object)this, layer3DDataset);
            this.fireLayer3DAdded((Layer3DAddedEvent)object);
        }
        return layer3DDataset;
    }

    public Layer3DDataset insert(int n, Dataset dataset, Layer3DSetting layer3DSetting) {
        long l;
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, Dataset dataset,Layer3DSetting layer3DSetting)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        Layer3DDataset layer3DDataset = null;
        if (InternalHandle.getHandle((InternalHandle)dataset) == 0L) {
            String string2 = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (layer3DSetting != null && (InternalDataset.getIsVector(dataset) && !layer3DSetting.getType().equals((Object)Layer3DSettingType.VECTOR) || dataset.getType().equals((Object)DatasetType.IMAGE) && !layer3DSetting.getType().equals((Object)Layer3DSettingType.IMAGE) || dataset.getType().equals((Object)DatasetType.GRID) && !layer3DSetting.getType().equals((Object)Layer3DSettingType.GRID))) {
            String string3 = InternalResource.loadString("dataset", "Layer3Ds_AddDatasetTypeAndLayer3DTypeIsNotMatching", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        Workspace workspace = dataset.getDatasource().getWorkspace();
        Layer3DsNative.jni_SetDatasource(this.getHandle(), InternalHandle.getHandle((InternalHandle)workspace));
        string = dataset.getName() + "@" + dataset.getDatasource().getAlias();
        boolean bl = false;
        if (InternalDataset.getIsVector(dataset) && ((DatasetVector)dataset).getRecordCount() <= 3000) {
            bl = true;
        }
        if ((l = Layer3DsNative.jni_Insert(this.getHandle(), Layer3DType.DATASET.value(), string, n, bl)) != 0L) {
            layer3DDataset = new Layer3DDataset(l, dataset, this);
            this._$1.add(n, layer3DDataset);
            if (layer3DSetting != null) {
                layer3DDataset.setAdditionalSetting(layer3DSetting);
            }
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3DDataset);
            this.fireLayer3DAdded(layer3DAddedEvent);
        }
        return layer3DDataset;
    }

    public Layer3D insert(int n, String string, Layer3DType layer3DType) {
        Object object;
        this._$1();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("insert(int index,  String dataName)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (n < 0 || n > this.getCount()) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string3);
        }
        if ((layer3DType.equals((Object)Layer3DType.KML) || layer3DType.equals((Object)Layer3DType.IMAGEFILE) || layer3DType.equals((Object)Layer3DType.MODEL)) && !((File)(object = new File(string))).exists()) {
            String string4 = InternalResource.loadString("", "Global_PathIsNotValid", "realspace_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!this.checkDataNameAndType(string, layer3DType, "")) {
            object = InternalResource.loadString("layerType", "Layer3Ds_AddDataNameAndLayer3DTypeIsNotMatching", "realspace_resources");
            throw new IllegalArgumentException((String)object);
        }
        long l = Layer3DsNative.jni_Insert(this.getHandle(), layer3DType.value(), string, n, false);
        if (l != 0L) {
            Layer3D layer3D = Layer3D.createInstance(l, this, layer3DType);
            this._$1.add(n, layer3D);
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded(layer3DAddedEvent);
            return layer3D;
        }
        return null;
    }

    public Layer3DDataset insert(int n, Dataset dataset, Theme3D theme3D) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, Dataset dataset,Theme3D theme3D)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        Layer3DDataset layer3DDataset = null;
        if (InternalHandle.getHandle((InternalHandle)dataset) == 0L) {
            String string2 = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (theme3D != null && InternalHandle.getHandle((InternalHandle)theme3D) == 0L) {
            String string3 = InternalResource.loadString("theme3D", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        Workspace workspace = dataset.getDatasource().getWorkspace();
        Layer3DsNative.jni_SetDatasource(this.getHandle(), InternalHandle.getHandle((InternalHandle)workspace));
        string = dataset.getName() + "@" + dataset.getDatasource().getAlias();
        boolean bl = false;
        if (InternalDataset.getIsVector(dataset) && ((DatasetVector)dataset).getRecordCount() <= 3000) {
            bl = true;
        }
        long l = 0L;
        l = theme3D != null ? Layer3DsNative.jni_InsertTheme(this.getHandle(), string, InternalHandle.getHandle((InternalHandle)theme3D), n, bl) : Layer3DsNative.jni_Insert(this.getHandle(), Layer3DType.DATASET.value(), string, n, bl);
        if (l != 0L) {
            layer3DDataset = new Layer3DDataset(l, dataset, this);
            this._$1.add(n, layer3DDataset);
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3DDataset);
            this.fireLayer3DAdded(layer3DAddedEvent);
        }
        return layer3DDataset;
    }

    public Layer3DDataset add(Dataset dataset, Layer3DSetting layer3DSetting, boolean bl, String string) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string2);
        }
        if (this.indexOf(string) != -1) {
            String string3 = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        Layer3DDataset layer3DDataset = this.add(dataset, layer3DSetting, bl);
        layer3DDataset.setName(string);
        return layer3DDataset;
    }

    public Layer3D add(String string, Layer3DType layer3DType, boolean bl, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            String string3 = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        if (this.indexOf(string2) != -1) {
            String string4 = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string4);
        }
        Layer3D layer3D = this.add(string, layer3DType, bl);
        layer3D.setName(string2);
        return layer3D;
    }

    public Layer3DDataset add(Dataset dataset, Theme3D theme3D, boolean bl, String string) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string2);
        }
        if (this.indexOf(string) != -1) {
            String string3 = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        Layer3DDataset layer3DDataset = this.add(dataset, theme3D, bl);
        layer3DDataset.setName(string);
        return layer3DDataset;
    }

    public Layer3D add(String string, Layer3DType layer3DType, boolean bl, String string2, String string3) {
        long l;
        Object object;
        if (string2 == null || string2.trim().length() == 0) {
            String string4 = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string4);
        }
        if (this.indexOf(string2) != -1) {
            String string5 = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this.getHandle() == 0L) {
            String string6 = InternalResource.loadString("add(String file,boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string6);
        }
        if ((layer3DType.equals((Object)Layer3DType.KML) || layer3DType.equals((Object)Layer3DType.IMAGEFILE) || layer3DType.equals((Object)Layer3DType.MODEL)) && !((File)(object = new File(string))).exists()) {
            String string7 = InternalResource.loadString("", "Global_PathIsNotValid", "realspace_resources");
            throw new IllegalArgumentException(string7);
        }
        object = string;
        Workspace workspace = this._$2.getWorkspace();
        long l2 = 0L;
        if (workspace != null) {
            l2 = InternalHandle.getHandle((InternalHandle)workspace);
        }
        if ((l = Layer3DsNative.jni_AddWithPassword(this.getHandle(), layer3DType.value(), bl, (String)object, string3, l2)) != 0L) {
            Layer3D layer3D = Layer3D.createInstance(l, this, layer3DType);
            layer3D.setName(string2);
            if (bl) {
                this._$1.add(0, layer3D);
            } else {
                this._$1.add(layer3D);
            }
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded(layer3DAddedEvent);
            return layer3D;
        }
        return null;
    }

    public Layer3D add(String string, Layer3DType layer3DType, String string2, boolean bl) {
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        if (this.indexOf(string2) != -1) {
            String string4 = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string4);
        }
        long l = Layer3DsNative.jni_AddIserver(this.getHandle(), string, layer3DType.value(), string2);
        if (l != 0L) {
            Layer3D layer3D = Layer3D.createInstance(l, this, layer3DType);
            layer3D.setName(string2);
            if (bl) {
                this._$1.add(0, layer3D);
            } else {
                this._$1.add(layer3D);
            }
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded(layer3DAddedEvent);
            return layer3D;
        }
        return null;
    }

    public Layer3DDataset insert(int n, Dataset dataset, Layer3DSetting layer3DSetting, String string) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string2);
        }
        if (this.indexOf(string) != -1) {
            String string3 = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        Layer3DDataset layer3DDataset = this.insert(n, dataset, layer3DSetting);
        layer3DDataset.setName(string);
        return layer3DDataset;
    }

    public Layer3D insert(int n, String string, String string2, Layer3DType layer3DType) {
        if (string2 == null || string2.trim().length() == 0) {
            String string3 = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        if (this.indexOf(string2) != -1) {
            String string4 = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string4);
        }
        Layer3D layer3D = this.insert(n, string, layer3DType);
        layer3D.setName(string2);
        return layer3D;
    }

    public Layer3DDataset insert(int n, Dataset dataset, Theme3D theme3D, String string) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string2);
        }
        if (this.indexOf(string) != -1) {
            String string3 = InternalResource.loadString("layerName", "Layer3Ds_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        Layer3DDataset layer3DDataset = this.insert(n, dataset, theme3D);
        layer3DDataset.setName(string);
        return layer3DDataset;
    }

    public Layer3D insert(int n, String string, String string2, Layer3DType layer3DType, String string3) {
        Object object;
        this._$1();
        if (this.getHandle() == 0L) {
            String string4 = InternalResource.loadString("insert(int index,  String dataName)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        if (n < 0 || n > this.getCount()) {
            String string5 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string5);
        }
        if ((layer3DType.equals((Object)Layer3DType.KML) || layer3DType.equals((Object)Layer3DType.IMAGEFILE) || layer3DType.equals((Object)Layer3DType.MODEL)) && !((File)(object = new File(string))).exists()) {
            String string6 = InternalResource.loadString("", "Global_PathIsNotValid", "realspace_resources");
            throw new IllegalArgumentException(string6);
        }
        if (!this.checkDataNameAndType(string, layer3DType, string3)) {
            object = InternalResource.loadString("layerType", "Layer3Ds_AddDataNameAndLayer3DTypeIsNotMatching", "realspace_resources");
            throw new IllegalArgumentException((String)object);
        }
        long l = Layer3DsNative.jni_Insert2(this.getHandle(), n, string, layer3DType.value(), string3);
        if (l != 0L) {
            Layer3D layer3D = Layer3D.createInstance(l, this, layer3DType);
            layer3D.setName(string2);
            this._$1.add(n, layer3D);
            Layer3DAddedEvent layer3DAddedEvent = new Layer3DAddedEvent((Object)this, layer3D);
            this.fireLayer3DAdded(layer3DAddedEvent);
            return layer3D;
        }
        return null;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Layer3D layer3D = this._$1.get(n);
        String string = layer3D.getName();
        boolean bl = Layer3DsNative.jni_Remove(this.getHandle(), layer3D.getName());
        if (bl) {
            this._$1.remove(n);
            layer3D.clearHandle();
            Layer3DRemovedEvent layer3DRemovedEvent = new Layer3DRemovedEvent((Object)this, layer3D, string, n);
            this.fireLayer3DRemoved(layer3DRemovedEvent);
        }
        return bl;
    }

    public boolean remove(String string) {
        int n;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("remove(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        Layer3D layer3D = null;
        boolean bl = false;
        for (n = 0; n < this._$1.size(); ++n) {
            layer3D = this._$1.get(n);
            if (!layer3D.getName().equals(string)) continue;
            bl = true;
            break;
        }
        n = this.indexOf(string);
        boolean bl2 = false;
        if (bl && (bl2 = Layer3DsNative.jni_Remove(this.getHandle(), string))) {
            this._$1.remove((Object)layer3D);
            layer3D.clearHandle();
            Layer3DRemovedEvent layer3DRemovedEvent = new Layer3DRemovedEvent((Object)this, layer3D, string, n);
            this.fireLayer3DRemoved(layer3DRemovedEvent);
        }
        return bl2;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        while (this.getCount() > 0) {
            this.remove(0);
        }
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("indexOf(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        int n = -1;
        if (string != null) {
            n = Layer3DsNative.jni_IndexOf(this.getHandle(), string);
        }
        return n;
    }

    public boolean contains(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("contains(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null) {
            bl = Layer3DsNative.jni_Contains(this.getHandle(), string);
        }
        return bl;
    }

    public boolean moveToTop(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveToTop(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (n == 0) {
            bl = true;
        } else {
            bl = Layer3DsNative.jni_MoveToTop(this.getHandle(), n);
            if (bl) {
                Layer3D layer3D = this._$1.remove(n);
                this._$1.add(0, layer3D);
            }
        }
        return bl;
    }

    public boolean moveToBottom(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveToBottom(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (n == n2 - 1) {
            bl = true;
        } else {
            bl = Layer3DsNative.jni_MoveToBottom(this.getHandle(), n);
            if (bl) {
                Layer3D layer3D = this._$1.remove(n);
                this._$1.add(layer3D);
            }
        }
        return bl;
    }

    public boolean moveUp(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveUp(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (n == 0) {
            bl = true;
        } else {
            bl = Layer3DsNative.jni_MoveUp(this.getHandle(), n);
            if (bl) {
                Layer3D layer3D = this._$1.remove(n);
                this._$1.add(n - 1, layer3D);
            }
        }
        return bl;
    }

    public boolean moveDown(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveDown(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (n == n2 - 1) {
            bl = true;
        } else {
            bl = Layer3DsNative.jni_MoveDown(this.getHandle(), n);
            if (bl) {
                Layer3D layer3D = this._$1.remove(n + 1);
                this._$1.add(n, layer3D);
            }
        }
        return bl;
    }

    public boolean moveTo(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveTo(int srcIndex, int desIndex)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n3 = this.getCount();
        if (n < 0 || n >= n3) {
            String string = InternalResource.loadString("srcIndex", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (n2 < 0 || n2 >= n3) {
            String string = InternalResource.loadString("desIndex", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (n == n2) {
            bl = true;
        } else {
            bl = Layer3DsNative.jni_MoveTo(this.getHandle(), n, n2);
            if (bl) {
                Layer3D layer3D = this._$1.remove(n);
                this._$1.add(n2, layer3D);
            }
        }
        return bl;
    }

    ArrayList getLayersList() {
        return this._$1;
    }

    Scene getScene() {
        return this._$2;
    }

    protected void clearHandle() {
        if (this._$1 != null) {
            int n = this._$1.size();
            for (int i = 0; i < n; ++i) {
                Layer3D layer3D = this._$1.get(i);
                layer3D.clearHandle();
            }
            this._$1.clear();
            this._$1 = null;
        }
        this._$2 = null;
        this.setHandle(0L);
    }

    protected static Layer3Ds createInstance(long l, Scene scene) {
        return new Layer3Ds(l, scene);
    }

    protected boolean checkDataNameAndType(String string, Layer3DType layer3DType, String string2) {
        if (layer3DType.equals((Object)Layer3DType.DATASET)) {
            return false;
        }
        boolean bl = false;
        int n = layer3DType.value();
        bl = Layer3DsNative.jni_CheckDataNameAndType(this.getHandle(), string, n, string2);
        return bl;
    }

    private void _$1() {
        int n = this._$2.getLicense().verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    public synchronized void addLayer3DAddedListener(Layer3DAddedListener layer3DAddedListener) {
        if (this.m_layerAddedListeners == null) {
            this.m_layerAddedListeners = new Vector();
        }
        if (!this.m_layerAddedListeners.contains(layer3DAddedListener)) {
            this.m_layerAddedListeners.add(layer3DAddedListener);
        }
    }

    public synchronized void removeLayer3DAddedListener(Layer3DAddedListener layer3DAddedListener) {
        if (this.m_layerAddedListeners != null && this.m_layerAddedListeners.contains(layer3DAddedListener)) {
            this.m_layerAddedListeners.remove(layer3DAddedListener);
        }
    }

    protected void fireLayer3DAdded(Layer3DAddedEvent layer3DAddedEvent) {
        if (this.m_layerAddedListeners != null) {
            Vector vector = this.m_layerAddedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((Layer3DAddedListener)vector.elementAt(i)).layer3DAdded(layer3DAddedEvent);
            }
        }
    }

    public synchronized void addLayer3DRemovedListener(Layer3DRemovedListener layer3DRemovedListener) {
        if (this.m_layerRemovedListeners == null) {
            this.m_layerRemovedListeners = new Vector();
        }
        if (!this.m_layerRemovedListeners.contains(layer3DRemovedListener)) {
            this.m_layerRemovedListeners.add(layer3DRemovedListener);
        }
    }

    public synchronized void removeLayer3DRemovedListener(Layer3DRemovedListener layer3DRemovedListener) {
        if (this.m_layerRemovedListeners != null && this.m_layerRemovedListeners.contains(layer3DRemovedListener)) {
            this.m_layerRemovedListeners.remove(layer3DRemovedListener);
        }
    }

    protected void fireLayer3DRemoved(Layer3DRemovedEvent layer3DRemovedEvent) {
        if (this.m_layerRemovedListeners != null) {
            Vector vector = this.m_layerRemovedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((Layer3DRemovedListener)vector.elementAt(i)).layer3DRemoved(layer3DRemovedEvent);
            }
        }
    }

    public synchronized void addLayer3DCaptionChangedListener(Layer3DCaptionChangedListener layer3DCaptionChangedListener) {
        if (this.m_layer3DCaptionChangedListeners == null) {
            this.m_layer3DCaptionChangedListeners = new Vector();
        }
        if (!this.m_layer3DCaptionChangedListeners.contains(layer3DCaptionChangedListener)) {
            this.m_layer3DCaptionChangedListeners.add(layer3DCaptionChangedListener);
        }
    }

    public synchronized void removeLayer3DCaptionChangedListener(Layer3DCaptionChangedListener layer3DCaptionChangedListener) {
        if (this.m_layer3DCaptionChangedListeners != null && this.m_layer3DCaptionChangedListeners.contains(layer3DCaptionChangedListener)) {
            this.m_layer3DCaptionChangedListeners.remove(layer3DCaptionChangedListener);
        }
    }

    protected void fireLyer3DCaptionChanged(Layer3DCaptionChangedEvent layer3DCaptionChangedEvent) {
        if (this.m_layer3DCaptionChangedListeners != null) {
            Vector<Layer3DCaptionChangedListener> vector = this.m_layer3DCaptionChangedListeners;
            int n = this.m_layer3DCaptionChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).Layer3DCaptionChanged(layer3DCaptionChangedEvent);
            }
        }
    }

    public synchronized void addLayer3DSelectableChangedListener(Layer3DSelectableChangedListener layer3DSelectableChangedListener) {
        if (this.m_layer3DSelectableChangedListeners == null) {
            this.m_layer3DSelectableChangedListeners = new Vector();
        }
        if (!this.m_layer3DSelectableChangedListeners.contains(layer3DSelectableChangedListener)) {
            this.m_layer3DSelectableChangedListeners.add(layer3DSelectableChangedListener);
        }
    }

    public synchronized void removeLayer3DSelectableChangedListener(Layer3DSelectableChangedListener layer3DSelectableChangedListener) {
        if (this.m_layer3DSelectableChangedListeners != null && this.m_layer3DSelectableChangedListeners.contains(layer3DSelectableChangedListener)) {
            this.m_layer3DSelectableChangedListeners.remove(layer3DSelectableChangedListener);
        }
    }

    protected void fireLyer3DSelectableChanged(Layer3DSelectableChangedEvent layer3DSelectableChangedEvent) {
        if (this.m_layer3DSelectableChangedListeners != null) {
            Vector<Layer3DSelectableChangedListener> vector = this.m_layer3DSelectableChangedListeners;
            int n = this.m_layer3DSelectableChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).layer3DSelectableChanged(layer3DSelectableChangedEvent);
            }
        }
    }

    public synchronized void addLayer3DEditableChangedListener(Layer3DEditableChangedListener layer3DEditableChangedListener) {
        if (this.m_layer3DEditableChangedListeners == null) {
            this.m_layer3DEditableChangedListeners = new Vector();
        }
        if (!this.m_layer3DEditableChangedListeners.contains(layer3DEditableChangedListener)) {
            this.m_layer3DEditableChangedListeners.add(layer3DEditableChangedListener);
        }
    }

    public synchronized void removeLayer3DEditableChangedListener(Layer3DEditableChangedListener layer3DEditableChangedListener) {
        if (this.m_layer3DEditableChangedListeners != null && this.m_layer3DEditableChangedListeners.contains(layer3DEditableChangedListener)) {
            this.m_layer3DEditableChangedListeners.remove(layer3DEditableChangedListener);
        }
    }

    protected void fireLyer3DEditableChanged(Layer3DEditableChangedEvent layer3DEditableChangedEvent) {
        if (this.m_layer3DEditableChangedListeners != null) {
            Vector<Layer3DEditableChangedListener> vector = this.m_layer3DEditableChangedListeners;
            int n = this.m_layer3DEditableChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).Layer3DEditableChanged(layer3DEditableChangedEvent);
            }
        }
    }

    public synchronized void addLayer3DVisibleChangedListener(Layer3DVisibleChangedListener layer3DVisibleChangedListener) {
        if (this.m_layer3DVisibleChangedListeners == null) {
            this.m_layer3DVisibleChangedListeners = new Vector();
        }
        if (!this.m_layer3DVisibleChangedListeners.contains(layer3DVisibleChangedListener)) {
            this.m_layer3DVisibleChangedListeners.add(layer3DVisibleChangedListener);
        }
    }

    public synchronized void removeLayer3DVisibleChangedListener(Layer3DVisibleChangedListener layer3DVisibleChangedListener) {
        if (this.m_layer3DVisibleChangedListeners != null && this.m_layer3DVisibleChangedListeners.contains(layer3DVisibleChangedListener)) {
            this.m_layer3DVisibleChangedListeners.remove(layer3DVisibleChangedListener);
        }
    }

    protected void fireLyer3DVisibleChanged(Layer3DVisibleChangedEvent layer3DVisibleChangedEvent) {
        if (this.m_layer3DVisibleChangedListeners != null) {
            Vector<Layer3DVisibleChangedListener> vector = this.m_layer3DVisibleChangedListeners;
            int n = this.m_layer3DVisibleChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).layer3DVisibleChanged(layer3DVisibleChangedEvent);
            }
        }
    }

    public synchronized void addLayer3DAlwaysRenderChangedListener(Layer3DAlwaysRenderChangedListener layer3DAlwaysRenderChangedListener) {
        if (this.m_layer3DAlwaysRenderChangedListeners == null) {
            this.m_layer3DAlwaysRenderChangedListeners = new Vector();
        }
        if (!this.m_layer3DAlwaysRenderChangedListeners.contains(layer3DAlwaysRenderChangedListener)) {
            this.m_layer3DAlwaysRenderChangedListeners.add(layer3DAlwaysRenderChangedListener);
        }
    }

    public synchronized void removeLayer3DAlwaysRenderChangedListener(Layer3DAlwaysRenderChangedListener layer3DAlwaysRenderChangedListener) {
        if (this.m_layer3DAlwaysRenderChangedListeners != null && this.m_layer3DAlwaysRenderChangedListeners.contains(layer3DAlwaysRenderChangedListener)) {
            this.m_layer3DAlwaysRenderChangedListeners.remove(layer3DAlwaysRenderChangedListener);
        }
    }

    protected void fireLayer3DAlwaysRenderChanged(Layer3DAlwaysRenderChangedEvent layer3DAlwaysRenderChangedEvent) {
        if (this.m_layer3DAlwaysRenderChangedListeners != null) {
            Vector<Layer3DAlwaysRenderChangedListener> vector = this.m_layer3DAlwaysRenderChangedListeners;
            int n = this.m_layer3DAlwaysRenderChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).layer3DAlwaysRenderChanged(layer3DAlwaysRenderChangedEvent);
            }
        }
    }
}

