/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.realspace.FogMode;
import com.supermap.realspace.FogNative;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import java.awt.Color;

public class Fog
extends InternalHandleDisposable {
    private FogMode _$1;

    public Fog() {
        long l = FogNative.jni_New();
        this.setHandle(l, true);
        this._$1 = FogMode.EXP;
        this.setEnable(false);
        this.setDensity(1.0);
    }

    Fog(long l) {
        int n = FogNative.jni_GetFogMode(l);
        switch (n) {
            case 0: 
            case 1: {
                this._$1 = FogMode.EXP;
                break;
            }
            case 2: {
                this._$1 = FogMode.EXP2;
                break;
            }
            case 3: {
                this._$1 = FogMode.LINEAR;
            }
        }
        this.setHandle(l, false);
    }

    public FogMode getFogMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFogMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this._$1;
    }

    public void setFogMode(FogMode fogMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFogMode(value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (fogMode == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        this._$1 = fogMode;
        int n = InternalEnum.getUGCValue(fogMode);
        FogNative.jni_SetFogMode(this.getHandle(), n);
    }

    public Color getColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColor()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(FogNative.jni_GetColor(this.getHandle()), true);
        return color;
    }

    public void setColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColor(Color value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FogNative.jni_SetColor(this.getHandle(), color.getRGB());
    }

    public double getDensity() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDensity()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FogNative.jni_GetDensity(this.getHandle());
    }

    public void setDensity(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDensity(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        FogNative.jni_SetDensity(this.getHandle(), d);
    }

    public double getStartDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartDistance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FogNative.jni_GetStartDistance(this.getHandle());
    }

    public void setStartDistance(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartDistance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        FogNative.jni_SetStartDistance(this.getHandle(), d);
    }

    public double getEndDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndDistance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FogNative.jni_GetEndDistance(this.getHandle());
    }

    public void setEndDistance(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEndDistance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        FogNative.jni_SetEndDistance(this.getHandle(), d);
    }

    public boolean isEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FogNative.jni_GetIsEnable(this.getHandle());
    }

    public void setEnable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEnable(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(this._$1);
        FogNative.jni_SetIsEnable(this.getHandle(), n, bl);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Color=");
        Color color = this.getColor();
        String string = color.getClass().getName() + "[r=" + color.getRed() + ",g=" + color.getGreen() + ",b=" + color.getBlue() + ",a=" + color.getAlpha() + "]";
        stringBuffer.append(string);
        stringBuffer.append(",Density=");
        stringBuffer.append(this.getDensity());
        stringBuffer.append(",EndDistance=");
        stringBuffer.append(this.getEndDistance());
        stringBuffer.append(",IsEnabled=");
        stringBuffer.append(this.isEnable());
        stringBuffer.append(",Mode=");
        stringBuffer.append((Object)this.getFogMode());
        stringBuffer.append(",StartDistance=");
        stringBuffer.append(this.getStartDistance());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            FogNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    static final Fog createInstance(long l) {
        return new Fog(l);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }
}

