/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.Dataset;
import com.supermap.mapping.Layer;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeType;
import com.supermap.ui.InternalImageIconFactory;
import com.supermap.ui.TreeNodeData;
import com.supermap.ui.TreeNodeDecorator;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class LayerThemeNodeDecorator
implements TreeNodeDecorator {
    LayerThemeNodeDecorator() {
    }

    public void decorate(JLabel jLabel, TreeNodeData treeNodeData) {
        Layer layer = (Layer)treeNodeData.getData();
        jLabel.setText(layer.getCaption());
        Dataset dataset = layer.getDataset();
        if (dataset == null) {
            ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(InternalImageIconFactory.DT_UNKNOWN.getImage(), 0, 0, jLabel);
            imageIcon.setImage(bufferedImage);
        } else {
            Theme theme = layer.getTheme();
            if (theme != null) {
                ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
                BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
                Graphics graphics = bufferedImage.getGraphics();
                ThemeType themeType = theme.getType();
                if (themeType.equals((Object)ThemeType.CUSTOM)) {
                    graphics.drawImage(InternalImageIconFactory.THEME_CUSTOM.getImage(), 0, 0, jLabel);
                } else if (themeType.equals((Object)ThemeType.DOTDENSITY)) {
                    graphics.drawImage(InternalImageIconFactory.THEME_DOTDENSITY.getImage(), 0, 0, jLabel);
                } else if (themeType.equals((Object)ThemeType.GRADUATEDSYMBOL)) {
                    graphics.drawImage(InternalImageIconFactory.THEME_GRADUATEDSYMBOL.getImage(), 0, 0, jLabel);
                } else if (themeType.equals((Object)ThemeType.GRAPH)) {
                    graphics.drawImage(InternalImageIconFactory.THEME_GRAPH.getImage(), 0, 0, jLabel);
                } else if (themeType.equals((Object)ThemeType.GRIDRANGE)) {
                    graphics.drawImage(InternalImageIconFactory.THEME_GRIDRANGE.getImage(), 0, 0, jLabel);
                } else if (themeType.equals((Object)ThemeType.GRIDUNIQUE)) {
                    graphics.drawImage(InternalImageIconFactory.THEME_GRIDUNIQUE.getImage(), 0, 0, jLabel);
                } else if (themeType.equals((Object)ThemeType.LABEL)) {
                    graphics.drawImage(InternalImageIconFactory.THEME_LABEL.getImage(), 0, 0, jLabel);
                } else if (themeType.equals((Object)ThemeType.RANGE)) {
                    graphics.drawImage(InternalImageIconFactory.THEME_RANGE.getImage(), 0, 0, jLabel);
                } else if (themeType.equals((Object)ThemeType.UNIQUE)) {
                    graphics.drawImage(InternalImageIconFactory.THEME_UNIQUE.getImage(), 0, 0, jLabel);
                }
                imageIcon.setImage(bufferedImage);
            }
        }
    }
}

