/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.geoprocessor.executeengine;

import bexee.core.BexeeMessage;
import bexee.core.ProcessController;
import bexee.core.ProcessInstance;
import bexee.model.BPELDocumentException;
import bexee.model.process.BPELProcess;
import com.supermap.geoprocessor.common.ProcessStatus;
import com.supermap.geoprocessor.core.RunningContext;
import com.supermap.geoprocessor.executeengine.AfterExecuteListener;
import com.supermap.geoprocessor.executeengine.BeforeExecuteListener;
import com.supermap.geoprocessor.executeengine.InternalAfterExecListener;
import com.supermap.geoprocessor.executeengine.InternalBeforeExecListener;
import com.supermap.geoprocessor.executeengine.core.GeoProcessContext;
import com.supermap.geoprocessor.executeengine.core.GeoProcessController;
import com.supermap.geoprocessor.executeengine.core.GeoProcessControllerFactory;
import com.supermap.geoprocessor.executeengine.core.GeoProcessInstance;
import com.supermap.geoprocessor.executeengine.manager.Manager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;

public class EngineManager {
    private Vector<BeforeExecuteListener> m_beforeListeners = new Vector();
    private Vector<AfterExecuteListener> m_afterListeners = new Vector();

    public EngineManager() {
        this.m_beforeListeners.add(new InternalBeforeExecListener());
        this.m_afterListeners.add(new InternalAfterExecListener());
    }

    public boolean execute(String string, long l, RunningContext runningContext) throws Exception {
        int n;
        boolean bl = false;
        for (n = 0; n < this.m_beforeListeners.size(); ++n) {
            this.m_beforeListeners.get(n).run(runningContext);
        }
        bl = EngineManager.internalExecute(string, l, runningContext);
        for (n = 0; n < this.m_afterListeners.size(); ++n) {
            this.m_afterListeners.get(n).run(runningContext);
        }
        return bl;
    }

    private static boolean internalExecute(String string, long l, RunningContext runningContext) throws Exception {
        if (string.length() < 0 || string == null) {
            throw new Exception("xmlContent\u4e3a\u7a7a");
        }
        if (string.length() < 0 || string == null) {
            throw new Exception("xmlContent\u4e3a\u7a7a");
        }
        Manager manager = new Manager();
        try {
            BPELProcess bPELProcess = manager.createBPELProcess(string);
            GeoProcessController geoProcessController = GeoProcessControllerFactory.createProcessController();
            GeoProcessContext geoProcessContext = new GeoProcessContext();
            BexeeMessage bexeeMessage = new BexeeMessage();
            bexeeMessage.setService("test");
            geoProcessContext.setMessage(bexeeMessage);
            GeoProcessInstance geoProcessInstance = new GeoProcessInstance(bPELProcess, geoProcessContext);
            geoProcessInstance.setRunningContext(runningContext);
            bPELProcess.getProcess().accept((ProcessController)geoProcessController, (ProcessInstance)geoProcessInstance);
            Object object = geoProcessContext.getResult();
        }
        catch (BPELDocumentException bPELDocumentException) {
            bPELDocumentException.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            runningContext.writeError("\u627e\u4e0d\u5230\u529f\u80fd\u7c7b" + classNotFoundException.getMessage());
            return false;
        }
        return true;
    }

    static boolean internalExecuteFromFile(String string, long l, RunningContext runningContext) throws Exception {
        return EngineManager.internalExecute(EngineManager.getContent(string), l, runningContext);
    }

    public static boolean internalExecuteFromURL(URL uRL, long l, RunningContext runningContext) {
        BPELProcess bPELProcess = null;
        boolean bl = false;
        try {
            bPELProcess = Manager.createBPELProcess(uRL);
        }
        catch (BPELDocumentException bPELDocumentException) {
            bPELDocumentException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            runningContext.writeError("\u627e\u4e0d\u5230\u529f\u80fd\u6587\u4ef6" + iOException.getMessage());
        }
        if (bPELProcess != null) {
            GeoProcessController geoProcessController = GeoProcessControllerFactory.createProcessController();
            GeoProcessContext geoProcessContext = new GeoProcessContext();
            GeoProcessInstance geoProcessInstance = new GeoProcessInstance(bPELProcess, geoProcessContext);
            geoProcessInstance.setRunningContext(runningContext);
            try {
                runningContext.updateProcessStatus(ProcessStatus.RUNNING);
                bPELProcess.getProcess().accept((ProcessController)geoProcessController, (ProcessInstance)geoProcessInstance);
                runningContext.updateProcessStatus(runningContext.getStatus());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Object object = geoProcessContext.getResult();
            bl = true;
        }
        return bl;
    }

    public boolean executeFromFile(String string, long l, RunningContext runningContext) throws Exception {
        String string2 = EngineManager.getContent(string);
        if (0 == string2.length()) {
            runningContext.writeError("\u627e\u4e0d\u5230\u6587\u4ef6" + string);
            return false;
        }
        return this.execute(string2, l, runningContext);
    }

    private static String getContent(String string) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return "";
        }
    }

    public void addBeforeExecuteListener(BeforeExecuteListener beforeExecuteListener) {
        this.m_beforeListeners.add(beforeExecuteListener);
    }

    public void addAfterExecuteListener(AfterExecuteListener afterExecuteListener) {
        this.m_afterListeners.add(afterExecuteListener);
    }
}

