/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BoundingBox;
import com.supermap.data.GeoModel;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.Geometry;
import com.supermap.data.Geometry3DNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Rectangle2D;

public abstract class Geometry3D
extends Geometry {
    private GeoStyle3D _$7 = null;
    private boolean _$6 = false;
    private BoundingBox _$5 = null;

    protected Geometry3D() {
    }

    public Point3D getPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPosition()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetPosition(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        return point3D;
    }

    public void setPosition(Point3D point3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPosition(Point3D point)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d = point3D.getX();
        double d2 = point3D.getY();
        double d3 = point3D.getZ();
        Geometry3DNative.jni_SetPosition(this.getHandle(), d, d2, d3);
    }

    public GeoStyle3D getStyle3D() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$7 == null && (l = Geometry3DNative.jni_GetStyle(this.getHandle())) != 0L) {
            this._$7 = GeoStyle3D.createInstance(l);
        }
        return this._$7;
    }

    public void setStyle3D(GeoStyle3D geoStyle3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle3D == null) {
            if (this._$7 != null) {
                this._$7.clearHandle();
                this._$7 = null;
            }
            Geometry3DNative.jni_SetStyle(this.getHandle(), 0L);
        } else {
            if (geoStyle3D.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            GeoStyle3D geoStyle3D2 = geoStyle3D.clone();
            Geometry3DNative.jni_SetStyle(this.getHandle(), geoStyle3D2.getHandle());
        }
        this._$6 = true;
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle3D);
    }

    public double getRotationX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotationX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetRotation(this.getHandle(), dArray);
        return dArray[0];
    }

    public void setRotationX(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotationX(double x)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_SetRotationX(this.getHandle(), d);
    }

    public double getRotationY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotationY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetRotation(this.getHandle(), dArray);
        return dArray[1];
    }

    public void setRotationY(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotationY(double y)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_SetRotationY(this.getHandle(), d);
    }

    public double getRotationZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotationZ()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetRotation(this.getHandle(), dArray);
        return dArray[2];
    }

    public void setRotationZ(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotationZ(double z)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_SetRotationZ(this.getHandle(), d);
    }

    public double getScaleX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetScale(this.getHandle(), dArray);
        return dArray[0];
    }

    public void setScaleX(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleX(double x)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("x", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_SetScaleX(this.getHandle(), d);
    }

    public double getScaleY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetScale(this.getHandle(), dArray);
        return dArray[1];
    }

    public void setScaleY(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleY(double y)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("y", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_SetScaleY(this.getHandle(), d);
    }

    public double getScaleZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleZ()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetScale(this.getHandle(), dArray);
        return dArray[2];
    }

    public void setScaleZ(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleZ(double z)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("z", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_SetScaleZ(this.getHandle(), d);
    }

    public BoundingBox getBoundingBox() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBoundingBox()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null && (l = Geometry3DNative.jni_GetBoundingBox(this.getHandle())) != 0L) {
            this._$5 = new BoundingBox(l);
        }
        BoundingBox boundingBox = new BoundingBox(this._$5);
        Rectangle2D rectangle2D = this.getBounds();
        boundingBox.setLower(new Point3D(rectangle2D.getLeft(), rectangle2D.getBottom(), boundingBox.getLower().getZ()));
        boundingBox.setUpper(new Point3D(rectangle2D.getRight(), rectangle2D.getTop(), boundingBox.getUpper().getZ()));
        return boundingBox;
    }

    public Point3D getInnerPoint3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInnerPoint3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        Geometry3DNative.jni_GetInnerPoint3D(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        return point3D;
    }

    public double getVolume() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVolume()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return Geometry3DNative.jni_GetVolume(this.getHandle());
    }

    public void offset(double d, double d2, double d3) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy, double dz)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry3DNative.jni_Offset(this.getHandle(), d, d2, d3);
    }

    public GeoModel getGeoModel(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGeoModel(int slices, int stacks)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0 || n2 <= 0) {
            String string = InternalResource.loadString("getGeoModel(int slices, int stacks)", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = Geometry3DNative.jni_GetGeoModel(this.getHandle(), n, n2);
        GeoModel geoModel = null;
        if (l != 0L) {
            geoModel = new GeoModel(l);
        }
        return geoModel;
    }
}

