/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.FeatureNative;
import com.supermap.data.FieldType;
import com.supermap.data.GeoPointNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Feature
extends InternalHandleDisposable {
    private int _$5 = 0;
    private ArrayList<FieldType> _$4 = null;
    private boolean[] _$3 = new boolean[]{false};

    Feature() {
        long l = FeatureNative.jni_New();
        this.setHandle(l, true);
        this._$4 = new ArrayList();
    }

    Feature(long l) {
        this.setHandle(l, true);
        this._$5 = FeatureNative.jni_GetFieldCount(this.getHandle());
        this._$4 = new ArrayList();
        for (int i = 0; i < this._$5; ++i) {
            int n = FeatureNative.jni_GetFieldType(this.getHandle(), i);
            FieldType fieldType = (FieldType)Enum.parseUGCValue(FieldType.class, n);
            this._$4.add(fieldType);
        }
    }

    Feature(Feature feature) {
        if (feature.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoPointNative.jni_Clone(feature.getHandle());
        this.setHandle(l, true);
        this._$5 = FeatureNative.jni_GetFieldCount(this.getHandle());
        this._$4 = new ArrayList();
        this._$4.addAll(feature._$4);
        InternalHandleDisposable.makeSureNativeObjectLive(feature);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            FeatureNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            super.clearHandle();
        }
    }

    private void _$1(int n) {
        if (n < 0 || n >= this._$5) {
            String string = InternalResource.loadString("" + n, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
    }

    public boolean getBoolean(int n) {
        this._$1(n);
        boolean bl = FeatureNative.jni_GetValueBoolByIndex(this.getHandle(), n, this._$3);
        return bl;
    }

    public byte[] getLongBinary(int n) {
        this._$1(n);
        byte[] byArray = FeatureNative.jni_GetValueLongBinaryByIndex(this.getHandle(), n);
        return byArray;
    }

    public byte getByte(int n) {
        this._$1(n);
        byte by = FeatureNative.jni_GetValueByteByIndex(this.getHandle(), n, this._$3);
        return by;
    }

    public int getInt32(int n) {
        this._$1(n);
        int n2 = FeatureNative.jni_GetValueIntByIndex(this.getHandle(), n, this._$3);
        return n2;
    }

    public float getFloat(int n) {
        this._$1(n);
        float f = FeatureNative.jni_GetValueFloatByIndex(this.getHandle(), n, this._$3);
        return f;
    }

    public double getDouble(int n) {
        this._$1(n);
        double d = FeatureNative.jni_GetValueDoubleByIndex(this.getHandle(), n, this._$3);
        return d;
    }

    public short getInt16(int n) {
        this._$1(n);
        short s = FeatureNative.jni_GetValueShortByIndex(this.getHandle(), n, this._$3);
        return s;
    }

    public String getString(int n) {
        this._$1(n);
        String string = FeatureNative.jni_GetValueStringByIndex(this.getHandle(), n, this._$3);
        return string;
    }

    public long getInt64(int n) {
        this._$1(n);
        long l = FeatureNative.jni_GetValueLongByIndex(this.getHandle(), n, this._$3);
        return l;
    }

    public Date getDateTime(int n) {
        this._$1(n);
        String string = FeatureNative.jni_GetValueDateByIndex(this.getHandle(), n, this._$3);
        if (string == null) {
            return null;
        }
        Date date = null;
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.equals("aix")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                try {
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
                    date = simpleDateFormat2.parse(string);
                }
                catch (ParseException parseException2) {}
            }
        } else {
            try {
                date = DateFormat.getDateTimeInstance().parse(string);
            }
            catch (ParseException parseException) {
                try {
                    date = DateFormat.getDateInstance().parse(string);
                }
                catch (ParseException parseException3) {
                    // empty catch block
                }
            }
        }
        return date;
    }

    public int getID() {
        int n = FeatureNative.jni_GetID(this.getHandle());
        return n;
    }

    public Geometry getGeometry() {
        long l = FeatureNative.jni_GetGeometry(this.getHandle());
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        return geometry;
    }

    public boolean hasTheSameFields(Feature feature) {
        if (feature == null) {
            return false;
        }
        if (0L == feature.getHandle()) {
            return false;
        }
        return FeatureNative.jni_IsLike(feature.getHandle());
    }

    public boolean getBoolean(String string) {
        int n = FeatureNative.jni_GetIndex(this.getHandle(), string);
        return this.getBoolean(n);
    }

    public byte[] getLongBinary(String string) {
        int n = FeatureNative.jni_GetIndex(this.getHandle(), string);
        return this.getLongBinary(n);
    }

    public byte getByte(String string) {
        int n = FeatureNative.jni_GetIndex(this.getHandle(), string);
        return this.getByte(n);
    }

    public int getInt32(String string) {
        int n = FeatureNative.jni_GetIndex(this.getHandle(), string);
        return this.getInt32(n);
    }

    public float getFloat(String string) {
        int n = FeatureNative.jni_GetIndex(this.getHandle(), string);
        return this.getFloat(n);
    }

    public double getDouble(String string) {
        int n = FeatureNative.jni_GetIndex(this.getHandle(), string);
        return this.getDouble(n);
    }

    public short getInt16(String string) {
        int n = FeatureNative.jni_GetIndex(this.getHandle(), string);
        return this.getInt16(n);
    }

    public String getString(String string) {
        int n = FeatureNative.jni_GetIndex(this.getHandle(), string);
        return this.getString(n);
    }

    public long getInt64(String string) {
        int n = FeatureNative.jni_GetIndex(this.getHandle(), string);
        return this.getInt64(n);
    }

    public Date getDateTime(String string) {
        int n = FeatureNative.jni_GetIndex(this.getHandle(), string);
        return this.getDateTime(n);
    }

    public Object getValue(int n) {
        this._$1(n);
        FieldType fieldType = this._$4.get(n);
        if (fieldType.equals(FieldType.INT32)) {
            Integer n2 = this.getInt32(n);
            if (this._$3[0]) {
                return null;
            }
            return n2;
        }
        if (fieldType.equals(FieldType.INT64)) {
            Long l = this.getInt64(n);
            if (this._$3[0]) {
                return null;
            }
            return l;
        }
        if (fieldType.equals(FieldType.INT16)) {
            Short s = this.getInt16(n);
            if (this._$3[0]) {
                return null;
            }
            return s;
        }
        if (fieldType.equals(FieldType.BOOLEAN)) {
            Boolean bl = this.getBoolean(n);
            if (this._$3[0]) {
                return null;
            }
            return bl;
        }
        if (fieldType.equals(FieldType.BYTE)) {
            Byte by = this.getByte(n);
            if (this._$3[0]) {
                return null;
            }
            return by;
        }
        if (fieldType.equals(FieldType.CHAR)) {
            String string = this.getString(n);
            if (this._$3[0]) {
                return null;
            }
            return string;
        }
        if (fieldType.equals(FieldType.DATETIME)) {
            Date date = this.getDateTime(n);
            if (this._$3[0]) {
                return null;
            }
            return date;
        }
        if (fieldType.equals(FieldType.DOUBLE)) {
            Double d = this.getDouble(n);
            if (this._$3[0]) {
                return null;
            }
            return d;
        }
        if (fieldType.equals(FieldType.LONGBINARY)) {
            byte[] byArray = this.getLongBinary(n);
            return byArray;
        }
        if (fieldType.equals(FieldType.SINGLE)) {
            Float f = Float.valueOf(this.getFloat(n));
            if (this._$3[0]) {
                return null;
            }
            return f;
        }
        if (fieldType.equals(FieldType.TEXT)) {
            String string = this.getString(n);
            if (this._$3[0]) {
                return null;
            }
            return string;
        }
        return null;
    }

    public Object getValue(String string) {
        int n = FeatureNative.jni_GetIndex(this.getHandle(), string);
        return this.getValue(n);
    }

    public boolean wasNull() {
        return this._$3[0];
    }
}

