/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression;

import java.util.Map;
import ognl.ObjectPropertyAccessor;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.PropertyAccessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.StaticListableBeanFactory;
import org.springframework.binding.collection.MapAdaptable;
import org.springframework.binding.expression.ognl.OgnlExpressionParser;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.AnnotatedAction;
import org.springframework.webflow.execution.RequestContext;

public class WebFlowOgnlExpressionParser
extends OgnlExpressionParser {
    public WebFlowOgnlExpressionParser() {
        this.addPropertyAccessor(MapAdaptable.class, new MapAdaptablePropertyAccessor(null, null));
        this.addPropertyAccessor(MutableAttributeMap.class, new MutableAttributeMapPropertyAccessor());
        this.addPropertyAccessor(MessageSource.class, new MessageSourcePropertyAccessor());
        this.addPropertyAccessor(RequestContext.class, new RequestContextPropertyAccessor((PropertyAccessor)new ObjectPropertyAccessor()));
        this.addPropertyAccessor(Action.class, new ActionPropertyAccessor());
    }

    private static class ActionPropertyAccessor
    implements PropertyAccessor {
        private ActionPropertyAccessor() {
        }

        public Object getProperty(Map context, Object target, Object name) throws OgnlException {
            Action action = (Action)target;
            AnnotatedAction annotated = new AnnotatedAction(action);
            annotated.setMethod(name.toString());
            return annotated;
        }

        public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
            throw new OgnlException("Cannot set properties on a Action instance - operation not allowed");
        }
    }

    private static class MapAdaptablePropertyAccessor
    implements PropertyAccessor {
        private MapAdaptablePropertyAccessor() {
        }

        public Object getProperty(Map context, Object target, Object name) throws OgnlException {
            return ((MapAdaptable)target).asMap().get(name);
        }

        public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
            throw new UnsupportedOperationException("Cannot mutate immutable attribute collections; operation disallowed");
        }

        /* synthetic */ MapAdaptablePropertyAccessor(MapAdaptablePropertyAccessor mapAdaptablePropertyAccessor, MapAdaptablePropertyAccessor mapAdaptablePropertyAccessor2) {
            this();
        }
    }

    private static class MessageSourcePropertyAccessor
    implements PropertyAccessor {
        private MessageSourcePropertyAccessor() {
        }

        public Object getProperty(Map context, Object target, Object name) throws OgnlException {
            MessageSource messageSource = (MessageSource)target;
            Object root = Ognl.getRoot((Map)context);
            ExternalContext externalContext = root instanceof RequestContext ? ((RequestContext)root).getExternalContext() : ExternalContextHolder.getExternalContext();
            if (externalContext != null) {
                return messageSource.getMessage(name.toString(), null, null, externalContext.getLocale());
            }
            return messageSource.getMessage(name.toString(), null, null, null);
        }

        public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
            throw new OgnlException("Cannot set properties on a MessageSource instance - operation not allowed");
        }
    }

    private static class MutableAttributeMapPropertyAccessor
    extends MapAdaptablePropertyAccessor {
        private MutableAttributeMapPropertyAccessor() {
        }

        public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
            ((MutableAttributeMap)target).put((String)name, value);
        }
    }

    private static class RequestContextPropertyAccessor
    implements PropertyAccessor {
        private static final BeanFactory EMPTY_BEAN_FACTORY = new StaticListableBeanFactory();
        private PropertyAccessor delegate;

        public RequestContextPropertyAccessor(PropertyAccessor delegate) {
            this.delegate = delegate;
        }

        public Object getProperty(Map context, Object target, Object name) throws OgnlException {
            String property = name.toString();
            RequestContext requestContext = (RequestContext)target;
            if (property.equals("flowRequestContext")) {
                return requestContext;
            }
            if (property.equals("currentUser")) {
                return requestContext.getExternalContext().getCurrentUser();
            }
            if (property.equals("resourceBundle")) {
                return requestContext.getActiveFlow().getApplicationContext();
            }
            if (requestContext.getRequestScope().contains(property)) {
                return requestContext.getRequestScope().get(property);
            }
            if (requestContext.getFlashScope().contains(property)) {
                return requestContext.getFlashScope().get(property);
            }
            if (requestContext.inViewState() && requestContext.getViewScope().contains(property)) {
                return requestContext.getViewScope().get(property);
            }
            if (requestContext.getFlowScope().contains(property)) {
                return requestContext.getFlowScope().get(property);
            }
            if (requestContext.getConversationScope().contains(property)) {
                return requestContext.getConversationScope().get(property);
            }
            BeanFactory bf = this.getBeanFactory(requestContext);
            if (bf.containsBean(property)) {
                return bf.getBean(property);
            }
            return this.delegate.getProperty(context, target, name);
        }

        public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
            String property = name.toString();
            RequestContext requestContext = (RequestContext)target;
            if (property.equals("flowRequestContext")) {
                throw new OgnlException("The 'flowRequestContext' variable is not writeable");
            }
            if (property.equals("currentUser")) {
                throw new OgnlException("The 'currentUser' variable is not writeable");
            }
            if (property.equals("resourceBundle")) {
                throw new OgnlException("The 'resourceBundle' variable is not writeable");
            }
            if (requestContext.getRequestScope().contains(property)) {
                requestContext.getRequestScope().put(property, value);
            } else if (requestContext.getFlashScope().contains(property)) {
                requestContext.getFlashScope().put(property, value);
            } else if (requestContext.inViewState() && requestContext.getViewScope().contains(property)) {
                requestContext.getViewScope().put(property, value);
            } else if (requestContext.getFlowScope().contains(property)) {
                requestContext.getFlowScope().put(property, value);
            } else if (requestContext.getConversationScope().contains(property)) {
                requestContext.getConversationScope().put(property, value);
            } else {
                this.delegate.setProperty(context, target, name, value);
            }
        }

        private BeanFactory getBeanFactory(RequestContext requestContext) {
            ApplicationContext beanFactory = requestContext.getActiveFlow().getApplicationContext();
            return beanFactory != null ? beanFactory : EMPTY_BEAN_FACTORY;
        }
    }
}

