/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Resources;
import com.supermap.data.Size2D;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolFill;
import com.supermap.data.SymbolFillLibrary;
import com.supermap.data.SymbolGroup;
import com.supermap.data.SymbolGroups;
import com.supermap.data.SymbolLine;
import com.supermap.data.SymbolLineLibrary;
import com.supermap.data.SymbolMarker;
import com.supermap.data.SymbolMarkerLibrary;
import com.supermap.data.SymbolType;
import com.supermap.ui.InternalImageIconFactory;
import com.supermap.ui.InternalSymbolLine;
import com.supermap.ui.InternalToolkitControl;
import com.supermap.ui.LabelInfo;
import com.supermap.ui.SymbolBasicInfoPanel;
import com.supermap.ui.SymbolPreViewPanel;
import com.supermap.ui.SymbolSearchPanel;
import com.supermap.ui.SymbolSettingPanel;
import com.supermap.ui.TreeComboBox;
import com.supermap.ui.UIEnvironment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JMenuBar _$42;
    private JMenu _$41;
    private JMenuItem _$40;
    private JMenuItem _$39;
    private JPanel _$38;
    private JPanel _$37;
    private JPanel _$36;
    private JPanel _$35;
    private JPanel _$34;
    private JPanel _$33;
    private JScrollPane _$32;
    private JPanel _$31;
    private JComboBox _$30;
    private SymbolSearchPanel _$29;
    private SymbolPreViewPanel _$28;
    private SymbolSettingPanel _$27;
    private SymbolBasicInfoPanel _$26;
    private Resources _$25;
    private SymbolType _$24;
    private SymbolGroup _$23;
    private SymbolGroup _$22;
    private JTree _$21;
    private static final int _$20 = 510;
    private static final int _$19 = 420;
    private static final int _$18 = 88;
    private static final int _$17 = 87;
    private static final int _$16 = 108;
    private GeoStyle _$15;
    private JLabel _$14;
    private JLabel _$13;
    private boolean _$12 = true;
    private boolean _$11 = false;
    private JFileChooser _$10;
    private JFileChooser _$9;
    private static final int _$8 = 80;
    private static final int _$7 = 85;
    private static final int _$6 = 100;
    private static final int _$5 = 105;
    private SymbolsViewRefresh _$4 = new SymbolsViewRefresh();
    private ArrayList<LabelInfo> _$3;
    private ArrayList<LabelInfo> _$2;
    private Object[] _$1 = null;

    public SymbolPanel() {
        this.setLayout(new BorderLayout());
    }

    public SymbolPanel(Resources resources, GeoStyle geoStyle, SymbolType symbolType) {
        this.setLayout(new BorderLayout());
        this._$24 = symbolType;
        this._$15 = geoStyle;
        this._$25 = resources;
        this._$3 = new ArrayList();
        this._$7();
    }

    private void _$8() {
        if (this._$24.equals((Object)SymbolType.MARKER)) {
            SymbolMarkerLibrary symbolMarkerLibrary = this._$25.getMarkerLibrary();
            this._$23 = symbolMarkerLibrary.getRootGroup();
            if (this._$15.getMarkerSymbolID() > 0) {
                this._$1();
            }
        } else if (this._$24.equals((Object)SymbolType.LINE)) {
            SymbolLineLibrary symbolLineLibrary = this._$25.getLineLibrary();
            this._$23 = symbolLineLibrary.getRootGroup();
            if (this._$15.getMarkerSymbolID() > 5) {
                this._$1();
            }
        } else if (this._$24.equals((Object)SymbolType.FILL)) {
            SymbolFillLibrary symbolFillLibrary = this._$25.getFillLibrary();
            this._$23 = symbolFillLibrary.getRootGroup();
            if (this._$15.getMarkerSymbolID() > 6) {
                this._$1();
            }
        }
    }

    public Resources getResources() {
        return this._$25;
    }

    public void setResources(Resources resources) {
        this._$25 = resources;
        if (this._$24 != null && this._$25 != null && this._$15 != null) {
            this._$7();
        }
    }

    public SymbolType getType() {
        return this._$24;
    }

    public void setType(SymbolType symbolType) {
        this._$24 = symbolType;
        if (this._$24 != null && this._$25 != null && this._$15 != null) {
            this._$7();
        }
    }

    public GeoStyle getStyle() {
        return this._$15;
    }

    public void setStyle(GeoStyle geoStyle) {
        this._$15 = geoStyle;
        if (this._$24 != null && this._$25 != null && this._$15 != null) {
            this._$7();
        }
    }

    protected void SetStyleAndRefresh(GeoStyle geoStyle) {
        this._$15 = geoStyle;
        if (geoStyle != null && this._$24 != null && this._$28 != null) {
            this._$28.refreshPreViewMapControl(this._$24, this._$15);
        }
    }

    private void _$7() {
        this._$8();
        if (this._$11) {
            this.add((Component)this._$6(), "North");
        }
        this.add((Component)this.getViewPanel(), "Center");
        if (this._$30 != null) {
            this.refreshSymbolsViewPanel();
            if (!this._$11) {
                int n = 0;
                if (this._$24.equals((Object)SymbolType.MARKER)) {
                    n = this._$15.getMarkerSymbolID();
                } else if (this._$24.equals((Object)SymbolType.LINE)) {
                    n = this._$15.getLineSymbolID();
                } else if (this._$24.equals((Object)SymbolType.FILL)) {
                    n = this._$15.getFillSymbolID();
                }
                LabelInfo labelInfo = this.getLabelInfoBySymbolID(n);
                this._$26.refreshComboBox(this._$3);
                this._$26.refreshBasicInfo(n, labelInfo.getSymbolName());
                this.changeCurrentLabel(labelInfo.getLabel());
                Rectangle rectangle = this.getCellRect(labelInfo.getRow(), labelInfo.getColumn());
                if (rectangle != null) {
                    this.getPanelSymbolsView().scrollRectToVisible(rectangle);
                }
                this._$28.refreshPreViewMapControl(this._$24, this._$15);
            }
        }
    }

    private JMenuBar _$6() {
        if (this._$42 == null) {
            this._$42 = new JMenuBar();
            this._$42.add(this._$5());
        }
        return this._$42;
    }

    private JMenu _$5() {
        if (this._$41 == null) {
            this._$41 = new JMenu();
            this._$41.setText("\u6587\u4ef6");
            this._$41.add(this._$4());
            this._$41.add(this._$3());
        }
        return this._$41;
    }

    private JMenuItem _$4() {
        if (this._$40 == null) {
            this._$40 = new JMenuItem();
            this._$40.setText("\u5bfc\u5165\u7b26\u53f7\u5e93\u6587\u4ef6");
            this._$40.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = SymbolPanel.this.getFileChooserImportSymFile();
                    int n = jFileChooser.showOpenDialog(null);
                    if (n == 0) {
                        String string = jFileChooser.getSelectedFile().getPath();
                        boolean bl = false;
                        if (SymbolPanel.this._$24.equals((Object)SymbolType.MARKER)) {
                            bl = SymbolPanel.this._$25.getMarkerLibrary().fromFile(string);
                            if (bl) {
                                SymbolPanel.this._$23 = SymbolPanel.this._$25.getMarkerLibrary().getRootGroup();
                                SymbolPanel.this._$1(SymbolPanel.this._$21, SymbolPanel.this._$23);
                                SymbolPanel.this.paintMarkerSymbols();
                            } else {
                                JOptionPane.showMessageDialog(null, "\u5bfc\u5165\u5931\u8d25!", "\u8b66\u544a", 2);
                            }
                        } else if (SymbolPanel.this._$24.equals((Object)SymbolType.LINE)) {
                            bl = SymbolPanel.this._$25.getLineLibrary().fromFile(string);
                            if (bl) {
                                SymbolPanel.this._$23 = SymbolPanel.this._$25.getLineLibrary().getRootGroup();
                                SymbolPanel.this._$1(SymbolPanel.this._$21, SymbolPanel.this._$23);
                                SymbolPanel.this.paintLineSymbols();
                            } else {
                                JOptionPane.showMessageDialog(null, "\u5bfc\u5165\u5931\u8d25!", "\u8b66\u544a", 2);
                            }
                        } else if (SymbolPanel.this._$24.equals((Object)SymbolType.FILL)) {
                            bl = SymbolPanel.this._$25.getFillLibrary().fromFile(string);
                            if (bl) {
                                SymbolPanel.this._$23 = SymbolPanel.this._$25.getFillLibrary().getRootGroup();
                                SymbolPanel.this._$1(SymbolPanel.this._$21, SymbolPanel.this._$23);
                                SymbolPanel.this.paintFillSymbols();
                            } else {
                                JOptionPane.showMessageDialog(null, "\u5bfc\u5165\u5931\u8d25!", "\u8b66\u544a", 2);
                            }
                        }
                    }
                }
            });
        }
        return this._$40;
    }

    private JMenuItem _$3() {
        if (this._$39 == null) {
            this._$39 = new JMenuItem();
            this._$39.setText("\u5bfc\u5165\u6805\u683c\u7b26\u53f7");
            this._$39.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
        }
        return this._$39;
    }

    protected JPanel getViewPanel() {
        if (this._$38 == null) {
            this._$38 = new JPanel();
            this._$38.setLayout(new BorderLayout());
            this._$38.add((Component)this.getNorthPanel(), "North");
            this._$38.add((Component)this.getCenterPanel(), "Center");
            if (!this._$11) {
                this._$38.add((Component)this.getEastPanel(), "East");
            }
        }
        return this._$38;
    }

    protected JPanel getNorthPanel() {
        if (this._$37 == null) {
            this._$37 = new JPanel();
            this._$37.setLayout(new GridLayout(1, 0));
            this._$37.add(this.getSearchTreePanel());
            this._$29 = new SymbolSearchPanel(this);
            this._$37.add(this._$29);
        }
        return this._$37;
    }

    protected JPanel getCenterPanel() {
        if (this._$36 == null) {
            this._$36 = new JPanel(new BorderLayout());
            this._$36.add((Component)this.getSymbolsViewScrollPane(), "Center");
        }
        return this._$36;
    }

    protected JPanel getEastPanel() {
        if (this._$35 == null) {
            this._$35 = new JPanel();
            this._$35.setLayout(new BorderLayout());
            this._$35.add((Component)this.getOperatePanel(), "Center");
        }
        return this._$35;
    }

    protected JPanel getOperatePanel() {
        if (this._$34 == null) {
            this._$34 = new JPanel();
            this._$34.setLayout(new BoxLayout(this._$34, 1));
            this._$26 = new SymbolBasicInfoPanel(this);
            this._$34.add(this._$26);
            this._$28 = new SymbolPreViewPanel(this._$25.getWorkspace(), this._$24);
            this._$28.addMapTrackingLayerDrawingListener();
            this._$34.add(this._$28);
            this._$27 = new SymbolSettingPanel(this, this._$15, this._$24);
            this._$34.add(this._$27);
        }
        return this._$34;
    }

    protected JPanel getSearchTreePanel() {
        if (this._$31 == null) {
            this._$31 = new JPanel();
            this._$31.setLayout(new BorderLayout());
            this._$31.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 0));
            JLabel jLabel = new JLabel();
            jLabel.setText(" \u67e5\u770b\u8303\u56f4\uff1a ");
            this._$31.add((Component)jLabel, "West");
            this._$31.add((Component)this.getSearchTreeComboBox(), "Center");
        }
        return this._$31;
    }

    protected JComboBox getSearchTreeComboBox() {
        if (this._$30 == null) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
            defaultTreeCellRenderer.setClosedIcon(InternalImageIconFactory.RESOURCENODEINVISIBLE);
            defaultTreeCellRenderer.setOpenIcon(InternalImageIconFactory.RESOURCENODEINVISIBLE);
            defaultTreeCellRenderer.setLeafIcon(InternalImageIconFactory.RESOURCENODEINVISIBLE);
            this._$30 = new TreeComboBox(this.getSymbolsTree(), defaultTreeCellRenderer);
        }
        return this._$30;
    }

    protected JTree getSymbolsTree() {
        if (this._$21 == null) {
            this._$21 = new JTree();
            this._$1(this._$21, this._$23);
            if (this._$1 != null && this._$1.length > 1) {
                TreePath treePath = new TreePath(this._$1);
                this._$21.setSelectionPath(treePath);
            }
            this._$21.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    SymbolPanel.this.refreshSymbolsViewPanel();
                    SymbolPanel.this._$26.refreshComboBox(SymbolPanel.this._$3);
                }
            });
            this._$21.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        SymbolPanel.this.refreshSymbolsViewPanel();
                        SymbolPanel.this._$26.refreshComboBox(SymbolPanel.this._$3);
                    }
                }
            });
        }
        return this._$21;
    }

    protected JScrollPane getSymbolsViewScrollPane() {
        if (this._$32 == null) {
            this._$32 = new JScrollPane();
            JScrollBar jScrollBar = this._$32.getVerticalScrollBar();
            jScrollBar.setUnitIncrement(jScrollBar.getMaximum() / 15);
            this._$32.setPreferredSize(new Dimension(500, 400));
            this._$32.setMinimumSize(new Dimension(500, 400));
            this._$32.setViewportView(this.getPanelSymbolsView());
            this._$32.setHorizontalScrollBarPolicy(31);
            this._$32.setVerticalScrollBarPolicy(22);
        }
        return this._$32;
    }

    protected JPanel getPanelSymbolsView() {
        if (this._$33 == null) {
            this._$33 = new JPanel();
            this._$33.setBackground(Color.white);
            this._$33.setLayout(new FlowLayout(0));
            this._$33.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    LabelInfo labelInfo = SymbolPanel.this._$2();
                    if (labelInfo == null) {
                        return;
                    }
                    if (keyEvent.getKeyCode() == 37) {
                        SymbolPanel.this.changeCurrentLabel(SymbolPanel.this._$1(labelInfo.getRow(), labelInfo.getColumn() - 1));
                    } else if (keyEvent.getKeyCode() == 39) {
                        SymbolPanel.this.changeCurrentLabel(SymbolPanel.this._$1(labelInfo.getRow(), labelInfo.getColumn() + 1));
                    } else if (keyEvent.getKeyCode() == 38) {
                        SymbolPanel.this.changeCurrentLabel(SymbolPanel.this._$1(labelInfo.getRow() - 1, labelInfo.getColumn()));
                        Rectangle rectangle = SymbolPanel.this.getCellRect(labelInfo.getRow() - 1, labelInfo.getColumn());
                        if (rectangle != null) {
                            SymbolPanel.this._$33.scrollRectToVisible(rectangle);
                        }
                    } else if (keyEvent.getKeyCode() == 40) {
                        SymbolPanel.this.changeCurrentLabel(SymbolPanel.this._$1(labelInfo.getRow() + 1, labelInfo.getColumn()));
                        Rectangle rectangle = SymbolPanel.this.getCellRect(labelInfo.getRow() + 1, labelInfo.getColumn());
                        if (rectangle != null) {
                            SymbolPanel.this._$33.scrollRectToVisible(rectangle);
                        }
                    }
                }
            });
        }
        return this._$33;
    }

    protected void refreshSymbolsViewPanel() {
        Object[] objectArray = this._$21.getSelectionPath().getPath();
        this._$22 = this.getSymbolGroup(objectArray);
        if (this._$24.equals((Object)SymbolType.MARKER)) {
            this.paintMarkerSymbols();
        } else if (this._$24.equals((Object)SymbolType.LINE)) {
            this.paintLineSymbols();
        } else if (this._$24.equals((Object)SymbolType.FILL)) {
            this.paintFillSymbols();
        }
        if (this._$2 != null) {
            this._$2.clear();
        }
        this._$2 = (ArrayList)this._$3.clone();
    }

    protected SymbolGroup getSymbolGroup(Object[] objectArray) {
        int n = objectArray.length;
        SymbolGroup symbolGroup = this._$23;
        for (int i = 1; i < n; ++i) {
            symbolGroup = symbolGroup.getChildGroups().get(objectArray[i].toString());
        }
        return symbolGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintMarkerSymbols() {
        JPanel jPanel = this.getPanelSymbolsView();
        try {
            int n = 48;
            int n2 = 48;
            jPanel.removeAll();
            int n3 = this._$22.getCount();
            int n4 = 0;
            this._$3.clear();
            GeoPoint geoPoint = this.getPaintPoint();
            int n5 = 6;
            if (this._$22.equals(this._$23)) {
                LabelInfo labelInfo;
                JLabel jLabel;
                Object object;
                BufferedImage bufferedImage;
                int n6;
                for (n6 = 0; n6 < 1; ++n6) {
                    bufferedImage = new BufferedImage(n, n2 - 4, 2);
                    geoPoint.getStyle().setMarkerSymbolID(n6);
                    InternalToolkitControl.internalDraw((Geometry)geoPoint, this._$25, bufferedImage.getGraphics());
                    object = "System " + n6;
                    jLabel = this.getSymbolLabel((String)object, bufferedImage);
                    jLabel.setName(String.valueOf(n6));
                    if (n6 != 0 && n6 % n5 == 0) {
                        ++n4;
                    }
                    jPanel.setPreferredSize(new Dimension(510, (n4 + 1) * 88));
                    jPanel.add(jLabel);
                    labelInfo = new LabelInfo(jLabel, n4, n6 % n5, n6, (String)object);
                    this._$3.add(labelInfo);
                }
                for (n6 = 1; n6 < n3 + 1; ++n6) {
                    bufferedImage = this._$22.get(n6 - 1);
                    object = this.getSymbolMarkerBufferdImage(n, n2, (SymbolMarker)bufferedImage, geoPoint);
                    jLabel = this.getSymbolLabel(bufferedImage.getName(), (BufferedImage)object);
                    jLabel.setName(String.valueOf(bufferedImage.getID()));
                    if (n6 % n5 == 0) {
                        ++n4;
                    }
                    jPanel.setPreferredSize(new Dimension(510, (n4 + 1) * 88));
                    jPanel.add(jLabel);
                    labelInfo = new LabelInfo(jLabel, n4, n6 % n5, bufferedImage.getID(), bufferedImage.getName());
                    this._$3.add(labelInfo);
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    Symbol symbol = this._$22.get(i);
                    BufferedImage bufferedImage = this.getSymbolMarkerBufferdImage(n, n2, (SymbolMarker)symbol, geoPoint);
                    JLabel jLabel = this.getSymbolLabel(symbol.getName(), bufferedImage);
                    jLabel.setName(String.valueOf(symbol.getID()));
                    if (i != 0 && i % n5 == 0) {
                        ++n4;
                    }
                    jPanel.setPreferredSize(new Dimension(510, (n4 + 1) * 88));
                    jPanel.add(jLabel);
                    LabelInfo labelInfo = new LabelInfo(jLabel, n4, i % n5, symbol.getID(), symbol.getName());
                    this._$3.add(labelInfo);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        finally {
            this._$26.refreshComboBox(this._$3);
            jPanel.getParent().validate();
            jPanel.getParent().repaint();
            jPanel.validate();
            jPanel.repaint();
        }
    }

    protected BufferedImage getSymbolMarkerBufferdImage(int n, int n2, SymbolMarker symbolMarker, GeoPoint geoPoint) {
        BufferedImage bufferedImage = new BufferedImage(n, n2 - 4, 2);
        Point point = symbolMarker.getOrigin();
        int n3 = point.x * n / UIEnvironment.g_symbolPointMax;
        int n4 = point.y * n2 / UIEnvironment.g_symbolPointMax;
        geoPoint.setX((double)n3);
        geoPoint.setY((double)n4);
        geoPoint.getStyle().setMarkerSymbolID(symbolMarker.getID());
        InternalToolkitControl.internalDraw((Geometry)geoPoint, this._$25, bufferedImage.getGraphics());
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintLineSymbols() {
        JPanel jPanel = this.getPanelSymbolsView();
        try {
            int n = 64;
            int n2 = 64;
            jPanel.removeAll();
            int n3 = this._$22.getCount();
            int n4 = 0;
            this._$3.clear();
            GeoLine geoLine = this.getPaintLine();
            int n5 = 6;
            if (this._$22.equals(this._$23)) {
                Object object;
                Object object2;
                Object object3;
                BufferedImage bufferedImage;
                int n6;
                for (n6 = 0; n6 < 6; ++n6) {
                    bufferedImage = new BufferedImage(n, n2 - 8, 2);
                    geoLine.getStyle().setLineSymbolID(n6);
                    InternalToolkitControl.internalDraw((Geometry)geoLine, this._$25, bufferedImage.getGraphics());
                    object3 = "System " + n6;
                    if (n6 == 5) {
                        object2 = bufferedImage.getGraphics();
                        object = new Font("Dialog", 0, 14);
                        ((Graphics)object2).setFont((Font)object);
                        ((Graphics)object2).setColor(new Color(13, 80, 143));
                        ((Graphics)object2).drawString("NULL", 16, 38);
                    }
                    object2 = this.getSymbolLabel((String)object3, bufferedImage);
                    ((Component)object2).setName(String.valueOf(n6));
                    if (n6 != 0 && n6 % n5 == 0) {
                        ++n4;
                    }
                    jPanel.setPreferredSize(new Dimension(510, (n4 + 1) * 87));
                    jPanel.add((Component)object2);
                    object = new LabelInfo((JLabel)object2, n4, n6 % n5, n6, (String)object3);
                    this._$3.add((LabelInfo)object);
                }
                for (n6 = 6; n6 < n3 + 6; ++n6) {
                    bufferedImage = this._$22.get(n6 - 6);
                    object3 = this.getSymbolLineBufferedImage(n, n2, (SymbolLine)bufferedImage, geoLine);
                    object2 = this.getSymbolLabel(bufferedImage.getName(), (BufferedImage)object3);
                    ((Component)object2).setName(String.valueOf(bufferedImage.getID()));
                    if (n6 % n5 == 0) {
                        ++n4;
                    }
                    jPanel.setPreferredSize(new Dimension(510, (n4 + 1) * 87));
                    jPanel.add((Component)object2);
                    object = new LabelInfo((JLabel)object2, n4, n6 % n5, bufferedImage.getID(), bufferedImage.getName());
                    this._$3.add((LabelInfo)object);
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    Symbol symbol = this._$22.get(i);
                    BufferedImage bufferedImage = this.getSymbolLineBufferedImage(n, n2, (SymbolLine)symbol, geoLine);
                    JLabel jLabel = this.getSymbolLabel(symbol.getName(), bufferedImage);
                    jLabel.setName(String.valueOf(symbol.getID()));
                    if (i != 0 && i % n5 == 0) {
                        ++n4;
                    }
                    jPanel.setPreferredSize(new Dimension(510, (n4 + 1) * 87));
                    jPanel.add(jLabel);
                    LabelInfo labelInfo = new LabelInfo(jLabel, n4, i % n5, symbol.getID(), symbol.getName());
                    this._$3.add(labelInfo);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        finally {
            this._$26.refreshComboBox(this._$3);
            jPanel.getParent().validate();
            jPanel.getParent().repaint();
            jPanel.validate();
            jPanel.repaint();
        }
    }

    protected BufferedImage getSymbolLineBufferedImage(int n, int n2, SymbolLine symbolLine, GeoLine geoLine) {
        BufferedImage bufferedImage = new BufferedImage(n, n2 - 8, 2);
        geoLine.getStyle().setLineSymbolID(symbolLine.getID());
        InternalSymbolLine.internalDraw(symbolLine, bufferedImage.getGraphics(), (Geometry)geoLine);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintFillSymbols() {
        JPanel jPanel = this.getPanelSymbolsView();
        try {
            int n = 80;
            int n2 = 80;
            jPanel.removeAll();
            int n3 = this._$22.getCount();
            int n4 = 0;
            this._$3.clear();
            GeoRegion geoRegion = this.getPaintRegion();
            int n5 = 4;
            if (this._$22.equals(this._$23)) {
                Object object;
                Object object2;
                Object object3;
                BufferedImage bufferedImage;
                int n6;
                for (n6 = 0; n6 < 7; ++n6) {
                    bufferedImage = new BufferedImage(n, n2 - 2, 2);
                    geoRegion.getStyle().setFillSymbolID(n6);
                    InternalToolkitControl.internalDraw((Geometry)geoRegion, this._$25, bufferedImage.getGraphics());
                    object3 = "System " + n6;
                    if (n6 == 1) {
                        object2 = bufferedImage.getGraphics();
                        object = new Font("Dialog", 0, 14);
                        ((Graphics)object2).setFont((Font)object);
                        ((Graphics)object2).setColor(new Color(13, 80, 143));
                        ((Graphics)object2).drawString("NULL", 25, 45);
                    }
                    object2 = this.getSymbolLabelForRegion((String)object3, bufferedImage);
                    ((Component)object2).setName(String.valueOf(n6));
                    if (n6 != 0 && n6 % n5 == 0) {
                        ++n4;
                    }
                    jPanel.setPreferredSize(new Dimension(420, (n4 + 1) * 108));
                    jPanel.add((Component)object2);
                    object = new LabelInfo((JLabel)object2, n4, n6 % n5, n6, (String)object3);
                    this._$3.add((LabelInfo)object);
                }
                for (n6 = 7; n6 < n3 + 7; ++n6) {
                    bufferedImage = this._$22.get(n6 - 7);
                    object3 = this.getSymbolFillBufferedImage(n, n2, (SymbolFill)bufferedImage, geoRegion);
                    object2 = this.getSymbolLabelForRegion(bufferedImage.getName(), (BufferedImage)object3);
                    ((Component)object2).setName(String.valueOf(bufferedImage.getID()));
                    if (n6 % n5 == 0) {
                        ++n4;
                    }
                    jPanel.setPreferredSize(new Dimension(420, (n4 + 1) * 108));
                    jPanel.add((Component)object2);
                    object = new LabelInfo((JLabel)object2, n4, n6 % n5, bufferedImage.getID(), bufferedImage.getName());
                    this._$3.add((LabelInfo)object);
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    Symbol symbol = this._$22.get(i);
                    BufferedImage bufferedImage = this.getSymbolFillBufferedImage(n, n2, (SymbolFill)symbol, geoRegion);
                    JLabel jLabel = this.getSymbolLabelForRegion(symbol.getName(), bufferedImage);
                    jLabel.setName(String.valueOf(symbol.getID()));
                    if (i != 0 && i % n5 == 0) {
                        ++n4;
                    }
                    jPanel.setPreferredSize(new Dimension(420, (n4 + 1) * 108));
                    jPanel.add(jLabel);
                    LabelInfo labelInfo = new LabelInfo(jLabel, n4, i % n5, symbol.getID(), symbol.getName());
                    this._$3.add(labelInfo);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        finally {
            this._$26.refreshComboBox(this._$3);
            jPanel.getParent().validate();
            jPanel.getParent().repaint();
            jPanel.validate();
            jPanel.repaint();
        }
    }

    protected BufferedImage getSymbolFillBufferedImage(int n, int n2, SymbolFill symbolFill, GeoRegion geoRegion) {
        BufferedImage bufferedImage = new BufferedImage(n, n2 - 2, 2);
        geoRegion.getStyle().setFillSymbolID(symbolFill.getID());
        InternalToolkitControl.internalDraw((Geometry)geoRegion, this._$25, bufferedImage.getGraphics());
        return bufferedImage;
    }

    protected JLabel getSymbolLabel(String string, BufferedImage bufferedImage) {
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        JLabel jLabel = new JLabel(string, imageIcon, 0);
        jLabel.setVerticalTextPosition(3);
        jLabel.setHorizontalTextPosition(0);
        jLabel.setPreferredSize(new Dimension(80, 80));
        jLabel.setBackground(Color.WHITE);
        jLabel.addMouseListener(this._$4);
        return jLabel;
    }

    protected JLabel getSymbolLabelForRegion(String string, BufferedImage bufferedImage) {
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        JLabel jLabel = new JLabel(string, imageIcon, 0);
        jLabel.setVerticalTextPosition(3);
        jLabel.setHorizontalTextPosition(0);
        jLabel.setPreferredSize(new Dimension(100, 100));
        jLabel.setBackground(Color.WHITE);
        jLabel.addMouseListener(new SymbolsViewRefresh());
        return jLabel;
    }

    private void _$1(JTree jTree, SymbolGroup symbolGroup) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(symbolGroup.getName());
        this._$1(defaultMutableTreeNode, symbolGroup);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        jTree.setModel(defaultTreeModel);
        jTree.setSelectionRow(0);
    }

    private void _$1(DefaultMutableTreeNode defaultMutableTreeNode, SymbolGroup symbolGroup) {
        SymbolGroups symbolGroups = symbolGroup.getChildGroups();
        for (int i = 0; i < symbolGroups.getCount(); ++i) {
            SymbolGroup symbolGroup2 = symbolGroups.get(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(symbolGroup2.getName());
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (symbolGroup2.getChildGroups() == null || symbolGroup2.getChildGroups().getCount() <= 0) continue;
            this._$1(defaultMutableTreeNode2, symbolGroup2);
        }
    }

    protected GeoPoint getPaintPoint() {
        GeoPoint geoPoint = new GeoPoint(24.0, 24.0);
        GeoStyle geoStyle = new GeoStyle();
        geoStyle.setMarkerSize(new Size2D(4.0, 4.0));
        geoStyle.setLineColor(new Color(13, 80, 143));
        geoPoint.setStyle(geoStyle);
        return geoPoint;
    }

    protected GeoLine getPaintLine() {
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(new Point2D(5.0, 32.0));
        point2Ds.add(new Point2D(60.0, 32.0));
        GeoLine geoLine = new GeoLine(point2Ds);
        GeoStyle geoStyle = new GeoStyle();
        geoStyle.setLineColor(new Color(13, 80, 143));
        geoStyle.setLineWidth(0.2);
        geoLine.setStyle(geoStyle);
        return geoLine;
    }

    protected GeoRegion getPaintRegion() {
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(new Point2D(5.0, 5.0));
        point2Ds.add(new Point2D(5.0, 75.0));
        point2Ds.add(new Point2D(75.0, 75.0));
        point2Ds.add(new Point2D(75.0, 5.0));
        GeoRegion geoRegion = new GeoRegion(point2Ds);
        GeoStyle geoStyle = new GeoStyle();
        geoStyle.setFillForeColor(new Color(13, 80, 143));
        geoStyle.setLineWidth(0.1);
        geoRegion.setStyle(geoStyle);
        return geoRegion;
    }

    protected ArrayList<LabelInfo> getLabelInfoArray() {
        return this._$3;
    }

    protected ArrayList<LabelInfo> getAllLabelInfo() {
        return this._$2;
    }

    protected LabelInfo getLabelInfoBySymbolID(int n) {
        LabelInfo labelInfo = null;
        for (int i = 0; i < this._$3.size(); ++i) {
            LabelInfo labelInfo2 = this._$3.get(i);
            int n2 = labelInfo2.getSymbolID();
            if (n2 != n) continue;
            labelInfo = labelInfo2;
            break;
        }
        return labelInfo;
    }

    protected LabelInfo getLabelInfoBySymbolName(String string) {
        LabelInfo labelInfo = null;
        for (int i = 0; i < this._$3.size(); ++i) {
            LabelInfo labelInfo2 = this._$3.get(i);
            String string2 = labelInfo2.getSymbolName();
            if (!string2.equals(string)) continue;
            labelInfo = labelInfo2;
            break;
        }
        return labelInfo;
    }

    protected void setSymbolLibraryPanel(boolean bl) {
        this._$11 = bl;
    }

    protected JFileChooser getFileChooserImportSymFile() {
        return this._$10;
    }

    protected JFileChooser getFileChooserImportGridSymbol() {
        return this._$10;
    }

    protected SymbolGroup getRootGroup() {
        return this._$23;
    }

    protected Rectangle getCellRect(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        Rectangle rectangle = new Rectangle();
        if (this._$24.equals((Object)SymbolType.MARKER) || this._$24.equals((Object)SymbolType.LINE)) {
            rectangle.height = 85;
            rectangle.y = 85 * n;
            rectangle.width = 80;
            rectangle.x = 80 * n2;
        } else {
            rectangle.height = 105;
            rectangle.y = 105 * n;
            rectangle.width = 100;
            rectangle.x = 100 * n2;
        }
        rectangle.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return rectangle;
    }

    private JLabel _$1(int n, int n2) {
        JLabel jLabel = null;
        for (int i = 0; i < this._$3.size(); ++i) {
            LabelInfo labelInfo = this._$3.get(i);
            if (labelInfo.getRow() != n || labelInfo.getColumn() != n2) continue;
            jLabel = labelInfo.getLabel();
            break;
        }
        return jLabel;
    }

    private LabelInfo _$2() {
        LabelInfo labelInfo = null;
        if (this._$14 != null) {
            for (int i = 0; i < this._$3.size(); ++i) {
                LabelInfo labelInfo2 = this._$3.get(i);
                if (!this._$14.equals(labelInfo2.getLabel())) continue;
                labelInfo = labelInfo2;
                break;
            }
        }
        return labelInfo;
    }

    private void _$1() {
        int n = 1;
        int n2 = 0;
        SymbolMarkerLibrary symbolMarkerLibrary = this._$25.getMarkerLibrary();
        SymbolGroup symbolGroup = symbolMarkerLibrary.findGroup(this._$15.getMarkerSymbolID());
        Stack<String> stack = new Stack<String>();
        stack.push(symbolGroup.getName());
        while (symbolGroup.getParent() != null) {
            symbolGroup = symbolGroup.getParent();
            stack.push(symbolGroup.getName());
            ++n;
        }
        this._$1 = new Object[n];
        while (!stack.empty()) {
            this._$1[n2] = new DefaultMutableTreeNode(stack.pop());
            ++n2;
        }
    }

    protected void changeCurrentLabel(JLabel jLabel) {
        if (jLabel == null) {
            return;
        }
        this._$14 = jLabel;
        this._$14.setBorder(BorderFactory.createLineBorder(new Color(255, 0, 0), 1));
        if (this._$13 != null && !this._$14.equals(this._$13)) {
            this._$13.setBorder(null);
        }
        this._$13 = this._$14;
        if (!this._$11) {
            int n = Integer.valueOf(jLabel.getName());
            if (this._$24.equals((Object)SymbolType.MARKER)) {
                this._$15.setMarkerSymbolID(n);
            } else if (this._$24.equals((Object)SymbolType.LINE)) {
                this._$15.setLineSymbolID(n);
            } else if (this._$24.equals((Object)SymbolType.FILL)) {
                this._$15.setFillSymbolID(n);
            }
            this._$28.refreshPreViewMapControl(this._$24, this._$15);
            LabelInfo labelInfo = this.getLabelInfoBySymbolID(n);
            this._$26.refreshBasicInfo(n, labelInfo.getSymbolName());
        }
    }

    SymbolBasicInfoPanel getSymbolBasicInfoPanel() {
        return this._$26;
    }

    class SymbolsViewRefresh
    extends MouseAdapter {
        SymbolsViewRefresh() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            try {
                JLabel jLabel = (JLabel)mouseEvent.getSource();
                this.refreshSymbolLabel(jLabel);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected void refreshSymbolLabel(JLabel jLabel) {
            SymbolPanel.this._$33.requestFocus();
            SymbolPanel.this._$33.requestFocusInWindow();
            SymbolPanel.this.changeCurrentLabel(jLabel);
            if (!SymbolPanel.this._$11 && SymbolPanel.this._$12) {
                SymbolPanel.this._$28.removeMapTrackingLayerDrawingListener();
                SymbolPanel.this._$12 = false;
            }
        }
    }
}

