/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.GeoModel;
import com.supermap.realspace.FlyEventType;
import com.supermap.realspace.FlyManager;
import com.supermap.realspace.FlyManagerNative;
import com.supermap.realspace.InternalGeoModel;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.PropertiesChangedEvent;
import com.supermap.realspace.Route;
import com.supermap.realspace.RoutesNative;
import com.supermap.realspace.Scene;
import java.util.ArrayList;

public class Routes
extends InternalHandle {
    FlyManager m_flyManager;
    ArrayList<Route> m_routes;
    GeoModel m_geoModel = null;

    protected Routes(FlyManager flyManager) {
        long l = FlyManagerNative.jni_GetRoutesHandle(InternalHandle.getHandle((com.supermap.data.InternalHandle)flyManager));
        this.setHandle(l);
        this.m_routes = new ArrayList();
        this.m_flyManager = flyManager;
        this._$3();
    }

    private void _$3() {
        int n;
        int n2 = this.getCount();
        for (n = 0; n < n2; ++n) {
            long l = RoutesNative.jni_Get(this.getHandle(), n);
            Route route = new Route(l);
            route.m_flyManager = this.m_flyManager;
            this.m_routes.add(route);
        }
        n = this.m_routes.size();
        if (n > 0) {
            this.setCurrentRouteIndex(n - 1);
        }
    }

    private void _$2() {
        if (this.m_routes != null) {
            this.m_routes.clear();
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RoutesNative.jni_GetCount(this.getHandle());
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("indexOf", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("indexOf", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            int n2 = this.getCount();
            for (int i = 0; i < n2; ++i) {
                if (!string.equalsIgnoreCase(this.get(i).getName())) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public Route get(String string) {
        return this.get(this.indexOf(string));
    }

    public Route get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("get", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Route route = this.m_routes.get(n);
        route.m_flyManager = this.m_flyManager;
        return route;
    }

    public void set(String string, Route route) {
        this.set(this.indexOf(string), route);
    }

    public void set(int n, Route route) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("set", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (route == null) {
            String string = InternalResource.loadString("set", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)route);
        RoutesNative.jni_Set(this.getHandle(), n, l);
        this.m_routes.set(n, route);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    private GeoModel _$1() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFollowModel", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoModel == null && (l = RoutesNative.jni_GetFollowModel(this.getHandle())) != 0L) {
            this.m_geoModel = InternalGeoModel.createInstance(l);
        }
        return this.m_geoModel;
    }

    private void _$1(GeoModel geoModel) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFollowModel", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel);
        RoutesNative.jni_SetFollowModel(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoModel);
    }

    public double getCameraDistanceX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraDistanceX()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RoutesNative.jni_GetCameraDistanceX(this.getHandle());
    }

    public void setCameraDistanceX(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraDistanceX(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "Argument_ShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        RoutesNative.jni_SetCameraDistanceX(this.getHandle(), d);
    }

    public double getCameraDistanceY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraDistanceY()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RoutesNative.jni_GetCameraDistanceY(this.getHandle());
    }

    public void setCameraDistanceY(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraDistanceY(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "Argument_ShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        RoutesNative.jni_SetCameraDistanceY(this.getHandle(), d);
    }

    public double getCameraDistanceZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraDistanceZ()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RoutesNative.jni_GetCameraDistanceZ(this.getHandle());
    }

    public void setCameraDistanceZ(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraDistanceZ(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "Argument_ShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        RoutesNative.jni_SetCameraDistanceZ(this.getHandle(), d);
    }

    public int getCurrentRouteIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentRouteIndex", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RoutesNative.jni_GetCurrentRouteIndex(this.getHandle());
    }

    public Route getCurrentRoute() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentRoute()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (0 == this.m_routes.size()) {
            Route route = new Route();
            RoutesNative.jni_Add(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)route));
            this._$3();
        }
        return this.m_routes.get(this.getCurrentRouteIndex());
    }

    public void setCurrentRouteIndex(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCurrentRouteIndex", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("setCurrentRouteIndex", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        RoutesNative.jni_SetCurrentRouteIndex(this.getHandle(), n);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.CURRENT_ROUTE_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public boolean contains(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("contains", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        return this.indexOf(string) != -1;
    }

    public int add(Route route) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (route == null) {
            String string = InternalResource.loadString("add", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        String string = route.getName();
        if (this.contains(string)) {
            String string2 = InternalResource.loadString("add", "Route_IsAlreadyExist", "realspace_resources");
            throw new IllegalArgumentException(string2);
        }
        Route route2 = new Route(route);
        int n = -1;
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)route2);
        if (l != 0L && (n = RoutesNative.jni_Add(this.getHandle(), l)) != -1) {
            this.m_routes.add(route2);
            if (this.m_flyManager != null) {
                Scene scene = this.m_flyManager.getScene();
                route2.setScene(scene);
                route2.m_flyManager = this.m_flyManager;
                route.m_flyManager = this.m_flyManager;
                PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_COUNT_CHANGED);
                this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
            }
        }
        return n;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("remove", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Route route = this.get(n);
        if (route == null) {
            String string = InternalResource.loadString("remove", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)route) == 0L) {
            String string = InternalResource.loadString("remove", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = RoutesNative.jni_Remove(this.getHandle(), n);
        if (bl) {
            this.m_routes.remove(n);
            route.clearHandle();
        }
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        return bl;
    }

    public boolean remove(String string) {
        int n = this.indexOf(string);
        return this.remove(n);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RoutesNative.jni_Clear(this.getHandle());
        this._$2();
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RoutesNative.jni_ToXML(this.getHandle());
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromXML", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("fromXML", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = RoutesNative.jni_FromXML(this.getHandle(), string);
        if (bl) {
            this.clear();
            this._$3();
        }
        this.m_routes.get(this.getCurrentRouteIndex()).setScene(this.m_flyManager.getScene());
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        return bl;
    }

    public void toFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("toFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("toFile", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        RoutesNative.jni_ToFile(this.getHandle(), string);
    }

    public boolean fromFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("fromFile", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = RoutesNative.jni_FromFile(this.getHandle(), string);
        if (bl) {
            this._$2();
            this._$3();
            this.m_routes.get(this.getCurrentRouteIndex()).setScene(this.m_flyManager.getScene());
        }
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        return bl;
    }

    protected void finalize() throws Throwable {
        if (this.getHandle() != 0L) {
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
        int n = this.m_routes.size();
        for (int i = 0; i < n; ++i) {
            Route route = this.m_routes.get(i);
            route.clearHandle();
        }
    }
}

