/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import com.supermap.ConsoleRuner;
import com.supermap.LicenseConnectMode;
import com.supermap.LicenseFeatureInfo;
import com.supermap.LicenseHaspInstance;
import com.supermap.LicenseVerifyFailedEvent;
import com.supermap.LicenseVerifyFailedListener;
import com.supermap.LicenseWrapInstance;
import com.supermap.ProductType;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class License {
    static String PROGRAM_PATH = "C:/Program Files/Common Files/SuperMap/License/";
    static String OPT_PATH = "/opt/SuperMap/License/";
    static String CONNECTION_CONFIG_FILE_NAME = "LICENSECONNECT.XML";
    private static String g_UGOBasePath;
    private LicenseHaspInstance m_licHasp;
    private LicenseWrapInstance m_licWrap;
    static Boolean g_debug;
    static int SuperMap_License_Error_Cannot_Find_LicenseInstance;

    static {
        SuperMap_License_Error_Cannot_Find_LicenseInstance = 4000;
        g_debug = false;
        g_UGOBasePath = "";
    }

    public static void main(String[] args) {
        String task = "";
        if (args.length > 0) {
            task = args[0].trim().toLowerCase();
            String[] runerArgs = new String[]{""};
            if (args.length > 1) {
                runerArgs = new String[args.length - 1];
                int i = 0;
                while (i < runerArgs.length) {
                    runerArgs[i] = args[i + 1];
                    ++i;
                }
            }
        }
        ConsoleRuner.run(task, args);
    }

    public License() {
        if (LicenseWrapInstance.findAndReadLicFile()) {
            this.m_licWrap = new LicenseWrapInstance();
        } else if (System.getProperty("os.name").toLowerCase().indexOf("aix") == -1) {
            this.m_licHasp = new LicenseHaspInstance();
        }
    }

    public void dispose() {
        if (this.m_licHasp != null) {
            this.m_licHasp.dispose();
        }
        if (this.m_licWrap != null) {
            this.m_licWrap.dispose();
        }
    }

    public int connect(ProductType product) {
        return this.connect(product.getUGCValue());
    }

    public int connect(int featureID) {
        int code = SuperMap_License_Error_Cannot_Find_LicenseInstance;
        if (this.m_licWrap != null) {
            code = this.m_licWrap.connect(featureID);
        }
        if (this.m_licHasp != null) {
            code = this.m_licHasp.connect(featureID);
        }
        return code;
    }

    public int verify() {
        int code = SuperMap_License_Error_Cannot_Find_LicenseInstance;
        if (this.m_licWrap != null) {
            code = this.m_licWrap.verify();
        }
        if (this.m_licHasp != null && code != 0) {
            code = this.m_licHasp.verify();
        }
        return code;
    }

    public LicenseFeatureInfo getFeatureInfo() {
        LicenseFeatureInfo result = null;
        if (this.m_licWrap != null) {
            result = this.m_licWrap.getFeatureInfo();
        } else if (this.m_licHasp != null) {
            result = this.m_licHasp.getFeatureInfo();
        }
        return result;
    }

    public void disconnect() {
        if (this.m_licHasp != null) {
            this.m_licHasp.disconnect();
        }
        if (this.m_licWrap != null) {
            this.m_licWrap.disconnect();
        }
    }

    public String getUser() {
        String user = "";
        if (this.m_licWrap != null) {
            user = this.m_licWrap.getUser();
        } else if (this.m_licHasp != null) {
            user = this.m_licHasp.getUser();
        }
        return user;
    }

    public String getCompany() {
        String company = "";
        if (this.m_licWrap != null) {
            company = this.m_licWrap.getCompany();
        } else if (this.m_licHasp != null) {
            company = this.m_licHasp.getCompany();
        }
        return company;
    }

    public static String getLicenseConnectServer() {
        return LicenseHaspInstance.getLicenseConnectServer();
    }

    public static void setLicenseConnectServer(String value) {
        LicenseHaspInstance.setLicenseConnectServer(value);
    }

    public static LicenseConnectMode getLicenseConnectMode() {
        return LicenseHaspInstance.getLicenseConnectMode();
    }

    public static void setLicenseConnectMode(LicenseConnectMode value) {
        LicenseHaspInstance.setLicenseConnectMode(value);
    }

    public static String getSpecifyLicenseFilePath() {
        return LicenseWrapInstance.getSpecifyLicenseFilePath();
    }

    public static void setSpecifyLicenseFilePath(String value) {
        LicenseWrapInstance.setSpecifyLicenseFilePath(value);
    }

    public static String getUGOBasePath() {
        return g_UGOBasePath;
    }

    public static void setUGOBasePath(String value) {
        g_UGOBasePath = value;
    }

    public static String getErrorMessage(int code) {
        String errorMessage = "";
        switch (code) {
            case 0: {
                errorMessage = "ok";
                break;
            }
            case 1: {
                errorMessage = "hasp_mem_range";
                break;
            }
            case 2: {
                errorMessage = "hasp_inv_prognum_opt";
                break;
            }
            case 3: {
                errorMessage = "hasp_insuf_mem";
                break;
            }
            case 4: {
                errorMessage = "hasp_tmof";
                break;
            }
            case 5: {
                errorMessage = "hasp_access_denied";
                break;
            }
            case 6: {
                errorMessage = "hasp_incompat_feature";
                break;
            }
            case 7: {
                errorMessage = "hasp_container_not_found";
                break;
            }
            case 8: {
                errorMessage = "hasp_too_short";
                break;
            }
            case 9: {
                errorMessage = "hasp_inv_hnd";
                break;
            }
            case 10: {
                errorMessage = "hasp_inv_fileid";
                break;
            }
            case 11: {
                errorMessage = "hasp_old_driver";
                break;
            }
            case 12: {
                errorMessage = "hasp_no_time";
                break;
            }
            case 13: {
                errorMessage = "hasp_sys_err";
                break;
            }
            case 14: {
                errorMessage = "hasp_no_driver";
                break;
            }
            case 15: {
                errorMessage = "hasp_inv_format";
                break;
            }
            case 16: {
                errorMessage = "hasp_req_not_supp";
                break;
            }
            case 17: {
                errorMessage = "hasp_inv_update_obj";
                break;
            }
            case 18: {
                errorMessage = "hasp_keyid_not_found";
                break;
            }
            case 19: {
                errorMessage = "hasp_inv_update_data";
                break;
            }
            case 20: {
                errorMessage = "hasp_inv_update_notsupp";
                break;
            }
            case 21: {
                errorMessage = "hasp_inv_update_cntr";
                break;
            }
            case 22: {
                errorMessage = "hasp_inv_vcode";
                break;
            }
            case 23: {
                errorMessage = "hasp_enc_not_supp";
                break;
            }
            case 24: {
                errorMessage = "hasp_inv_time";
                break;
            }
            case 25: {
                errorMessage = "hasp_no_battery_power";
                break;
            }
            case 26: {
                errorMessage = "hasp_no_ack_space";
                break;
            }
            case 27: {
                errorMessage = "hasp_ts_detected";
                break;
            }
            case 28: {
                errorMessage = "hasp_feature_type_not_impl";
                break;
            }
            case 29: {
                errorMessage = "hasp_unknown_alg";
                break;
            }
            case 30: {
                errorMessage = "hasp_inv_sig";
                break;
            }
            case 31: {
                errorMessage = "hasp_feature_not_found";
                break;
            }
            case 32: {
                errorMessage = "hasp_no_log";
                break;
            }
            case 33: {
                errorMessage = "hasp_local_comm_err";
                break;
            }
            case 34: {
                errorMessage = "hasp_unknown_vcode";
                break;
            }
            case 35: {
                errorMessage = "hasp_inv_spec";
                break;
            }
            case 36: {
                errorMessage = "hasp_inv_scope";
                break;
            }
            case 37: {
                errorMessage = "hasp_too_many_keys";
                break;
            }
            case 38: {
                errorMessage = "hasp_too_many_users";
                break;
            }
            case 39: {
                errorMessage = "hasp_broken_session";
                break;
            }
            case 40: {
                errorMessage = "hasp_remote_comm_err";
                break;
            }
            case 41: {
                errorMessage = "hasp_feature_expired";
                break;
            }
            case 42: {
                errorMessage = "hasp_old_lm";
                break;
            }
            case 43: {
                errorMessage = "hasp_device_err";
                break;
            }
            case 44: {
                errorMessage = "hasp_update_blocked";
                break;
            }
            case 45: {
                errorMessage = "hasp_time_err";
                break;
            }
            case 46: {
                errorMessage = "hasp_schan_err";
                break;
            }
            case 47: {
                errorMessage = "hasp_storage_corrupt";
                break;
            }
            case 48: {
                errorMessage = "hasp_no_vlib";
                break;
            }
            case 49: {
                errorMessage = "hasp_inv_vlib";
                break;
            }
            case 50: {
                errorMessage = "hasp_scope_results_empty";
                break;
            }
            case 51: {
                errorMessage = "hasp_vm_detected";
                break;
            }
            case 52: {
                errorMessage = "hasp_hardware_modified";
                break;
            }
            case 53: {
                errorMessage = "hasp_user_denied";
                break;
            }
            case 54: {
                errorMessage = "hasp_update_too_old";
                break;
            }
            case 55: {
                errorMessage = "hasp_update_too_new";
                break;
            }
            case 56: {
                errorMessage = "hasp_old_vlib";
                break;
            }
            case 57: {
                errorMessage = "hasp_upload_error";
                break;
            }
            case 58: {
                errorMessage = "hasp_inv_recipient";
                break;
            }
            case 59: {
                errorMessage = "hasp_inv_detach_action";
                break;
            }
            case 60: {
                errorMessage = "hasp_too_many_products";
                break;
            }
            case 61: {
                errorMessage = "hasp_inv_product";
                break;
            }
            case 62: {
                errorMessage = "hasp_unknown_recipient";
                break;
            }
            case 63: {
                errorMessage = "hasp_inv_duration";
                break;
            }
            case 64: {
                errorMessage = "hasp_clone_detected";
                break;
            }
            case 65: {
                errorMessage = "hasp_update_already_added";
                break;
            }
            case 66: {
                errorMessage = "hasp_hasp_inactive";
                break;
            }
            case 67: {
                errorMessage = "hasp_no_deatchable_feature";
                break;
            }
            case 68: {
                errorMessage = "hasp_too_many_hosts";
                break;
            }
            case 69: {
                errorMessage = "hasp_rehost_not_allowed";
                break;
            }
            case 70: {
                errorMessage = "hasp_license_rehosted";
                break;
            }
            case 71: {
                errorMessage = "hasp_rehost_already_applied";
                break;
            }
            case 72: {
                errorMessage = "hasp_cannot_read_file";
                break;
            }
            case 400: {
                errorMessage = "hasp_no_api_dylib";
                break;
            }
            case 401: {
                errorMessage = "hasp_inv_api_dylib";
                break;
            }
            case 501: {
                errorMessage = "hasp_inv_param";
                break;
            }
            case 650: {
                errorMessage = "hasp_inv_port_type";
                break;
            }
            case 651: {
                errorMessage = "hasp_inv_port";
                break;
            }
            case 698: {
                errorMessage = "hasp_not_impl";
                break;
            }
            case 699: {
                errorMessage = "hasp_int_err";
                break;
            }
            case 4000: {
                errorMessage = "SuperMap_License_Error_Cannot_Find_LicenseInstance";
                break;
            }
            case 4001: {
                errorMessage = "SuperMap_License_Error_Hasp_Load_Library_Error";
                break;
            }
            case 5000: {
                errorMessage = "SuperMap_licensefile_7C_unknown_error";
                break;
            }
            case 5001: {
                errorMessage = "SuperMap_licensefile_7C_later_than_ExpiredDate";
                break;
            }
            case 5002: {
                errorMessage = "SuperMap_License_Error_early_than_StartDate";
                break;
            }
            case 5003: {
                errorMessage = "SuperMap_licensefile_7C_wrong_license_data";
                break;
            }
            case 5004: {
                errorMessage = "SuperMap_licensefile_7C_wrong_product_version";
                break;
            }
            case 5005: {
                errorMessage = "SuperMap_licensefile_7C_encrypt_failed";
                break;
            }
            case 5006: {
                errorMessage = "SuperMap_licensefile_7C_computer_name_error";
                break;
            }
            case 5007: {
                errorMessage = "SuperMap_licensefile_7C_featrue_not_found";
                break;
            }
            case 5008: {
                errorMessage = "SuperMap_licensefile_7C_specify_MAC_not_found";
                break;
            }
            case 5009: {
                errorMessage = "SuperMap_licensefile_7C_wrong_feature_in_license_data";
                break;
            }
            default: {
                errorMessage = "unknown error code: " + code;
            }
        }
        if (!errorMessage.equals("")) {
            LicenseVerifyFailedEvent licenseVerifyFailedEvent = new LicenseVerifyFailedEvent(License.class, code, errorMessage);
        }
        return errorMessage;
    }

    public String toString() {
        return "License";
    }

    public static synchronized void addLicenseVerifyFailedListener(LicenseVerifyFailedListener l) {
        LicenseHaspInstance.addLicenseVerifyFailedListener(l);
        LicenseWrapInstance.addLicenseVerifyFailedListener(l);
    }

    public static synchronized void removeLicenseVerifyFailedListener(LicenseVerifyFailedListener l) {
        LicenseHaspInstance.removeLicenseVerifyFailedListener(l);
        LicenseWrapInstance.removeLicenseVerifyFailedListener(l);
    }

    public static ArrayList<ProductType> getTrialLicenses() {
        ArrayList<ProductType> products = new ArrayList<ProductType>();
        products.add(new ProductType(65400, 65400));
        products.add(new ProductType(65401, 65401));
        products.add(new ProductType(65402, 65402));
        products.add(new ProductType(65403, 65403));
        products.add(new ProductType(65404, 65404));
        products.add(new ProductType(65405, 65405));
        products.add(new ProductType(65406, 65406));
        products.add(new ProductType(65407, 65407));
        products.add(new ProductType(65408, 65408));
        products.add(new ProductType(65409, 65409));
        products.add(new ProductType(65410, 65410));
        products.add(new ProductType(65411, 65411));
        return products;
    }

    static Element getFirstElementByName(Element element, String tagName) {
        return (Element)License.getFirstElement(element.getElementsByTagName(tagName));
    }

    private static Node getFirstElement(NodeList nodeList) {
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        return nodeList.item(0);
    }
}

