/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.AboutBox;
import com.supermap.data.Datasources;
import com.supermap.data.Enum;
import com.supermap.data.Environment;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Layouts;
import com.supermap.data.License;
import com.supermap.data.LicenseFeatureInfo;
import com.supermap.data.Maps;
import com.supermap.data.ObjectsRuntimeException;
import com.supermap.data.ProductType;
import com.supermap.data.Resources;
import com.supermap.data.Scenes;
import com.supermap.data.Toolkit;
import com.supermap.data.WorkspaceCaptionChangedEvent;
import com.supermap.data.WorkspaceCaptionChangedListener;
import com.supermap.data.WorkspaceClosedEvent;
import com.supermap.data.WorkspaceClosedListener;
import com.supermap.data.WorkspaceClosingEvent;
import com.supermap.data.WorkspaceClosingListener;
import com.supermap.data.WorkspaceConnectionInfo;
import com.supermap.data.WorkspaceConnectionInfoNative;
import com.supermap.data.WorkspaceCreatedEvent;
import com.supermap.data.WorkspaceCreatedListener;
import com.supermap.data.WorkspaceNative;
import com.supermap.data.WorkspaceOpenedEvent;
import com.supermap.data.WorkspaceOpenedListener;
import com.supermap.data.WorkspaceSavedAsEvent;
import com.supermap.data.WorkspaceSavedAsListener;
import com.supermap.data.WorkspaceSavedEvent;
import com.supermap.data.WorkspaceSavedListener;
import com.supermap.data.WorkspaceType;
import com.supermap.data.WorkspaceVersion;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;

public class Workspace
extends InternalHandleDisposable {
    private WorkspaceConnectionInfo _$16;
    private Datasources _$15;
    private Maps _$14;
    private Scenes _$13;
    private transient CopyOnWriteArrayList<WorkspaceOpenedListener> _$12;
    private transient CopyOnWriteArrayList<WorkspaceCreatedListener> _$11;
    private transient CopyOnWriteArrayList<WorkspaceClosingListener> _$10;
    private transient CopyOnWriteArrayList<WorkspaceClosedListener> _$9;
    private transient CopyOnWriteArrayList<WorkspaceSavedAsListener> _$8;
    private transient CopyOnWriteArrayList<WorkspaceSavedListener> _$7;
    private transient CopyOnWriteArrayList<WorkspaceCaptionChangedListener> _$6;
    private License _$5;
    private Resources _$4;
    private Layouts _$3;

    public Workspace() {
        this._$2();
        long l = WorkspaceNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        l = WorkspaceNative.jni_GetConnectionInfo(this.getHandle());
        this._$16 = new WorkspaceConnectionInfo(l, false, true);
        this._$16.reset();
        this._$14 = new Maps(this);
        this._$15 = new Datasources(this);
        this._$13 = new Scenes(this);
        this._$3 = new Layouts(this);
    }

    private void _$2() {
        ArrayList<ProductType> arrayList = Toolkit.managerProducts(Toolkit.getDataProducts());
        this._$5 = Toolkit.verifyLicense(arrayList);
        LicenseFeatureInfo licenseFeatureInfo = this._$5.getFeatureInfo();
        Toolkit.setMappingRuntimeLicenseMode(licenseFeatureInfo.isTrial());
        Toolkit.updateStatus();
    }

    private void _$1() {
        if (this._$5 != null) {
            this._$5.disconnect();
            this._$5.dispose();
            this._$5 = null;
        }
    }

    public WorkspaceConnectionInfo getConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getConnectionInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$16;
    }

    public String getCaption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetCaption(this.getHandle());
    }

    public void setCaption(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setCaption()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        String string4 = this.getCaption();
        WorkspaceNative.jni_SetCaption(this.getHandle(), string);
        WorkspaceCaptionChangedEvent workspaceCaptionChangedEvent = new WorkspaceCaptionChangedEvent(this, this, string4, string);
        this.fireCaptionChanged(workspaceCaptionChangedEvent);
    }

    public Datasources getDatasources() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDatasources()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$15;
    }

    public Maps getMaps() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaps()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$14;
    }

    public boolean isModified() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isModified()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetIsModified(this.getHandle());
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setDescription()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        WorkspaceNative.jni_SetDescription(this.getHandle(), string);
    }

    public WorkspaceType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = WorkspaceNative.jni_GetType(this.getHandle());
        WorkspaceType workspaceType = (WorkspaceType)Enum.parseUGCValue(WorkspaceType.class, n);
        return workspaceType;
    }

    public WorkspaceVersion getVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVersion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = WorkspaceNative.jni_GetVersion(this.getHandle());
        return (WorkspaceVersion)Enum.parseUGCValue(WorkspaceVersion.class, n);
    }

    public Date getLastUpdateTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLastUpdateTime()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = WorkspaceNative.jni_GetLastUpdateTime(this.getHandle());
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
                date = simpleDateFormat2.parse(string);
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
        return date;
    }

    public void aboutBox() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("aboutBox()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        AboutBox aboutBox = new AboutBox();
    }

    public boolean create(WorkspaceConnectionInfo workspaceConnectionInfo) {
        int n = this._$5.verify();
        if (n != 0) {
            String string = License.getErrorMessage(n);
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("create()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (workspaceConnectionInfo == null) {
            String string = InternalResource.loadString("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (workspaceConnectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$14.clear();
        this._$15.clearChildHandle();
        boolean bl = WorkspaceNative.jni_Create(this.getHandle(), workspaceConnectionInfo.getHandle());
        if (bl) {
            WorkspaceCreatedEvent workspaceCreatedEvent = new WorkspaceCreatedEvent(this, this, workspaceConnectionInfo);
            this.fireCreated(workspaceCreatedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspaceConnectionInfo);
        return bl;
    }

    public boolean open(WorkspaceConnectionInfo workspaceConnectionInfo) {
        int n = this._$5.verify();
        if (n != 0) {
            String string = License.getErrorMessage(n);
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("open()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (workspaceConnectionInfo == null) {
            String string = InternalResource.loadString("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (workspaceConnectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.close();
        Toolkit.clearErrors();
        boolean bl = WorkspaceNative.jni_Open(this.getHandle(), workspaceConnectionInfo.getHandle());
        if (!bl) {
            this.getConnectionInfo().setReadOnly(false);
            this.getConnectionInfo().setVersion(WorkspaceVersion.UGC20);
            this.getConnectionInfo().setReadOnly(true);
        }
        this.getDatasources().reset();
        WorkspaceVersion workspaceVersion = this.getConnectionInfo().getVersion();
        this._$1(workspaceConnectionInfo);
        WorkspaceConnectionInfoNative.jni_SetVersion(this.getConnectionInfo().getHandle(), workspaceVersion.getUGCValue());
        if (bl) {
            WorkspaceOpenedEvent workspaceOpenedEvent = new WorkspaceOpenedEvent(this, this);
            this.fireOpened(workspaceOpenedEvent);
        }
        if (!bl) {
            throw new ObjectsRuntimeException(Toolkit.getLastError());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspaceConnectionInfo);
        return bl;
    }

    public boolean saveAs(WorkspaceConnectionInfo workspaceConnectionInfo) {
        int n = this._$5.verify();
        if (n != 0) {
            String string = License.getErrorMessage(n);
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("saveAs()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (workspaceConnectionInfo == null) {
            String string = InternalResource.loadString("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (workspaceConnectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$1(workspaceConnectionInfo);
        boolean bl = WorkspaceNative.jni_SaveAs(this.getHandle(), workspaceConnectionInfo.getHandle());
        if (bl) {
            WorkspaceSavedAsEvent workspaceSavedAsEvent = new WorkspaceSavedAsEvent(this, this);
            this.fireSavedAs(workspaceSavedAsEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspaceConnectionInfo);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("close()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        WorkspaceClosingEvent workspaceClosingEvent = new WorkspaceClosingEvent(this, this);
        this.fireClosing(workspaceClosingEvent);
        if (workspaceClosingEvent.getCancel()) {
            return;
        }
        Object object = this;
        synchronized (object) {
            this.getMaps().clear();
            this.getScenes().clear();
            WorkspaceNative.jni_Close(this.getHandle());
            this.getDatasources().clearChildHandle();
            if (this._$4 != null) {
                this._$4.clearHandle();
                this._$4 = null;
            }
            this.getConnectionInfo().reset();
            this.reset();
        }
        object = new WorkspaceClosedEvent(this, this);
        this.fireClosed((WorkspaceClosedEvent)object);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            this.close();
            WorkspaceNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
        this._$1();
    }

    protected static void refresh(Workspace workspace) {
        workspace.getDatasources().refresh();
    }

    public boolean save() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("save()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = WorkspaceNative.jni_Save(this.getHandle());
        if (bl) {
            WorkspaceSavedEvent workspaceSavedEvent = new WorkspaceSavedEvent(this, this);
            this.fireSaved(workspaceSavedEvent);
        }
        return bl;
    }

    public static boolean deleteWorkspace(WorkspaceConnectionInfo workspaceConnectionInfo) {
        if (workspaceConnectionInfo == null) {
            String string = InternalResource.loadString("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = workspaceConnectionInfo.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = WorkspaceNative.jni_DeleteWorkspace(l);
        if (bl) {
            workspaceConnectionInfo.clearHandle();
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspaceConnectionInfo);
        return bl;
    }

    public static String[] getWorkspaceName(WorkspaceConnectionInfo workspaceConnectionInfo) {
        if (workspaceConnectionInfo == null) {
            String string = InternalResource.loadString("getWorkspaceName()", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = workspaceConnectionInfo.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = null;
        if (workspaceConnectionInfo.getType().equals(WorkspaceType.DEFAULT)) {
            stringArray = null;
        } else if (workspaceConnectionInfo.getType().equals(WorkspaceType.SXW) || workspaceConnectionInfo.getType().equals(WorkspaceType.SMW) || workspaceConnectionInfo.getType().equals(WorkspaceType.SXWU) || workspaceConnectionInfo.getType().equals(WorkspaceType.SMWU)) {
            String string = workspaceConnectionInfo.getServer();
            stringArray = new String[]{string};
            if (string.toLowerCase().endsWith(".sxw")) {
                int n = string.toLowerCase().lastIndexOf(".sxw");
                stringArray[0] = string.substring(0, n);
            } else if (string.toLowerCase().endsWith(".smw")) {
                int n = string.toLowerCase().lastIndexOf(".smw");
                stringArray[0] = string.substring(0, n);
            } else if (string.toLowerCase().endsWith(".sxwu")) {
                int n = string.toLowerCase().lastIndexOf(".sxwu");
                stringArray[0] = string.substring(0, n);
            } else if (string.toLowerCase().endsWith(".smwu")) {
                int n = string.toLowerCase().lastIndexOf(".smwu");
                stringArray[0] = string.substring(0, n);
            }
        } else {
            stringArray = WorkspaceNative.jni_GetWorkspaceName(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspaceConnectionInfo);
        return stringArray;
    }

    public Resources getResources() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getResources()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null && (l = WorkspaceNative.jni_GetResources(this.getHandle())) != 0L) {
            this._$4 = new Resources(this, l);
        }
        return this._$4;
    }

    public Scenes getScenes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScenes()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$13;
    }

    public Layouts getLayouts() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLayouts()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$3;
    }

    public boolean changePassword(String string, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("changePassword(String oldPassword, String newPassword)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string2 == null) {
            String string4 = InternalResource.loadString("password", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string4);
        }
        return WorkspaceNative.jni_ChangePassword(this.getHandle(), string, string2);
    }

    void reset() {
        WorkspaceNative.jni_Reset(this.getHandle());
    }

    protected void clearHandle() {
        if (this._$15 != null) {
            this._$15.clearHandle();
            this._$15 = null;
        }
        if (this._$14 != null) {
            this._$14.clearHandle();
            this._$14 = null;
        }
        if (this._$3 != null) {
            this._$3.clearHandle();
            this._$3 = null;
        }
        if (this._$16 != null) {
            this._$16.clearHandle();
            this._$16 = null;
        }
        if (this._$4 != null) {
            this._$4.clearHandle();
            this._$4 = null;
        }
        if (this._$13 != null) {
            this._$13.clearHandle();
            this._$13 = null;
        }
        this.setHandle(0L);
    }

    License getLicense() {
        return this._$5;
    }

    private void _$1(WorkspaceConnectionInfo workspaceConnectionInfo) {
        WorkspaceConnectionInfoNative.jni_SetValue(this.getConnectionInfo().getHandle(), workspaceConnectionInfo.getHandle());
    }

    public synchronized void addOpenedListener(WorkspaceOpenedListener workspaceOpenedListener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setConnectionInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$12 == null) {
            this._$12 = new CopyOnWriteArrayList();
        }
        if (!this._$12.contains(workspaceOpenedListener)) {
            this._$12.add(workspaceOpenedListener);
        }
    }

    public void removeOpenedListener(WorkspaceOpenedListener workspaceOpenedListener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeOpenedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$12 != null && this._$12.contains(workspaceOpenedListener)) {
            this._$12.remove(workspaceOpenedListener);
        }
    }

    public synchronized void addCreatedListener(WorkspaceCreatedListener workspaceCreatedListener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addCreatedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$11 == null) {
            this._$11 = new CopyOnWriteArrayList();
        }
        if (!this._$11.contains(workspaceCreatedListener)) {
            this._$11.add(workspaceCreatedListener);
        }
    }

    public void removeCreatedListener(WorkspaceCreatedListener workspaceCreatedListener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeCreatedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$11 != null && this._$11.contains(workspaceCreatedListener)) {
            this._$11.remove(workspaceCreatedListener);
        }
    }

    public synchronized void addClosingListener(WorkspaceClosingListener workspaceClosingListener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addClosingListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$10 == null) {
            this._$10 = new CopyOnWriteArrayList();
        }
        if (!this._$10.contains(workspaceClosingListener)) {
            this._$10.add(workspaceClosingListener);
        }
    }

    public void removeClosingListener(WorkspaceClosingListener workspaceClosingListener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeClosingListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$10 != null && this._$10.contains(workspaceClosingListener)) {
            this._$10.remove(workspaceClosingListener);
        }
    }

    protected void fireOpened(WorkspaceOpenedEvent workspaceOpenedEvent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireOpened()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$12 != null) {
            CopyOnWriteArrayList<WorkspaceOpenedListener> copyOnWriteArrayList = this._$12;
            for (WorkspaceOpenedListener workspaceOpenedListener : copyOnWriteArrayList) {
                workspaceOpenedListener.workspaceOpened(workspaceOpenedEvent);
            }
        }
    }

    protected void fireCreated(WorkspaceCreatedEvent workspaceCreatedEvent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireCreated()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$11 != null) {
            CopyOnWriteArrayList<WorkspaceCreatedListener> copyOnWriteArrayList = this._$11;
            for (WorkspaceCreatedListener workspaceCreatedListener : copyOnWriteArrayList) {
                workspaceCreatedListener.workspaceCreated(workspaceCreatedEvent);
            }
        }
    }

    protected void fireClosing(WorkspaceClosingEvent workspaceClosingEvent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireClosing()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$10 != null) {
            CopyOnWriteArrayList<WorkspaceClosingListener> copyOnWriteArrayList = this._$10;
            for (WorkspaceClosingListener workspaceClosingListener : copyOnWriteArrayList) {
                workspaceClosingListener.workspaceClosing(workspaceClosingEvent);
            }
        }
    }

    public synchronized void addClosedListener(WorkspaceClosedListener workspaceClosedListener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addClosedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$9 == null) {
            this._$9 = new CopyOnWriteArrayList();
        }
        if (!this._$9.contains(workspaceClosedListener)) {
            this._$9.add(workspaceClosedListener);
        }
    }

    public void removeClosedListener(WorkspaceClosedListener workspaceClosedListener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeClosedListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$9 != null && this._$9.contains(workspaceClosedListener)) {
            this._$9.remove(workspaceClosedListener);
        }
    }

    protected void fireClosed(WorkspaceClosedEvent workspaceClosedEvent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireClosed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$9 != null) {
            CopyOnWriteArrayList<WorkspaceClosedListener> copyOnWriteArrayList = this._$9;
            for (WorkspaceClosedListener workspaceClosedListener : copyOnWriteArrayList) {
                workspaceClosedListener.workspaceClosed(workspaceClosedEvent);
            }
        }
    }

    public synchronized void addSavedAsListener(WorkspaceSavedAsListener workspaceSavedAsListener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addSavedAsListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 == null) {
            this._$8 = new CopyOnWriteArrayList();
        }
        if (!this._$8.contains(workspaceSavedAsListener)) {
            this._$8.add(workspaceSavedAsListener);
        }
    }

    public void removeSavedAsListener(WorkspaceSavedAsListener workspaceSavedAsListener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeSavedAsListener()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 != null && this._$8.contains(workspaceSavedAsListener)) {
            this._$8.remove(workspaceSavedAsListener);
        }
    }

    protected void fireSavedAs(WorkspaceSavedAsEvent workspaceSavedAsEvent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fireClosed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 != null) {
            CopyOnWriteArrayList<WorkspaceSavedAsListener> copyOnWriteArrayList = this._$8;
            for (WorkspaceSavedAsListener workspaceSavedAsListener : copyOnWriteArrayList) {
                workspaceSavedAsListener.workspaceSavedAs(workspaceSavedAsEvent);
            }
        }
    }

    public synchronized void addSavedListener(WorkspaceSavedListener workspaceSavedListener) {
        if (this._$7 == null) {
            this._$7 = new CopyOnWriteArrayList();
        }
        if (!this._$7.contains(workspaceSavedListener)) {
            this._$7.add(workspaceSavedListener);
        }
    }

    public void removeSavedListener(WorkspaceSavedListener workspaceSavedListener) {
        if (this._$7 != null && this._$7.contains(workspaceSavedListener)) {
            this._$7.remove(workspaceSavedListener);
        }
    }

    protected void fireSaved(WorkspaceSavedEvent workspaceSavedEvent) {
        if (this._$7 != null) {
            CopyOnWriteArrayList<WorkspaceSavedListener> copyOnWriteArrayList = this._$7;
            for (WorkspaceSavedListener workspaceSavedListener : copyOnWriteArrayList) {
                workspaceSavedListener.workspaceSaved(workspaceSavedEvent);
            }
        }
    }

    public synchronized void addCaptionChangedListener(WorkspaceCaptionChangedListener workspaceCaptionChangedListener) {
        if (this._$6 == null) {
            this._$6 = new CopyOnWriteArrayList();
        }
        if (!this._$6.contains(workspaceCaptionChangedListener)) {
            this._$6.add(workspaceCaptionChangedListener);
        }
    }

    public void removeCaptionChangedListener(WorkspaceCaptionChangedListener workspaceCaptionChangedListener) {
        if (this._$6 != null && this._$6.contains(workspaceCaptionChangedListener)) {
            this._$6.remove(workspaceCaptionChangedListener);
        }
    }

    protected void fireCaptionChanged(WorkspaceCaptionChangedEvent workspaceCaptionChangedEvent) {
        if (this._$6 != null) {
            CopyOnWriteArrayList<WorkspaceCaptionChangedListener> copyOnWriteArrayList = this._$6;
            for (WorkspaceCaptionChangedListener workspaceCaptionChangedListener : copyOnWriteArrayList) {
                workspaceCaptionChangedListener.workspaceCaptionChanged(workspaceCaptionChangedEvent);
            }
        }
    }

    static void loadPlugins() {
        WorkspaceNative.jni_InitPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Environment.LoadWrapJ();
        Workspace.loadPlugins();
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_SDX_RUNTIME);
        arrayList.add(ProductType.IOBJECTS_SDX_DEVELOP);
        arrayList.addAll(Toolkit.getTrialProducts());
        ArrayList<ProductType> arrayList2 = Toolkit.managerProducts(arrayList);
        License license = null;
        try {
            license = Toolkit.verifyLicense(arrayList2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WorkspaceNative.jni_ManagerEngineType();
        }
        finally {
            if (license != null) {
                license.dispose();
            }
        }
    }
}

