/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGroup;
import com.supermap.data.DatasetGroupNative;
import com.supermap.data.DatasetGroups;
import com.supermap.data.DatasetNative;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorNative;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.DatasourceNative;
import com.supermap.data.EncodeType;
import com.supermap.data.EngineType;
import com.supermap.data.Environment;
import com.supermap.data.ErrorInfo;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalBufferImage;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.License;
import com.supermap.data.PackageType;
import com.supermap.data.ProductType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Resources;
import com.supermap.data.ToolkitNative;
import com.supermap.data.Workspace;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.imageio.stream.FileImageOutputStream;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Toolkit {
    private static boolean _$4;
    private static boolean _$3;
    private static boolean _$2;
    private static int _$1;
    protected static final double DBL_MAX_VALUE = Double.MAX_VALUE;
    protected static final double DBL_MIN_VALUE = -1.7976931348623157E308;
    protected static final float FLT_MAX_VALUE = Float.MAX_VALUE;
    protected static final float FLT_MIN_VALUE = -3.4028235E38f;

    protected Toolkit() {
    }

    public static boolean isZero(double d) {
        boolean bl = d >= Environment.getMinEqualZeroPrecision() && d <= Environment.getMaxEqualZeroPrecision();
        return bl;
    }

    public static boolean isZero(double d, double d2) {
        boolean bl = d >= -Math.abs(d2) && d <= Math.abs(d2);
        return bl;
    }

    public static boolean isZero(double d, double d2, double d3) {
        boolean bl = d >= d2 && d <= d3;
        return bl;
    }

    public static boolean drawToPNG(Geometry geometry, Resources resources, String string, Dimension dimension) {
        if (geometry == null) {
            String string2 = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string3 = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (resources == null) {
            String string4 = InternalResource.loadString("resources", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        long l2 = InternalHandle.getHandle(resources);
        if (l2 == 0L) {
            String string5 = InternalResource.loadString("resources", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        boolean bl = false;
        bl = ToolkitNative.jni_DrawGeometryToPNG(geometry.getHandle(), l2, string, dimension.width, dimension.height);
        geometry.makeSureNativeObjectLive();
        resources.makeSureNativeObjectLive();
        return bl;
    }

    public static boolean draw(Geometry geometry, Resources resources, Graphics graphics) {
        InternalBufferImage internalBufferImage;
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resources == null) {
            String string = InternalResource.loadString("resources", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(resources);
        if (l2 == 0L) {
            String string = InternalResource.loadString("resources", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Rectangle2D rectangle2D = geometry.getBounds();
        SunGraphics2D sunGraphics2D = (SunGraphics2D)graphics;
        Region region = sunGraphics2D.clipRegion;
        int n = sunGraphics2D.transX;
        int n2 = sunGraphics2D.transY;
        int n3 = region.getHiX() - n;
        int n4 = region.getHiY() - n2;
        boolean bl = false;
        try {
            internalBufferImage = new InternalBufferImage(n3, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        bl = ToolkitNative.jni_DrawGeometry(geometry.getHandle(), l2, internalBufferImage.getHandle());
        graphics.drawImage(internalBufferImage.getMemoryImage(), 0, 0, internalBufferImage.getWidth(), internalBufferImage.getHeight(), null);
        geometry.makeSureNativeObjectLive();
        resources.makeSureNativeObjectLive();
        InternalHandleDisposable.makeSureNativeObjectLive(internalBufferImage);
        return bl;
    }

    protected static boolean internalDraw(Geometry geometry, Resources resources, Graphics graphics) {
        InternalBufferImage internalBufferImage;
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resources == null) {
            String string = InternalResource.loadString("resources", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(resources);
        if (l2 == 0L) {
            String string = InternalResource.loadString("resources", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Rectangle2D rectangle2D = geometry.getBounds();
        boolean bl = false;
        SunGraphics2D sunGraphics2D = (SunGraphics2D)graphics;
        Region region = sunGraphics2D.clipRegion;
        int n = sunGraphics2D.transX;
        int n2 = sunGraphics2D.transY;
        int n3 = region.getHiX() - n;
        int n4 = region.getHiY() - n2;
        try {
            if (geometry.getType().equals(GeometryType.GEOPOINT) && geometry.getStyle() != null) {
                internalBufferImage = new InternalBufferImage((int)geometry.getStyle().getMarkerSize().getWidth() + n3 * 4, (int)geometry.getStyle().getMarkerSize().getHeight() + n4 * 4);
                geometry.offset(-rectangle2D.getLeft() + (double)(n3 * 2), -rectangle2D.getBottom() + (double)(n4 * 2));
            } else if (geometry.getType().equals(GeometryType.GEOLINE) && geometry.getStyle() != null) {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + n3 * 2, (int)rectangle2D.getHeight() + n4 * 2);
                geometry.offset(-rectangle2D.getLeft() + (double)(n3 / 2), -rectangle2D.getBottom() + (double)(n4 / 2));
            } else {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1);
                geometry.offset(-rectangle2D.getLeft(), -rectangle2D.getBottom());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        bl = ToolkitNative.jni_DrawGeometry(geometry.getHandle(), l2, internalBufferImage.getHandle());
        BufferedImage bufferedImage = new BufferedImage(internalBufferImage.getWidth(), internalBufferImage.getHeight(), 2);
        bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(), 0, 0, internalBufferImage.getWidth(), internalBufferImage.getHeight(), null);
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int n5 = bufferedImage.getRGB(i, j);
                if (n5 != -16711423) continue;
                bufferedImage.setRGB(i, j, 65793);
            }
        }
        if (bl) {
            if (geometry.getType().equals(GeometryType.GEOPOINT) && geometry.getStyle() != null) {
                graphics.drawImage(bufferedImage, (int)rectangle2D.getLeft() - n3 * 2, (int)rectangle2D.getBottom() - n4 * 2, null);
            } else if (geometry.getType().equals(GeometryType.GEOLINE) && geometry.getStyle() != null) {
                graphics.drawImage(bufferedImage, (int)rectangle2D.getLeft() - n3 / 2, (int)rectangle2D.getBottom() - n4 / 2, null);
            } else {
                graphics.drawImage(bufferedImage, (int)rectangle2D.getLeft(), (int)rectangle2D.getBottom(), null);
            }
        }
        geometry.makeSureNativeObjectLive();
        resources.makeSureNativeObjectLive();
        InternalHandleDisposable.makeSureNativeObjectLive(internalBufferImage);
        return bl;
    }

    public static boolean compactDatasource(Datasource datasource) {
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(datasource);
        if (l == 0L) {
            String string = InternalResource.loadString("datasource", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Datasource.m_senderMethodName = "compactDatasource";
        datasource.m_selfEventHandle = DatasourceNative.jni_NewSelfEventHandle(datasource);
        boolean bl = ToolkitNative.jni_CompactDatasource(l, datasource.m_selfEventHandle);
        datasource.clearSelfEventHandle();
        if (datasource.getDatasets().getCount() > 0) {
            datasource.getDatasets().reset();
        }
        return bl;
    }

    public static boolean degraRaster(DatasourceConnectionInfo datasourceConnectionInfo, String string) {
        if (datasourceConnectionInfo == null || datasourceConnectionInfo.getHandle() == 0L) {
            String string2 = InternalResource.loadString("open()", "Datasources_ConnectionInfoIsInvalid", "data_resources");
            throw new IllegalStateException(string2);
        }
        return ToolkitNative.jni_DegraUDBRaster(datasourceConnectionInfo.getHandle(), string);
    }

    public static EncodeType[] getEncodeType(DatasetType datasetType) {
        if (datasetType == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        ArrayList<EncodeType> arrayList = new ArrayList<EncodeType>();
        switch (datasetType.value()) {
            case 3: 
            case 4: 
            case 5: 
            case 205: {
                arrayList.add(EncodeType.BYTE);
                arrayList.add(EncodeType.INT16);
                arrayList.add(EncodeType.INT24);
                arrayList.add(EncodeType.INT32);
                arrayList.add(EncodeType.NONE);
                break;
            }
            case 0: 
            case 1: 
            case 7: 
            case 35: 
            case 149: 
            case 153: {
                arrayList.add(EncodeType.NONE);
                break;
            }
            case 81: {
                arrayList.add(EncodeType.LZW);
                arrayList.add(EncodeType.DCT);
                arrayList.add(EncodeType.PNG);
                arrayList.add(EncodeType.COMPOUND);
                break;
            }
            case 83: {
                arrayList.add(EncodeType.LZW);
                arrayList.add(EncodeType.SGL);
                break;
            }
            default: {
                arrayList.add(EncodeType.NONE);
            }
        }
        EncodeType[] encodeTypeArray = new EncodeType[arrayList.size()];
        return arrayList.toArray(encodeTypeArray);
    }

    public static ErrorInfo[] getLastErrors(int n) {
        int n2;
        if (n < 0) {
            n = 0;
        }
        int n3 = n < (n2 = ToolkitNative.jni_GetErrorCount()) ? n : n2;
        ErrorInfo[] errorInfoArray = new ErrorInfo[n3];
        int[] nArray = new int[n3];
        String[] stringArray = new String[n3];
        String[] stringArray2 = new String[n3];
        ToolkitNative.jni_GetErrorInfos(nArray, stringArray, stringArray2, n2, n);
        for (int i = 0; i < stringArray2.length; ++i) {
            errorInfoArray[i] = new ErrorInfo(nArray[i], stringArray[i], stringArray2[i]);
        }
        return errorInfoArray;
    }

    public static void clearErrors() {
        ToolkitNative.jni_ClearErrors();
    }

    public static ErrorInfo[] getAllErrors() {
        int n = ToolkitNative.jni_GetErrorCount();
        int[] nArray = new int[n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        ToolkitNative.jni_GetAllErrors(nArray, stringArray, stringArray2);
        ErrorInfo[] errorInfoArray = new ErrorInfo[n];
        for (int i = 0; i < stringArray2.length; ++i) {
            errorInfoArray[i] = new ErrorInfo(nArray[i], stringArray[i], stringArray2[i]);
        }
        return errorInfoArray;
    }

    public static String[] getWarnings() {
        int n = ToolkitNative.jni_GetErrorCount();
        int[] nArray = new int[n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        ToolkitNative.jni_GetAllErrors(nArray, stringArray, stringArray2);
        String[] stringArray3 = new String[n];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = new String(stringArray2[i]);
        }
        return stringArray3;
    }

    public static String getLastError() {
        return ToolkitNative.jni_GetLastError();
    }

    public static boolean extractCacheFile(String string, String string2) {
        return Toolkit.extractCacheFile(string, string2, "");
    }

    public static boolean extractCacheFile(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        boolean bl = false;
        if (Locale.getDefault().getLanguage() == Locale.JAPANESE.getLanguage()) {
            string = string.replaceAll("\\\\", "/");
            string2 = string2.replaceAll("\\\\", "/");
        }
        bl = ToolkitNative.jni_ExtractCacheFile(string, string2, string3);
        return bl;
    }

    public static boolean compress(String[] stringArray, String string, String string2, PackageType packageType) {
        boolean bl = false;
        if (stringArray != null && string != null) {
            if (string2 == null) {
                string2 = "";
            }
            if (packageType.equals(PackageType.pkg7ZIP)) {
                if (Locale.getDefault().getLanguage() == Locale.JAPANESE.getLanguage()) {
                    string = string.replaceAll("\\\\", "/");
                }
                bl = ToolkitNative.jni_Compress7Zip(stringArray, string, string2);
            }
        }
        return bl;
    }

    public static boolean unCompress(String string, String string2, String string3) {
        boolean bl = false;
        if (string != null && string2 != null) {
            if (string3 == null) {
                string3 = "";
            }
            bl = ToolkitNative.jni_UnCompress7Zip(string, string2, string3);
        }
        return bl;
    }

    protected static void setHandleBooleanValue(long l, boolean bl) {
        ToolkitNative.jni_SetBooleanHandle(l, bl);
    }

    protected static boolean getHandleBooleanValue(long l) {
        return ToolkitNative.jni_GetBooleanHandle(l);
    }

    protected static void setHandleDoubleValue(long l, double d) {
        ToolkitNative.jni_SetHandleDoubleValue(l, d);
    }

    protected static double getHandleDoubleValue(long l) {
        return ToolkitNative.jni_GetHandleDoubleValue(l);
    }

    protected static String joinString(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0 || string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i] + string);
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return stringBuffer.toString();
    }

    protected static String[] splitString(String string, String string2) {
        if (string == null || string.trim().equals("") || string2 == null) {
            return new String[0];
        }
        return string.split(string2);
    }

    static Date parseUGCTime(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    static String toUGCTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return simpleDateFormat.format(date);
    }

    static boolean isValidEncodeType(boolean bl, EncodeType encodeType) {
        boolean bl2 = true;
        if (bl) {
            if (encodeType.equals(EncodeType.DCT) || encodeType.equals(EncodeType.LZW) || encodeType.equals(EncodeType.SGL) || encodeType.equals(EncodeType.PNG) || encodeType.equals(EncodeType.COMPOUND)) {
                bl2 = false;
            }
        } else if (encodeType.equals(EncodeType.BYTE) || encodeType.equals(EncodeType.INT16) || encodeType.equals(EncodeType.INT24) || encodeType.equals(EncodeType.INT32)) {
            bl2 = false;
        }
        return bl2;
    }

    protected static Dataset toManageDataset(Workspace workspace, long l) {
        if (workspace == null || InternalHandle.getHandle(workspace) == 0L || l == 0L) {
            return null;
        }
        long l2 = DatasetNative.jni_GetDatasource(l);
        String string = null;
        if (l2 != 0L) {
            string = DatasourceNative.jni_GetAlias(l2);
        }
        Datasource datasource = workspace.getDatasources().get(string);
        Dataset dataset = null;
        if (datasource != null) {
            dataset = Toolkit._$1(datasource, l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return dataset;
    }

    private static Dataset _$1(Datasource datasource, long l) {
        if (datasource == null || InternalHandle.getHandle(datasource) == 0L || l == 0L) {
            return null;
        }
        String string = DatasetNative.jni_GetName(l);
        boolean bl = false;
        long l2 = 0L;
        boolean bl2 = DatasetNative.jni_GetIsVector(l);
        if (bl2) {
            l2 = DatasetVectorNative.jni_GetParentDataset(l);
        }
        if (l2 != 0L) {
            string = DatasetNative.jni_GetName(l2);
            bl = true;
        }
        Dataset dataset = datasource.getDatasets().get(string);
        if (bl && dataset != null) {
            dataset = ((DatasetVector)dataset).getChildDataset();
        }
        return dataset;
    }

    protected static DatasetGroup toManageDatasetGroup(Workspace workspace, long l) {
        if (workspace == null || InternalHandle.getHandle(workspace) == 0L || l == 0L) {
            return null;
        }
        long l2 = DatasetGroupNative.jni_GetDatasource(l);
        String string = null;
        if (l2 != 0L) {
            string = DatasourceNative.jni_GetAlias(l2);
        }
        Datasource datasource = workspace.getDatasources().get(string);
        DatasetGroup datasetGroup = null;
        if (datasource != null) {
            datasetGroup = Toolkit.toManageDatasetGroup(datasource, l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return datasetGroup;
    }

    protected static DatasetGroup toManageDatasetGroup(Datasource datasource, long l) {
        if (datasource == null || InternalHandle.getHandle(datasource) == 0L || l == 0L) {
            return null;
        }
        DatasetGroup datasetGroup = datasource.getRootGroup();
        DatasetGroup datasetGroup2 = Toolkit._$1(datasetGroup, l);
        return datasetGroup2;
    }

    private static DatasetGroup _$1(DatasetGroup datasetGroup, long l) {
        if (datasetGroup == null) {
            return null;
        }
        DatasetGroup datasetGroup2 = null;
        DatasetGroups datasetGroups = datasetGroup.getChildGroups();
        int n = datasetGroups.getCount();
        for (int i = 0; i < n; ++i) {
            DatasetGroup datasetGroup3 = datasetGroups.get(i);
            if (datasetGroup3 == null) continue;
            if (datasetGroup3.getHandle() == l) {
                return datasetGroup3;
            }
            datasetGroup2 = Toolkit._$1(datasetGroup3, l);
            if (datasetGroup2 == null) continue;
            return datasetGroup2;
        }
        return datasetGroup2;
    }

    protected static boolean isDirectoryExisted(String string) {
        File file = new File(string);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    protected static License verifyLicense(ArrayList<ProductType> arrayList) {
        ProductType productType;
        int n = -1;
        License license = new License();
        Object object = arrayList.iterator();
        while (object.hasNext() && (n = license.connect(productType = object.next())) != 0) {
        }
        if (n == 0) {
            n = license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage(n);
            throw new IllegalStateException((String)object);
        }
        return license;
    }

    protected static void updateStatus() {
        ToolkitNative.jni_updateTrialStatus(Toolkit.getMappingRuntimeLicenseMode(), Toolkit.getLayoutRuntimeLicenseMode(), Toolkit.getSpaceRuntimeLicenseMode());
    }

    protected static ArrayList<ProductType> managerProducts(ArrayList<ProductType> arrayList) {
        ArrayList<ProductType> arrayList2 = new ArrayList<ProductType>();
        arrayList2.add(ProductType.ISERVER_ENTERPRISE);
        arrayList2.add(ProductType.ISERVER_PROFESSIONAL);
        arrayList2.add(ProductType.ISERVER_STANDARD);
        for (ProductType productType : arrayList) {
            arrayList2.add(productType);
        }
        return arrayList2;
    }

    public static ArrayList<ProductType> getTrialProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(new ProductType(65400, 65400));
        arrayList.add(new ProductType(65401, 65401));
        arrayList.add(new ProductType(65402, 65402));
        arrayList.add(new ProductType(65403, 65403));
        arrayList.add(new ProductType(65404, 65404));
        arrayList.add(new ProductType(65405, 65405));
        arrayList.add(new ProductType(65406, 65406));
        arrayList.add(new ProductType(65407, 65407));
        arrayList.add(new ProductType(65408, 65408));
        arrayList.add(new ProductType(65409, 65409));
        arrayList.add(new ProductType(65410, 65410));
        arrayList.add(new ProductType(65411, 65411));
        return arrayList;
    }

    protected static ArrayList<ProductType> getAddressMatchingProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_ADDRESS_MATCHING_DEVELOP);
        arrayList.add(ProductType.IOBJECTS_ADDRESS_MATCHING_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getDataProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_CORE_DEVELOP);
        arrayList.add(ProductType.IOBJECTS_CORE_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getLayoutProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_LAYOUT_DEVELOP);
        arrayList.add(ProductType.IOBJECTS_LAYOUT_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getNetworkAnalystProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_NETWORK_DEVELOP);
        arrayList.add(ProductType.IOBJECTS_NETWORK_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getTrafficAnalystProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.ISERVER_TRAFFIC_TRANSFER);
        arrayList.add(ProductType.IOBJECTS_TRAFFIC_ANALYST_DEVELOP);
        arrayList.add(ProductType.IOBJECTS_TRAFFIC_ANALYST_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getSpaceProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_SPACE_DEVELOP);
        arrayList.add(ProductType.IOBJECTS_SPACE_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getSpace3DEffectProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_REALSPACE_EFFECT_DEVELOP);
        arrayList.add(ProductType.IOBJECTS_REALSPACE_EFFECT_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getSpatialAnalystProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_SPATIAL_DEVELOP);
        arrayList.add(ProductType.IOBJECTS_SPATIAL_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getTopologyProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_TOPOLOGY_DEVELOP);
        arrayList.add(ProductType.IOBJECTS_TOPOLOGY_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getConversionProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_SDX_RUNTIME);
        arrayList.add(ProductType.IOBJECTS_SDX_DEVELOP);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getChartProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.ISERVER_CHART);
        arrayList.add(ProductType.IOBJECTS_CHART_DEVELOP);
        arrayList.add(ProductType.IOBJECTS_CHART_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getRealspaceSpatialAnalystProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_REALSPACE_SPATIAL_ANALYST_DEVELOP);
        arrayList.add(ProductType.IOBJECTS_REALSPACE_SPATIAL_ANALYST_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getRealspaceNetworkAnalystProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_REALSPACE_NETWORK_ANALYST_DEVELOP);
        arrayList.add(ProductType.IOBJECTS_REALSPACE_NETWORK_ANALYST_RUNTIME);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getFMEVectorProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_FME_VECTOR);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getFMEEsriProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_FME_ESRI);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getFMERasterProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_FME_RASTER);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    protected static ArrayList<ProductType> getFMEOtherProducts() {
        ArrayList<ProductType> arrayList = new ArrayList<ProductType>();
        arrayList.add(ProductType.IOBJECTS_FME_OTHER);
        arrayList.addAll(Toolkit.getTrialProducts());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyPictureToTempFile(String string, String string2, String ... stringArray) {
        for (String string3 : stringArray) {
            String string4 = string + string3;
            URL uRL = Toolkit.class.getResource(string4);
            if (uRL == null) {
                System.out.println("null");
            }
            String string5 = System.getProperty("os.name");
            String string6 = "";
            string6 = "Windows".indexOf(string5) != -1 ? string2 + string3 : string2 + "/" + string3;
            File file = new File(string6);
            InputStream inputStream = null;
            FileImageOutputStream fileImageOutputStream = null;
            if (string6 == null) continue;
            try {
                inputStream = uRL.openStream();
                fileImageOutputStream = new FileImageOutputStream(file);
            }
            catch (IOException iOException) {
                System.out.println("File Not Found!");
                iOException.printStackTrace();
            }
            try {
                int n = 0;
                while ((n = inputStream.read()) != -1) {
                    fileImageOutputStream.write(n);
                }
            }
            catch (IOException iOException) {
                System.out.println("IO write Error");
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (fileImageOutputStream != null) {
                        fileImageOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("IO close Error");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyFileToTempFile(String string, String string2, String ... stringArray) {
        for (String string3 : stringArray) {
            String string4 = string + string3;
            URL uRL = Class.class.getResource(string4);
            String string5 = string2 + string3;
            File file = new File(string5);
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            if (string5 == null) continue;
            try {
                inputStream = uRL.openStream();
                fileOutputStream = new FileOutputStream(file);
            }
            catch (IOException iOException) {
                System.out.println("File Not Found!");
                iOException.printStackTrace();
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
            try {
                String string6 = null;
                while ((string6 = lineNumberReader.readLine()) != null) {
                    fileOutputStream.write(string6.getBytes());
                }
            }
            catch (Exception exception) {
                System.out.println("IO write Error");
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (lineNumberReader != null) {
                        lineNumberReader.close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("IO close Error");
                }
            }
        }
    }

    protected static void setMappingRuntimeLicenseMode(boolean bl) {
        _$4 = bl;
    }

    protected static boolean getMappingRuntimeLicenseMode() {
        return _$4;
    }

    protected static void setSpaceRuntimeLicenseMode(boolean bl) {
        _$3 = bl;
    }

    protected static boolean getSpaceRuntimeLicenseMode() {
        return _$3;
    }

    protected static void setLayoutRuntimeLicenseMode(boolean bl) {
        _$2 = bl;
    }

    protected static boolean getLayoutRuntimeLicenseMode() {
        return _$2;
    }

    protected static int getChartLicenseState() {
        return ToolkitNative.jni_getChartLicenseState();
    }

    protected static void setChartLicenseState(int n) {
        ToolkitNative.jni_setChartLicenseState(n);
    }

    protected static int CheckChartLicenseState() {
        License license = new License();
        ToolkitNative.jni_setDrawChartLayer(false);
        int n = -1;
        if (license.connect(ProductType.IOBJECTS_CHART_DEVELOP) == 0 || license.connect(ProductType.IOBJECTS_CHART_RUNTIME) == 0) {
            n = 2;
        } else {
            ArrayList<ProductType> arrayList = Toolkit.getTrialProducts();
            int n2 = -1;
            for (ProductType productType : arrayList) {
                n2 = license.connect(productType);
                if (n2 != 0) continue;
                n = 0;
                ToolkitNative.jni_setDrawChartLayer(true);
                break;
            }
        }
        if (license.connect(ProductType.ISERVER_CHART) == 0) {
            n = 0;
            if (_$1 == 0) {
                ToolkitNative.jni_setDrawChartLayer(true);
            }
        }
        license.disconnect();
        license.dispose();
        if (n != -1 && _$1 == 2) {
            ToolkitNative.jni_setDrawChartLayer(true);
        }
        ToolkitNative.jni_setChartLicenseState(n);
        return n;
    }

    protected static void setCurrentProduction(int n) {
        _$1 = n;
    }

    protected static int getCurrentProduction() {
        return _$1;
    }

    protected static boolean isEscape(int n, boolean bl) {
        return ToolkitNative.jni_IsEscape(n, bl);
    }

    static void dumpExceptionCallBack(String string) {
        if (string != null && !string.trim().equals("")) {
            throw new RuntimeException(string);
        }
    }

    public static String ConvertDateTimeToString(Date date, EngineType engineType) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        return ToolkitNative.jni_ConvertDateTimeToString(n, n2, n3, n4, n5, n6, engineType.getUGCValue());
    }

    public static Date ConvertStringToDate(String string) {
        String string2;
        Date date = null;
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        if (pattern.matcher(string2 = string).matches()) {
            String string3 = System.getProperty("os.name").toLowerCase();
            if (string3.equals("aix")) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    date = simpleDateFormat.parse(string2);
                }
                catch (ParseException parseException) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        date = simpleDateFormat.parse(string2);
                    }
                    catch (ParseException parseException2) {}
                }
            } else {
                try {
                    date = DateFormat.getDateInstance().parse(string2);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return date;
    }

    static {
        Environment.LoadWrapJ();
        _$4 = true;
        _$3 = true;
        _$2 = true;
        _$1 = 2;
    }
}

