/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2Ds;
import com.supermap.data.SymbolFill;
import com.supermap.data.SymbolGroup;
import com.supermap.data.SymbolLibrary;
import com.supermap.data.SymbolLine;
import com.supermap.data.SymbolMarker;
import com.supermap.data.SymbolMarker3D;
import com.supermap.data.SymbolNative;
import com.supermap.data.SymbolType;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public abstract class Symbol
extends InternalHandleDisposable {
    private SymbolLibrary _$4;
    private SymbolGroup _$3;

    protected Symbol() {
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        String string3 = "";
        if (string != null) {
            string3 = string;
        }
        SymbolNative.jni_setName(this.getHandle(), string3);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolNative.jni_getName(this.getHandle());
    }

    public int getID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolNative.jni_getID(this.getHandle());
    }

    public SymbolLibrary getLibrary() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$4;
    }

    public abstract SymbolType getType();

    public abstract boolean draw(Graphics var1, Geometry var2);

    public abstract boolean draw(BufferedImage var1, Geometry var2);

    public abstract boolean draw(Graphics var1, Point2Ds var2, GeoStyle var3);

    public abstract boolean draw(BufferedImage var1, Point2Ds var2, GeoStyle var3);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Name=");
        stringBuffer.append(this.getName());
        stringBuffer.append(",ID=");
        stringBuffer.append(this.getID());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static final Symbol createInstance(Symbol symbol) {
        long l = SymbolNative.createInstance(symbol.getHandle());
        Symbol symbol2 = Symbol.createInstance(l);
        InternalHandleDisposable.makeSureNativeObjectLive(symbol);
        return symbol2;
    }

    static final Symbol createInstance(long l) {
        if (l == 0L) {
            return null;
        }
        int n = SymbolNative.jni_GetType(l);
        Symbol symbol = null;
        if (n == 0) {
            boolean bl = SymbolNative.jni_Is3D(l);
            symbol = bl ? new SymbolMarker3D(l) : new SymbolMarker(l);
        } else if (n == 1 || n == 4 || n == 6) {
            symbol = new SymbolLine(l);
        } else if (n == 2 || n == 5) {
            symbol = new SymbolFill(l);
        }
        if (symbol != null) {
            symbol.setIsDisposable(true);
        }
        return symbol;
    }

    void setLibrary(SymbolLibrary symbolLibrary) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this._$4 = symbolLibrary;
    }

    protected void setGroup(SymbolGroup symbolGroup) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLibrary()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this._$3 = symbolGroup;
    }

    protected SymbolGroup getGroup() {
        return this._$3;
    }
}

