/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.slf4j.Logger;

public final class SamlCompliantUniqueTicketIdGenerator
implements UniqueTicketIdGenerator {
    private static final int ASSERTION_HANDLE_SIZE = 20;
    private static final byte[] ENDPOINT_ID;
    private final byte[] sourceIdDigest;
    private boolean saml2compliant;
    private final SecureRandom random;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        SamlCompliantUniqueTicketIdGenerator.ajc$preClinit();
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        ENDPOINT_ID = byArray;
    }

    public SamlCompliantUniqueTicketIdGenerator(String sourceId) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(sourceId.getBytes("8859_1"));
            this.sourceIdDigest = messageDigest.digest();
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception generating digest of source ID.", e);
        }
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Cannot get SHA1PRNG secure random instance.");
        }
    }

    @Override
    public String getNewTicketId(String prefix) {
        String string = prefix;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        return (String)SamlCompliantUniqueTicketIdGenerator.getNewTicketId_aroundBody1$advice(this, string, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public void setSaml2compliant(boolean saml2compliant) {
        this.saml2compliant = saml2compliant;
    }

    private byte[] newAssertionHandle() {
        byte[] handle = new byte[20];
        this.random.nextBytes(handle);
        return handle;
    }

    private static final /* synthetic */ String getNewTicketId_aroundBody0(SamlCompliantUniqueTicketIdGenerator ajc$this, String prefix, JoinPoint joinPoint) {
        if (ajc$this.saml2compliant) {
            return new SAML2ArtifactType0004(ENDPOINT_ID, ajc$this.newAssertionHandle(), ajc$this.sourceIdDigest).base64Encode();
        }
        return new SAML1ArtifactType0001(ajc$this.sourceIdDigest, ajc$this.newAssertionHandle()).base64Encode();
    }

    private static final /* synthetic */ Object getNewTicketId_aroundBody1$advice(SamlCompliantUniqueTicketIdGenerator ajc$this, String prefix, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        String string;
        String returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            string = returnVal = SamlCompliantUniqueTicketIdGenerator.getNewTicketId_aroundBody0(ajc$this, prefix, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return string;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SamlCompliantUniqueTicketIdGenerator.java", SamlCompliantUniqueTicketIdGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewTicketId", "org.jasig.cas.util.SamlCompliantUniqueTicketIdGenerator", "java.lang.String", "prefix", "", "java.lang.String"), 74);
    }
}

