/*
 * Decompiled with CFR 0.152.
 */
package org.json.tests;

import junit.framework.TestCase;
import org.json.HTTPTokener;
import org.json.JSONException;

public class TestHTTPTokener
extends TestCase {
    private HTTPTokener httptokener;

    public void testNextToken_SimpleString() {
        try {
            this.httptokener = new HTTPTokener("{\n  \"Accept-Language\": 'en-us' ,\n  \"Host\": 23");
            TestHTTPTokener.assertEquals((String)"{", (String)this.httptokener.nextToken());
            TestHTTPTokener.assertEquals((String)"Accept-Language", (String)this.httptokener.nextToken());
            TestHTTPTokener.assertEquals((String)":", (String)this.httptokener.nextToken());
            TestHTTPTokener.assertEquals((String)"en-us", (String)this.httptokener.nextToken());
            TestHTTPTokener.assertEquals((String)",", (String)this.httptokener.nextToken());
            TestHTTPTokener.assertEquals((String)"Host", (String)this.httptokener.nextToken());
            TestHTTPTokener.assertEquals((String)":", (String)this.httptokener.nextToken());
            TestHTTPTokener.assertEquals((String)"23", (String)this.httptokener.nextToken());
        }
        catch (JSONException e) {
            TestHTTPTokener.fail((String)e.getMessage());
        }
    }

    public void testNextToken_UnterminatedString() {
        try {
            this.httptokener = new HTTPTokener("'en-us");
            this.httptokener.nextToken();
            TestHTTPTokener.fail((String)"Should have thrown exception");
        }
        catch (JSONException e) {
            TestHTTPTokener.assertEquals((String)"Unterminated string. at 7 [character 8 line 1]", (String)e.getMessage());
        }
    }
}

