/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.Colors;
import com.supermap.ui.DialogResult;
import com.supermap.ui.InternalImageIconFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

class ColorSchemeEditorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JLabel _$25;
    private JButton _$24;
    private JButton _$23;
    private JButton _$22;
    private JButton _$21;
    private JButton _$20;
    private JButton _$19;
    private ColorsTableModel _$18;
    private JButton _$17;
    private JButton _$16;
    private LinkedList<Color> _$15;
    private JTable _$14;
    private JScrollPane _$13;
    private JPanel _$12;
    private JPanel _$11;
    private JButton _$10;
    private JButton _$9;
    private JPanel _$8;
    private JPanel _$7;
    private JButton _$6;
    private JToolBar _$5;
    private DialogResult _$4 = DialogResult.CANCEL;
    private Colors _$3;
    private static final int _$2 = 1;
    private static final int _$1 = 121;

    public ColorSchemeEditorDialog() {
        this.setBounds(100, 100, 500, 350);
        this.setResizable(false);
    }

    public ColorSchemeEditorDialog(Colors colors) {
        this.setBounds(100, 100, 500, 350);
        this.setModal(true);
        this.setResizable(false);
        this._$3 = new Colors(colors);
        this._$15 = new LinkedList();
        for (int i = 0; i < colors.getCount(); ++i) {
            this._$15.add(colors.get(i));
        }
        this._$1();
        this.setDefaultCloseOperation(2);
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                ColorSchemeEditorDialog.this.refreshViewLabel();
            }
        });
    }

    public DialogResult getResult() {
        return this._$4;
    }

    public Colors getResultColors() {
        if (this._$4.equals((Object)DialogResult.APPLY)) {
            Color[] colorArray = new Color[this._$15.size()];
            return new Colors(this._$15.toArray(colorArray));
        }
        return this._$3;
    }

    private void _$1() {
        this.setTitle("\u914d\u8272\u65b9\u6848\u7f16\u8f91\u5668");
        this.getContentPane().add((Component)this.getToolBar(), "North");
        this.getContentPane().add((Component)this.getCenterPanel(), "Center");
        this.getContentPane().add((Component)this.getSourcePanel(), "South");
    }

    protected JToolBar getToolBar() {
        if (this._$5 == null) {
            this._$5 = new JToolBar();
            this._$5.add(this.getSelectAllButton());
            this._$5.add(this.getClearSelectionButton());
            this._$5.add(this.getAddColorButton());
            this._$5.add(this.getEditColorButton());
            this._$5.add(this.getRemoveColorButton());
            this._$5.add(this.getMoveTopButton());
            this._$5.add(this.getMoveUpButton());
            this._$5.add(this.getMoveDownButton());
            this._$5.add(this.getMoveBottomButton());
        }
        return this._$5;
    }

    protected JButton getSelectAllButton() {
        if (this._$6 == null) {
            ImageIcon imageIcon = new ImageIcon();
            BufferedImage bufferedImage = new BufferedImage(24, 24, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(InternalImageIconFactory.SELECTALL.getImage(), 0, 0, null);
            imageIcon.setImage(bufferedImage);
            this._$6 = new JButton(imageIcon);
            this._$6.setToolTipText("\u5168\u9009");
            this._$6.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorSchemeEditorDialog.this._$14.selectAll();
                }
            });
        }
        return this._$6;
    }

    protected JPanel getCenterPanel() {
        if (this._$7 == null) {
            this._$7 = new JPanel();
            this._$7.setLayout(new BorderLayout());
            this._$7.add((Component)this.getColorsPanel(), "Center");
            this._$7.add((Component)this.getPreViewPanel(), "South");
        }
        return this._$7;
    }

    protected JPanel getSourcePanel() {
        if (this._$8 == null) {
            this._$8 = new JPanel();
            this._$8.add(this.getConfirmButton());
            this._$8.add(this.getCancelButton());
        }
        return this._$8;
    }

    protected JButton getConfirmButton() {
        if (this._$9 == null) {
            this._$9 = new JButton();
            this._$9.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorSchemeEditorDialog.this._$4 = DialogResult.APPLY;
                    ColorSchemeEditorDialog.this.setVisible(false);
                }
            });
            this._$9.setText("\u786e\u5b9a");
        }
        return this._$9;
    }

    protected JButton getCancelButton() {
        if (this._$10 == null) {
            this._$10 = new JButton();
            this._$10.setText("\u53d6\u6d88");
            this._$10.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorSchemeEditorDialog.this._$4 = DialogResult.CANCEL;
                    ColorSchemeEditorDialog.this.setVisible(false);
                }
            });
        }
        return this._$10;
    }

    protected JPanel getColorsPanel() {
        if (this._$11 == null) {
            this._$11 = new JPanel();
            this._$11.setBorder(new TitledBorder(null, "\u989c\u8272\u96c6\u5408", 0, 0, null, null));
            this._$11.setLayout(new BorderLayout());
            this._$11.add((Component)this.getColorsScrollPane(), "Center");
        }
        return this._$11;
    }

    protected JPanel getPreViewPanel() {
        if (this._$12 == null) {
            this._$12 = new JPanel();
            this._$12.setLayout(new BorderLayout());
            this._$12.setBorder(new TitledBorder(null, "\u9884\u89c8", 0, 0, null, null));
            this._$12.add((Component)this.getPreViewLabel(), "Center");
        }
        return this._$12;
    }

    protected JScrollPane getColorsScrollPane() {
        if (this._$13 == null) {
            this._$13 = new JScrollPane();
            this._$13.setViewportView(this.getColorsTable());
        }
        return this._$13;
    }

    protected JTable getColorsTable() {
        if (this._$14 == null) {
            this._$14 = new JTable();
            this._$14.setRowHeight(25);
            this._$18 = new ColorsTableModel();
            this._$14.setModel(this._$18);
            TableColumn tableColumn = this._$14.getColumn("\u989c\u8272");
            tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

                public void setValue(Object object) {
                    if (object instanceof Color) {
                        Color color = (Color)object;
                        this.setBackground(color);
                    } else {
                        super.setValue(object);
                    }
                }
            });
        }
        return this._$14;
    }

    protected JButton getClearSelectionButton() {
        if (this._$16 == null) {
            ImageIcon imageIcon = new ImageIcon();
            BufferedImage bufferedImage = new BufferedImage(24, 24, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(InternalImageIconFactory.SELECTPREVIOUS.getImage(), 0, 0, null);
            imageIcon.setImage(bufferedImage);
            this._$16 = new JButton(imageIcon);
            this._$16.setToolTipText("\u53cd\u9009");
            this._$16.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    int n2;
                    int[] nArray = ColorSchemeEditorDialog.this._$14.getSelectedRows();
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        arrayList.add(nArray[n2]);
                    }
                    n2 = ColorSchemeEditorDialog.this._$15.size();
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    for (n = 0; n < n2; ++n) {
                        arrayList2.add(n);
                    }
                    arrayList2.removeAll(arrayList);
                    ColorSchemeEditorDialog.this._$14.clearSelection();
                    for (n = 0; n < arrayList2.size(); ++n) {
                        ColorSchemeEditorDialog.this._$14.addRowSelectionInterval((Integer)arrayList2.get(n), (Integer)arrayList2.get(n));
                    }
                }
            });
        }
        return this._$16;
    }

    protected JButton getAddColorButton() {
        if (this._$17 == null) {
            ImageIcon imageIcon = new ImageIcon();
            BufferedImage bufferedImage = new BufferedImage(24, 24, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(InternalImageIconFactory.COLORSCHEMEEDITORADDKEYCOLOR.getImage(), 0, 0, null);
            imageIcon.setImage(bufferedImage);
            this._$17 = new JButton(imageIcon);
            this._$17.setToolTipText("\u6dfb\u52a0");
            this._$17.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(null, "\u9009\u62e9\u989c\u8272", null);
                    if (color != null) {
                        ColorSchemeEditorDialog.this._$15.add(color);
                        ColorSchemeEditorDialog.this._$18.fireTableDataChanged();
                        ColorSchemeEditorDialog.this.refreshViewLabel();
                        ColorSchemeEditorDialog.this._$14.setRowSelectionInterval(ColorSchemeEditorDialog.this._$15.size() - 1, ColorSchemeEditorDialog.this._$15.size() - 1);
                    }
                }
            });
        }
        return this._$17;
    }

    protected JButton getEditColorButton() {
        if (this._$19 == null) {
            ImageIcon imageIcon = new ImageIcon();
            BufferedImage bufferedImage = new BufferedImage(24, 24, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(InternalImageIconFactory.COLORSCHEMEEDITOREDITKEYCOLOER.getImage(), 0, 0, null);
            imageIcon.setImage(bufferedImage);
            this._$19 = new JButton(imageIcon);
            this._$19.setToolTipText("\u7f16\u8f91");
            this._$19.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color;
                    int n = ColorSchemeEditorDialog.this._$14.getSelectedRow();
                    Object object = ColorSchemeEditorDialog.this._$18.getValueAt(n, 1);
                    if (object != null && object instanceof Color && (color = JColorChooser.showDialog(null, "\u9009\u62e9\u989c\u8272", null)) != null) {
                        ColorSchemeEditorDialog.this._$15.set(n, color);
                        ColorSchemeEditorDialog.this._$18.fireTableDataChanged();
                        ColorSchemeEditorDialog.this.refreshViewLabel();
                        ColorSchemeEditorDialog.this._$14.setRowSelectionInterval(n, n);
                    }
                }
            });
        }
        return this._$19;
    }

    protected JButton getRemoveColorButton() {
        if (this._$20 == null) {
            ImageIcon imageIcon = new ImageIcon();
            BufferedImage bufferedImage = new BufferedImage(24, 24, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(InternalImageIconFactory.COLORSCHEMEEDITORREMOVEKEYCOLOR.getImage(), 0, 0, null);
            imageIcon.setImage(bufferedImage);
            this._$20 = new JButton(imageIcon);
            this._$20.setToolTipText("\u79fb\u9664");
            this._$20.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ColorSchemeEditorDialog.this._$14.getSelectedRow();
                    int[] nArray = ColorSchemeEditorDialog.this._$14.getSelectedRows();
                    int n2 = nArray.length;
                    if (n2 > 0) {
                        while (n2 > 0) {
                            ColorSchemeEditorDialog.this._$15.remove(n2 - 1);
                            --n2;
                        }
                        ColorSchemeEditorDialog.this._$18.fireTableDataChanged();
                        ColorSchemeEditorDialog.this.refreshViewLabel();
                        if (n - 1 != -1) {
                            ColorSchemeEditorDialog.this._$14.setRowSelectionInterval(n - 1, n - 1);
                        }
                    }
                }
            });
        }
        return this._$20;
    }

    protected JButton getMoveTopButton() {
        if (this._$21 == null) {
            ImageIcon imageIcon = new ImageIcon();
            BufferedImage bufferedImage = new BufferedImage(24, 24, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(InternalImageIconFactory.COLORSCHEMEEDITORMOVEFIRST.getImage(), 0, 0, null);
            imageIcon.setImage(bufferedImage);
            this._$21 = new JButton(imageIcon);
            this._$21.setToolTipText("\u7f6e\u9876");
            this._$21.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ColorSchemeEditorDialog.this._$14.getSelectedRow() == 0) {
                        return;
                    }
                    Object object = ColorSchemeEditorDialog.this._$18.getValueAt(ColorSchemeEditorDialog.this._$14.getSelectedRow(), 1);
                    if (object != null) {
                        ColorSchemeEditorDialog.this._$15.remove(ColorSchemeEditorDialog.this._$14.getSelectedRow());
                        ColorSchemeEditorDialog.this._$15.addFirst((Color)object);
                        ColorSchemeEditorDialog.this._$18.fireTableDataChanged();
                        ColorSchemeEditorDialog.this.refreshViewLabel();
                        ColorSchemeEditorDialog.this._$14.setRowSelectionInterval(0, 0);
                    }
                }
            });
        }
        return this._$21;
    }

    protected JButton getMoveUpButton() {
        if (this._$22 == null) {
            ImageIcon imageIcon = new ImageIcon();
            BufferedImage bufferedImage = new BufferedImage(24, 24, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(InternalImageIconFactory.COLORSCHEMEEDITORMOVEUP.getImage(), 0, 0, null);
            imageIcon.setImage(bufferedImage);
            this._$22 = new JButton(imageIcon);
            this._$22.setToolTipText("\u4e0a\u79fb");
            this._$22.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ColorSchemeEditorDialog.this._$14.getSelectedRow();
                    if (n == 0) {
                        return;
                    }
                    Object object = ColorSchemeEditorDialog.this._$18.getValueAt(n, 1);
                    Object object2 = ColorSchemeEditorDialog.this._$18.getValueAt(n - 1, 1);
                    if (object != null && object2 != null) {
                        ColorSchemeEditorDialog.this._$15.set(n - 1, (Color)object);
                        ColorSchemeEditorDialog.this._$15.set(n, (Color)object2);
                        ColorSchemeEditorDialog.this._$18.fireTableDataChanged();
                        ColorSchemeEditorDialog.this.refreshViewLabel();
                        ColorSchemeEditorDialog.this._$14.setRowSelectionInterval(n - 1, n - 1);
                    }
                }
            });
        }
        return this._$22;
    }

    protected JButton getMoveDownButton() {
        if (this._$23 == null) {
            ImageIcon imageIcon = new ImageIcon();
            BufferedImage bufferedImage = new BufferedImage(24, 24, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(InternalImageIconFactory.COLORSCHEMEEDITORMOVEDOWN.getImage(), 0, 0, null);
            imageIcon.setImage(bufferedImage);
            this._$23 = new JButton(imageIcon);
            this._$23.setToolTipText("\u4e0b\u79fb");
            this._$23.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ColorSchemeEditorDialog.this._$14.getSelectedRow();
                    if (n == ColorSchemeEditorDialog.this._$15.size() - 1) {
                        return;
                    }
                    Object object = ColorSchemeEditorDialog.this._$18.getValueAt(n, 1);
                    Object object2 = ColorSchemeEditorDialog.this._$18.getValueAt(n + 1, 1);
                    if (object != null && object2 != null) {
                        ColorSchemeEditorDialog.this._$15.set(n + 1, (Color)object);
                        ColorSchemeEditorDialog.this._$15.set(n, (Color)object2);
                        ColorSchemeEditorDialog.this._$18.fireTableDataChanged();
                        ColorSchemeEditorDialog.this.refreshViewLabel();
                        ColorSchemeEditorDialog.this._$14.setRowSelectionInterval(n + 1, n + 1);
                    }
                }
            });
        }
        return this._$23;
    }

    protected JButton getMoveBottomButton() {
        if (this._$24 == null) {
            ImageIcon imageIcon = new ImageIcon();
            BufferedImage bufferedImage = new BufferedImage(24, 24, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(InternalImageIconFactory.COLORSCHEMEEDITORMOVELAST.getImage(), 0, 0, null);
            imageIcon.setImage(bufferedImage);
            this._$24 = new JButton(imageIcon);
            this._$24.setToolTipText("\u7f6e\u5e95");
            this._$24.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ColorSchemeEditorDialog.this._$14.getSelectedRow() == ColorSchemeEditorDialog.this._$15.size() - 1) {
                        return;
                    }
                    Object object = ColorSchemeEditorDialog.this._$18.getValueAt(ColorSchemeEditorDialog.this._$14.getSelectedRow(), 1);
                    if (object != null) {
                        ColorSchemeEditorDialog.this._$15.remove(ColorSchemeEditorDialog.this._$14.getSelectedRow());
                        ColorSchemeEditorDialog.this._$15.addLast((Color)object);
                        ColorSchemeEditorDialog.this._$18.fireTableDataChanged();
                        ColorSchemeEditorDialog.this.refreshViewLabel();
                        ColorSchemeEditorDialog.this._$14.setRowSelectionInterval(ColorSchemeEditorDialog.this._$15.size() - 1, ColorSchemeEditorDialog.this._$15.size() - 1);
                    }
                }
            });
        }
        return this._$24;
    }

    protected JLabel getPreViewLabel() {
        if (this._$25 == null) {
            this._$25 = new JLabel();
            this._$25.setPreferredSize(new Dimension(10, 35));
        }
        return this._$25;
    }

    protected void refreshViewLabel() {
        int n = this._$25.getSize().width;
        int n2 = this._$25.getSize().height;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n3 = this._$15.size();
        Color[] colorArray = new Color[n3];
        if (n3 == 0) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n, n2);
        } else if (n3 == 1) {
            graphics2D.setColor(this._$15.get(0));
            graphics2D.fillRect(0, 0, n, n2);
        } else {
            Colors colors = Colors.makeGradient((int)121, (Color[])this._$15.toArray(colorArray));
            int n4 = colors.getCount();
            int n5 = n / n4;
            for (int i = 0; i < n4; ++i) {
                graphics2D.setColor(colors.get(i));
                graphics2D.fillRect(n5 * i, 0, n5 * (i + 1), n2);
            }
        }
        this._$25.setIcon(new ImageIcon(bufferedImage));
    }

    class ColorsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] _$1 = new String[]{"\u5e8f\u53f7", "\u989c\u8272"};

        public int getRowCount() {
            return ColorSchemeEditorDialog.this._$15.size();
        }

        public int getColumnCount() {
            return this._$1.length;
        }

        public String getColumnName(int n) {
            return this._$1[n];
        }

        public Object getValueAt(int n, int n2) {
            Integer n3 = null;
            if (n >= 0 && n < ColorSchemeEditorDialog.this._$15.size()) {
                n3 = n2 == 0 ? Integer.valueOf(n + 1) : ColorSchemeEditorDialog.this._$15.get(n);
            }
            return n3;
        }
    }
}

