/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.mapping.InternalGeometry;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Map;
import com.supermap.mapping.ScreenLayerAddedEvent;
import com.supermap.mapping.ScreenLayerAddedListener;
import com.supermap.mapping.ScreenLayerClearedEvent;
import com.supermap.mapping.ScreenLayerClearedListener;
import com.supermap.mapping.ScreenLayerGeometryChangedEvent;
import com.supermap.mapping.ScreenLayerGeometryChangedListener;
import com.supermap.mapping.ScreenLayerNative;
import com.supermap.mapping.ScreenLayerRemovedEvent;
import com.supermap.mapping.ScreenLayerRemovedListener;
import com.supermap.mapping.ScreenLayerTagChangedEvent;
import com.supermap.mapping.ScreenLayerTagChangedListener;
import com.supermap.mapping.ScreenLayerVisibleChangedEvent;
import com.supermap.mapping.ScreenLayerVisibleChangedListener;
import java.util.Vector;

public class ScreenLayer
extends InternalHandle {
    Map m_map;
    transient Vector m_screenLayerAddedListeners;
    transient Vector m_screenLayerRemovedListeners;
    transient Vector m_screenLayerGeometryChangedListeners;
    transient Vector m_screenLayerTagChangedListeners;
    transient Vector m_screenLayerClearedListeners;
    transient Vector m_screenLayerVisibleChangedListeners;

    private ScreenLayer(long l, Map map) {
        this.setHandle(l);
        this.m_map = map;
        this._$1();
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_GetCount(this.getHandle());
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_GetIsVisible(this.getHandle());
    }

    public void setVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ScreenLayerNative.jni_SetIsVisible(this.getHandle(), bl);
        ScreenLayerVisibleChangedEvent screenLayerVisibleChangedEvent = new ScreenLayerVisibleChangedEvent((Object)this, bl);
        this.fireScreenLayerVisibleChanged(screenLayerVisibleChangedEvent);
    }

    public boolean isAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_GetIsAntialias(this.getHandle());
    }

    public void setAntialias(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAntialias(value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ScreenLayerNative.jni_SetAntialias(this.getHandle(), bl);
    }

    public int add(Geometry geometry, String string) {
        int n;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("add(Geometry geometry, String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (geometry == null) {
            String string3 = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string4 = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            string = "";
        }
        if ((n = ScreenLayerNative.jni_Add(this.getHandle(), l, string)) != -1) {
            ScreenLayerAddedEvent screenLayerAddedEvent = new ScreenLayerAddedEvent((Object)this, n, geometry, string);
            this.fireScreenLayerAdded(screenLayerAddedEvent);
        }
        this._$1((com.supermap.data.InternalHandleDisposable)geometry);
        return n;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("delete(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = ScreenLayerNative.jni_Delete(this.getHandle(), n);
        if (bl) {
            ScreenLayerRemovedEvent screenLayerRemovedEvent = new ScreenLayerRemovedEvent((Object)this, n);
            this.fireScreenLayerRemoved(screenLayerRemovedEvent);
        }
        return bl;
    }

    public Geometry get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry = null;
        long l = ScreenLayerNative.jni_Get(this.getHandle(), n);
        if (l != 0L) {
            geometry = InternalGeometry.createInstance2(l, this.m_map.getWorkspace());
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, true);
        }
        return geometry;
    }

    public boolean set(int n, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ScreenLayerNative.jni_Set(this.getHandle(), n, l);
        if (bl) {
            ScreenLayerGeometryChangedEvent screenLayerGeometryChangedEvent = new ScreenLayerGeometryChangedEvent((Object)this, n, geometry);
            this.fireScreenLayerGeometryChanged(screenLayerGeometryChangedEvent);
        }
        return bl;
    }

    public String getTag(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTag(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return ScreenLayerNative.jni_GetTag(this.getHandle(), n);
    }

    public boolean setTag(int n, String string) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setTag(int index, String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (n < 0 || n >= this.getCount()) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string3);
        }
        if (string == null) {
            string = "";
        }
        if (bl = ScreenLayerNative.jni_SetTag(this.getHandle(), n, string)) {
            ScreenLayerTagChangedEvent screenLayerTagChangedEvent = new ScreenLayerTagChangedEvent((Object)this, n, string);
            this.fireScreenLayerTagChanged(screenLayerTagChangedEvent);
        }
        return bl;
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("indexOf(String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("indexOf(String tag)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        return ScreenLayerNative.jni_IndexOf(this.getHandle(), string);
    }

    public boolean setEditBulk(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEditBulk(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_SetEditBulk(this.getHandle(), bl);
    }

    public boolean flushBulkEdit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FlushBulkEdit()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_FlushBulkEdit(this.getHandle());
    }

    @Deprecated
    public boolean cancleBulkOperated() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CancleBulkOperated()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_CancleBulkOperated(this.getHandle());
    }

    public boolean cancelBulkOperated() {
        return this.cancleBulkOperated();
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ScreenLayerNative.jni_Clear(this.getHandle());
        ScreenLayerClearedEvent screenLayerClearedEvent = new ScreenLayerClearedEvent((Object)this);
        this.fireScreenLayerCleared(screenLayerClearedEvent);
    }

    public int hitTest(Point2D point2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D point, double tolerance)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("tolerance", "ScreenLayer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return ScreenLayerNative.jni_HitTest(this.getHandle(), point2D.getX(), point2D.getY(), d);
    }

    protected static ScreenLayer createInstance(long l, Map map) {
        return new ScreenLayer(l, map);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    @Deprecated
    public synchronized void addSreenLayerAddedListeners(ScreenLayerAddedListener screenLayerAddedListener) {
        this.addScreenLayerAddedListener(screenLayerAddedListener);
    }

    public synchronized void addScreenLayerAddedListener(ScreenLayerAddedListener screenLayerAddedListener) {
        if (this.m_screenLayerAddedListeners == null) {
            this.m_screenLayerAddedListeners = new Vector();
        }
        if (!this.m_screenLayerAddedListeners.contains(screenLayerAddedListener)) {
            this.m_screenLayerAddedListeners.add(screenLayerAddedListener);
        }
    }

    @Deprecated
    public synchronized void removeSreenLayerAddedListeners(ScreenLayerAddedListener screenLayerAddedListener) {
        this.removeScreenLayerAddedListener(screenLayerAddedListener);
    }

    public synchronized void removeScreenLayerAddedListener(ScreenLayerAddedListener screenLayerAddedListener) {
        if (this.m_screenLayerAddedListeners != null && this.m_screenLayerAddedListeners.contains(screenLayerAddedListener)) {
            this.m_screenLayerAddedListeners.remove(screenLayerAddedListener);
        }
    }

    protected void fireScreenLayerAdded(ScreenLayerAddedEvent screenLayerAddedEvent) {
        if (this.m_screenLayerAddedListeners != null) {
            Vector vector = this.m_screenLayerAddedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayerAddedListener)vector.elementAt(i)).screenLayerAdded(screenLayerAddedEvent);
            }
        }
    }

    @Deprecated
    public synchronized void addSreenLayerRemovedListeners(ScreenLayerRemovedListener screenLayerRemovedListener) {
        this.addScreenLayerRemovedListener(screenLayerRemovedListener);
    }

    public synchronized void addScreenLayerRemovedListener(ScreenLayerRemovedListener screenLayerRemovedListener) {
        if (this.m_screenLayerRemovedListeners == null) {
            this.m_screenLayerRemovedListeners = new Vector();
        }
        if (!this.m_screenLayerRemovedListeners.contains(screenLayerRemovedListener)) {
            this.m_screenLayerRemovedListeners.add(screenLayerRemovedListener);
        }
    }

    @Deprecated
    public synchronized void removeSreenLayerRemovedListeners(ScreenLayerRemovedListener screenLayerRemovedListener) {
        this.removeScreenLayerRemovedListener(screenLayerRemovedListener);
    }

    public synchronized void removeScreenLayerRemovedListener(ScreenLayerRemovedListener screenLayerRemovedListener) {
        if (this.m_screenLayerRemovedListeners != null && this.m_screenLayerRemovedListeners.contains(screenLayerRemovedListener)) {
            this.m_screenLayerRemovedListeners.remove(screenLayerRemovedListener);
        }
    }

    protected void fireScreenLayerRemoved(ScreenLayerRemovedEvent screenLayerRemovedEvent) {
        if (this.m_screenLayerRemovedListeners != null) {
            Vector vector = this.m_screenLayerRemovedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayerRemovedListener)vector.elementAt(i)).screenLayerRemoved(screenLayerRemovedEvent);
            }
        }
    }

    @Deprecated
    public synchronized void addSreenLayerGeometryChangedListeners(ScreenLayerGeometryChangedListener screenLayerGeometryChangedListener) {
        this.addScreenLayerGeometryChangedListener(screenLayerGeometryChangedListener);
    }

    public synchronized void addScreenLayerGeometryChangedListener(ScreenLayerGeometryChangedListener screenLayerGeometryChangedListener) {
        if (this.m_screenLayerGeometryChangedListeners == null) {
            this.m_screenLayerGeometryChangedListeners = new Vector();
        }
        if (!this.m_screenLayerGeometryChangedListeners.contains(screenLayerGeometryChangedListener)) {
            this.m_screenLayerGeometryChangedListeners.add(screenLayerGeometryChangedListener);
        }
    }

    @Deprecated
    public synchronized void removeSreenLayerGeometryChangedListeners(ScreenLayerGeometryChangedListener screenLayerGeometryChangedListener) {
        this.removeScreenLayerGeometryChangedListener(screenLayerGeometryChangedListener);
    }

    public synchronized void removeScreenLayerGeometryChangedListener(ScreenLayerGeometryChangedListener screenLayerGeometryChangedListener) {
        if (this.m_screenLayerGeometryChangedListeners != null && this.m_screenLayerGeometryChangedListeners.contains(screenLayerGeometryChangedListener)) {
            this.m_screenLayerGeometryChangedListeners.remove(screenLayerGeometryChangedListener);
        }
    }

    protected void fireScreenLayerGeometryChanged(ScreenLayerGeometryChangedEvent screenLayerGeometryChangedEvent) {
        if (this.m_screenLayerGeometryChangedListeners != null) {
            Vector vector = this.m_screenLayerGeometryChangedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayerGeometryChangedListener)vector.elementAt(i)).screenLayerGeometryChanged(screenLayerGeometryChangedEvent);
            }
        }
    }

    @Deprecated
    public synchronized void addSreenLayerTagChangedListeners(ScreenLayerTagChangedListener screenLayerTagChangedListener) {
        this.addScreenLayerTagChangedListener(screenLayerTagChangedListener);
    }

    public synchronized void addScreenLayerTagChangedListener(ScreenLayerTagChangedListener screenLayerTagChangedListener) {
        if (this.m_screenLayerTagChangedListeners == null) {
            this.m_screenLayerTagChangedListeners = new Vector();
        }
        if (!this.m_screenLayerTagChangedListeners.contains(screenLayerTagChangedListener)) {
            this.m_screenLayerTagChangedListeners.add(screenLayerTagChangedListener);
        }
    }

    @Deprecated
    public synchronized void removeSreenLayerTagChangedListeners(ScreenLayerTagChangedListener screenLayerTagChangedListener) {
        this.removeScreenLayerTagChangedListener(screenLayerTagChangedListener);
    }

    public synchronized void removeScreenLayerTagChangedListener(ScreenLayerTagChangedListener screenLayerTagChangedListener) {
        if (this.m_screenLayerTagChangedListeners != null && this.m_screenLayerTagChangedListeners.contains(screenLayerTagChangedListener)) {
            this.m_screenLayerTagChangedListeners.remove(screenLayerTagChangedListener);
        }
    }

    protected void fireScreenLayerTagChanged(ScreenLayerTagChangedEvent screenLayerTagChangedEvent) {
        if (this.m_screenLayerTagChangedListeners != null) {
            Vector vector = this.m_screenLayerTagChangedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayerTagChangedListener)vector.elementAt(i)).screenLayerTagChanged(screenLayerTagChangedEvent);
            }
        }
    }

    @Deprecated
    public synchronized void addSreenLayerClearedListeners(ScreenLayerClearedListener screenLayerClearedListener) {
        this.addScreenLayerClearedListener(screenLayerClearedListener);
    }

    public synchronized void addScreenLayerClearedListener(ScreenLayerClearedListener screenLayerClearedListener) {
        if (this.m_screenLayerClearedListeners == null) {
            this.m_screenLayerClearedListeners = new Vector();
        }
        if (!this.m_screenLayerClearedListeners.contains(screenLayerClearedListener)) {
            this.m_screenLayerClearedListeners.add(screenLayerClearedListener);
        }
    }

    @Deprecated
    public synchronized void removeSreenLayerClearedListeners(ScreenLayerClearedListener screenLayerClearedListener) {
        this.removeScreenLayerClearedListener(screenLayerClearedListener);
    }

    public synchronized void removeScreenLayerClearedListener(ScreenLayerClearedListener screenLayerClearedListener) {
        if (this.m_screenLayerClearedListeners != null && this.m_screenLayerClearedListeners.contains(screenLayerClearedListener)) {
            this.m_screenLayerClearedListeners.remove(screenLayerClearedListener);
        }
    }

    protected void fireScreenLayerCleared(ScreenLayerClearedEvent screenLayerClearedEvent) {
        if (this.m_screenLayerClearedListeners != null) {
            Vector vector = this.m_screenLayerClearedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayerClearedListener)vector.elementAt(i)).screenLayerCleared(screenLayerClearedEvent);
            }
        }
    }

    @Deprecated
    public synchronized void addScreenLayerVisibleChangedListeners(ScreenLayerVisibleChangedListener screenLayerVisibleChangedListener) {
        this.addScreenLayerVisibleChangedListener(screenLayerVisibleChangedListener);
    }

    public synchronized void addScreenLayerVisibleChangedListener(ScreenLayerVisibleChangedListener screenLayerVisibleChangedListener) {
        if (this.m_screenLayerVisibleChangedListeners == null) {
            this.m_screenLayerVisibleChangedListeners = new Vector();
        }
        if (!this.m_screenLayerVisibleChangedListeners.contains(screenLayerVisibleChangedListener)) {
            this.m_screenLayerVisibleChangedListeners.add(screenLayerVisibleChangedListener);
        }
    }

    @Deprecated
    public synchronized void removeScreenLayerVisibleChangedListeners(ScreenLayerVisibleChangedListener screenLayerVisibleChangedListener) {
        this.removeScreenLayerVisibleChangedListener(screenLayerVisibleChangedListener);
    }

    public synchronized void removeScreenLayerVisibleChangedListener(ScreenLayerVisibleChangedListener screenLayerVisibleChangedListener) {
        if (this.m_screenLayerVisibleChangedListeners != null && this.m_screenLayerVisibleChangedListeners.contains(screenLayerVisibleChangedListener)) {
            this.m_screenLayerVisibleChangedListeners.remove(screenLayerVisibleChangedListener);
        }
    }

    protected void fireScreenLayerVisibleChanged(ScreenLayerVisibleChangedEvent screenLayerVisibleChangedEvent) {
        if (this.m_screenLayerVisibleChangedListeners != null) {
            Vector vector = this.m_screenLayerVisibleChangedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayerVisibleChangedListener)vector.elementAt(i)).visibleChanged(screenLayerVisibleChangedEvent);
            }
        }
    }

    private void _$1() {
        ScreenLayerNative.jni_Reset(this.getHandle());
    }

    private void _$1(com.supermap.data.InternalHandleDisposable internalHandleDisposable) {
        InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable);
    }
}

