/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.GeoMap;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.LayerPainterNative;
import com.supermap.mapping.Map;
import com.supermap.ui.InternalBufferImage;
import java.awt.Graphics;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPainter
extends InternalHandle {
    protected long graphicsHandle;
    private InternalBufferImage _$2 = null;
    private Graphics _$1 = null;

    MapPainter(Map map, long l) {
        this.setHandle(LayerPainterNative.jni_GetLayerPainterHandle(InternalHandle.getHandle((com.supermap.data.InternalHandle)map)));
        this.graphicsHandle = l;
    }

    public Graphics getGraphics() {
        long l;
        if (this._$1 == null && (l = LayerPainterNative.jni_GetBufferImageHandle(this.graphicsHandle)) != 0L) {
            this._$2 = new InternalBufferImage(l, true);
            this._$1 = this._$2.getInternalImage().getGraphics();
        }
        return this._$1;
    }

    void realeaseGraphics() {
        if (this._$1 != null) {
            this._$1.dispose();
            this._$1 = null;
        }
        if (this._$2 != null) {
            this._$2.dispose();
            this._$2 = null;
        }
    }

    public void drawGeometry(Geometry geometry) {
        if (geometry instanceof GeoMap) {
            throw new IllegalArgumentException();
        }
        LayerPainterNative.jni_DrawGeometry(this.getHandle(), this.graphicsHandle, InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
    }

    public void drawGeometry(Iterable<Geometry> iterable, GeoStyle geoStyle) {
        Object object2;
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (Object object2 : iterable) {
            if (object2 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)object2) == 0L) continue;
            arrayList.add((Geometry)object2);
        }
        object2 = new long[arrayList.size()];
        for (int i = 0; i < ((Geometry)object2).length; ++i) {
            object2[i] = (Geometry)InternalHandle.getHandle((com.supermap.data.InternalHandle)arrayList.get(i));
        }
        long l = 0L;
        if (geoStyle != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        }
        LayerPainterNative.jni_DrawGeometries(this.getHandle(), this.graphicsHandle, (long[])object2, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        InternalHandleDisposable.makeSureNativeObjectLive(arrayList);
    }

    void copyBufferImageToUGC() {
        if (this._$2 != null) {
            this._$2.setMemoryImageToUGC();
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$2);
            if (l != 0L) {
                LayerPainterNative.jni_CopyBufferImageToUGC(this.graphicsHandle, l);
            }
        }
    }

    public void dispose() {
        this.clearHandle();
    }
}

