/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.IgnoreMode;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingJPGNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.MultiBandImportMode;
import java.io.File;

public class ImportSettingJPG
extends ImportSetting {
    public ImportSettingJPG() {
        long l = ImportSettingJPGNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.RASTER);
    }

    public ImportSettingJPG(ImportSettingJPG importSettingJPG) {
        if (importSettingJPG == null) {
            String string = InternalResource.loadString("importSettingJPG", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingJPG);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingJPG", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingJPGNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingJPG.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingJPG.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingJPG.getTargetPrjCoordSys());
        super.setDataType(DataType.RASTER);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingJPG));
    }

    public ImportSettingJPG(String string, DatasourceConnectionInfo datasourceConnectionInfo) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public ImportSettingJPG(String string, Datasource datasource) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasource(datasource);
    }

    public boolean isImportingAsGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDataInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingJPGNative.jni_IsImportingAsGrid(this.getHandle());
    }

    public void setImportingAsGrid(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsGrid(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingJPGNative.jni_SetImportingAsGrid(this.getHandle(), bl);
    }

    public boolean isPyramidBuilt() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isPyramidBuilt()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingJPGNative.jni_IsPyramidBuilt(this.getHandle());
    }

    public void setPyramidBuilt(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPyramidBuilt(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingJPGNative.jni_SetPyramidBuilt(this.getHandle(), bl);
    }

    public String getWorldFilePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorldFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingJPGNative.jni_GetWorldFilePath(this.getHandle());
    }

    public MultiBandImportMode getMultiBandImportMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMultiBandImportMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingJPGNative.jni_GetMultiBandImportMode(this.getHandle());
        return (MultiBandImportMode)InternalEnum.parseUGCValue(MultiBandImportMode.class, n);
    }

    public void setMultiBandImportMode(MultiBandImportMode multiBandImportMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMultiBandImportMode(MultiBandImportMode mode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (multiBandImportMode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (multiBandImportMode != MultiBandImportMode.COMPOSITE && !this.hasFMElicense()) {
            String string = InternalResource.loadString("MultiBandImportMode Mode", "OnlySupportCOMPOSITEByNotHasFME", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingJPGNative.jni_SetMultiBandImportMode(this.getHandle(), multiBandImportMode.value());
    }

    public void setWorldFilePath(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setWorldFilePath(String value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = InternalResource.loadString("", "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string3);
        }
        ImportSettingJPGNative.jni_SetWorldFilePath(this.getHandle(), string);
    }

    public void setIgnoreMode(IgnoreMode ignoreMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreMode(int ignoreMode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ignoreMode.value();
        ImportSettingJPGNative.jni_SetIgnorMode(this.getHandle(), n);
    }

    public IgnoreMode getIgnoreMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingJPGNative.jni_GetIgnorMode(this.getHandle());
        return (IgnoreMode)InternalEnum.parseUGCValue(IgnoreMode.class, n);
    }

    public double[] getIgnoreValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreValues()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingJPGNative.jni_GetIgnoreValueCount(this.getHandle());
        double[] dArray = new double[n];
        ImportSettingJPGNative.jni_GetIgnoreValues(this.getHandle(), dArray);
        return dArray;
    }

    public void setIgnoreValues(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreValues", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (dArray == null) {
            dArray = new double[]{};
        }
        ImportSettingJPGNative.jni_SetIgnoreValues(this.getHandle(), dArray);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingJPGNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

