/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Charset;
import com.supermap.data.Dataset;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.DataExportNative;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalResource;
import java.io.File;

public class ExportSetting {
    String m_targetFilePath;
    String[] m_arrIgnoreFieldNames;
    boolean m_overwrite;
    FileType m_type;
    Object m_sourceData;
    Charset m_targetCharset;

    public ExportSetting() {
        this.m_targetFilePath = "";
        this.m_overwrite = false;
        this.m_type = FileType.NONE;
        this.m_sourceData = null;
        this.m_targetCharset = Charset.DEFAULT;
        this.m_arrIgnoreFieldNames = null;
    }

    public ExportSetting(ExportSetting exportSetting) {
        if (exportSetting == null) {
            String string = InternalResource.loadString("exportSetting", "Global_ArgumentNull", "conversion_resources");
            throw new NullPointerException(string);
        }
        this.setSourceData(exportSetting.getSourceData());
        this.setTargetFilePath(exportSetting.getTargetFilePath());
        this.setTargetFileType(exportSetting.getTargetFileType());
        this.setOverwrite(exportSetting.isOverwrite());
        this.setTargetFileCharset(exportSetting.getTargetFileCharset());
    }

    public ExportSetting(Object object, String string, FileType fileType) {
        this();
        this.setSourceData(object);
        this.setTargetFilePath(string);
        this.setTargetFileType(fileType);
        this.setTargetFileCharset(Charset.DEFAULT);
    }

    public String getTargetFilePath() {
        return this.m_targetFilePath;
    }

    public void setTargetFilePath(String string) {
        if (!this._$1(string)) {
            String string2 = InternalResource.loadString("filePath:" + string, "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string2);
        }
        this.m_targetFilePath = string;
    }

    public boolean isOverwrite() {
        return this.m_overwrite;
    }

    public void setOverwrite(boolean bl) {
        this.m_overwrite = bl;
    }

    public FileType getTargetFileType() {
        return this.m_type;
    }

    public void setTargetFileType(FileType fileType) {
        this.m_type = fileType;
    }

    public Charset getTargetFileCharset() {
        return this.m_targetCharset;
    }

    public void setTargetFileCharset(Charset charset) {
        this.m_targetCharset = charset;
    }

    public Object getSourceData() {
        return this.m_sourceData;
    }

    public void setSourceData(Object object) {
        if (object != null && !(object instanceof Dataset)) {
            String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_sourceData = object;
    }

    @Deprecated
    public String toXML() {
        return "";
    }

    @Deprecated
    public boolean fromXML(String string) {
        return false;
    }

    public FileType[] getSupportedFileType() {
        Dataset dataset = (Dataset)this.getSourceData();
        FileType[] fileTypeArray = null;
        if (dataset != null) {
            long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)dataset);
            int[] nArray = DataExportNative.jni_GetSupportedFileType(l);
            fileTypeArray = new FileType[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                fileTypeArray[i] = (FileType)InternalEnum.parseUGCValue(FileType.class, nArray[i]);
            }
        }
        return fileTypeArray;
    }

    private boolean _$1(String string) {
        File file = new File(string);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    public String[] getIgnoreFieldNames() {
        return this.m_arrIgnoreFieldNames;
    }

    public void setIgnoreFieldNames(String[] stringArray) {
        this.m_arrIgnoreFieldNames = stringArray;
    }

    boolean check() {
        boolean bl = true;
        if (this.m_targetFilePath.length() == 0 || this.m_type.equals((Object)FileType.NONE) || this.m_sourceData == null) {
            bl = false;
        }
        return bl;
    }
}

