/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.key;

import com.googlecode.ehcache.annotations.key.AbstractDeepCacheKeyGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringCacheKeyGenerator
extends AbstractDeepCacheKeyGenerator<StringGenerator, String> {
    public static final String DEFAULT_BEAN_NAME = "com.googlecode.ehcache.annotations.key.StringCacheKeyGenerator.DEFAULT_BEAN_NAME";

    public StringCacheKeyGenerator() {
    }

    public StringCacheKeyGenerator(boolean includeMethod, boolean includeParameterTypes) {
        super(includeMethod, includeParameterTypes);
    }

    @Override
    protected StringGenerator getGenerator(Object ... data) {
        return new StringGenerator();
    }

    @Override
    protected String generateKey(StringGenerator generator) {
        return generator.builder.toString();
    }

    @Override
    protected void beginRecursion(StringGenerator generator, Object e) {
        generator.builder.append("[");
        generator.depth++;
    }

    @Override
    protected void endRecursion(StringGenerator generator, Object e) {
        int length = generator.builder.length();
        if (generator.depth > 0 && length > 2) {
            generator.builder.delete(length - 2, length);
        }
        if (generator.depth > 1) {
            generator.builder.append("], ");
        } else {
            generator.builder.append("]");
        }
        generator.depth--;
    }

    @Override
    protected void append(StringGenerator generator, boolean[] a) {
        generator.builder.append("[");
        if (a.length > 0) {
            for (int index = 0; index < a.length - 1; ++index) {
                generator.builder.append(a[index]).append(", ");
            }
            generator.builder.append(a[a.length - 1]);
        }
        generator.builder.append("], ");
    }

    @Override
    protected void append(StringGenerator generator, byte[] a) {
        generator.builder.append("[");
        if (a.length > 0) {
            for (int index = 0; index < a.length - 1; ++index) {
                generator.builder.append(a[index]).append(", ");
            }
            generator.builder.append(a[a.length - 1]);
        }
        generator.builder.append("], ");
    }

    @Override
    protected void append(StringGenerator generator, char[] a) {
        generator.builder.append("[");
        if (a.length > 0) {
            for (int index = 0; index < a.length - 1; ++index) {
                generator.builder.append(a[index]).append(", ");
            }
            generator.builder.append(a[a.length - 1]);
        }
        generator.builder.append("], ");
    }

    @Override
    protected void append(StringGenerator generator, double[] a) {
        generator.builder.append("[");
        if (a.length > 0) {
            for (int index = 0; index < a.length - 1; ++index) {
                generator.builder.append(a[index]).append(", ");
            }
            generator.builder.append(a[a.length - 1]);
        }
        generator.builder.append("], ");
    }

    @Override
    protected void append(StringGenerator generator, float[] a) {
        generator.builder.append("[");
        if (a.length > 0) {
            for (int index = 0; index < a.length - 1; ++index) {
                generator.builder.append(a[index]).append(", ");
            }
            generator.builder.append(a[a.length - 1]);
        }
        generator.builder.append("], ");
    }

    @Override
    protected void append(StringGenerator generator, int[] a) {
        generator.builder.append("[");
        if (a.length > 0) {
            for (int index = 0; index < a.length - 1; ++index) {
                generator.builder.append(a[index]).append(", ");
            }
            generator.builder.append(a[a.length - 1]);
        }
        generator.builder.append("], ");
    }

    @Override
    protected void append(StringGenerator generator, long[] a) {
        generator.builder.append("[");
        if (a.length > 0) {
            for (int index = 0; index < a.length - 1; ++index) {
                generator.builder.append(a[index]).append(", ");
            }
            generator.builder.append(a[a.length - 1]);
        }
        generator.builder.append("], ");
    }

    @Override
    protected void append(StringGenerator generator, short[] a) {
        generator.builder.append("[");
        if (a.length > 0) {
            for (int index = 0; index < a.length - 1; ++index) {
                generator.builder.append(a[index]).append(", ");
            }
            generator.builder.append(a[a.length - 1]);
        }
        generator.builder.append("], ");
    }

    @Override
    protected void append(StringGenerator generator, Object e) {
        generator.builder.append(e.toString()).append(", ");
    }

    @Override
    protected void appendGraphCycle(StringGenerator generator, Object o) {
        generator.builder.append("[...], ");
    }

    @Override
    protected void appendNull(StringGenerator generator) {
        generator.builder.append("null, ");
    }

    @Override
    protected boolean shouldReflect(Object element) {
        return !this.getReflectionHelper().implementsToString(element);
    }

    public static class StringGenerator {
        private final StringBuilder builder = new StringBuilder();
        private int depth = 0;

        private StringGenerator() {
        }
    }
}

