/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.interceptor;

import com.googlecode.ehcache.annotations.AdviceType;
import com.googlecode.ehcache.annotations.CacheAttributeSource;
import com.googlecode.ehcache.annotations.CacheableAttribute;
import com.googlecode.ehcache.annotations.MethodAttribute;
import com.googlecode.ehcache.annotations.ParameterMask;
import com.googlecode.ehcache.annotations.TriggersRemoveAttribute;
import com.googlecode.ehcache.annotations.When;
import com.googlecode.ehcache.annotations.key.CacheKeyGenerator;
import com.googlecode.ehcache.annotations.resolver.CacheableCacheResolver;
import com.googlecode.ehcache.annotations.resolver.TriggersRemoveCacheResolver;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheInterceptor
implements MethodInterceptor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CacheAttributeSource cacheAttributeSource;

    public void setCacheAttributeSource(CacheAttributeSource cacheableAttributeSource) {
        this.cacheAttributeSource = cacheableAttributeSource;
    }

    public final Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        Class<?> targetClass = methodInvocation.getThis() != null ? methodInvocation.getThis().getClass() : null;
        AdviceType adviceType = this.cacheAttributeSource.getAdviceType(method, targetClass);
        switch (adviceType) {
            case CACHE: {
                CacheableAttribute cacheableAttribute = this.cacheAttributeSource.getCacheableAttribute(method, targetClass);
                if (cacheableAttribute == null) {
                    this.logger.warn("CacheAttributeSource.getAdviceType(Method, Class) returned CACHE but CacheAttributeSource.getCacheableAttribute(Method, Class) returned null. Method will be invoked directly with no Cachable advice. Method: {}, Class: {}", (Object)method, targetClass);
                    return methodInvocation.proceed();
                }
                return this.invokeCacheable(methodInvocation, cacheableAttribute);
            }
            case REMOVE: {
                TriggersRemoveAttribute triggersRemoveAttribute = this.cacheAttributeSource.getTriggersRemoveAttribute(method, targetClass);
                if (triggersRemoveAttribute == null) {
                    this.logger.warn("CacheAttributeSource.getAdviceType(Method, Class) returned REMOVE but CacheAttributeSource.getTriggersRemoveAttribute(Method, Class) returned null. Method will be invoked directly with no TriggersFlush advice. Method: {}, Class: {}", (Object)method, targetClass);
                    return methodInvocation.proceed();
                }
                return this.invokeTriggersRemove(methodInvocation, triggersRemoveAttribute);
            }
        }
        this.logger.trace("The method {} is not advised {}.", (Object)methodInvocation, (Object)adviceType);
        return methodInvocation.proceed();
    }

    private Object invokeCacheable(MethodInvocation methodInvocation, CacheableAttribute cacheableAttribute) throws Throwable {
        Object value;
        Serializable cacheKey = this.generateCacheKey(methodInvocation, cacheableAttribute);
        this.checkForCachedException(cacheableAttribute, methodInvocation, cacheKey);
        CacheableCacheResolver cacheResolver = cacheableAttribute.getCacheResolver();
        Ehcache cache = cacheResolver.resolveCache(cacheKey, methodInvocation);
        ThreadLocal<MethodInvocation> entryFactory = cacheResolver.resolveSelfPopulatingCacheEntryFactory(cache, cacheKey, methodInvocation);
        if (entryFactory != null) {
            return this.invokeSelfPopulatingCacheable(methodInvocation, cacheableAttribute, cache, entryFactory, cacheKey);
        }
        Element element = cache.get(cacheKey);
        if (element != null) {
            return element.getObjectValue();
        }
        try {
            value = methodInvocation.proceed();
        }
        catch (Throwable t) {
            this.cacheException(cacheableAttribute, methodInvocation, cacheKey, t);
            throw t;
        }
        cache.put(new Element((Object)cacheKey, value));
        return value;
    }

    private Object invokeSelfPopulatingCacheable(MethodInvocation methodInvocation, CacheableAttribute cacheableAttribute, Ehcache cache, ThreadLocal<MethodInvocation> entryFactory, Serializable key) throws Throwable {
        Element element;
        entryFactory.set(methodInvocation);
        try {
            element = cache.get(key);
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            this.cacheException(cacheableAttribute, methodInvocation, key, cause);
            throw cause;
        }
        finally {
            entryFactory.remove();
        }
        if (element == null) {
            throw new IllegalStateException("the supposed SelfPopulatingCache returned null, which violates the contract it should always return an Element; perhaps the cache is not truly a SelfPopulatingCache?");
        }
        return element.getObjectValue();
    }

    private Object invokeTriggersRemove(MethodInvocation methodInvocation, TriggersRemoveAttribute triggersRemoveAttribute) throws Throwable {
        if (When.BEFORE_METHOD_INVOCATION.equals((Object)triggersRemoveAttribute.getWhen())) {
            this.invokeCacheRemove(methodInvocation, triggersRemoveAttribute);
            return methodInvocation.proceed();
        }
        Object methodInvocationResult = methodInvocation.proceed();
        this.invokeCacheRemove(methodInvocation, triggersRemoveAttribute);
        return methodInvocationResult;
    }

    private void invokeCacheRemove(MethodInvocation methodInvocation, TriggersRemoveAttribute triggersRemoveAttribute) {
        TriggersRemoveCacheResolver cacheResolver = triggersRemoveAttribute.getCacheResolver();
        if (triggersRemoveAttribute.isRemoveAll()) {
            Iterable<Ehcache> caches = cacheResolver.resolveRemoveAllCaches(methodInvocation);
            for (Ehcache ehcache : caches) {
                ehcache.removeAll();
            }
        } else {
            Serializable cacheKey = this.generateCacheKey(methodInvocation, triggersRemoveAttribute);
            Iterable<Ehcache> caches = cacheResolver.resolveRemoveCaches(cacheKey, methodInvocation);
            for (Ehcache ehcache : caches) {
                ehcache.remove(cacheKey);
            }
        }
    }

    protected void checkForCachedException(CacheableAttribute cacheableAttribute, MethodInvocation methodInvocation, Serializable key) throws Throwable {
        Element execptionElement;
        CacheableCacheResolver cacheResolver = cacheableAttribute.getCacheResolver();
        Ehcache exceptionCache = cacheResolver.resolveExceptionCache(key, methodInvocation, null);
        if (exceptionCache != null && (execptionElement = exceptionCache.get(key)) != null) {
            throw (Throwable)execptionElement.getObjectValue();
        }
    }

    protected void cacheException(CacheableAttribute cacheableAttribute, MethodInvocation methodInvocation, Serializable key, Throwable t) {
        CacheableCacheResolver cacheResolver = cacheableAttribute.getCacheResolver();
        Ehcache exceptionCache = cacheResolver.resolveExceptionCache(key, methodInvocation, t);
        if (exceptionCache != null) {
            exceptionCache.put(new Element(key, (Serializable)t));
        }
    }

    protected Serializable generateCacheKey(MethodInvocation methodInvocation, MethodAttribute methodAttribute) {
        CacheKeyGenerator<? extends Serializable> cacheKeyGenerator = methodAttribute.getCacheKeyGenerator();
        ParameterMask parameterMask = methodAttribute.getCacheKeyParameterMask();
        if (parameterMask.shouldMask()) {
            methodInvocation = new ParameterFilteringMethodInvocation(methodInvocation, parameterMask);
        }
        Serializable cacheKey = cacheKeyGenerator.generateKey(methodInvocation);
        this.logger.debug("Generated key '{}' for invocation: {}", (Object)cacheKey, (Object)methodInvocation);
        return cacheKey;
    }

    private static class ParameterFilteringMethodInvocation
    implements MethodInvocation {
        private final MethodInvocation methodInvocation;
        private final ParameterMask parameterMask;
        private Object[] filteredArguments = null;

        public ParameterFilteringMethodInvocation(MethodInvocation methodInvocation, ParameterMask parameterMask) {
            this.methodInvocation = methodInvocation;
            this.parameterMask = parameterMask;
        }

        public Object[] getArguments() {
            if (this.filteredArguments == null) {
                Object[] arguments = this.methodInvocation.getArguments();
                this.filteredArguments = this.parameterMask.maskParameters(arguments);
            }
            return this.filteredArguments;
        }

        public Method getMethod() {
            return this.methodInvocation.getMethod();
        }

        public AccessibleObject getStaticPart() {
            return this.methodInvocation.getStaticPart();
        }

        public Object getThis() {
            return this.methodInvocation.getThis();
        }

        public Object proceed() throws Throwable {
            if (this.filteredArguments != null) {
                Object[] arguments = this.methodInvocation.getArguments();
                this.parameterMask.unmaskParameters(arguments, this.filteredArguments);
            }
            return this.methodInvocation.proceed();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.filteredArguments);
            result = 31 * result + (this.methodInvocation == null ? 0 : this.methodInvocation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterFilteringMethodInvocation other = (ParameterFilteringMethodInvocation)obj;
            if (!Arrays.equals(this.filteredArguments, other.filteredArguments)) {
                return false;
            }
            return !(this.methodInvocation == null ? other.methodInvocation != null : !this.methodInvocation.equals(other.methodInvocation));
        }

        public String toString() {
            return "ParameterFilteringMethodInvocation [filteredArguments=" + Arrays.toString(this.filteredArguments) + ", methodInvocation=" + this.methodInvocation + "]";
        }
    }
}

