/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Resources;
import com.supermap.data.Size2D;
import com.supermap.data.Toolkit;
import com.supermap.realspace.Layer3DVectorFile;
import com.supermap.realspace.Layer3DVectorFileDataType;
import com.supermap.ui.InternalImageIconFactory;
import com.supermap.ui.NodeDataType;
import com.supermap.ui.TreeNodeData;
import com.supermap.ui.TreeNodeDecorator;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class Layer3DVectorFileNodeDecorator
implements TreeNodeDecorator {
    Layer3DVectorFileNodeDecorator() {
    }

    public void decorate(JLabel jLabel, TreeNodeData treeNodeData) {
        if (treeNodeData.getType().equals((Object)NodeDataType.LAYER3DVECTORFILE)) {
            ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
            Layer3DVectorFile layer3DVectorFile = (Layer3DVectorFile)treeNodeData.getData();
            jLabel.setText(layer3DVectorFile.getCaption());
            Layer3DVectorFileDataType layer3DVectorFileDataType = layer3DVectorFile.getDataType();
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics graphics = bufferedImage.getGraphics();
            GeoStyle3D geoStyle3D = layer3DVectorFile.getStyle();
            if (layer3DVectorFileDataType.equals((Object)Layer3DVectorFileDataType.POINT)) {
                Geometry geometry = this._$1(layer3DVectorFileDataType);
                GeoStyle geoStyle = this._$1(geoStyle3D);
                geometry.setStyle(geoStyle);
                graphics.setColor(geoStyle.getLineColor());
                graphics.drawImage(InternalImageIconFactory.LAYER3DVECTORFILEBACK.getImage(), 0, 0, jLabel);
                graphics.fillOval(6, 6, 4, 4);
                imageIcon.setImage(bufferedImage);
            } else if (layer3DVectorFileDataType.equals((Object)Layer3DVectorFileDataType.LINE)) {
                GeoStyle geoStyle = this._$1(geoStyle3D);
                graphics.setColor(geoStyle.getLineColor());
                geoStyle.setLineWidth(0.2);
                Geometry geometry = this._$1(layer3DVectorFileDataType);
                geometry.setStyle(geoStyle);
                Toolkit.draw((Geometry)geometry, (Resources)new Resources(), (Graphics)graphics);
                graphics.drawImage(InternalImageIconFactory.LAYER3DVECTORFILEBACK.getImage(), 0, 0, jLabel);
                imageIcon.setImage(bufferedImage);
            } else if (layer3DVectorFileDataType.equals((Object)Layer3DVectorFileDataType.REGION)) {
                GeoStyle geoStyle = this._$1(geoStyle3D);
                Geometry geometry = this._$1(layer3DVectorFileDataType);
                geometry.setStyle(geoStyle);
                Toolkit.draw((Geometry)geometry, (Resources)new Resources(), (Graphics)graphics);
                graphics.drawImage(InternalImageIconFactory.LAYER3DVECTORFILEBACK.getImage(), 0, 0, jLabel);
                imageIcon.setImage(bufferedImage);
            } else if (layer3DVectorFileDataType.equals((Object)Layer3DVectorFileDataType.TEXT)) {
                graphics.drawImage(InternalImageIconFactory.DT_TEXT.getImage(), 0, 0, jLabel);
                graphics.drawImage(InternalImageIconFactory.LAYER3DVECTORFILEBACK.getImage(), 0, 0, jLabel);
                imageIcon.setImage(bufferedImage);
            } else if (layer3DVectorFileDataType.equals((Object)Layer3DVectorFileDataType.MODEL)) {
                graphics.drawImage(InternalImageIconFactory.LAYER3DVECTORFILE.getImage(), 0, 0, jLabel);
                graphics.drawImage(InternalImageIconFactory.LAYER3DVECTORFILEBACK.getImage(), 0, 0, jLabel);
                imageIcon.setImage(bufferedImage);
            }
        }
    }

    private Geometry _$1(Layer3DVectorFileDataType layer3DVectorFileDataType) {
        if (layer3DVectorFileDataType.equals((Object)Layer3DVectorFileDataType.POINT)) {
            GeoPoint geoPoint = new GeoPoint();
            return geoPoint;
        }
        if (layer3DVectorFileDataType.equals((Object)Layer3DVectorFileDataType.LINE)) {
            Point2D[] point2DArray = new Point2D[]{new Point2D(0.0, 16.0), new Point2D(4.0, 0.0), new Point2D(12.0, 16.0), new Point2D(16.0, 0.0)};
            Point2Ds point2Ds = new Point2Ds(point2DArray);
            GeoLine geoLine = new GeoLine(point2Ds);
            return geoLine;
        }
        if (layer3DVectorFileDataType.equals((Object)Layer3DVectorFileDataType.REGION)) {
            Point2D[] point2DArray = new Point2D[]{new Point2D(1.0, 15.0), new Point2D(1.0, 5.0), new Point2D(10.0, 1.0), new Point2D(15.0, 5.0), new Point2D(15.0, 15.0), new Point2D(1.0, 15.0)};
            Point2Ds point2Ds = new Point2Ds(point2DArray);
            GeoRegion geoRegion = new GeoRegion(point2Ds);
            return geoRegion;
        }
        return null;
    }

    private GeoStyle _$1(GeoStyle3D geoStyle3D) {
        GeoStyle geoStyle = new GeoStyle();
        geoStyle.setFillBackColor(geoStyle3D.getFillForeColor());
        geoStyle.setFillForeColor(geoStyle3D.getFillForeColor());
        geoStyle.setLineColor(geoStyle3D.getLineColor());
        if (geoStyle3D.getLineWidth() > 0.2) {
            geoStyle.setLineWidth(0.2);
        } else {
            geoStyle.setLineWidth(geoStyle3D.getLineWidth());
        }
        geoStyle.setMarkerSize(new Size2D(geoStyle3D.getMarkerSize(), geoStyle3D.getMarkerSize()));
        return geoStyle;
    }
}

