/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.FacilityAnalystNative;
import com.supermap.analyst.networkanalyst.FacilityAnalystResult;
import com.supermap.analyst.networkanalyst.FacilityAnalystSetting;
import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.InternalToolkitNetworkAnalyst;
import com.supermap.analyst.networkanalyst.WeightFieldInfos;
import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfos;
import com.supermap.data.License;
import com.supermap.data.ProductType;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.Toolkit;
import java.util.ArrayList;

public class FacilityAnalyst
extends InternalHandleDisposable {
    private FacilityAnalystSetting _$3 = null;
    private License _$2;
    private boolean _$1 = false;

    public FacilityAnalyst() {
        this._$3();
        long l = FacilityAnalystNative.jni_New();
        this.setHandle(l, true);
        this._$3 = new FacilityAnalystSetting();
        this._$1 = false;
    }

    public FacilityAnalystSetting getAnalystSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnalystSetting()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this._$3;
    }

    public void setAnalystSetting(FacilityAnalystSetting facilityAnalystSetting) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnalystSetting(FacilityAnalystSetting value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (facilityAnalystSetting == null) {
            String string = InternalResource.loadString("setAnalystSetting(FacilityAnalystSetting value)", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!this.getAnalystSetting().equals(facilityAnalystSetting)) {
            this._$3.copyFrom(facilityAnalystSetting);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean load() {
        boolean bl;
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("load()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        boolean bl2 = false;
        if (this._$3.getNeedSet()) {
            this.setAnalsytSettingToUGC();
        }
        if (bl = this._$3.getNeedLoadModel()) {
            Toolkit.clearErrors();
            bl2 = FacilityAnalystNative.jni_LoadModel(this.getHandle());
            if (!bl2) {
                this._$3.setNeedLoadModel(true);
                String string = Toolkit.getLastError();
                throw new IllegalArgumentException(string);
            }
            this._$3.setNeedLoadModel(false);
        } else {
            bl2 = true;
        }
        if (bl2) {
            this._$1 = true;
            return bl2;
        }
        this._$1 = false;
        return bl2;
    }

    public int[] findLoopsFromNodes(int[] nArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findLoopsFromNodes(int[] nodeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return FacilityAnalystNative.jni_FindLoopsFromNodes(this.getHandle(), nArray, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
    }

    public int[] findLoopsFromEdges(int[] nArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findLoopsFromEdgeIDs(int[] edgeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return FacilityAnalystNative.jni_FindLoopsFromEdges(this.getHandle(), nArray, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
    }

    public int[] findConnectedEdgesFromNodes(int[] nArray) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findConnectedEdgesFromNodes(int[] nodeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < nArray.length; bl += 1) {
            if (nArray[bl] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = true;
        return FacilityAnalystNative.jni_FindConnectedEdgesFromNodes(this.getHandle(), nArray, bl, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
    }

    public int[] findConnectedEdgesFromEdges(int[] nArray) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findConnectedEdgesFromEdges(int[] edgeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < nArray.length; bl += 1) {
            if (nArray[bl] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = true;
        return FacilityAnalystNative.jni_FindConnectedEdgesFromEdges(this.getHandle(), nArray, bl, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
    }

    public int[] findUnconnectedEdgesFromNodes(int[] nArray) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findUnconnectedEdgesFromNodes(int[] nodeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < nArray.length; bl += 1) {
            if (nArray[bl] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = false;
        return FacilityAnalystNative.jni_FindConnectedEdgesFromNodes(this.getHandle(), nArray, bl, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
    }

    public int[] findUnconnectedEdgesFromEdges(int[] nArray) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findUnconnectedEdgesFromEdges(int[] edgeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < nArray.length; bl += 1) {
            if (nArray[bl] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = false;
        return FacilityAnalystNative.jni_FindConnectedEdgesFromEdges(this.getHandle(), nArray, bl, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
    }

    public int[] findCommonAncestorsFromNodes(int[] nArray, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCommonAncestorsFromNodes(int[] nodeIDs, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this._$3.getWeightFieldInfos().get(0).getName();
        int n = 0;
        return FacilityAnalystNative.jni_FindCommonAncestorsFromNodes(this.getHandle(), nArray, string, bl, n, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
    }

    public int[] findCommonAncestorsFromEdges(int[] nArray, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCommonAncestorsFromEdges(int[] edgeIDs, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this._$3.getWeightFieldInfos().get(0).getName();
        int n = 0;
        return FacilityAnalystNative.jni_FindCommonAncestorsFromEdges(this.getHandle(), nArray, string, bl, n, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
    }

    public int[] findCommonCatchmentsFromNodes(int[] nArray, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCommonCatchementsFromNodes(int[] nodeIDs, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this._$3.getWeightFieldInfos().get(0).getName();
        int n = 1;
        return FacilityAnalystNative.jni_FindCommonAncestorsFromNodes(this.getHandle(), nArray, string, bl, n, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
    }

    public int[] findCommonCatchmentsFromEdges(int[] nArray, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCommonCatchmentsFromEdges(int[] edgeIDs, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this._$3.getWeightFieldInfos().get(0).getName();
        int n = 1;
        return FacilityAnalystNative.jni_FindCommonAncestorsFromEdges(this.getHandle(), nArray, string, bl, n, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
    }

    public FacilityAnalystResult findSourceFromNode(int n, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findSourceFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = 0;
        int[][] nArray = FacilityAnalystNative.jni_FindSourceFromNode(this.getHandle(), n, string, bl, n2, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findSourceFromEdge(int n, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findSourceFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = 0;
        int[][] nArray = FacilityAnalystNative.jni_FindSourceFromEdge(this.getHandle(), n, string, bl, n2, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findSinkFromNode(int n, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findSinkFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = 1;
        int[][] nArray = FacilityAnalystNative.jni_FindSourceFromNode(this.getHandle(), n, string, bl, n2, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findSinkFromEdge(int n, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findSinkFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = 1;
        int[][] nArray = FacilityAnalystNative.jni_FindSourceFromEdge(this.getHandle(), n, string, bl, n2, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult traceUpFromNode(int n, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("traceUpFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = 0;
        int[][] nArray = FacilityAnalystNative.jni_TraceUpFromNode(this.getHandle(), n, string, bl, n2, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
        return facilityAnalystResult;
    }

    public FacilityAnalystResult traceUpFromEdge(int n, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("traceUpFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = 0;
        int[][] nArray = FacilityAnalystNative.jni_TraceUpFromEdge(this.getHandle(), n, string, bl, n2, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
        return facilityAnalystResult;
    }

    public FacilityAnalystResult traceDownFromNode(int n, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("traceDownFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = 1;
        int[][] nArray = FacilityAnalystNative.jni_TraceUpFromNode(this.getHandle(), n, string, bl, n2, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
        return facilityAnalystResult;
    }

    public FacilityAnalystResult traceDownFromEdge(int n, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("traceDownFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = 1;
        int[][] nArray = FacilityAnalystNative.jni_TraceUpFromEdge(this.getHandle(), n, string, bl, n2, this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
        return facilityAnalystResult;
    }

    public int[] checkLoops() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("checkLoops()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return FacilityAnalystNative.jni_CheckLoops(this.getHandle(), this._$3.getBarrierEdges(), this._$3.getBarrierNodes());
    }

    public FacilityAnalystResult findPathFromNodes(int n, int n2, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findPathFromNodes(int startNodeID,int endNodeID,String weightName,boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("startNodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (n2 <= 0) {
            String string5 = InternalResource.loadString("endNodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string6 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        int[][] nArray = FacilityAnalystNative.jni_FindPathFromNodes(this.getHandle(), n, n2, string, true, this._$3.getBarrierEdges(), this._$3.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findPathFromEdges(int n, int n2, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findPathFromEdges(int startEdgeID,int endEdgeID,String weightName,boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("startEdgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (n2 <= 0) {
            String string5 = InternalResource.loadString("endEdgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string6 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        int[][] nArray = FacilityAnalystNative.jni_FindPathFromEdges(this.getHandle(), n, n2, string, true, this._$3.getBarrierEdges(), this._$3.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findPathUpFromNode(int n, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findPathUpFromNode(int nodeID,String weightName,boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = 0;
        int[][] nArray = FacilityAnalystNative.jni_FindPathUpFromNode(this.getHandle(), n, string, true, n2, this._$3.getBarrierEdges(), this._$3.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findPathUpFromEdge(int n, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findPathUpFromEdge(int edgeID,String weightName,boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = 0;
        int[][] nArray = FacilityAnalystNative.jni_FindPathUpFromEdge(this.getHandle(), n, string, true, n2, this._$3.getBarrierEdges(), this._$3.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findPathDownFromNode(int n, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findPathDownFromNode(int nodeID,String weightName,boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = 1;
        int[][] nArray = FacilityAnalystNative.jni_FindPathUpFromNode(this.getHandle(), n, string, true, n2, this._$3.getBarrierEdges(), this._$3.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public FacilityAnalystResult findPathDownFromEdge(int n, String string, boolean bl) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findPathUpFromEdge(int edgeID,String weightName,boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$4()) {
            String string3 = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            string = this._$3.getWeightFieldInfos().get(0).getName();
        } else if (this._$3.getWeightFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        int n2 = 1;
        int[][] nArray = FacilityAnalystNative.jni_FindPathUpFromEdge(this.getHandle(), n, string, true, n2, this._$3.getBarrierEdges(), this._$3.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalystNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult facilityAnalystResult = new FacilityAnalystResult(nArray2, nArray3, d);
            return facilityAnalystResult;
        }
        return null;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "networkanalyst_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            FacilityAnalystNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
        this._$2();
    }

    void setAnalsytSettingToUGC() {
        DatasetType datasetType;
        if (!this._$3.getNeedSet()) {
            return;
        }
        DatasetVector datasetVector = this._$3.getNetworkDataset();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset()", "FacilityAnalyst_NetworkDatasetHasNotBeenSet", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!datasetVector.isOpen()) {
            datasetVector.open();
        }
        if ((datasetType = datasetVector.getType()) != DatasetType.NETWORK) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset().getType()", "FacilityAnalyst_DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        String[] stringArray = new String[]{this._$3.getNodeIDField(), this._$3.getEdgeIDField(), this._$3.getFNodeIDField(), this._$3.getTNodeIDField(), this._$3.getDirectionField()};
        if (!FacilityAnalyst._$1(stringArray, datasetVector)) {
            String string = InternalResource.loadString("fields", "FacilityAnalystSetting_FieldIsNotInNetworkDataset", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        WeightFieldInfos weightFieldInfos = this._$3.getWeightFieldInfos();
        if (weightFieldInfos == null || weightFieldInfos.getCount() <= 0) {
            String string = InternalResource.loadString("m_analystSetting.getWeightFieldInfos()", "FacilityAnalystSetting_WeightFieldInfoCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        int n = weightFieldInfos.getCount();
        stringArray2 = new String[n];
        stringArray3 = new String[n];
        stringArray4 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = weightFieldInfos.get(i).getName();
            stringArray3[i] = weightFieldInfos.get(i).getFTWeightField();
            stringArray4[i] = weightFieldInfos.get(i).getTFWeightField();
        }
        int[] nArray = this._$3.getBarrierEdges();
        int[] nArray2 = this._$3.getBarrierNodes();
        double d = this._$3.getTolerance();
        FacilityAnalystNative.jni_SetAnalystSettingToUGC(this.getHandle(), l, stringArray, stringArray2, stringArray3, stringArray4, nArray2, nArray, d);
        this._$3.setNeedSet(false);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    private boolean _$4() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLoadModelNeeded()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this._$3.getNeedSet() || !this._$1;
    }

    private static boolean _$1(String[] stringArray, DatasetVector datasetVector) {
        int n;
        boolean bl = true;
        if (!datasetVector.open()) {
            datasetVector.open();
        }
        FieldInfos fieldInfos = datasetVector.getChildDataset().getFieldInfos();
        boolean bl2 = false;
        for (n = 0; n < fieldInfos.getCount(); ++n) {
            if (fieldInfos.get(n).getName().compareToIgnoreCase(stringArray[0]) != 0) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return bl2;
        }
        fieldInfos = datasetVector.getFieldInfos();
        n = stringArray.length;
        for (int i = 1; i < n; ++i) {
            bl2 = false;
            if (stringArray[i] == "" || stringArray[i] == null) {
                return bl2;
            }
            for (int j = 0; j < fieldInfos.getCount(); ++j) {
                if (fieldInfos.get(j).getName().compareToIgnoreCase(stringArray[i]) != 0) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return bl2;
        }
        return bl;
    }

    private void _$3() {
        ArrayList<ProductType> arrayList = InternalToolkitNetworkAnalyst.managerProducts(InternalToolkitNetworkAnalyst.getNetworkAnalystProducts());
        this._$2 = InternalToolkitNetworkAnalyst.verifyLicense(arrayList);
    }

    private void _$2() {
        if (this._$2 != null) {
            this._$2.disconnect();
            this._$2.dispose();
            this._$2 = null;
        }
    }

    private void _$1() {
        int n = this._$2.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    boolean checkWeightField() {
        QueryParameter queryParameter = new QueryParameter();
        queryParameter.setCursorType(CursorType.STATIC);
        queryParameter.setHasGeometry(false);
        queryParameter.setAttributeFilter("1<0");
        DatasetVector datasetVector = this._$3.getNetworkDataset();
        if (datasetVector == null) {
            return false;
        }
        for (int i = 0; i < this._$3.getWeightFieldInfos().getCount(); ++i) {
            int n;
            String string = this._$3.getWeightFieldInfos().get(i).getFTWeightField();
            String string2 = this._$3.getWeightFieldInfos().get(i).getTFWeightField();
            queryParameter.setResultFields(new String[]{string});
            Recordset recordset = datasetVector.query(queryParameter);
            FieldInfos fieldInfos = recordset.getFieldInfos();
            int n2 = fieldInfos.getCount();
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                String string3 = fieldInfos.get(n).getName();
                if (!string3.equalsIgnoreCase(string)) continue;
                bl = true;
            }
            if (!bl) {
                String string4 = InternalResource.loadString(string, "Global_EnumValueIsError", "networkanalyst_resources");
                throw new IllegalArgumentException(string4);
            }
            recordset.dispose();
            queryParameter.setResultFields(new String[]{string2});
            recordset = this._$3.getNetworkDataset().query(queryParameter);
            fieldInfos = recordset.getFieldInfos();
            n2 = fieldInfos.getCount();
            n = 0;
            for (int j = 0; j < n2; ++j) {
                String string5 = fieldInfos.get(j).getName();
                if (!string5.equalsIgnoreCase(string2)) continue;
                n = 1;
            }
            if (n == 0) {
                String string6 = InternalResource.loadString(string2, "Global_EnumValueIsError", "networkanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
            recordset.dispose();
        }
        if (this._$3.getDirectionField() == null || this._$3.getDirectionField() == "") {
            String string = InternalResource.loadString("DirectionField", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return true;
    }
}

