/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.util;

import com.noelios.restlet.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SecurityUtils {
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public static String makeNonce(String secretKey) {
        long currentTimeMS = System.currentTimeMillis();
        return Base64.encode((currentTimeMS + ":" + SecurityUtils.toMd5(currentTimeMS + ":" + secretKey)).getBytes(), true);
    }

    public static byte[] toHMac(String source, String secretKey) {
        byte[] result = null;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(secretKey.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            result = mac.doFinal(source.getBytes());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Could not find the SHA-1 algorithm. HMac conversion failed.", nsae);
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException("Invalid key exception detected. HMac conversion failed.", ike);
        }
        return result;
    }

    public static String toMd5(String target) {
        try {
            return SecurityUtils.toMd5(target, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("US-ASCII is an unsupported encoding, unable to compute MD5");
        }
    }

    public static String toMd5(String target, String charsetName) throws UnsupportedEncodingException {
        try {
            byte[] md5 = MessageDigest.getInstance("MD5").digest(target.getBytes(charsetName));
            char[] md5Chars = new char[32];
            int i = 0;
            for (byte b : md5) {
                md5Chars[i++] = HEXDIGITS[b >> 4 & 0xF];
                md5Chars[i++] = HEXDIGITS[b & 0xF];
            }
            return new String(md5Chars);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("No MD5 algorithm, unable to compute MD5");
        }
    }

    public static String toSha1(String target) {
        try {
            return SecurityUtils.toSha1(target, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("US-ASCII is an unsupported encoding, unable to compute SHA1");
        }
    }

    public static String toSha1(String target, String charsetName) throws UnsupportedEncodingException {
        try {
            return Base64.encode(MessageDigest.getInstance("SHA1").digest(target.getBytes(charsetName)), false);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("No SHA1 algorithm, unable to compute SHA1");
        }
    }
}

