/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.model.MasterSheet;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.ShapeGroup;
import org.apache.poi.hslf.model.ShapePainter;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.model.SimpleShape;
import org.apache.poi.hslf.model.TextPainter;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.record.EscherTextboxWrapper;
import org.apache.poi.hslf.record.InteractiveInfo;
import org.apache.poi.hslf.record.InteractiveInfoAtom;
import org.apache.poi.hslf.record.OEPlaceholderAtom;
import org.apache.poi.hslf.record.OutlineTextRefAtom;
import org.apache.poi.hslf.record.PPDrawing;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.StyleTextPropAtom;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;
import org.apache.poi.hslf.record.TextHeaderAtom;
import org.apache.poi.hslf.record.TxInteractiveInfoAtom;
import org.apache.poi.hslf.usermodel.RichTextRun;

public abstract class TextShape
extends SimpleShape {
    public static final int AnchorTop = 0;
    public static final int AnchorMiddle = 1;
    public static final int AnchorBottom = 2;
    public static final int AnchorTopCentered = 3;
    public static final int AnchorMiddleCentered = 4;
    public static final int AnchorBottomCentered = 5;
    public static final int AnchorTopBaseline = 6;
    public static final int AnchorBottomBaseline = 7;
    public static final int AnchorTopCenteredBaseline = 8;
    public static final int AnchorBottomCenteredBaseline = 9;
    public static final int WrapSquare = 0;
    public static final int WrapByPoints = 1;
    public static final int WrapNone = 2;
    public static final int WrapTopBottom = 3;
    public static final int WrapThrough = 4;
    public static final int AlignLeft = 0;
    public static final int AlignCenter = 1;
    public static final int AlignRight = 2;
    public static final int AlignJustify = 3;
    protected TextRun _txtrun;
    protected EscherTextboxWrapper _txtbox;
    protected static final FontRenderContext _frc = new FontRenderContext(null, true, true);

    protected TextShape(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public TextShape(Shape parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(parent instanceof ShapeGroup);
    }

    public TextShape() {
        this(null);
    }

    public TextRun createTextRun() {
        this._txtbox = this.getEscherTextboxWrapper();
        if (this._txtbox == null) {
            this._txtbox = new EscherTextboxWrapper();
        }
        this._txtrun = this.getTextRun();
        if (this._txtrun == null) {
            TextHeaderAtom tha = new TextHeaderAtom();
            tha.setParentRecord(this._txtbox);
            this._txtbox.appendChildRecord(tha);
            TextCharsAtom tca = new TextCharsAtom();
            this._txtbox.appendChildRecord(tca);
            StyleTextPropAtom sta = new StyleTextPropAtom(0);
            this._txtbox.appendChildRecord(sta);
            this._txtrun = new TextRun(tha, tca, sta);
            this._txtrun._records = new Record[]{tha, tca, sta};
            this._txtrun.setText("");
            this._escherContainer.addChildRecord((EscherRecord)this._txtbox.getEscherRecord());
            this.setDefaultTextProperties(this._txtrun);
        }
        return this._txtrun;
    }

    protected void setDefaultTextProperties(TextRun _txtrun) {
    }

    public String getText() {
        TextRun tx = this.getTextRun();
        return tx == null ? null : tx.getText();
    }

    public void setText(String text) {
        TextRun tx = this.getTextRun();
        if (tx == null) {
            tx = this.createTextRun();
        }
        tx.setText(text);
        this.setTextId(text.hashCode());
    }

    protected void afterInsert(Sheet sh) {
        super.afterInsert(sh);
        EscherTextboxWrapper _txtbox = this.getEscherTextboxWrapper();
        if (_txtbox != null) {
            PPDrawing ppdrawing = sh.getPPDrawing();
            ppdrawing.addTextboxWrapper(_txtbox);
            try {
                _txtbox.writeOut(null);
            }
            catch (IOException e) {
                throw new HSLFException(e);
            }
            if (this.getAnchor().equals(new Rectangle()) && !"".equals(this.getText())) {
                this.resizeToFitText();
            }
        }
        if (this._txtrun != null) {
            this._txtrun.setShapeId(this.getShapeId());
            sh.onAddTextShape(this);
        }
    }

    protected EscherTextboxWrapper getEscherTextboxWrapper() {
        EscherTextboxRecord textRecord;
        if (this._txtbox == null && (textRecord = (EscherTextboxRecord)Shape.getEscherChild(this._escherContainer, -4083)) != null) {
            this._txtbox = new EscherTextboxWrapper(textRecord);
        }
        return this._txtbox;
    }

    public Rectangle2D resizeToFitText() {
        String txt = this.getText();
        if (txt == null || txt.length() == 0) {
            return new Rectangle2D.Float();
        }
        RichTextRun rt = this.getTextRun().getRichTextRuns()[0];
        int size = rt.getFontSize();
        int style = 0;
        if (rt.isBold()) {
            style |= 1;
        }
        if (rt.isItalic()) {
            style |= 2;
        }
        String fntname = rt.getFontName();
        Font font = new Font(fntname, style, size);
        float width = 0.0f;
        float height = 0.0f;
        float leading = 0.0f;
        String[] lines = txt.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() == 0) continue;
            TextLayout layout = new TextLayout(lines[i], font, _frc);
            leading = Math.max(leading, layout.getLeading());
            width = Math.max(width, layout.getAdvance());
            height = Math.max(height, height + (layout.getDescent() + layout.getAscent()));
        }
        Rectangle2D charBounds = font.getMaxCharBounds(_frc);
        width = (float)((double)width + ((double)(this.getMarginLeft() + this.getMarginRight()) + charBounds.getWidth()));
        Rectangle2D anchor = this.getAnchor2D();
        anchor.setRect(anchor.getX(), anchor.getY(), width, height += this.getMarginTop() + this.getMarginBottom() + leading);
        this.setAnchor(anchor);
        return anchor;
    }

    public int getVerticalAlignment() {
        EscherOptRecord opt = (EscherOptRecord)TextShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextShape.getEscherProperty(opt, 135);
        int valign = 0;
        if (prop == null) {
            int type = this.getTextRun().getRunType();
            MasterSheet master = this.getSheet().getMasterSheet();
            if (master != null) {
                TextShape masterShape = master.getPlaceholderByTextType(type);
                if (masterShape != null) {
                    valign = masterShape.getVerticalAlignment();
                }
            } else {
                switch (type) {
                    case 0: 
                    case 6: {
                        valign = 1;
                        break;
                    }
                    default: {
                        valign = 0;
                    }
                }
            }
        } else {
            valign = prop.getPropertyValue();
        }
        return valign;
    }

    public void setVerticalAlignment(int align) {
        this.setEscherProperty((short)135, align);
    }

    public void setHorizontalAlignment(int align) {
        TextRun tx = this.getTextRun();
        if (tx != null) {
            tx.getRichTextRuns()[0].setAlignment(align);
        }
    }

    public int getHorizontalAlignment() {
        TextRun tx = this.getTextRun();
        return tx == null ? -1 : tx.getRichTextRuns()[0].getAlignment();
    }

    public float getMarginBottom() {
        EscherOptRecord opt = (EscherOptRecord)TextShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextShape.getEscherProperty(opt, 132);
        int val = prop == null ? 45720 : prop.getPropertyValue();
        return (float)val / 12700.0f;
    }

    public void setMarginBottom(float margin) {
        this.setEscherProperty((short)132, (int)(margin * 12700.0f));
    }

    public float getMarginLeft() {
        EscherOptRecord opt = (EscherOptRecord)TextShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextShape.getEscherProperty(opt, 129);
        int val = prop == null ? 91440 : prop.getPropertyValue();
        return (float)val / 12700.0f;
    }

    public void setMarginLeft(float margin) {
        this.setEscherProperty((short)129, (int)(margin * 12700.0f));
    }

    public float getMarginRight() {
        EscherOptRecord opt = (EscherOptRecord)TextShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextShape.getEscherProperty(opt, 131);
        int val = prop == null ? 91440 : prop.getPropertyValue();
        return (float)val / 12700.0f;
    }

    public void setMarginRight(float margin) {
        this.setEscherProperty((short)131, (int)(margin * 12700.0f));
    }

    public float getMarginTop() {
        EscherOptRecord opt = (EscherOptRecord)TextShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextShape.getEscherProperty(opt, 130);
        int val = prop == null ? 45720 : prop.getPropertyValue();
        return (float)val / 12700.0f;
    }

    public void setMarginTop(float margin) {
        this.setEscherProperty((short)130, (int)(margin * 12700.0f));
    }

    public int getWordWrap() {
        EscherOptRecord opt = (EscherOptRecord)TextShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextShape.getEscherProperty(opt, 133);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public void setWordWrap(int wrap) {
        this.setEscherProperty((short)133, wrap);
    }

    public int getTextId() {
        EscherOptRecord opt = (EscherOptRecord)TextShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextShape.getEscherProperty(opt, 128);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public void setTextId(int id) {
        this.setEscherProperty((short)128, id);
    }

    public TextRun getTextRun() {
        if (null == this._txtrun) {
            this.initTextRun();
        }
        if (null == this._txtrun && null != this._txtbox) {
            Record[] childRecords;
            TextHeaderAtom tha = null;
            TextBytesAtom tba = null;
            StyleTextPropAtom sta = null;
            for (Record r : childRecords = this._txtbox.getChildRecords()) {
                if (r instanceof TextHeaderAtom) {
                    tha = (TextHeaderAtom)r;
                    continue;
                }
                if (r instanceof TextBytesAtom) {
                    tba = (TextBytesAtom)r;
                    continue;
                }
                if (!(r instanceof StyleTextPropAtom)) continue;
                sta = (StyleTextPropAtom)r;
            }
            if (null != tba) {
                this._txtrun = new TextRun(tha, tba, sta);
            }
        }
        return this._txtrun;
    }

    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
        TextRun tx = this.getTextRun();
        if (tx != null) {
            tx.setSheet(this._sheet);
            RichTextRun[] rt = tx.getRichTextRuns();
            for (int i = 0; i < rt.length; ++i) {
                rt[i].supplySlideShow(this._sheet.getSlideShow());
            }
        }
    }

    protected void initTextRun() {
        Record[] child;
        block9: {
            TextRun[] runs;
            block8: {
                EscherTextboxWrapper txtbox = this.getEscherTextboxWrapper();
                Sheet sheet = this.getSheet();
                if (sheet == null || txtbox == null) {
                    return;
                }
                OutlineTextRefAtom ota = null;
                child = txtbox.getChildRecords();
                for (int i = 0; i < child.length; ++i) {
                    if (!(child[i] instanceof OutlineTextRefAtom)) continue;
                    ota = (OutlineTextRefAtom)child[i];
                    break;
                }
                runs = this._sheet.getTextRuns();
                if (ota == null) break block8;
                int idx = ota.getTextIndex();
                for (int i = 0; i < runs.length; ++i) {
                    if (runs[i].getIndex() != idx) continue;
                    this._txtrun = runs[i];
                    break;
                }
                if (this._txtrun != null) break block9;
                this.logger.log(5, (Object)("text run not found for OutlineTextRefAtom.TextIndex=" + idx));
                break block9;
            }
            EscherSpRecord escherSpRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
            int shapeId = escherSpRecord.getShapeId();
            if (runs != null) {
                for (int i = 0; i < runs.length; ++i) {
                    if (runs[i].getShapeId() != shapeId) continue;
                    this._txtrun = runs[i];
                    break;
                }
            }
        }
        if (this._txtrun != null) {
            for (int i = 0; i < child.length; ++i) {
                for (Record r : this._txtrun.getRecords()) {
                    if (child[i].getRecordType() != r.getRecordType()) continue;
                    child[i] = r;
                }
            }
        }
    }

    public void draw(Graphics2D graphics) {
        AffineTransform at = graphics.getTransform();
        ShapePainter.paint(this, graphics);
        new TextPainter(this).paint(graphics);
        graphics.setTransform(at);
    }

    public OEPlaceholderAtom getPlaceholderAtom() {
        return (OEPlaceholderAtom)this.getClientDataRecord(RecordTypes.OEPlaceholderAtom.typeID);
    }

    public void setHyperlink(int linkId, int beginIndex, int endIndex) {
        InteractiveInfo info = new InteractiveInfo();
        InteractiveInfoAtom infoAtom = info.getInteractiveInfoAtom();
        infoAtom.setAction((byte)4);
        infoAtom.setHyperlinkType((byte)8);
        infoAtom.setHyperlinkID(linkId);
        this._txtbox.appendChildRecord(info);
        TxInteractiveInfoAtom txiatom = new TxInteractiveInfoAtom();
        txiatom.setStartIndex(beginIndex);
        txiatom.setEndIndex(endIndex);
        this._txtbox.appendChildRecord(txiatom);
    }
}

