/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.Assert;

public class DirtiesContextTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(DirtiesContextTestExecutionListener.class);

    @Override
    public final int getOrder() {
        return 3000;
    }

    @Override
    public void beforeTestClass(TestContext testContext) throws Exception {
        this.beforeOrAfterTestClass(testContext, "Before", DirtiesContext.ClassMode.BEFORE_CLASS);
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.beforeOrAfterTestMethod(testContext, "Before", DirtiesContext.MethodMode.BEFORE_METHOD, DirtiesContext.ClassMode.BEFORE_EACH_TEST_METHOD);
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        this.beforeOrAfterTestMethod(testContext, "After", DirtiesContext.MethodMode.AFTER_METHOD, DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD);
    }

    @Override
    public void afterTestClass(TestContext testContext) throws Exception {
        this.beforeOrAfterTestClass(testContext, "After", DirtiesContext.ClassMode.AFTER_CLASS);
    }

    protected void dirtyContext(TestContext testContext, DirtiesContext.HierarchyMode hierarchyMode) {
        testContext.markApplicationContextDirty(hierarchyMode);
        testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, Boolean.TRUE);
    }

    private void beforeOrAfterTestMethod(TestContext testContext, String phase, DirtiesContext.MethodMode requiredMethodMode, DirtiesContext.ClassMode requiredClassMode) throws Exception {
        DirtiesContext.ClassMode classMode;
        Class<?> testClass = testContext.getTestClass();
        Assert.notNull(testClass, (String)"The test class of the supplied TestContext must not be null");
        Method testMethod = testContext.getTestMethod();
        Assert.notNull((Object)testMethod, (String)"The test method of the supplied TestContext must not be null");
        String annotationType = DirtiesContext.class.getName();
        AnnotationAttributes methodAnnAttrs = AnnotatedElementUtils.findAnnotationAttributes((AnnotatedElement)testMethod, (String)annotationType);
        AnnotationAttributes classAnnAttrs = AnnotatedElementUtils.findAnnotationAttributes(testClass, (String)annotationType);
        boolean methodAnnotated = methodAnnAttrs != null;
        boolean classAnnotated = classAnnAttrs != null;
        DirtiesContext.MethodMode methodMode = methodAnnotated ? (DirtiesContext.MethodMode)methodAnnAttrs.getEnum("methodMode") : null;
        DirtiesContext.ClassMode classMode2 = classMode = classAnnotated ? (DirtiesContext.ClassMode)classAnnAttrs.getEnum("classMode") : null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("%s test method: context %s, class annotated with @DirtiesContext [%s] with mode [%s], method annotated with @DirtiesContext [%s] with mode [%s].", new Object[]{phase, testContext, classAnnotated, classMode, methodAnnotated, methodMode}));
        }
        if (methodMode == requiredMethodMode || classMode == requiredClassMode) {
            DirtiesContext.HierarchyMode hierarchyMode = methodAnnotated ? (DirtiesContext.HierarchyMode)methodAnnAttrs.getEnum("hierarchyMode") : (DirtiesContext.HierarchyMode)classAnnAttrs.getEnum("hierarchyMode");
            this.dirtyContext(testContext, hierarchyMode);
        }
    }

    private void beforeOrAfterTestClass(TestContext testContext, String phase, DirtiesContext.ClassMode requiredClassMode) throws Exception {
        DirtiesContext.ClassMode classMode;
        Class<?> testClass = testContext.getTestClass();
        Assert.notNull(testClass, (String)"The test class of the supplied TestContext must not be null");
        String annotationType = DirtiesContext.class.getName();
        AnnotationAttributes classAnnAttrs = AnnotatedElementUtils.findAnnotationAttributes(testClass, (String)annotationType);
        boolean classAnnotated = classAnnAttrs != null;
        DirtiesContext.ClassMode classMode2 = classMode = classAnnotated ? (DirtiesContext.ClassMode)classAnnAttrs.getEnum("classMode") : null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("%s test class: context %s, class annotated with @DirtiesContext [%s] with mode [%s].", new Object[]{phase, testContext, classAnnotated, classMode}));
        }
        if (classMode == requiredClassMode) {
            DirtiesContext.HierarchyMode hierarchyMode = (DirtiesContext.HierarchyMode)classAnnAttrs.getEnum("hierarchyMode");
            this.dirtyContext(testContext, hierarchyMode);
        }
    }
}

